/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.macs;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Mac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.CBCBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.paddings.ISO7816d4Padding;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class CMac
implements Mac {
    private byte[] poly;
    private byte[] ZEROES;
    private byte[] mac;
    private byte[] buf;
    private int bufOff;
    private BlockCipher cipher;
    private int macSize;
    private byte[] Lu;
    private byte[] Lu2;

    public CMac(BlockCipher blockCipher) {
        BlockCipher blockCipher2 = blockCipher;
        this(blockCipher2, blockCipher2.getBlockSize() * 8);
    }

    public CMac(BlockCipher blockCipher, int n) {
        if (n % 8 == 0) {
            if (n <= blockCipher.getBlockSize() * 8) {
                CMac cMac = this;
                this.cipher = new CBCBlockCipher(blockCipher);
                this.macSize = n / 8;
                this.poly = CMac.lookupPoly(blockCipher.getBlockSize());
                this.mac = new byte[blockCipher.getBlockSize()];
                this.buf = new byte[blockCipher.getBlockSize()];
                cMac.ZEROES = new byte[blockCipher.getBlockSize()];
                cMac.bufOff = 0;
                return;
            }
            throw new IllegalArgumentException(b.a.a("MAC size must be less or equal to ").append(blockCipher.getBlockSize() * 8).toString());
        }
        throw new IllegalArgumentException("MAC size must be multiple of 8");
    }

    private static int shiftLeft(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        int n2 = 0;
        while ((n += -1) >= 0) {
            int n3 = byArray[n] & 0xFF;
            byArray2[n] = (byte)(n3 << 1 | n2);
            n2 = n3 >>> 7 & 1;
        }
        return n2;
    }

    private byte[] doubleLu(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        byte[] byArray3 = byArray2;
        int n = -CMac.shiftLeft(byArray, byArray3) & 0xFF;
        int n2 = byArray.length - 3;
        Object object = ((CMac)object).poly;
        byArray3[n2] = (byte)(byArray3[n2] ^ ((CMac)object).poly[1] & n);
        n2 = byArray.length - 2;
        byArray3[n2] = (byte)(byArray3[n2] ^ object[2] & n);
        n2 = byArray.length - 1;
        byArray2[n2] = (byte)(byArray2[n2] ^ object[3] & n);
        return byArray2;
    }

    private static byte[] lookupPoly(int n) {
        int n2;
        switch (n *= 8) {
            default: {
                throw new IllegalArgumentException(a.a("Unknown block size for CMAC: ", n));
            }
            case 2048: {
                n2 = 548865;
                break;
            }
            case 1024: {
                n2 = 524355;
                break;
            }
            case 768: {
                n2 = 655377;
                break;
            }
            case 512: {
                n2 = 293;
                break;
            }
            case 448: {
                n2 = 2129;
                break;
            }
            case 384: {
                n2 = 4109;
                break;
            }
            case 256: {
                n2 = 1061;
                break;
            }
            case 224: {
                n2 = 777;
                break;
            }
            case 160: {
                n2 = 45;
                break;
            }
            case 128: 
            case 192: {
                n2 = 135;
                break;
            }
            case 64: 
            case 320: {
                n2 = 27;
            }
        }
        return Pack.intToBigEndian(n2);
    }

    @Override
    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName();
    }

    @Override
    public void init(CipherParameters object) {
        CMac cMac = object2;
        cMac.validate((CipherParameters)object);
        cMac.cipher.init(true, (CipherParameters)object);
        object = cMac.ZEROES;
        byte[] byArray = new byte[cMac.ZEROES.length];
        ((CMac)object2).cipher.processBlock((byte[])object, 0, byArray, 0);
        byte[] byArray2 = cMac.doubleLu(byArray);
        Object object2 = byArray2;
        cMac.Lu = byArray2;
        cMac.Lu2 = cMac.doubleLu((byte[])object2);
        cMac.reset();
    }

    public void validate(CipherParameters cipherParameters) {
        if (cipherParameters != null && !(cipherParameters instanceof KeyParameter)) {
            throw new IllegalArgumentException("CMac mode only permits key to be set.");
        }
    }

    @Override
    public int getMacSize() {
        return this.macSize;
    }

    @Override
    public void update(byte by) {
        byte[] byArray = this.buf;
        if (this.bufOff == this.buf.length) {
            this.cipher.processBlock(byArray, 0, this.mac, 0);
            this.bufOff = 0;
        }
        int n = this.bufOff;
        this.bufOff = n + 1;
        this.buf[n] = by;
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        if (n2 >= 0) {
            int n3;
            int n4 = ((CMac)object).cipher.getBlockSize();
            int n5 = n4 - (n3 = ((CMac)object).bufOff);
            if (n2 > n5) {
                int n6 = n;
                System.arraycopy(byArray, n, ((CMac)object).buf, n3, n5);
                Object object = object;
                byte[] byArray2 = ((CMac)object).buf;
                byte[] byArray3 = ((CMac)object).mac;
                ((CMac)object).cipher.processBlock(byArray2, 0, byArray3, 0);
                ((CMac)object).bufOff = 0;
                n = n2 - n5;
                n2 = n6 + n5;
                int n7 = n;
                n = n2;
                n2 = n7;
                while (n2 > n4) {
                    int n8 = n;
                    ((CMac)object).cipher.processBlock(byArray, n, ((CMac)object).mac, 0);
                    n = n2 - n4;
                    n2 = n8 + n4;
                    int n9 = n;
                    n = n2;
                    n2 = n9;
                }
            }
            CMac cMac = object;
            CMac cMac2 = object;
            Object object = cMac2.buf;
            System.arraycopy(byArray, n, object, cMac2.bufOff, n2);
            cMac.bufOff += n2;
            return;
        }
        throw new IllegalArgumentException("Can't have a negative input length!");
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        byte[] byArray2;
        Object object;
        CMac cMac = this;
        int n2 = cMac.cipher.getBlockSize();
        if (cMac.bufOff == n2) {
            object = this.Lu;
        } else {
            ISO7816d4Padding iSO7816d4Padding;
            object = iSO7816d4Padding;
            CMac cMac2 = this;
            object();
            object = cMac2.buf;
            iSO7816d4Padding.addPadding((byte[])object, cMac2.bufOff);
            object = this.Lu2;
        }
        int n3 = 0;
        while (true) {
            byArray2 = this.mac;
            if (n3 >= this.mac.length) break;
            this.buf[n3] = (byte)(this.buf[n3] ^ object[n3]);
            ++n3;
        }
        CMac cMac3 = this;
        cMac3.cipher.processBlock(this.buf, 0, byArray2, 0);
        int n4 = this.macSize;
        System.arraycopy(cMac3.mac, 0, byArray, n, n4);
        cMac3.reset();
        return cMac3.macSize;
    }

    @Override
    public void reset() {
        int n = 0;
        while (true) {
            byte[] byArray = this.buf;
            if (n >= this.buf.length) break;
            byArray[n] = 0;
            ++n;
        }
        this.bufOff = 0;
        this.cipher.reset();
    }
}

