/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.macs;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.ExtendedDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Mac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Integers;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Memoable;
import java.util.Hashtable;

public class HMac
implements Mac {
    private static final byte IPAD = 54;
    private static final byte OPAD = 92;
    private static Hashtable blockLengths = new Hashtable<String, Integer>();
    private Digest digest;
    private int digestSize;
    private int blockLength;
    private Memoable ipadState;
    private Memoable opadState;
    private byte[] inputPad;
    private byte[] outputBuf;

    private static int getByteLength(Digest digest) {
        if (digest instanceof ExtendedDigest) {
            return ((ExtendedDigest)digest).getByteLength();
        }
        Integer n = (Integer)blockLengths.get(digest.getAlgorithmName());
        if (n != null) {
            return n;
        }
        throw new IllegalArgumentException(a.a("unknown digest passed: ").append(digest.getAlgorithmName()).toString());
    }

    public HMac(Digest digest) {
        this(digest, HMac.getByteLength(digest));
    }

    private HMac(Digest digest, int n) {
        int n2;
        this.digest = digest;
        this.digestSize = n2 = digest.getDigestSize();
        this.blockLength = n;
        this.inputPad = new byte[n];
        this.outputBuf = new byte[n + n2];
    }

    private static void xorPad(byte[] byArray, int n, byte by) {
        for (int k = 0; k < n; ++k) {
            byArray[k] = (byte)(byArray[k] ^ by);
        }
    }

    static {
        blockLengths.put("GOST3411", Integers.valueOf(32));
        blockLengths.put("MD2", Integers.valueOf(16));
        blockLengths.put("MD4", Integers.valueOf(64));
        blockLengths.put("MD5", Integers.valueOf(64));
        blockLengths.put("RIPEMD128", Integers.valueOf(64));
        blockLengths.put("RIPEMD160", Integers.valueOf(64));
        blockLengths.put("SHA-1", Integers.valueOf(64));
        blockLengths.put("SHA-224", Integers.valueOf(64));
        blockLengths.put("SHA-256", Integers.valueOf(64));
        blockLengths.put("SHA-384", Integers.valueOf(128));
        blockLengths.put("SHA-512", Integers.valueOf(128));
        blockLengths.put("Tiger", Integers.valueOf(64));
        blockLengths.put("Whirlpool", Integers.valueOf(64));
    }

    @Override
    public String getAlgorithmName() {
        return this.digest.getAlgorithmName() + "/HMAC";
    }

    public Digest getUnderlyingDigest() {
        return this.digest;
    }

    @Override
    public void init(CipherParameters object) {
        this.digest.reset();
        byte[] byArray = ((KeyParameter)object).getKey();
        object = byArray;
        int n = byArray.length;
        if (n > this.blockLength) {
            HMac hMac = this;
            hMac.digest.update((byte[])object, 0, n);
            hMac.digest.doFinal(this.inputPad, 0);
            n = hMac.digestSize;
        } else {
            System.arraycopy(object, 0, this.inputPad, 0, n);
        }
        while (true) {
            object = this.inputPad;
            if (n >= this.inputPad.length) break;
            object[n] = false;
            ++n;
        }
        HMac hMac = this;
        Object object2 = object;
        HMac hMac2 = this;
        object = hMac2.outputBuf;
        n = hMac2.blockLength;
        System.arraycopy(object2, 0, object, 0, n);
        HMac.xorPad(hMac.inputPad, this.blockLength, (byte)54);
        HMac.xorPad(hMac.outputBuf, this.blockLength, (byte)92);
        object = hMac.digest;
        if (object instanceof Memoable) {
            object = ((Memoable)object).copy();
            this.opadState = object;
            Digest digest = (Digest)object;
            HMac hMac3 = this;
            object = hMac3.outputBuf;
            n = hMac3.blockLength;
            digest.update((byte[])object, 0, n);
        }
        HMac hMac4 = this;
        hMac4.digest.update(this.inputPad, 0, this.inputPad.length);
        object = hMac4.digest;
        if (object instanceof Memoable) {
            this.ipadState = ((Memoable)object).copy();
        }
    }

    @Override
    public int getMacSize() {
        return this.digestSize;
    }

    @Override
    public void update(byte by) {
        this.digest.update(by);
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        this.digest.update(byArray, n, n2);
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        HMac hMac = this;
        HMac hMac2 = this;
        Object object = hMac2.outputBuf;
        hMac.digest.doFinal((byte[])object, hMac2.blockLength);
        Memoable memoable = hMac.opadState;
        object = memoable;
        if (memoable != null) {
            HMac hMac3 = this;
            ((Memoable)((Object)hMac3.digest)).reset((Memoable)object);
            Digest digest = hMac3.digest;
            HMac hMac4 = this;
            object = hMac4.outputBuf;
            int n2 = hMac4.blockLength;
            int n3 = digest.getDigestSize();
            digest.update((byte[])object, n2, n3);
        } else {
            this.digest.update(this.outputBuf, 0, this.outputBuf.length);
        }
        HMac hMac5 = this;
        int n4 = hMac5.digest.doFinal(byArray, n);
        n = hMac5.blockLength;
        while (true) {
            object = this.outputBuf;
            if (n >= this.outputBuf.length) break;
            object[n] = 0;
            ++n;
        }
        Memoable memoable2 = this.ipadState;
        if (memoable2 != null) {
            ((Memoable)((Object)this.digest)).reset(memoable2);
        } else {
            this.digest.update(this.inputPad, 0, this.inputPad.length);
        }
        return n4;
    }

    @Override
    public void reset() {
        HMac hMac = this;
        hMac.digest.reset();
        hMac.digest.update(this.inputPad, 0, this.inputPad.length);
    }
}

