/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.macs;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Mac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class SipHash
implements Mac {
    public final int c;
    public final int d;
    public long k0;
    public long k1;
    public long v0;
    public long v1;
    public long v2;
    public long v3;
    public long m = 0L;
    public int wordPos = 0;
    public int wordCount = 0;

    public SipHash() {
        this.c = 2;
        this.d = 4;
    }

    public SipHash(int n, int n2) {
        this.c = n;
        this.d = n2;
    }

    public static long rotateLeft(long l, int n) {
        return l << n | l >>> -n;
    }

    @Override
    public String getAlgorithmName() {
        return a.a("SipHash-").append(this.c).append("-").append(this.d).toString();
    }

    @Override
    public int getMacSize() {
        return 8;
    }

    @Override
    public void init(CipherParameters object) {
        if (object instanceof KeyParameter) {
            byte[] byArray = ((KeyParameter)object).getKey();
            object = byArray;
            if (byArray.length == 16) {
                this.k0 = Pack.littleEndianToLong((byte[])object, 0);
                this.k1 = Pack.littleEndianToLong((byte[])object, 8);
                this.reset();
                return;
            }
            throw new IllegalArgumentException("'params' must be a 128-bit key");
        }
        throw new IllegalArgumentException("'params' must be an instance of KeyParameter");
    }

    @Override
    public void update(byte by) {
        SipHash sipHash = this;
        sipHash.m = sipHash.m >>> 8 | ((long)by & 0xFFL) << 56;
        this.wordPos = sipHash.wordPos + 1;
        if (this.wordPos == 8) {
            this.processMessageWord();
            this.wordPos = 0;
        }
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        int n3;
        int n4 = n2 & 0xFFFFFFF8;
        int n5 = this.wordPos;
        if (n5 == 0) {
            for (n3 = 0; n3 < n4; n3 += 8) {
                this.m = Pack.littleEndianToLong(byArray, n + n3);
                this.processMessageWord();
            }
            while (n3 < n2) {
                this.m = this.m >>> 8 | ((long)byArray[n + n3] & 0xFFL) << 56;
                ++n3;
            }
            this.wordPos = n2 - n4;
        } else {
            n5 <<= 3;
            while (n3 < n4) {
                long l = Pack.littleEndianToLong(byArray, n + n3);
                this.m = l << n5 | this.m >>> -n5;
                this.processMessageWord();
                this.m = l;
                n3 += 8;
            }
            while (n3 < n2) {
                SipHash sipHash = this;
                sipHash.m = sipHash.m >>> 8 | ((long)byArray[n + n3] & 0xFFL) << 56;
                this.wordPos = sipHash.wordPos + 1;
                if (this.wordPos == 8) {
                    this.processMessageWord();
                    this.wordPos = 0;
                }
                ++n3;
            }
        }
    }

    public long doFinal() {
        SipHash sipHash = this;
        int n = this.wordPos;
        sipHash.m = sipHash.m >>> (7 - n << 3) >>> 8 | ((long)((this.wordCount << 3) + n) & 0xFFL) << 56;
        sipHash.processMessageWord();
        sipHash.v2 ^= 0xFFL;
        sipHash.applySipRounds(sipHash.d);
        long l = sipHash.v0 ^ this.v1 ^ this.v2 ^ this.v3;
        this.reset();
        return l;
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        Pack.longToLittleEndian(this.doFinal(), byArray, n);
        return 8;
    }

    @Override
    public void reset() {
        SipHash sipHash = this;
        long l = sipHash.k0;
        sipHash.v0 = l ^ 0x736F6D6570736575L;
        long l2 = sipHash.k1;
        this.v1 = l2 ^ 0x646F72616E646F6DL;
        this.v2 = l ^ 0x6C7967656E657261L;
        sipHash.v3 = l2 ^ 0x7465646279746573L;
        sipHash.m = 0L;
        sipHash.wordPos = 0;
        sipHash.wordCount = 0;
    }

    public void processMessageWord() {
        SipHash sipHash = this;
        ++sipHash.wordCount;
        sipHash.v3 ^= this.m;
        sipHash.applySipRounds(sipHash.c);
        sipHash.v0 ^= this.m;
    }

    public void applySipRounds(int n) {
        SipHash sipHash = this;
        long l = sipHash.v0;
        long l2 = sipHash.v1;
        long l3 = sipHash.v2;
        long l4 = sipHash.v3;
        for (int k = 0; k < n; ++k) {
            long l5 = l3 + l4;
            l3 = l5;
            long l6 = l += l2;
            l2 = SipHash.rotateLeft(l2, 13);
            l = l2 ^ l;
            l2 = SipHash.rotateLeft(l4, 16) ^ l3;
            l3 = SipHash.rotateLeft(l6, 32);
            long l7 = l5 + l;
            l4 = l7;
            long l8 = l2;
            long l9 = l;
            l = l3 + l2;
            l2 = SipHash.rotateLeft(l9, 17);
            l2 ^= l4;
            l4 = SipHash.rotateLeft(l8, 21) ^ l;
            l3 = SipHash.rotateLeft(l7, 32);
        }
        SipHash sipHash2 = this;
        sipHash2.v0 = l;
        sipHash2.v1 = l2;
        sipHash2.v2 = l3;
        sipHash2.v3 = l4;
    }
}

