/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;

public class Blake3Parameters
implements CipherParameters {
    private static final int KEYLEN = 32;
    private byte[] theKey;
    private byte[] theContext;

    public static Blake3Parameters context(byte[] byArray) {
        if (byArray != null) {
            new Blake3Parameters().theContext = Arrays.clone(byArray);
            return new Blake3Parameters();
        }
        throw new IllegalArgumentException("Invalid context");
    }

    public static Blake3Parameters key(byte[] byArray) {
        if (byArray != null && byArray.length == 32) {
            new Blake3Parameters().theKey = Arrays.clone(byArray);
            return new Blake3Parameters();
        }
        throw new IllegalArgumentException("Invalid keyLength");
    }

    public byte[] getKey() {
        return Arrays.clone(this.theKey);
    }

    public void clearKey() {
        Arrays.fill(this.theKey, (byte)0);
    }

    public byte[] getContext() {
        return Arrays.clone(this.theContext);
    }
}

