/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DHKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DHParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Integers;
import java.math.BigInteger;

public class DHPublicKeyParameters
extends DHKeyParameters {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private BigInteger y;

    public DHPublicKeyParameters(BigInteger bigInteger, DHParameters dHParameters) {
        super(false, dHParameters);
        this.y = this.validate(bigInteger, dHParameters);
    }

    private BigInteger validate(BigInteger bigInteger, DHParameters object) {
        if (bigInteger != null) {
            BigInteger bigInteger2 = ((DHParameters)object).getP();
            BigInteger bigInteger3 = TWO;
            if (bigInteger.compareTo(bigInteger3) >= 0 && bigInteger.compareTo(bigInteger2.subtract(bigInteger3)) <= 0) {
                if ((object = ((DHParameters)object).getQ()) == null) {
                    return bigInteger;
                }
                if (bigInteger2.testBit(0) && bigInteger2.bitLength() - 1 == ((BigInteger)object).bitLength() && bigInteger2.shiftRight(1).equals(object) ? 1 == DHPublicKeyParameters.legendre(bigInteger, bigInteger2) : ONE.equals(bigInteger.modPow((BigInteger)object, bigInteger2))) {
                    return bigInteger;
                }
                throw new IllegalArgumentException("Y value does not appear to be in correct group");
            }
            throw new IllegalArgumentException("invalid DH public key");
        }
        throw new NullPointerException("y value cannot be null");
    }

    private static int legendre(BigInteger object, BigInteger object2) {
        int n = ((BigInteger)object2).bitLength();
        object = Nat.fromBigInteger(n, (BigInteger)object);
        int[] nArray = Nat.fromBigInteger(n, (BigInteger)object2);
        object2 = nArray;
        int n2 = 0;
        Object object3 = nArray.length;
        while (true) {
            Object object4;
            if ((object4 = object[0]) == false) {
                Nat.shiftDownWord(object3, (int[])object, 0);
                continue;
            }
            int n3 = Integers.numberOfTrailingZeros((int)object4);
            object4 = n3;
            if (n3 > 0) {
                Nat.shiftDownBits(object3, (int[])object, (int)object4, 0);
                Object object5 = object2[0];
                n2 ^= (object5 ^ object5 >>> 1) & object4 << 1;
            }
            int n4 = Nat.compare(object3, (int[])object, (int[])object2);
            object4 = n4;
            if (n4 == 0) {
                return Nat.isOne(object3, (int[])object2) ? 1 - (n2 & 2) : 0;
            }
            if (object4 < 0) {
                n2 ^= object[0] & object2[0];
                Object object6 = object2;
                object2 = object;
                object = object6;
            }
            while (true) {
                int n5 = object3 - 1;
                object4 = n5;
                if (object[n5] != false) break;
                object3 = object4;
            }
            Nat.sub(object3, (int[])object, (int[])object2, (int[])object);
        }
    }

    public BigInteger getY() {
        return this.y;
    }

    @Override
    public int hashCode() {
        return this.y.hashCode() ^ super.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof DHPublicKeyParameters)) {
            return false;
        }
        return ((DHPublicKeyParameters)object).getY().equals(this.y) && super.equals(object);
    }
}

