/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Signer;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SM3Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECDomainParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithID;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.DSAEncoding;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.DSAKCalculator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.RandomDSAKCalculator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.StandardDSAEncoding;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECAlgorithms;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECConstants;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECMultiplier;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.FixedPointCombMultiplier;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.BigIntegers;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SM2Signer
implements Signer,
ECConstants {
    private final DSAKCalculator kCalculator;
    private final Digest digest;
    private final DSAEncoding encoding;
    private ECDomainParameters ecParams;
    private ECPoint pubPoint;
    private ECKeyParameters ecKey;
    private byte[] z;

    public SM2Signer() {
        SM3Digest sM3Digest;
        SM2Signer sM2Signer = standardDSAEncoding;
        StandardDSAEncoding standardDSAEncoding = StandardDSAEncoding.INSTANCE;
        SM3Digest sM3Digest2 = sM3Digest;
        sM3Digest = new SM3Digest();
        sM2Signer(standardDSAEncoding, sM3Digest2);
    }

    public SM2Signer(Digest digest) {
        this(StandardDSAEncoding.INSTANCE, digest);
    }

    public SM2Signer(DSAEncoding dSAEncoding) {
        SM3Digest sM3Digest;
        RandomDSAKCalculator randomDSAKCalculator;
        Object object = randomDSAKCalculator;
        randomDSAKCalculator = new RandomDSAKCalculator();
        v1.kCalculator = object;
        v1.encoding = dSAEncoding;
        object = sM3Digest;
        sM3Digest = new SM3Digest();
        v1.digest = object;
    }

    public SM2Signer(DSAEncoding dSAEncoding, Digest digest) {
        RandomDSAKCalculator randomDSAKCalculator;
        RandomDSAKCalculator randomDSAKCalculator2 = randomDSAKCalculator;
        randomDSAKCalculator = new RandomDSAKCalculator();
        v1.kCalculator = randomDSAKCalculator2;
        v1.encoding = dSAEncoding;
        v1.digest = digest;
    }

    private boolean verifySignature(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = ((SM2Signer)object).ecParams.getN();
        BigInteger bigInteger4 = ECConstants.ONE;
        if (bigInteger.compareTo(bigInteger4) >= 0 && bigInteger.compareTo(bigInteger3) < 0) {
            if (bigInteger2.compareTo(bigInteger4) >= 0 && bigInteger2.compareTo(bigInteger3) < 0) {
                bigInteger4 = ((SM2Signer)object).calculateE(bigInteger3, ((SM2Signer)object).digestDoFinal());
                BigInteger bigInteger5 = bigInteger.add(bigInteger2).mod(bigInteger3);
                if (bigInteger5.equals(ECConstants.ZERO)) {
                    return false;
                }
                SM2Signer sM2Signer = object;
                Object object = ((ECPublicKeyParameters)sM2Signer.ecKey).getQ();
                object = ECAlgorithms.sumOfTwoMultiplies(sM2Signer.ecParams.getG(), bigInteger2, (ECPoint)object, bigInteger5).normalize();
                if (((ECPoint)object).isInfinity()) {
                    return false;
                }
                return bigInteger4.add(((ECPoint)object).getAffineXCoord().toBigInteger()).mod(bigInteger3).equals(bigInteger);
            }
            return false;
        }
        return false;
    }

    private byte[] digestDoFinal() {
        byte[] byArray = new byte[this.digest.getDigestSize()];
        SM2Signer sM2Signer = this;
        sM2Signer.digest.doFinal(byArray, 0);
        sM2Signer.reset();
        return byArray;
    }

    private byte[] getZ(byte[] byArray) {
        SM2Signer sM2Signer = this;
        sM2Signer.digest.reset();
        sM2Signer.addUserID(sM2Signer.digest, byArray);
        sM2Signer.addFieldElement(sM2Signer.digest, this.ecParams.getCurve().getA());
        sM2Signer.addFieldElement(sM2Signer.digest, this.ecParams.getCurve().getB());
        sM2Signer.addFieldElement(sM2Signer.digest, this.ecParams.getG().getAffineXCoord());
        sM2Signer.addFieldElement(sM2Signer.digest, this.ecParams.getG().getAffineYCoord());
        sM2Signer.addFieldElement(sM2Signer.digest, this.pubPoint.getAffineXCoord());
        sM2Signer.addFieldElement(sM2Signer.digest, this.pubPoint.getAffineYCoord());
        byte[] byArray2 = new byte[sM2Signer.digest.getDigestSize()];
        this.digest.doFinal(byArray2, 0);
        return byArray2;
    }

    private void addUserID(Digest digest, byte[] byArray) {
        int n = byArray.length * 8;
        digest.update((byte)(n >> 8 & 0xFF));
        digest.update((byte)(n & 0xFF));
        digest.update(byArray, 0, byArray.length);
    }

    private void addFieldElement(Digest digest, ECFieldElement eCFieldElement) {
        byte[] byArray = eCFieldElement.getEncoded();
        Object object = byArray;
        int n = byArray.length;
        digest.update((byte[])object, 0, n);
    }

    @Override
    public void init(boolean bl, CipherParameters object) {
        byte[] byArray;
        if (object instanceof ParametersWithID) {
            ParametersWithID parametersWithID = (ParametersWithID)object;
            object = parametersWithID.getParameters();
            byArray = parametersWithID.getID();
            if (byArray.length >= 8192) {
                throw new IllegalArgumentException("SM2 user ID must be less than 2^16 bits long");
            }
        } else {
            byArray = Hex.decodeStrict("31323334353637383132333435363738");
        }
        if (bl) {
            if (object instanceof ParametersWithRandom) {
                Object object2 = (ParametersWithRandom)object;
                ((SM2Signer)object3).ecKey = (ECKeyParameters)((ParametersWithRandom)object2).getParameters();
                object = ((SM2Signer)object3).ecKey.getParameters();
                ((SM2Signer)object3).ecParams = object;
                ParametersWithRandom parametersWithRandom = object2;
                object2 = ((ECDomainParameters)object).getN();
                ((SM2Signer)object3).kCalculator.init((BigInteger)object2, parametersWithRandom.getRandom());
            } else {
                ECDomainParameters eCDomainParameters;
                ((SM2Signer)object3).ecKey = (ECKeyParameters)object;
                ((SM2Signer)object3).ecParams = eCDomainParameters = ((SM2Signer)object3).ecKey.getParameters();
                ((SM2Signer)object3).kCalculator.init(eCDomainParameters.getN(), CryptoServicesRegistrar.getSecureRandom());
            }
            ((SM2Signer)object3).pubPoint = ((SM2Signer)object3).createBasePointMultiplier().multiply(((SM2Signer)object3).ecParams.getG(), ((ECPrivateKeyParameters)((SM2Signer)object3).ecKey).getD()).normalize();
        } else {
            ECKeyParameters eCKeyParameters;
            ((SM2Signer)object3).ecKey = eCKeyParameters = (ECKeyParameters)object;
            ((SM2Signer)object3).ecParams = eCKeyParameters.getParameters();
            ((SM2Signer)object3).pubPoint = ((ECPublicKeyParameters)((SM2Signer)object3).ecKey).getQ();
        }
        SM2Signer sM2Signer = object3;
        byte[] byArray2 = sM2Signer.getZ(byArray);
        Object object3 = byArray2;
        sM2Signer.z = byArray2;
        Object object4 = object3;
        sM2Signer.digest.update((byte[])object4, 0, ((Object)object4).length);
    }

    @Override
    public void update(byte by) {
        this.digest.update(by);
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        this.digest.update(byArray, n, n2);
    }

    @Override
    public boolean verifySignature(byte[] byArray) {
        BigInteger[] bigIntegerArray;
        SM2Signer sM2Signer;
        try {
            SM2Signer sM2Signer2 = bigInteger;
            sM2Signer = sM2Signer2;
            BigInteger[] bigIntegerArray2 = sM2Signer2.encoding.decode(((SM2Signer)((Object)bigInteger)).ecParams.getN(), byArray);
            bigIntegerArray = bigIntegerArray2;
            BigInteger bigInteger = bigIntegerArray2[0];
        }
        catch (Exception exception) {
            return false;
        }
        return sM2Signer.verifySignature(bigInteger, bigIntegerArray[1]);
    }

    @Override
    public void reset() {
        SM2Signer sM2Signer = this;
        sM2Signer.digest.reset();
        byte[] byArray = sM2Signer.z;
        if (sM2Signer.z != null) {
            this.digest.update(byArray, 0, byArray.length);
        }
    }

    @Override
    public byte[] generateSignature() {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        SM2Signer sM2Signer;
        BigInteger bigInteger3;
        SM2Signer sM2Signer2 = this;
        Object object = sM2Signer2.digestDoFinal();
        BigInteger bigInteger4 = sM2Signer2.ecParams.getN();
        object = sM2Signer2.calculateE(bigInteger4, (byte[])object);
        BigInteger bigInteger5 = ((ECPrivateKeyParameters)sM2Signer2.ecKey).getD();
        ECMultiplier eCMultiplier = sM2Signer2.createBasePointMultiplier();
        do {
            sM2Signer = this;
            bigInteger2 = sM2Signer.kCalculator.nextK();
        } while ((bigInteger3 = ((BigInteger)object).add(eCMultiplier.multiply(sM2Signer.ecParams.getG(), bigInteger2).normalize().getAffineXCoord().toBigInteger()).mod(bigInteger4)).equals(bigInteger = ECConstants.ZERO) || bigInteger3.add(bigInteger2).equals(bigInteger4) || (bigInteger2 = BigIntegers.modOddInverse(bigInteger4, bigInteger5.add(ECConstants.ONE)).multiply(bigInteger2.subtract(bigInteger3.multiply(bigInteger5)).mod(bigInteger4)).mod(bigInteger4)).equals(bigInteger));
        try {
            return this.encoding.encode(this.ecParams.getN(), bigInteger3, bigInteger2);
        }
        catch (Exception exception) {
            throw new CryptoException(com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.a.a(exception, a.a("unable to encode signature: ")), exception);
        }
    }

    public ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }

    public BigInteger calculateE(BigInteger bigInteger, byte[] byArray) {
        return new BigInteger(1, byArray);
    }
}

