/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.SecureRandom;

public class JournalingSecureRandom
extends SecureRandom {
    private static byte[] EMPTY_TRANSCRIPT = new byte[0];
    private final SecureRandom base;
    private TranscriptStream tOut;
    private byte[] transcript;
    private int index;

    public JournalingSecureRandom() {
        this(CryptoServicesRegistrar.getSecureRandom());
    }

    public JournalingSecureRandom(SecureRandom secureRandom) {
        JournalingSecureRandom journalingSecureRandom = this;
        this.tOut = new TranscriptStream(null);
        this.index = 0;
        journalingSecureRandom.base = secureRandom;
        journalingSecureRandom.transcript = EMPTY_TRANSCRIPT;
    }

    public JournalingSecureRandom(byte[] byArray, SecureRandom secureRandom) {
        this.tOut = new TranscriptStream(null);
        this.index = 0;
        this.base = secureRandom;
        this.transcript = Arrays.clone(byArray);
    }

    @Override
    public final void nextBytes(byte[] byArray) {
        if (this.index >= this.transcript.length) {
            this.base.nextBytes(byArray);
        } else {
            int n;
            int n2;
            for (n2 = 0; n2 != byArray.length; ++n2) {
                n = this.index;
                byte[] byArray2 = this.transcript;
                if (n >= this.transcript.length) break;
                this.index = n + 1;
                byArray[n2] = byArray2[n];
            }
            if (n2 != byArray.length) {
                n = byArray.length - n2;
                byte[] byArray3 = new byte[n];
                this.base.nextBytes(byArray3);
                System.arraycopy(byArray3, 0, byArray, n2, n);
            }
        }
        try {
            this.tOut.write(byArray);
            return;
        }
        catch (IOException iOException) {
            throw new IllegalStateException(b.a(iOException, a.a("unable to record transcript: ")));
        }
    }

    public void clear() {
        JournalingSecureRandom journalingSecureRandom = this;
        Arrays.fill(journalingSecureRandom.transcript, (byte)0);
        journalingSecureRandom.tOut.clear();
    }

    public void reset() {
        this.index = 0;
        if (this.transcript.length == 0) {
            this.transcript = this.tOut.toByteArray();
        }
        this.tOut.reset();
    }

    public byte[] getTranscript() {
        return this.tOut.toByteArray();
    }

    public byte[] getFullTranscript() {
        byte[] byArray = this.transcript;
        if (this.index == this.transcript.length) {
            return this.tOut.toByteArray();
        }
        return Arrays.clone(byArray);
    }

    public class TranscriptStream
    extends ByteArrayOutputStream {
        private TranscriptStream() {
        }

        public /* synthetic */ TranscriptStream(1 var2_2) {
            this();
        }

        public void clear() {
            Arrays.fill(this.buf, (byte)0);
        }
    }
}

