/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import java.io.IOException;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CompositePrivateKey
implements PrivateKey {
    private final List<PrivateKey> keys;

    public CompositePrivateKey(PrivateKey ... privateKeyArray) {
        if (privateKeyArray != null && privateKeyArray.length != 0) {
            ArrayList<PrivateKey> arrayList;
            ArrayList<PrivateKey> arrayList2 = arrayList;
            arrayList = new ArrayList<PrivateKey>(privateKeyArray.length);
            for (int k = 0; k != privateKeyArray.length; ++k) {
                arrayList2.add(privateKeyArray[k]);
            }
            this.keys = Collections.unmodifiableList(arrayList2);
            return;
        }
        throw new IllegalArgumentException("at least one public key must be provided");
    }

    public List<PrivateKey> getPrivateKeys() {
        return this.keys;
    }

    @Override
    public String getAlgorithm() {
        return "Composite";
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        DERSequence dERSequence;
        AlgorithmIdentifier algorithmIdentifier;
        PrivateKeyInfo privateKeyInfo;
        PrivateKeyInfo privateKeyInfo2;
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector = new ASN1EncodableVector();
        for (int k = 0; k != ((CompositePrivateKey)((Object)dERSequence2)).keys.size(); ++k) {
            aSN1EncodableVector2.add(PrivateKeyInfo.getInstance(((CompositePrivateKey)((Object)dERSequence2)).keys.get(k).getEncoded()));
        }
        try {
            PrivateKeyInfo privateKeyInfo3;
            privateKeyInfo2 = privateKeyInfo3;
            privateKeyInfo = privateKeyInfo3;
            algorithmIdentifier = new AlgorithmIdentifier(MiscObjectIdentifiers.id_alg_composite);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(b.a(iOException, a.a("unable to encode composite key: ")));
        }
        DERSequence dERSequence2 = dERSequence;
        dERSequence = new DERSequence(aSN1EncodableVector2);
        privateKeyInfo2(algorithmIdentifier, dERSequence2);
        return privateKeyInfo.getEncoded("DER");
    }

    public int hashCode() {
        return this.keys.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof CompositePrivateKey) {
            return this.keys.equals(((CompositePrivateKey)object).keys);
        }
        return false;
    }
}

