/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.ec;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.d;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.i;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.InvalidCipherTextException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.KeyEncoder;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.AESEngine;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.DESedeEngine;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.IESEngine;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators.ECKeyPairGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators.EphemeralKeyPairGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators.KDF2BytesGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.macs.HMac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.CBCBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECDomainParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECKeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.IESWithCipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.parsers.ECIESPublicKeyParser;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.DigestFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.ec.ECUtils;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.IESUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.util.BadBlockException;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.util.BCJcaJceHelper;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.util.JcaJceHelper;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.ECKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.IESKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.IESParameterSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;
import java.io.ByteArrayOutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.CipherSpi;
import javax.crypto.NoSuchPaddingException;

public class IESCipher
extends CipherSpi {
    private final JcaJceHelper helper;
    private int ivLength;
    private IESEngine engine;
    private int state;
    private ByteArrayOutputStream buffer;
    private AlgorithmParameters engineParam;
    private IESParameterSpec engineSpec;
    private AsymmetricKeyParameter key;
    private SecureRandom random;
    private boolean dhaesMode;
    private AsymmetricKeyParameter otherKeyParameter;

    public IESCipher(IESEngine iESEngine) {
        ByteArrayOutputStream byteArrayOutputStream;
        BCJcaJceHelper bCJcaJceHelper;
        Object object = bCJcaJceHelper;
        bCJcaJceHelper = new BCJcaJceHelper();
        v1.helper = object;
        v1.state = -1;
        object = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        v1.buffer = object;
        v1.engineParam = null;
        v1.engineSpec = null;
        v1.dhaesMode = false;
        v1.otherKeyParameter = null;
        v1.engine = iESEngine;
        v1.ivLength = 0;
    }

    public IESCipher(IESEngine iESEngine, int n) {
        ByteArrayOutputStream byteArrayOutputStream;
        BCJcaJceHelper bCJcaJceHelper;
        Object object = bCJcaJceHelper;
        bCJcaJceHelper = new BCJcaJceHelper();
        v1.helper = object;
        v1.state = -1;
        object = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        v1.buffer = object;
        v1.engineParam = null;
        v1.engineSpec = null;
        v1.dhaesMode = false;
        v1.otherKeyParameter = null;
        v1.engine = iESEngine;
        v1.ivLength = n;
    }

    @Override
    public int engineGetBlockSize() {
        if (this.engine.getCipher() != null) {
            return this.engine.getCipher().getBlockSize();
        }
        return 0;
    }

    @Override
    public int engineGetKeySize(Key key) {
        if (key instanceof ECKey) {
            return ((ECKey)((Object)key)).getParameters().getCurve().getFieldSize();
        }
        throw new IllegalArgumentException("not an EC key");
    }

    @Override
    public byte[] engineGetIV() {
        IESParameterSpec iESParameterSpec = ((IESCipher)((Object)iESParameterSpec)).engineSpec;
        if (iESParameterSpec != null) {
            return iESParameterSpec.getNonce();
        }
        return null;
    }

    @Override
    public AlgorithmParameters engineGetParameters() {
        if (this.engineParam == null && this.engineSpec != null) {
            AlgorithmParameters algorithmParameters;
            try {
                algorithmParameters = this.helper.createAlgorithmParameters("IES");
            }
            catch (Exception exception) {
                throw new RuntimeException(((Object)exception).toString());
            }
            this.engineParam = algorithmParameters;
            algorithmParameters.init(this.engineSpec);
        }
        return this.engineParam;
    }

    @Override
    public void engineSetMode(String string) {
        block4: {
            block3: {
                String string2;
                block2: {
                    string2 = Strings.toUpperCase(string);
                    if (!string2.equals("NONE")) break block2;
                    this.dhaesMode = false;
                    break block3;
                }
                if (!string2.equals("DHAES")) break block4;
                this.dhaesMode = true;
            }
            return;
        }
        throw new IllegalArgumentException(i.a("can't support mode ", string));
    }

    @Override
    public int engineGetOutputSize(int n) {
        if (this.key != null) {
            int n2;
            IESCipher iESCipher = this;
            int n3 = iESCipher.engine.getMac().getMacSize();
            int n4 = iESCipher.otherKeyParameter == null ? (((ECKeyParameters)this.key).getParameters().getCurve().getFieldSize() + 7) / 8 * 2 : 0;
            if (this.engine.getCipher() != null) {
                n2 = this.state;
                if (n2 != 1 && n2 != 3) {
                    if (n2 != 2 && n2 != 4) {
                        throw new IllegalStateException("cipher not initialised");
                    }
                    n = this.engine.getCipher().getOutputSize(n - n3 - n4);
                } else {
                    n = this.engine.getCipher().getOutputSize(n);
                }
            }
            if ((n2 = this.state) != 1 && n2 != 3) {
                if (n2 != 2 && n2 != 4) {
                    throw new IllegalStateException("cipher not initialised");
                }
                return this.buffer.size() - n3 - n4 + n;
            }
            return this.buffer.size() + n3 + 1 + n4 + n;
        }
        throw new IllegalStateException("cipher not initialised");
    }

    @Override
    public void engineSetPadding(String string) {
        String string2 = Strings.toUpperCase(string);
        if (!(string2.equals("NOPADDING") || string2.equals("PKCS5PADDING") || string2.equals("PKCS7PADDING"))) {
            throw new NoSuchPaddingException("padding not available with IESCipher");
        }
    }

    @Override
    public void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) {
        IESParameterSpec iESParameterSpec = null;
        if (algorithmParameters != null) {
            try {
                iESParameterSpec = algorithmParameters.getParameterSpec(IESParameterSpec.class);
            }
            catch (Exception exception) {
                throw new InvalidAlgorithmParameterException(d.a(exception, a.a("cannot recognise parameters: ")));
            }
        }
        this.engineParam = algorithmParameters;
        this.engineInit(n, key, iESParameterSpec, secureRandom);
    }

    @Override
    public void engineInit(int n, Key key, AlgorithmParameterSpec object, SecureRandom secureRandom) {
        block8: {
            block14: {
                block11: {
                    block13: {
                        block9: {
                            block12: {
                                block10: {
                                    int n2;
                                    block7: {
                                        block6: {
                                            this.otherKeyParameter = null;
                                            if (object != null) break block6;
                                            object = null;
                                            n2 = this.ivLength;
                                            if (n2 != 0 && n == 1) {
                                                byte[] byArray = new byte[n2];
                                                object = byArray;
                                                secureRandom.nextBytes(byArray);
                                            }
                                            this.engineSpec = IESUtil.guessParameterSpec(this.engine.getCipher(), (byte[])object);
                                            break block7;
                                        }
                                        if (!(object instanceof IESParameterSpec)) break block8;
                                        this.engineSpec = (IESParameterSpec)object;
                                    }
                                    IESCipher iESCipher = this;
                                    object = iESCipher.engineSpec.getNonce();
                                    n2 = iESCipher.ivLength;
                                    if (n2 != 0 && (object == null || ((Object)object).length != n2)) {
                                        throw new InvalidAlgorithmParameterException(b.a(a.a("NONCE in IES Parameters needs to be "), this.ivLength, " bytes long"));
                                    }
                                    if (n == 1 || n == 3) break block9;
                                    if (n != 2 && n != 4) {
                                        throw new InvalidKeyException("must be passed EC key");
                                    }
                                    if (!(key instanceof PrivateKey)) break block10;
                                    this.key = ECUtil.generatePrivateKeyParameter((PrivateKey)key);
                                    break block11;
                                }
                                if (!(key instanceof IESKey)) break block12;
                                IESCipher iESCipher = this;
                                key = (IESKey)key;
                                iESCipher.otherKeyParameter = ECUtils.generatePublicKeyParameter(key.getPublic());
                                iESCipher.key = ECUtil.generatePrivateKeyParameter(key.getPrivate());
                                break block11;
                            }
                            throw new InvalidKeyException("must be passed recipient's private EC key for decryption");
                        }
                        if (!(key instanceof PublicKey)) break block13;
                        this.key = ECUtils.generatePublicKeyParameter((PublicKey)key);
                        break block11;
                    }
                    if (!(key instanceof IESKey)) break block14;
                    IESCipher iESCipher = this;
                    key = (IESKey)key;
                    iESCipher.key = ECUtils.generatePublicKeyParameter(key.getPublic());
                    iESCipher.otherKeyParameter = ECUtil.generatePrivateKeyParameter(key.getPrivate());
                }
                this.random = secureRandom;
                this.state = n;
                this.buffer.reset();
                return;
            }
            throw new InvalidKeyException("must be passed recipient's public EC key for encryption");
        }
        throw new InvalidAlgorithmParameterException("must be passed IES parameters");
    }

    @Override
    public void engineInit(int n, Key key, SecureRandom secureRandom) {
        IESCipher iESCipher = iESCipher2;
        IESCipher iESCipher2 = null;
        try {
            iESCipher.engineInit(n, key, (AlgorithmParameterSpec)((Object)iESCipher2), secureRandom);
            return;
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new IllegalArgumentException(a.a("cannot handle supplied parameter spec: ").append(invalidAlgorithmParameterException.getMessage()).toString());
        }
    }

    @Override
    public byte[] engineUpdate(byte[] byArray, int n, int n2) {
        this.buffer.write(byArray, n, n2);
        return null;
    }

    @Override
    public int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        this.buffer.write(byArray, n, n2);
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] engineDoFinal(byte[] byArray, int n, int n2) {
        EphemeralKeyPairGenerator ephemeralKeyPairGenerator;
        ECKeyPairGenerator eCKeyPairGenerator;
        IESWithCipherParameters iESWithCipherParameters;
        if (n2 != 0) {
            ((IESCipher)((Object)eCIESPublicKeyParser2)).buffer.write(byArray, n, n2);
        }
        IESCipher iESCipher = eCIESPublicKeyParser2;
        byArray = iESCipher.buffer.toByteArray();
        iESCipher.buffer.reset();
        CipherParameters cipherParameters = iESWithCipherParameters;
        IESCipher iESCipher2 = eCIESPublicKeyParser2;
        byte[] byArray2 = iESCipher2.engineSpec.getEncodingV();
        int n3 = iESCipher2.engineSpec.getMacKeySize();
        int n4 = iESCipher2.engineSpec.getCipherKeySize();
        iESWithCipherParameters = new IESWithCipherParameters(((IESCipher)((Object)eCIESPublicKeyParser2)).engineSpec.getDerivationV(), byArray2, n3, n4);
        if (iESCipher.engineSpec.getNonce() != null) {
            ParametersWithIV parametersWithIV;
            ParametersWithIV parametersWithIV2 = parametersWithIV;
            parametersWithIV = new ParametersWithIV(cipherParameters, ((IESCipher)((Object)eCIESPublicKeyParser2)).engineSpec.getNonce());
            cipherParameters = parametersWithIV2;
        }
        IESCipher iESCipher3 = eCIESPublicKeyParser2;
        ECDomainParameters eCDomainParameters = ((ECKeyParameters)iESCipher3.key).getParameters();
        AsymmetricKeyParameter asymmetricKeyParameter = iESCipher3.otherKeyParameter;
        if (asymmetricKeyParameter != null) {
            try {
                int n5 = ((IESCipher)((Object)eCIESPublicKeyParser2)).state;
                if (n5 != 1 && n5 != 3) {
                    boolean bl = false;
                    ((IESCipher)((Object)eCIESPublicKeyParser2)).engine.init(bl, ((IESCipher)((Object)eCIESPublicKeyParser2)).key, asymmetricKeyParameter, cipherParameters);
                } else {
                    boolean bl = true;
                    AsymmetricKeyParameter asymmetricKeyParameter2 = ((IESCipher)((Object)eCIESPublicKeyParser2)).key;
                    ((IESCipher)((Object)eCIESPublicKeyParser2)).engine.init(bl, asymmetricKeyParameter, asymmetricKeyParameter2, cipherParameters);
                }
                int n6 = 0;
                return ((IESCipher)((Object)eCIESPublicKeyParser2)).engine.processBlock(byArray, n6, byArray.length);
            }
            catch (Exception exception) {
                throw new BadBlockException("unable to process block", exception);
            }
        }
        int n7 = ((IESCipher)((Object)eCIESPublicKeyParser2)).state;
        if (n7 != 1 && n7 != 3) {
            ECIESPublicKeyParser eCIESPublicKeyParser;
            CipherParameters cipherParameters2;
            AsymmetricKeyParameter asymmetricKeyParameter3;
            IESEngine iESEngine;
            IESCipher iESCipher4;
            if (n7 != 2 && n7 != 4) {
                throw new IllegalStateException("cipher not initialised");
            }
            try {
                IESCipher iESCipher5 = eCIESPublicKeyParser2;
                iESCipher4 = iESCipher5;
                iESEngine = iESCipher5.engine;
                asymmetricKeyParameter3 = ((IESCipher)((Object)eCIESPublicKeyParser2)).key;
                cipherParameters2 = cipherParameters;
            }
            catch (InvalidCipherTextException invalidCipherTextException) {
                throw new BadBlockException("unable to process block", invalidCipherTextException);
            }
            ECIESPublicKeyParser eCIESPublicKeyParser2 = eCIESPublicKeyParser;
            eCIESPublicKeyParser = new ECIESPublicKeyParser(eCDomainParameters);
            iESEngine.init(asymmetricKeyParameter3, cipherParameters2, eCIESPublicKeyParser2);
            IESEngine iESEngine2 = iESCipher4.engine;
            int n8 = 0;
            return iESEngine2.processBlock(byArray, n8, byArray.length);
        }
        IESCipher iESCipher6 = eCIESPublicKeyParser2;
        ECKeyPairGenerator eCKeyPairGenerator2 = eCKeyPairGenerator;
        new ECKeyPairGenerator().init(new ECKeyGenerationParameters(eCDomainParameters, ((IESCipher)((Object)eCIESPublicKeyParser2)).random));
        final boolean bl = iESCipher6.engineSpec.getPointCompression();
        EphemeralKeyPairGenerator ephemeralKeyPairGenerator2 = ephemeralKeyPairGenerator;
        ephemeralKeyPairGenerator = new EphemeralKeyPairGenerator(eCKeyPairGenerator2, new KeyEncoder(){

            @Override
            public byte[] getEncoded(AsymmetricKeyParameter asymmetricKeyParameter) {
                return ((ECPublicKeyParameters)asymmetricKeyParameter).getQ().getEncoded(bl);
            }
        });
        try {
            iESCipher6.engine.init(((IESCipher)((Object)eCIESPublicKeyParser2)).key, cipherParameters, ephemeralKeyPairGenerator2);
            int n9 = 0;
            return iESCipher6.engine.processBlock(byArray, n9, byArray.length);
        }
        catch (Exception exception) {
            throw new BadBlockException("unable to process block", exception);
        }
    }

    @Override
    public int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        byte[] byArray3 = this.engineDoFinal(byArray, n, n2);
        int n4 = byArray3.length;
        System.arraycopy(byArray3, 0, byArray2, n3, n4);
        return byArray3.length;
    }

    public static class ECIESwithAESCBC
    extends ECIESwithCipher {
        public ECIESwithAESCBC() {
            AESEngine aESEngine;
            CBCBlockCipher cBCBlockCipher;
            ECIESwithAESCBC eCIESwithAESCBC = cBCBlockCipher2;
            CBCBlockCipher cBCBlockCipher2 = cBCBlockCipher;
            AESEngine aESEngine2 = aESEngine;
            aESEngine = new AESEngine();
            cBCBlockCipher = new CBCBlockCipher(aESEngine2);
            super(cBCBlockCipher2, 16);
        }
    }

    public static class ECIESwithDESedeCBC
    extends ECIESwithCipher {
        public ECIESwithDESedeCBC() {
            DESedeEngine dESedeEngine;
            CBCBlockCipher cBCBlockCipher;
            ECIESwithDESedeCBC eCIESwithDESedeCBC = cBCBlockCipher2;
            CBCBlockCipher cBCBlockCipher2 = cBCBlockCipher;
            DESedeEngine dESedeEngine2 = dESedeEngine;
            dESedeEngine = new DESedeEngine();
            cBCBlockCipher = new CBCBlockCipher(dESedeEngine2);
            super(cBCBlockCipher2, 8);
        }
    }

    public static class ECIESwithCipher
    extends IESCipher {
        public ECIESwithCipher(BlockCipher blockCipher, int n) {
            PaddedBufferedBlockCipher paddedBufferedBlockCipher;
            HMac hMac;
            KDF2BytesGenerator kDF2BytesGenerator;
            ECIESwithCipher eCIESwithCipher = kDF2BytesGenerator2;
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA1());
            HMac hMac2 = hMac;
            hMac = new HMac(DigestFactory.createSHA1());
            PaddedBufferedBlockCipher paddedBufferedBlockCipher2 = paddedBufferedBlockCipher;
            paddedBufferedBlockCipher = new PaddedBufferedBlockCipher(blockCipher);
            super(new IESEngine(new ECDHBasicAgreement(), kDF2BytesGenerator2, hMac2, paddedBufferedBlockCipher2), n);
        }
    }

    public static class ECIES
    extends IESCipher {
        public ECIES() {
            HMac hMac;
            KDF2BytesGenerator kDF2BytesGenerator;
            ECIES eCIES = kDF2BytesGenerator2;
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA1());
            HMac hMac2 = hMac;
            hMac = new HMac(DigestFactory.createSHA1());
            super(new IESEngine(new ECDHBasicAgreement(), kDF2BytesGenerator2, hMac2));
        }
    }
}

