/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.ecgost12;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9IntegerConverter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DerivationFunction;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement.ECVKOAgreement;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.GOST3411_2012_256Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECDomainParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithUKM;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.ecgost12.BCECGOST3410_2012PublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.BaseAgreementSpi;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.spec.UserKeyingMaterialSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.ECPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.ECPublicKey;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class KeyAgreementSpi
extends BaseAgreementSpi {
    private static final X9IntegerConverter converter = new X9IntegerConverter();
    private String kaAlgorithm;
    private ECDomainParameters parameters;
    private ECVKOAgreement agreement;
    private byte[] result;

    public KeyAgreementSpi(String string, ECVKOAgreement eCVKOAgreement, DerivationFunction derivationFunction) {
        super(string, derivationFunction);
        this.kaAlgorithm = string;
        this.agreement = eCVKOAgreement;
    }

    private void initFromKey(Key object, AlgorithmParameterSpec object2) {
        if (object instanceof PrivateKey) {
            object = (ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter((PrivateKey)object);
            this.parameters = ((ECKeyParameters)object).getParameters();
            object2 = object2 instanceof UserKeyingMaterialSpec ? (Object)((UserKeyingMaterialSpec)object2).getUserKeyingMaterial() : null;
            this.ukmParameters = (byte[])object2;
            this.agreement.init(new ParametersWithUKM((CipherParameters)object, (byte[])object2));
            return;
        }
        throw new InvalidKeyException(d.a.a(new StringBuilder().append(this.kaAlgorithm).append(" key agreement requires "), KeyAgreementSpi.getSimpleName(ECPrivateKey.class), " for initialisation"));
    }

    private static String getSimpleName(Class clazz) {
        String string = clazz.getName();
        return string.substring(string.lastIndexOf(46) + 1);
    }

    public static AsymmetricKeyParameter generatePublicKeyParameter(PublicKey publicKey) {
        return publicKey instanceof BCECGOST3410_2012PublicKey ? ((BCECGOST3410_2012PublicKey)publicKey).engineGetKeyParameters() : ECUtil.generatePublicKeyParameter(publicKey);
    }

    @Override
    public Key engineDoPhase(Key object, boolean bl) {
        if (this.parameters != null) {
            if (bl) {
                if (object instanceof PublicKey) {
                    object = KeyAgreementSpi.generatePublicKeyParameter((PublicKey)object);
                    try {
                        this.result = this.agreement.calculateAgreement((CipherParameters)object);
                        return null;
                    }
                    catch (Exception exception) {
                        throw new InvalidKeyException(com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.a.a(exception, a.a("calculation failed: "))){

                            @Override
                            public Throwable getCause() {
                                return exception;
                            }
                        };
                    }
                }
                throw new InvalidKeyException(d.a.a(new StringBuilder().append(this.kaAlgorithm).append(" key agreement requires "), KeyAgreementSpi.getSimpleName(ECPublicKey.class), " for doPhase"));
            }
            throw new IllegalStateException(d.a.a(new StringBuilder(), this.kaAlgorithm, " can only be between two parties."));
        }
        throw new IllegalStateException(d.a.a(new StringBuilder(), this.kaAlgorithm, " not initialised."));
    }

    @Override
    public void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) {
        if (algorithmParameterSpec != null && !(algorithmParameterSpec instanceof UserKeyingMaterialSpec)) {
            throw new InvalidAlgorithmParameterException("No algorithm parameters supported");
        }
        this.initFromKey(key, algorithmParameterSpec);
    }

    @Override
    public void engineInit(Key key, SecureRandom secureRandom) {
        this.initFromKey(key, null);
    }

    @Override
    public byte[] calcSecret() {
        return this.result;
    }

    public static class ECVKO512
    extends KeyAgreementSpi {
        public ECVKO512() {
            GOST3411_2012_256Digest gOST3411_2012_256Digest;
            ECVKOAgreement eCVKOAgreement;
            ECVKO512 eCVKO512 = eCVKOAgreement2;
            ECVKOAgreement eCVKOAgreement2 = eCVKOAgreement;
            GOST3411_2012_256Digest gOST3411_2012_256Digest2 = gOST3411_2012_256Digest;
            gOST3411_2012_256Digest = new GOST3411_2012_256Digest();
            eCVKOAgreement = new ECVKOAgreement(gOST3411_2012_256Digest2);
            super("ECGOST3410-2012-512", eCVKOAgreement2, null);
        }
    }

    public static class ECVKO256
    extends KeyAgreementSpi {
        public ECVKO256() {
            GOST3411_2012_256Digest gOST3411_2012_256Digest;
            ECVKOAgreement eCVKOAgreement;
            ECVKO256 eCVKO256 = eCVKOAgreement2;
            ECVKOAgreement eCVKOAgreement2 = eCVKOAgreement;
            GOST3411_2012_256Digest gOST3411_2012_256Digest2 = gOST3411_2012_256Digest;
            gOST3411_2012_256Digest = new GOST3411_2012_256Digest();
            eCVKOAgreement = new ECVKOAgreement(gOST3411_2012_256Digest2);
            super("ECGOST3410-2012-256", eCVKOAgreement2, null);
        }
    }
}

