/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.edec;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DerivationFunction;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.RawAgreement;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement.X25519Agreement;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement.X448Agreement;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement.XDHUnifiedAgreement;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement.kdf.ConcatenationKDFGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators.KDF2BytesGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.X448PrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.XDHUPrivateParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.XDHUPublicParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.DigestFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.edec.BCXDHPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.edec.BCXDHPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.BaseAgreementSpi;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.spec.DHUParameterSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.spec.UserKeyingMaterialSpec;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class KeyAgreementSpi
extends BaseAgreementSpi {
    private RawAgreement agreement;
    private DHUParameterSpec dhuSpec;
    private byte[] result;

    public KeyAgreementSpi(String string) {
        super(string, null);
    }

    public KeyAgreementSpi(String string, DerivationFunction derivationFunction) {
        super(string, derivationFunction);
    }

    private RawAgreement getAgreement(String string) {
        if (!((BaseAgreementSpi)object).kaAlgorithm.equals("XDH") && !((BaseAgreementSpi)object).kaAlgorithm.startsWith(string)) {
            throw new InvalidKeyException(a.a("inappropriate key for ").append(((BaseAgreementSpi)object).kaAlgorithm).toString());
        }
        if (((BaseAgreementSpi)object).kaAlgorithm.indexOf(85) > 0) {
            X25519Agreement x25519Agreement;
            Object object;
            if (string.startsWith("X448")) {
                X448Agreement x448Agreement;
                object = x448Agreement;
                x448Agreement = new X448Agreement();
                return new XDHUnifiedAgreement((RawAgreement)object);
            }
            object = x25519Agreement;
            x25519Agreement = new X25519Agreement();
            return new XDHUnifiedAgreement((RawAgreement)object);
        }
        if (string.startsWith("X448")) {
            return new X448Agreement();
        }
        return new X25519Agreement();
    }

    @Override
    public byte[] calcSecret() {
        return this.result;
    }

    @Override
    public void engineInit(Key object, SecureRandom secureRandom) {
        if (object instanceof BCXDHPrivateKey) {
            this.agreement = (object = ((BCXDHPrivateKey)object).engineGetKeyParameters()) instanceof X448PrivateKeyParameters ? this.getAgreement("X448") : this.getAgreement("X25519");
            KeyAgreementSpi keyAgreementSpi = this;
            keyAgreementSpi.agreement.init((CipherParameters)object);
            this.ukmParameters = (byte[])(keyAgreementSpi.kdf != null ? new byte[0] : null);
            return;
        }
        throw new InvalidKeyException("cannot identify XDH private key");
    }

    @Override
    public void engineInit(Key object, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) {
        block4: {
            block8: {
                block9: {
                    block7: {
                        block5: {
                            block6: {
                                if (!(object instanceof BCXDHPrivateKey)) break block4;
                                this.agreement = (object = ((BCXDHPrivateKey)object).engineGetKeyParameters()) instanceof X448PrivateKeyParameters ? this.getAgreement("X448") : this.getAgreement("X25519");
                                this.ukmParameters = null;
                                if (!(algorithmParameterSpec instanceof DHUParameterSpec)) break block5;
                                if (this.kaAlgorithm.indexOf(85) < 0) break block6;
                                algorithmParameterSpec = (DHUParameterSpec)algorithmParameterSpec;
                                this.dhuSpec = algorithmParameterSpec;
                                this.ukmParameters = ((DHUParameterSpec)algorithmParameterSpec).getUserKeyingMaterial();
                                Object object2 = object;
                                KeyAgreementSpi keyAgreementSpi = this;
                                object = ((BCXDHPrivateKey)keyAgreementSpi.dhuSpec.getEphemeralPrivateKey()).engineGetKeyParameters();
                                this.agreement.init(new XDHUPrivateParameters((AsymmetricKeyParameter)object2, (AsymmetricKeyParameter)object, ((BCXDHPublicKey)keyAgreementSpi.dhuSpec.getEphemeralPublicKey()).engineGetKeyParameters()));
                                break block7;
                            }
                            throw new InvalidAlgorithmParameterException("agreement algorithm not DHU based");
                        }
                        this.agreement.init((CipherParameters)object);
                        if (!(algorithmParameterSpec instanceof UserKeyingMaterialSpec)) break block8;
                        if (this.kdf == null) break block9;
                        this.ukmParameters = ((UserKeyingMaterialSpec)algorithmParameterSpec).getUserKeyingMaterial();
                    }
                    if (this.kdf != null && this.ukmParameters == null) {
                        this.ukmParameters = new byte[0];
                    }
                    return;
                }
                throw new InvalidAlgorithmParameterException("no KDF specified for UserKeyingMaterialSpec");
            }
            throw new InvalidAlgorithmParameterException("unknown ParameterSpec");
        }
        throw new InvalidKeyException("cannot identify XDH private key");
    }

    @Override
    public Key engineDoPhase(Key object, boolean bl) {
        if (((KeyAgreementSpi)((Object)xDHUPublicParameters2)).agreement != null) {
            if (bl) {
                if (object instanceof BCXDHPublicKey) {
                    KeyAgreementSpi keyAgreementSpi = xDHUPublicParameters2;
                    object = ((BCXDHPublicKey)object).engineGetKeyParameters();
                    byte[] byArray = new byte[keyAgreementSpi.agreement.getAgreementSize()];
                    keyAgreementSpi.result = byArray;
                    DHUParameterSpec dHUParameterSpec = keyAgreementSpi.dhuSpec;
                    if (dHUParameterSpec != null) {
                        XDHUPublicParameters xDHUPublicParameters;
                        KeyAgreementSpi keyAgreementSpi2 = xDHUPublicParameters2;
                        XDHUPublicParameters xDHUPublicParameters2 = xDHUPublicParameters;
                        xDHUPublicParameters = new XDHUPublicParameters((AsymmetricKeyParameter)object, ((BCXDHPublicKey)dHUParameterSpec.getOtherPartyEphemeralKey()).engineGetKeyParameters());
                        ((KeyAgreementSpi)((Object)xDHUPublicParameters2)).agreement.calculateAgreement(xDHUPublicParameters2, keyAgreementSpi2.result, 0);
                    } else {
                        ((KeyAgreementSpi)((Object)xDHUPublicParameters2)).agreement.calculateAgreement((CipherParameters)object, byArray, 0);
                    }
                    return null;
                }
                throw new InvalidKeyException("cannot identify XDH private key");
            }
            throw new IllegalStateException(d.a.a(new StringBuilder(), ((BaseAgreementSpi)((Object)xDHUPublicParameters2)).kaAlgorithm, " can only be between two parties."));
        }
        throw new IllegalStateException(d.a.a(new StringBuilder(), ((BaseAgreementSpi)((Object)xDHUPublicParameters2)).kaAlgorithm, " not initialised."));
    }

    public static class X448UwithSHA512KDF
    extends KeyAgreementSpi {
        public X448UwithSHA512KDF() {
            KDF2BytesGenerator kDF2BytesGenerator;
            X448UwithSHA512KDF x448UwithSHA512KDF = kDF2BytesGenerator2;
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA512());
            super("X448UwithSHA512KDF", kDF2BytesGenerator2);
        }
    }

    public static class X25519UwithSHA256KDF
    extends KeyAgreementSpi {
        public X25519UwithSHA256KDF() {
            KDF2BytesGenerator kDF2BytesGenerator;
            X25519UwithSHA256KDF x25519UwithSHA256KDF = kDF2BytesGenerator2;
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA256());
            super("X25519UwithSHA256KDF", kDF2BytesGenerator2);
        }
    }

    public static class X448UwithSHA512CKDF
    extends KeyAgreementSpi {
        public X448UwithSHA512CKDF() {
            ConcatenationKDFGenerator concatenationKDFGenerator;
            X448UwithSHA512CKDF x448UwithSHA512CKDF = concatenationKDFGenerator2;
            ConcatenationKDFGenerator concatenationKDFGenerator2 = concatenationKDFGenerator;
            concatenationKDFGenerator = new ConcatenationKDFGenerator(DigestFactory.createSHA512());
            super("X448UwithSHA512CKDF", concatenationKDFGenerator2);
        }
    }

    public static class X25519UwithSHA256CKDF
    extends KeyAgreementSpi {
        public X25519UwithSHA256CKDF() {
            ConcatenationKDFGenerator concatenationKDFGenerator;
            X25519UwithSHA256CKDF x25519UwithSHA256CKDF = concatenationKDFGenerator2;
            ConcatenationKDFGenerator concatenationKDFGenerator2 = concatenationKDFGenerator;
            concatenationKDFGenerator = new ConcatenationKDFGenerator(DigestFactory.createSHA256());
            super("X25519UwithSHA256CKDF", concatenationKDFGenerator2);
        }
    }

    public static final class X448withSHA512KDF
    extends KeyAgreementSpi {
        public X448withSHA512KDF() {
            KDF2BytesGenerator kDF2BytesGenerator;
            X448withSHA512KDF x448withSHA512KDF = kDF2BytesGenerator2;
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA512());
            super("X448withSHA512KDF", kDF2BytesGenerator2);
        }
    }

    public static final class X25519withSHA256KDF
    extends KeyAgreementSpi {
        public X25519withSHA256KDF() {
            KDF2BytesGenerator kDF2BytesGenerator;
            X25519withSHA256KDF x25519withSHA256KDF = kDF2BytesGenerator2;
            KDF2BytesGenerator kDF2BytesGenerator2 = kDF2BytesGenerator;
            kDF2BytesGenerator = new KDF2BytesGenerator(DigestFactory.createSHA256());
            super("X25519withSHA256KDF", kDF2BytesGenerator2);
        }
    }

    public static final class X448withSHA512CKDF
    extends KeyAgreementSpi {
        public X448withSHA512CKDF() {
            ConcatenationKDFGenerator concatenationKDFGenerator;
            X448withSHA512CKDF x448withSHA512CKDF = concatenationKDFGenerator2;
            ConcatenationKDFGenerator concatenationKDFGenerator2 = concatenationKDFGenerator;
            concatenationKDFGenerator = new ConcatenationKDFGenerator(DigestFactory.createSHA512());
            super("X448withSHA512CKDF", concatenationKDFGenerator2);
        }
    }

    public static class X448withSHA384CKDF
    extends KeyAgreementSpi {
        public X448withSHA384CKDF() {
            ConcatenationKDFGenerator concatenationKDFGenerator;
            X448withSHA384CKDF x448withSHA384CKDF = concatenationKDFGenerator2;
            ConcatenationKDFGenerator concatenationKDFGenerator2 = concatenationKDFGenerator;
            concatenationKDFGenerator = new ConcatenationKDFGenerator(DigestFactory.createSHA384());
            super("X448withSHA384CKDF", concatenationKDFGenerator2);
        }
    }

    public static final class X448withSHA256CKDF
    extends KeyAgreementSpi {
        public X448withSHA256CKDF() {
            ConcatenationKDFGenerator concatenationKDFGenerator;
            X448withSHA256CKDF x448withSHA256CKDF = concatenationKDFGenerator2;
            ConcatenationKDFGenerator concatenationKDFGenerator2 = concatenationKDFGenerator;
            concatenationKDFGenerator = new ConcatenationKDFGenerator(DigestFactory.createSHA256());
            super("X448withSHA256CKDF", concatenationKDFGenerator2);
        }
    }

    public static class X25519withSHA512CKDF
    extends KeyAgreementSpi {
        public X25519withSHA512CKDF() {
            ConcatenationKDFGenerator concatenationKDFGenerator;
            X25519withSHA512CKDF x25519withSHA512CKDF = concatenationKDFGenerator2;
            ConcatenationKDFGenerator concatenationKDFGenerator2 = concatenationKDFGenerator;
            concatenationKDFGenerator = new ConcatenationKDFGenerator(DigestFactory.createSHA512());
            super("X25519withSHA512CKDF", concatenationKDFGenerator2);
        }
    }

    public static class X25519withSHA384CKDF
    extends KeyAgreementSpi {
        public X25519withSHA384CKDF() {
            ConcatenationKDFGenerator concatenationKDFGenerator;
            X25519withSHA384CKDF x25519withSHA384CKDF = concatenationKDFGenerator2;
            ConcatenationKDFGenerator concatenationKDFGenerator2 = concatenationKDFGenerator;
            concatenationKDFGenerator = new ConcatenationKDFGenerator(DigestFactory.createSHA384());
            super("X25519withSHA384CKDF", concatenationKDFGenerator2);
        }
    }

    public static final class X25519withSHA256CKDF
    extends KeyAgreementSpi {
        public X25519withSHA256CKDF() {
            ConcatenationKDFGenerator concatenationKDFGenerator;
            X25519withSHA256CKDF x25519withSHA256CKDF = concatenationKDFGenerator2;
            ConcatenationKDFGenerator concatenationKDFGenerator2 = concatenationKDFGenerator;
            concatenationKDFGenerator = new ConcatenationKDFGenerator(DigestFactory.createSHA256());
            super("X25519withSHA256CKDF", concatenationKDFGenerator2);
        }
    }

    public static final class X25519
    extends KeyAgreementSpi {
        public X25519() {
            super("X25519");
        }
    }

    public static final class X448
    extends KeyAgreementSpi {
        public X448() {
            super("X448");
        }
    }

    public static final class XDH
    extends KeyAgreementSpi {
        public XDH() {
            super("XDH");
        }
    }
}

