/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.edec;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Signer;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.Ed448PrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.Ed448PublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.Ed25519Signer;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.Ed448Signer;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.edec.BCEdDSAPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.edec.BCEdDSAPublicKey;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;

public class SignatureSpi
extends java.security.SignatureSpi {
    private static final byte[] EMPTY_CONTEXT = new byte[0];
    private final String algorithm;
    private Signer signer;

    public SignatureSpi(String string) {
        this.algorithm = string;
    }

    private Signer getSigner(String string) {
        String string2 = this.algorithm;
        if (string2 != null && !string.equals(string2)) {
            throw new InvalidKeyException(a.a("inappropriate key for ").append(this.algorithm).toString());
        }
        if (string.equals("Ed448")) {
            return new Ed448Signer(EMPTY_CONTEXT);
        }
        return new Ed25519Signer();
    }

    @Override
    public void engineInitVerify(PublicKey object) {
        if (object instanceof BCEdDSAPublicKey) {
            this.signer = (object = ((BCEdDSAPublicKey)object).engineGetKeyParameters()) instanceof Ed448PublicKeyParameters ? this.getSigner("Ed448") : this.getSigner("Ed25519");
            this.signer.init(false, (CipherParameters)object);
            return;
        }
        throw new InvalidKeyException("cannot identify EdDSA public key");
    }

    @Override
    public void engineInitSign(PrivateKey object) {
        if (object instanceof BCEdDSAPrivateKey) {
            this.signer = (object = ((BCEdDSAPrivateKey)object).engineGetKeyParameters()) instanceof Ed448PrivateKeyParameters ? this.getSigner("Ed448") : this.getSigner("Ed25519");
            this.signer.init(true, (CipherParameters)object);
            return;
        }
        throw new InvalidKeyException("cannot identify EdDSA private key");
    }

    @Override
    public void engineUpdate(byte by) {
        this.signer.update(by);
    }

    @Override
    public void engineUpdate(byte[] byArray, int n, int n2) {
        this.signer.update(byArray, n, n2);
    }

    @Override
    public byte[] engineSign() {
        try {
            return this.signer.generateSignature();
        }
        catch (CryptoException cryptoException) {
            throw new SignatureException(cryptoException.getMessage());
        }
    }

    @Override
    public boolean engineVerify(byte[] byArray) {
        return this.signer.verifySignature(byArray);
    }

    @Override
    public void engineSetParameter(String string, Object object) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    public Object engineGetParameter(String string) {
        throw new UnsupportedOperationException("engineGetParameter unsupported");
    }

    @Override
    public AlgorithmParameters engineGetParameters() {
        return null;
    }

    public static final class Ed25519
    extends SignatureSpi {
        public Ed25519() {
            super("Ed25519");
        }
    }

    public static final class Ed448
    extends SignatureSpi {
        public Ed448() {
            super("Ed448");
        }
    }

    public static final class EdDSA
    extends SignatureSpi {
        public EdDSA() {
            super(null);
        }
    }
}

