/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.gost;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.GOST3410PrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.gost.GOSTUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.GOST3410Util;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.PKCS12BagAttributeCarrierImpl;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.GOST3410Params;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.GOST3410PrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.PKCS12BagAttributeCarrier;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.GOST3410ParameterSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.GOST3410PrivateKeySpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.GOST3410PublicKeyParameterSetSpec;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.util.Enumeration;

public class BCGOST3410PrivateKey
implements GOST3410PrivateKey,
PKCS12BagAttributeCarrier {
    public static final long serialVersionUID = 8581661527592305464L;
    private BigInteger x;
    private transient GOST3410Params gost3410Spec;
    private transient PKCS12BagAttributeCarrier attrCarrier;

    public BCGOST3410PrivateKey() {
        PKCS12BagAttributeCarrierImpl pKCS12BagAttributeCarrierImpl;
        PKCS12BagAttributeCarrier pKCS12BagAttributeCarrier = pKCS12BagAttributeCarrierImpl;
        pKCS12BagAttributeCarrierImpl = new PKCS12BagAttributeCarrierImpl();
        v1.attrCarrier = pKCS12BagAttributeCarrier;
    }

    public BCGOST3410PrivateKey(GOST3410PrivateKey gOST3410PrivateKey) {
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        this.x = gOST3410PrivateKey.getX();
        this.gost3410Spec = gOST3410PrivateKey.getParameters();
    }

    public BCGOST3410PrivateKey(GOST3410PrivateKeySpec object) {
        BCGOST3410PrivateKey bCGOST3410PrivateKey = serializable;
        serializable.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        bCGOST3410PrivateKey.x = ((GOST3410PrivateKeySpec)object).getX();
        GOST3410PrivateKeySpec gOST3410PrivateKeySpec = object;
        Serializable serializable = gOST3410PrivateKeySpec.getP();
        object = gOST3410PrivateKeySpec.getQ();
        BigInteger bigInteger = gOST3410PrivateKeySpec.getA();
        bCGOST3410PrivateKey.gost3410Spec = new GOST3410ParameterSpec(new GOST3410PublicKeyParameterSetSpec((BigInteger)serializable, (BigInteger)object, bigInteger));
    }

    public BCGOST3410PrivateKey(PrivateKeyInfo object) {
        PrivateKeyInfo privateKeyInfo = object;
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        GOST3410PublicKeyAlgParameters gOST3410PublicKeyAlgParameters = GOST3410PublicKeyAlgParameters.getInstance(privateKeyInfo.getPrivateKeyAlgorithm().getParameters());
        Object object2 = privateKeyInfo.parsePrivateKey();
        if (object2 instanceof ASN1Integer) {
            this.x = ASN1Integer.getInstance(object2).getPositiveValue();
        } else {
            BigInteger bigInteger;
            byte[] byArray = ASN1OctetString.getInstance(((PrivateKeyInfo)object).parsePrivateKey()).getOctets();
            object = byArray;
            object2 = new byte[byArray.length];
            for (int k = 0; k != ((Object)object).length; ++k) {
                Object object3 = object;
                object2[k] = object3[((Object)object3).length - 1 - k];
            }
            object = bigInteger;
            bigInteger = new BigInteger(1, (byte[])object2);
            this.x = object;
        }
        this.gost3410Spec = GOST3410ParameterSpec.fromPublicKeyAlg(gOST3410PublicKeyAlgParameters);
    }

    public BCGOST3410PrivateKey(GOST3410PrivateKeyParameters gOST3410PrivateKeyParameters, GOST3410ParameterSpec gOST3410ParameterSpec) {
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        this.x = gOST3410PrivateKeyParameters.getX();
        this.gost3410Spec = gOST3410ParameterSpec;
        if (gOST3410ParameterSpec != null) {
            return;
        }
        throw new IllegalArgumentException("spec is null");
    }

    private boolean compareObj(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null) {
            return false;
        }
        return object.equals(object2);
    }

    private void readObject(ObjectInputStream object) {
        PKCS12BagAttributeCarrierImpl pKCS12BagAttributeCarrierImpl;
        ObjectInputStream objectInputStream = object;
        objectInputStream.defaultReadObject();
        String string = (String)objectInputStream.readObject();
        if (string != null) {
            ObjectInputStream objectInputStream2 = object;
            object = (String)objectInputStream2.readObject();
            pKCS12BagAttributeCarrier.gost3410Spec = new GOST3410ParameterSpec(string, (String)object, (String)objectInputStream2.readObject());
        } else {
            ObjectInputStream objectInputStream3 = object;
            BigInteger bigInteger = (BigInteger)((ObjectInputStream)object).readObject();
            Object object2 = object;
            object = (BigInteger)((ObjectInputStream)object2).readObject();
            pKCS12BagAttributeCarrier.gost3410Spec = new GOST3410ParameterSpec(new GOST3410PublicKeyParameterSetSpec(bigInteger, (BigInteger)object, (BigInteger)((ObjectInputStream)object2).readObject()));
            objectInputStream3.readObject();
            objectInputStream3.readObject();
        }
        BCGOST3410PrivateKey bCGOST3410PrivateKey = pKCS12BagAttributeCarrier;
        PKCS12BagAttributeCarrier pKCS12BagAttributeCarrier = pKCS12BagAttributeCarrierImpl;
        pKCS12BagAttributeCarrierImpl = new PKCS12BagAttributeCarrierImpl();
        bCGOST3410PrivateKey.attrCarrier = pKCS12BagAttributeCarrier;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        if (this.gost3410Spec.getPublicKeyParamSetOID() != null) {
            objectOutputStream.writeObject(this.gost3410Spec.getPublicKeyParamSetOID());
            objectOutputStream.writeObject(this.gost3410Spec.getDigestParamSetOID());
            objectOutputStream.writeObject(this.gost3410Spec.getEncryptionParamSetOID());
        } else {
            objectOutputStream.writeObject(null);
            objectOutputStream.writeObject(this.gost3410Spec.getPublicKeyParameters().getP());
            objectOutputStream.writeObject(this.gost3410Spec.getPublicKeyParameters().getQ());
            objectOutputStream.writeObject(this.gost3410Spec.getPublicKeyParameters().getA());
            objectOutputStream.writeObject(this.gost3410Spec.getDigestParamSetOID());
            objectOutputStream.writeObject(this.gost3410Spec.getEncryptionParamSetOID());
        }
    }

    @Override
    public String getAlgorithm() {
        return "GOST3410";
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte[] getEncoded() {
        DEROctetString dEROctetString;
        PrivateKeyInfo privateKeyInfo;
        void var1_4;
        byte[] byArray;
        block7: {
            PrivateKeyInfo privateKeyInfo2;
            byte[] byArray2 = ((BCGOST3410PrivateKey)((Object)dEROctetString2)).getX().toByteArray();
            byArray = byArray2[0] == 0 ? new byte[byArray2.length - 1] : new byte[byArray2.length];
            for (int k = 0; k != byArray.length; ++k) {
                byArray[k] = byArray2[byArray2.length - 1 - k];
            }
            try {
                if (!(((BCGOST3410PrivateKey)((Object)dEROctetString2)).gost3410Spec instanceof GOST3410ParameterSpec)) break block7;
            }
            catch (IOException iOException) {
                return null;
            }
            PrivateKeyInfo privateKeyInfo3 = privateKeyInfo2;
            privateKeyInfo2 = new PrivateKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_94, new GOST3410PublicKeyAlgParameters(new ASN1ObjectIdentifier(((BCGOST3410PrivateKey)((Object)dEROctetString2)).gost3410Spec.getPublicKeyParamSetOID()), new ASN1ObjectIdentifier(((BCGOST3410PrivateKey)((Object)dEROctetString2)).gost3410Spec.getDigestParamSetOID()))), new DEROctetString(byArray));
            return var1_4.getEncoded("DER");
        }
        PrivateKeyInfo privateKeyInfo4 = privateKeyInfo;
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_94);
        DEROctetString dEROctetString2 = dEROctetString;
        dEROctetString = new DEROctetString(byArray);
        privateKeyInfo = new PrivateKeyInfo(algorithmIdentifier, dEROctetString2);
        return var1_4.getEncoded("DER");
    }

    @Override
    public GOST3410Params getParameters() {
        return this.gost3410Spec;
    }

    @Override
    public BigInteger getX() {
        return this.x;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof GOST3410PrivateKey)) {
            return false;
        }
        object = (GOST3410PrivateKey)object;
        if (!this.getX().equals(object.getX())) return false;
        if (!this.getParameters().getPublicKeyParameters().equals(object.getParameters().getPublicKeyParameters())) return false;
        if (!this.getParameters().getDigestParamSetOID().equals(object.getParameters().getDigestParamSetOID())) return false;
        BCGOST3410PrivateKey bCGOST3410PrivateKey = this;
        if (!bCGOST3410PrivateKey.compareObj(bCGOST3410PrivateKey.getParameters().getEncryptionParamSetOID(), object.getParameters().getEncryptionParamSetOID())) return false;
        return true;
    }

    public int hashCode() {
        return this.getX().hashCode() ^ this.gost3410Spec.hashCode();
    }

    public String toString() {
        try {
            return GOSTUtil.privateKeyToString("GOST3410", this.x, ((GOST3410PrivateKeyParameters)GOST3410Util.generatePrivateKeyParameter(this)).getParameters());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalStateException(invalidKeyException.getMessage());
        }
    }

    @Override
    public void setBagAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable aSN1Encodable) {
        this.attrCarrier.setBagAttribute(aSN1ObjectIdentifier, aSN1Encodable);
    }

    @Override
    public ASN1Encodable getBagAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return this.attrCarrier.getBagAttribute(aSN1ObjectIdentifier);
    }

    @Override
    public Enumeration getBagAttributeKeys() {
        return this.attrCarrier.getBagAttributeKeys();
    }
}

