/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.rsa;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERNull;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.KeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.RSAKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPrivateCrtKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.PrimeCertaintyCalculator;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;

public class KeyPairGeneratorSpi
extends KeyPairGenerator {
    private static final AlgorithmIdentifier PKCS_ALGID = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, DERNull.INSTANCE);
    private static final AlgorithmIdentifier PSS_ALGID = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_RSASSA_PSS);
    public static final BigInteger defaultPublicExponent = BigInteger.valueOf(65537L);
    public RSAKeyGenerationParameters param;
    public RSAKeyPairGenerator engine;
    public AlgorithmIdentifier algId;

    public KeyPairGeneratorSpi(String string, AlgorithmIdentifier algorithmIdentifier) {
        super(string);
        KeyPairGeneratorSpi keyPairGeneratorSpi;
        RSAKeyGenerationParameters rSAKeyGenerationParameters;
        ((KeyPairGeneratorSpi)((Object)rSAKeyGenerationParameters2)).algId = algorithmIdentifier;
        ((KeyPairGeneratorSpi)((Object)rSAKeyGenerationParameters2)).engine = new RSAKeyPairGenerator();
        RSAKeyGenerationParameters rSAKeyGenerationParameters2 = rSAKeyGenerationParameters;
        keyPairGeneratorSpi.param = new RSAKeyGenerationParameters(defaultPublicExponent, CryptoServicesRegistrar.getSecureRandom(), 2048, PrimeCertaintyCalculator.getDefaultCertainty(2048));
        keyPairGeneratorSpi.engine.init(rSAKeyGenerationParameters2);
    }

    public KeyPairGeneratorSpi() {
        this("RSA", PKCS_ALGID);
    }

    @Override
    public void initialize(int n, SecureRandom secureRandom) {
        RSAKeyGenerationParameters rSAKeyGenerationParameters;
        KeyPairGeneratorSpi keyPairGeneratorSpi = rSAKeyGenerationParameters2;
        RSAKeyGenerationParameters rSAKeyGenerationParameters2 = rSAKeyGenerationParameters;
        BigInteger bigInteger = defaultPublicExponent;
        int n2 = PrimeCertaintyCalculator.getDefaultCertainty(n);
        keyPairGeneratorSpi.param = new RSAKeyGenerationParameters(bigInteger, secureRandom, n, n2);
        keyPairGeneratorSpi.engine.init(rSAKeyGenerationParameters2);
    }

    @Override
    public void initialize(AlgorithmParameterSpec object, SecureRandom secureRandom) {
        if (object instanceof RSAKeyGenParameterSpec) {
            RSAKeyGenerationParameters rSAKeyGenerationParameters;
            KeyPairGeneratorSpi keyPairGeneratorSpi = object2;
            Object object2 = (RSAKeyGenParameterSpec)object;
            object = rSAKeyGenerationParameters;
            Object object3 = object2;
            object2 = ((RSAKeyGenParameterSpec)object3).getPublicExponent();
            int n = ((RSAKeyGenParameterSpec)object3).getKeysize();
            int n2 = PrimeCertaintyCalculator.getDefaultCertainty(2048);
            keyPairGeneratorSpi.param = new RSAKeyGenerationParameters((BigInteger)object2, secureRandom, n, n2);
            keyPairGeneratorSpi.engine.init((KeyGenerationParameters)object);
            return;
        }
        throw new InvalidAlgorithmParameterException("parameter object not a RSAKeyGenParameterSpec");
    }

    @Override
    public KeyPair generateKeyPair() {
        BCRSAPrivateCrtKey bCRSAPrivateCrtKey;
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.engine.generateKeyPair();
        Object object = (RSAKeyParameters)asymmetricCipherKeyPair.getPublic();
        RSAPrivateCrtKeyParameters rSAPrivateCrtKeyParameters = (RSAPrivateCrtKeyParameters)asymmetricCipherKeyPair.getPrivate();
        BCRSAPublicKey bCRSAPublicKey = new BCRSAPublicKey(this.algId, (RSAKeyParameters)object);
        object = bCRSAPrivateCrtKey;
        bCRSAPrivateCrtKey = new BCRSAPrivateCrtKey(this.algId, rSAPrivateCrtKeyParameters);
        return new KeyPair(bCRSAPublicKey, (PrivateKey)object);
    }

    public static class PSS
    extends KeyPairGeneratorSpi {
        public PSS() {
            super("RSASSA-PSS", PSS_ALGID);
        }
    }
}

