/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.rsa;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.RSABlindedEngine;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.RSAKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.PSSSigner;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.rsa.RSAUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.util.DigestFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.util.BCJcaJceHelper;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.util.JcaJceHelper;
import java.io.ByteArrayOutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;

public class PSSSignatureSpi
extends SignatureSpi {
    private final JcaJceHelper helper;
    private AlgorithmParameters engineParams;
    private PSSParameterSpec paramSpec;
    private PSSParameterSpec originalSpec;
    private AsymmetricBlockCipher signer;
    private Digest contentDigest;
    private Digest mgfDigest;
    private int saltLength;
    private byte trailer;
    private boolean isRaw;
    private RSAKeyParameters key;
    private SecureRandom random;
    private PSSSigner pss;
    private boolean isInitState;

    private byte getTrailer(int n) {
        if (n == 1) {
            return -68;
        }
        throw new IllegalArgumentException("unknown trailer field");
    }

    private void setupContentDigest() {
        if (this.isRaw) {
            NullPssDigest nullPssDigest;
            NullPssDigest nullPssDigest2 = nullPssDigest;
            nullPssDigest = new NullPssDigest(this.mgfDigest);
            this.contentDigest = nullPssDigest2;
        } else {
            this.contentDigest = this.mgfDigest;
        }
    }

    public PSSSignatureSpi(AsymmetricBlockCipher asymmetricBlockCipher, PSSParameterSpec pSSParameterSpec) {
        this(asymmetricBlockCipher, pSSParameterSpec, false);
    }

    public PSSSignatureSpi(AsymmetricBlockCipher asymmetricBlockCipher, PSSParameterSpec pSSParameterSpec, boolean bl) {
        BCJcaJceHelper bCJcaJceHelper;
        BCJcaJceHelper bCJcaJceHelper2 = bCJcaJceHelper;
        bCJcaJceHelper = new BCJcaJceHelper();
        this.helper = bCJcaJceHelper2;
        this.isInitState = true;
        this.signer = asymmetricBlockCipher;
        this.originalSpec = pSSParameterSpec;
        this.paramSpec = pSSParameterSpec == null ? PSSParameterSpec.DEFAULT : pSSParameterSpec;
        PSSSignatureSpi pSSSignatureSpi = this;
        pSSSignatureSpi.mgfDigest = DigestFactory.getDigest(pSSSignatureSpi.paramSpec.getDigestAlgorithm());
        pSSSignatureSpi.saltLength = pSSSignatureSpi.paramSpec.getSaltLength();
        pSSSignatureSpi.trailer = pSSSignatureSpi.getTrailer(pSSSignatureSpi.paramSpec.getTrailerField());
        this.isRaw = bl;
        this.setupContentDigest();
    }

    @Override
    public void engineInitVerify(PublicKey object) {
        if (object instanceof RSAPublicKey) {
            PSSSigner pSSSigner;
            PSSSignatureSpi pSSSignatureSpi = asymmetricBlockCipher;
            pSSSignatureSpi.key = RSAUtil.generatePublicKeyParameter((RSAPublicKey)object);
            object = pSSSigner;
            PSSSignatureSpi pSSSignatureSpi2 = asymmetricBlockCipher;
            Object object2 = object;
            PSSSignatureSpi pSSSignatureSpi3 = asymmetricBlockCipher;
            AsymmetricBlockCipher asymmetricBlockCipher = pSSSignatureSpi3.signer;
            object = pSSSignatureSpi3.contentDigest;
            Digest digest = pSSSignatureSpi3.mgfDigest;
            int n = pSSSignatureSpi3.saltLength;
            byte by = pSSSignatureSpi3.trailer;
            ((PSSSigner)object2)(asymmetricBlockCipher, (Digest)object, digest, n, by);
            pSSSignatureSpi2.pss = object2;
            pSSSigner.init(false, pSSSignatureSpi2.key);
            pSSSignatureSpi.isInitState = true;
            return;
        }
        throw new InvalidKeyException("Supplied key is not a RSAPublicKey instance");
    }

    @Override
    public void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) {
        this.random = secureRandom;
        this.engineInitSign(privateKey);
    }

    @Override
    public void engineInitSign(PrivateKey object) {
        if (object instanceof RSAPrivateKey) {
            PSSSigner pSSSigner;
            this.key = RSAUtil.generatePrivateKeyParameter((RSAPrivateKey)object);
            object = pSSSigner;
            PSSSignatureSpi pSSSignatureSpi = this;
            Object object2 = pSSSignatureSpi.signer;
            Digest digest = pSSSignatureSpi.contentDigest;
            Digest digest2 = pSSSignatureSpi.mgfDigest;
            int n = pSSSignatureSpi.saltLength;
            byte by = pSSSignatureSpi.trailer;
            this.pss = new PSSSigner((AsymmetricBlockCipher)object2, digest, digest2, n, by);
            object2 = this.random;
            if (object2 != null) {
                ParametersWithRandom parametersWithRandom;
                Object object3 = object;
                object = parametersWithRandom;
                parametersWithRandom = new ParametersWithRandom(this.key, (SecureRandom)object2);
                ((PSSSigner)object3).init(true, (CipherParameters)object);
            } else {
                ((PSSSigner)object).init(true, this.key);
            }
            this.isInitState = true;
            return;
        }
        throw new InvalidKeyException("Supplied key is not a RSAPrivateKey instance");
    }

    @Override
    public void engineUpdate(byte by) {
        this.pss.update(by);
        this.isInitState = false;
    }

    @Override
    public void engineUpdate(byte[] byArray, int n, int n2) {
        this.pss.update(byArray, n, n2);
        this.isInitState = false;
    }

    @Override
    public byte[] engineSign() {
        this.isInitState = true;
        try {
            return this.pss.generateSignature();
        }
        catch (CryptoException cryptoException) {
            throw new SignatureException(cryptoException.getMessage());
        }
    }

    @Override
    public boolean engineVerify(byte[] byArray) {
        this.isInitState = true;
        return this.pss.verifySignature(byArray);
    }

    @Override
    public void engineSetParameter(AlgorithmParameterSpec object) {
        if (object == null && (object = this.originalSpec) == null) {
            return;
        }
        if (this.isInitState) {
            if (object instanceof PSSParameterSpec) {
                object = (PSSParameterSpec)object;
                Object object2 = this.originalSpec;
                if (object2 != null && !DigestFactory.isSameDigest(((PSSParameterSpec)object2).getDigestAlgorithm(), ((PSSParameterSpec)object).getDigestAlgorithm())) {
                    throw new InvalidAlgorithmParameterException(a.a("parameter must be using ").append(this.originalSpec.getDigestAlgorithm()).toString());
                }
                if (!((PSSParameterSpec)object).getMGFAlgorithm().equalsIgnoreCase("MGF1") && !((PSSParameterSpec)object).getMGFAlgorithm().equals(PKCSObjectIdentifiers.id_mgf1.getId())) {
                    throw new InvalidAlgorithmParameterException("unknown mask generation function specified");
                }
                if (((PSSParameterSpec)object).getMGFParameters() instanceof MGF1ParameterSpec) {
                    object2 = (MGF1ParameterSpec)((PSSParameterSpec)object).getMGFParameters();
                    if (DigestFactory.isSameDigest(((MGF1ParameterSpec)object2).getDigestAlgorithm(), ((PSSParameterSpec)object).getDigestAlgorithm())) {
                        Digest digest = DigestFactory.getDigest(((MGF1ParameterSpec)object2).getDigestAlgorithm());
                        if (digest != null) {
                            PSSSignatureSpi pSSSignatureSpi = this;
                            this.engineParams = null;
                            this.paramSpec = object;
                            this.mgfDigest = digest;
                            pSSSignatureSpi.saltLength = ((PSSParameterSpec)object).getSaltLength();
                            pSSSignatureSpi.trailer = pSSSignatureSpi.getTrailer(pSSSignatureSpi.paramSpec.getTrailerField());
                            pSSSignatureSpi.setupContentDigest();
                            if (pSSSignatureSpi.key != null) {
                                PSSSignatureSpi pSSSignatureSpi2 = this;
                                object = pSSSignatureSpi2.signer;
                                object2 = pSSSignatureSpi2.contentDigest;
                                digest = pSSSignatureSpi2.mgfDigest;
                                int n = pSSSignatureSpi2.saltLength;
                                byte by = pSSSignatureSpi2.trailer;
                                this.pss = new PSSSigner((AsymmetricBlockCipher)object, (Digest)object2, digest, n, by);
                                if (this.key.isPrivate()) {
                                    this.pss.init(true, this.key);
                                } else {
                                    this.pss.init(false, this.key);
                                }
                            }
                            return;
                        }
                        throw new InvalidAlgorithmParameterException(a.a("no match on MGF digest algorithm: ").append(((MGF1ParameterSpec)object2).getDigestAlgorithm()).toString());
                    }
                    throw new InvalidAlgorithmParameterException("digest algorithm for MGF should be the same as for PSS parameters.");
                }
                throw new InvalidAlgorithmParameterException("unknown MGF parameters");
            }
            throw new InvalidAlgorithmParameterException("Only PSSParameterSpec supported");
        }
        throw new ProviderException("cannot call setParameter in the middle of update");
    }

    @Override
    public AlgorithmParameters engineGetParameters() {
        if (this.engineParams == null && this.paramSpec != null) {
            AlgorithmParameters algorithmParameters;
            try {
                algorithmParameters = this.helper.createAlgorithmParameters("PSS");
            }
            catch (Exception exception) {
                throw new RuntimeException(((Object)exception).toString());
            }
            this.engineParams = algorithmParameters;
            algorithmParameters.init(this.paramSpec);
        }
        return this.engineParams;
    }

    @Override
    public void engineSetParameter(String string, Object object) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    public Object engineGetParameter(String string) {
        throw new UnsupportedOperationException("engineGetParameter unsupported");
    }

    public class NullPssDigest
    implements Digest {
        private ByteArrayOutputStream bOut;
        private Digest baseDigest;
        private boolean oddTime;

        public NullPssDigest(Digest digest) {
            ByteArrayOutputStream byteArrayOutputStream;
            ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
            byteArrayOutputStream = new ByteArrayOutputStream();
            v1.bOut = byteArrayOutputStream2;
            v1.oddTime = true;
            v1.baseDigest = digest;
        }

        @Override
        public String getAlgorithmName() {
            return "NULL";
        }

        @Override
        public int getDigestSize() {
            return this.baseDigest.getDigestSize();
        }

        @Override
        public void update(byte by) {
            this.bOut.write(by);
        }

        @Override
        public void update(byte[] byArray, int n, int n2) {
            this.bOut.write(byArray, n, n2);
        }

        @Override
        public int doFinal(byte[] byArray, int n) {
            NullPssDigest nullPssDigest = this;
            byte[] byArray2 = nullPssDigest.bOut.toByteArray();
            if (nullPssDigest.oddTime) {
                int n2 = byArray2.length;
                System.arraycopy(byArray2, 0, byArray, n, n2);
            } else {
                NullPssDigest nullPssDigest2 = this;
                nullPssDigest2.baseDigest.update(byArray2, 0, byArray2.length);
                nullPssDigest2.baseDigest.doFinal(byArray, n);
            }
            NullPssDigest nullPssDigest3 = this;
            nullPssDigest3.reset();
            nullPssDigest3.oddTime ^= true;
            return byArray2.length;
        }

        @Override
        public void reset() {
            NullPssDigest nullPssDigest = this;
            nullPssDigest.bOut.reset();
            nullPssDigest.baseDigest.reset();
        }

        public int getByteLength() {
            return 0;
        }
    }

    public static class SHA3_512withRSA
    extends PSSSignatureSpi {
        public SHA3_512withRSA() {
            MGF1ParameterSpec mGF1ParameterSpec;
            PSSParameterSpec pSSParameterSpec;
            RSABlindedEngine rSABlindedEngine;
            SHA3_512withRSA sHA3_512withRSA = rSABlindedEngine2;
            RSABlindedEngine rSABlindedEngine2 = rSABlindedEngine;
            rSABlindedEngine = new RSABlindedEngine();
            PSSParameterSpec pSSParameterSpec2 = pSSParameterSpec;
            MGF1ParameterSpec mGF1ParameterSpec2 = mGF1ParameterSpec;
            mGF1ParameterSpec = new MGF1ParameterSpec("SHA3-512");
            pSSParameterSpec = new PSSParameterSpec("SHA3-512", "MGF1", mGF1ParameterSpec2, 64, 1);
            super(rSABlindedEngine2, pSSParameterSpec2);
        }
    }

    public static class SHA3_384withRSA
    extends PSSSignatureSpi {
        public SHA3_384withRSA() {
            MGF1ParameterSpec mGF1ParameterSpec;
            PSSParameterSpec pSSParameterSpec;
            RSABlindedEngine rSABlindedEngine;
            SHA3_384withRSA sHA3_384withRSA = rSABlindedEngine2;
            RSABlindedEngine rSABlindedEngine2 = rSABlindedEngine;
            rSABlindedEngine = new RSABlindedEngine();
            PSSParameterSpec pSSParameterSpec2 = pSSParameterSpec;
            MGF1ParameterSpec mGF1ParameterSpec2 = mGF1ParameterSpec;
            mGF1ParameterSpec = new MGF1ParameterSpec("SHA3-384");
            pSSParameterSpec = new PSSParameterSpec("SHA3-384", "MGF1", mGF1ParameterSpec2, 48, 1);
            super(rSABlindedEngine2, pSSParameterSpec2);
        }
    }

    public static class SHA3_256withRSA
    extends PSSSignatureSpi {
        public SHA3_256withRSA() {
            MGF1ParameterSpec mGF1ParameterSpec;
            PSSParameterSpec pSSParameterSpec;
            RSABlindedEngine rSABlindedEngine;
            SHA3_256withRSA sHA3_256withRSA = rSABlindedEngine2;
            RSABlindedEngine rSABlindedEngine2 = rSABlindedEngine;
            rSABlindedEngine = new RSABlindedEngine();
            PSSParameterSpec pSSParameterSpec2 = pSSParameterSpec;
            MGF1ParameterSpec mGF1ParameterSpec2 = mGF1ParameterSpec;
            mGF1ParameterSpec = new MGF1ParameterSpec("SHA3-256");
            pSSParameterSpec = new PSSParameterSpec("SHA3-256", "MGF1", mGF1ParameterSpec2, 32, 1);
            super(rSABlindedEngine2, pSSParameterSpec2);
        }
    }

    public static class SHA3_224withRSA
    extends PSSSignatureSpi {
        public SHA3_224withRSA() {
            MGF1ParameterSpec mGF1ParameterSpec;
            PSSParameterSpec pSSParameterSpec;
            RSABlindedEngine rSABlindedEngine;
            SHA3_224withRSA sHA3_224withRSA = rSABlindedEngine2;
            RSABlindedEngine rSABlindedEngine2 = rSABlindedEngine;
            rSABlindedEngine = new RSABlindedEngine();
            PSSParameterSpec pSSParameterSpec2 = pSSParameterSpec;
            MGF1ParameterSpec mGF1ParameterSpec2 = mGF1ParameterSpec;
            mGF1ParameterSpec = new MGF1ParameterSpec("SHA3-224");
            pSSParameterSpec = new PSSParameterSpec("SHA3-224", "MGF1", mGF1ParameterSpec2, 28, 1);
            super(rSABlindedEngine2, pSSParameterSpec2);
        }
    }

    public static class SHA512_256withRSA
    extends PSSSignatureSpi {
        public SHA512_256withRSA() {
            MGF1ParameterSpec mGF1ParameterSpec;
            PSSParameterSpec pSSParameterSpec;
            RSABlindedEngine rSABlindedEngine;
            SHA512_256withRSA sHA512_256withRSA = rSABlindedEngine2;
            RSABlindedEngine rSABlindedEngine2 = rSABlindedEngine;
            rSABlindedEngine = new RSABlindedEngine();
            PSSParameterSpec pSSParameterSpec2 = pSSParameterSpec;
            MGF1ParameterSpec mGF1ParameterSpec2 = mGF1ParameterSpec;
            mGF1ParameterSpec = new MGF1ParameterSpec("SHA-512(256)");
            pSSParameterSpec = new PSSParameterSpec("SHA-512(256)", "MGF1", mGF1ParameterSpec2, 32, 1);
            super(rSABlindedEngine2, pSSParameterSpec2);
        }
    }

    public static class SHA512_224withRSA
    extends PSSSignatureSpi {
        public SHA512_224withRSA() {
            MGF1ParameterSpec mGF1ParameterSpec;
            PSSParameterSpec pSSParameterSpec;
            RSABlindedEngine rSABlindedEngine;
            SHA512_224withRSA sHA512_224withRSA = rSABlindedEngine2;
            RSABlindedEngine rSABlindedEngine2 = rSABlindedEngine;
            rSABlindedEngine = new RSABlindedEngine();
            PSSParameterSpec pSSParameterSpec2 = pSSParameterSpec;
            MGF1ParameterSpec mGF1ParameterSpec2 = mGF1ParameterSpec;
            mGF1ParameterSpec = new MGF1ParameterSpec("SHA-512(224)");
            pSSParameterSpec = new PSSParameterSpec("SHA-512(224)", "MGF1", mGF1ParameterSpec2, 28, 1);
            super(rSABlindedEngine2, pSSParameterSpec2);
        }
    }

    public static class SHA512withRSA
    extends PSSSignatureSpi {
        public SHA512withRSA() {
            MGF1ParameterSpec mGF1ParameterSpec;
            PSSParameterSpec pSSParameterSpec;
            RSABlindedEngine rSABlindedEngine;
            SHA512withRSA sHA512withRSA = rSABlindedEngine2;
            RSABlindedEngine rSABlindedEngine2 = rSABlindedEngine;
            rSABlindedEngine = new RSABlindedEngine();
            PSSParameterSpec pSSParameterSpec2 = pSSParameterSpec;
            MGF1ParameterSpec mGF1ParameterSpec2 = mGF1ParameterSpec;
            mGF1ParameterSpec = new MGF1ParameterSpec("SHA-512");
            pSSParameterSpec = new PSSParameterSpec("SHA-512", "MGF1", mGF1ParameterSpec2, 64, 1);
            super(rSABlindedEngine2, pSSParameterSpec2);
        }
    }

    public static class SHA384withRSA
    extends PSSSignatureSpi {
        public SHA384withRSA() {
            MGF1ParameterSpec mGF1ParameterSpec;
            PSSParameterSpec pSSParameterSpec;
            RSABlindedEngine rSABlindedEngine;
            SHA384withRSA sHA384withRSA = rSABlindedEngine2;
            RSABlindedEngine rSABlindedEngine2 = rSABlindedEngine;
            rSABlindedEngine = new RSABlindedEngine();
            PSSParameterSpec pSSParameterSpec2 = pSSParameterSpec;
            MGF1ParameterSpec mGF1ParameterSpec2 = mGF1ParameterSpec;
            mGF1ParameterSpec = new MGF1ParameterSpec("SHA-384");
            pSSParameterSpec = new PSSParameterSpec("SHA-384", "MGF1", mGF1ParameterSpec2, 48, 1);
            super(rSABlindedEngine2, pSSParameterSpec2);
        }
    }

    public static class SHA256withRSA
    extends PSSSignatureSpi {
        public SHA256withRSA() {
            MGF1ParameterSpec mGF1ParameterSpec;
            PSSParameterSpec pSSParameterSpec;
            RSABlindedEngine rSABlindedEngine;
            SHA256withRSA sHA256withRSA = rSABlindedEngine2;
            RSABlindedEngine rSABlindedEngine2 = rSABlindedEngine;
            rSABlindedEngine = new RSABlindedEngine();
            PSSParameterSpec pSSParameterSpec2 = pSSParameterSpec;
            MGF1ParameterSpec mGF1ParameterSpec2 = mGF1ParameterSpec;
            mGF1ParameterSpec = new MGF1ParameterSpec("SHA-256");
            pSSParameterSpec = new PSSParameterSpec("SHA-256", "MGF1", mGF1ParameterSpec2, 32, 1);
            super(rSABlindedEngine2, pSSParameterSpec2);
        }
    }

    public static class SHA224withRSA
    extends PSSSignatureSpi {
        public SHA224withRSA() {
            MGF1ParameterSpec mGF1ParameterSpec;
            PSSParameterSpec pSSParameterSpec;
            RSABlindedEngine rSABlindedEngine;
            SHA224withRSA sHA224withRSA = rSABlindedEngine2;
            RSABlindedEngine rSABlindedEngine2 = rSABlindedEngine;
            rSABlindedEngine = new RSABlindedEngine();
            PSSParameterSpec pSSParameterSpec2 = pSSParameterSpec;
            MGF1ParameterSpec mGF1ParameterSpec2 = mGF1ParameterSpec;
            mGF1ParameterSpec = new MGF1ParameterSpec("SHA-224");
            pSSParameterSpec = new PSSParameterSpec("SHA-224", "MGF1", mGF1ParameterSpec2, 28, 1);
            super(rSABlindedEngine2, pSSParameterSpec2);
        }
    }

    public static class SHA1withRSA
    extends PSSSignatureSpi {
        public SHA1withRSA() {
            RSABlindedEngine rSABlindedEngine;
            SHA1withRSA sHA1withRSA = rSABlindedEngine2;
            RSABlindedEngine rSABlindedEngine2 = rSABlindedEngine;
            rSABlindedEngine = new RSABlindedEngine();
            super(rSABlindedEngine2, PSSParameterSpec.DEFAULT);
        }
    }

    public static class PSSwithRSA
    extends PSSSignatureSpi {
        public PSSwithRSA() {
            RSABlindedEngine rSABlindedEngine;
            PSSwithRSA pSSwithRSA = rSABlindedEngine2;
            RSABlindedEngine rSABlindedEngine2 = rSABlindedEngine;
            rSABlindedEngine = new RSABlindedEngine();
            super(rSABlindedEngine2, null);
        }
    }

    public static class nonePSS
    extends PSSSignatureSpi {
        public nonePSS() {
            RSABlindedEngine rSABlindedEngine;
            nonePSS nonePSS2 = rSABlindedEngine2;
            RSABlindedEngine rSABlindedEngine2 = rSABlindedEngine;
            rSABlindedEngine = new RSABlindedEngine();
            super(rSABlindedEngine2, null, true);
        }
    }
}

