/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.x509;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1InputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Set;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.SignedData;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.CertificateList;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.x509.PEMUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.x509.PKIXCertPath;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.x509.X509CRLObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.x509.X509CertificateObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.util.BCJcaJceHelper;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.util.JcaJceHelper;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.io.Streams;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class CertificateFactory
extends CertificateFactorySpi {
    private static final PEMUtil PEM_CERT_PARSER = new PEMUtil("CERTIFICATE");
    private static final PEMUtil PEM_CRL_PARSER = new PEMUtil("CRL");
    private static final PEMUtil PEM_PKCS7_PARSER = new PEMUtil("PKCS7");
    private final JcaJceHelper bcHelper;
    private ASN1Set sData;
    private int sDataObjectCount;
    private InputStream currentStream;
    private ASN1Set sCrlData;
    private int sCrlDataObjectCount;
    private InputStream currentCrlStream;

    public CertificateFactory() {
        BCJcaJceHelper bCJcaJceHelper;
        BCJcaJceHelper bCJcaJceHelper2 = bCJcaJceHelper;
        bCJcaJceHelper = new BCJcaJceHelper();
        v1.bcHelper = bCJcaJceHelper2;
        v1.sData = null;
        v1.sDataObjectCount = 0;
        v1.currentStream = null;
        v1.sCrlData = null;
        v1.sCrlDataObjectCount = 0;
        v1.currentCrlStream = null;
    }

    private Certificate readDERCertificate(ASN1InputStream aSN1InputStream) {
        return this.getCertificate(ASN1Sequence.getInstance(aSN1InputStream.readObject()));
    }

    private Certificate readPEMCertificate(InputStream inputStream) {
        return this.getCertificate(PEM_CERT_PARSER.readPEMObject(inputStream));
    }

    private Certificate getCertificate(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence == null) {
            return null;
        }
        if (aSN1Sequence.size() > 1 && aSN1Sequence.getObjectAt(0) instanceof ASN1ObjectIdentifier && aSN1Sequence.getObjectAt(0).equals(PKCSObjectIdentifiers.signedData)) {
            ((CertificateFactory)((Object)jcaJceHelper)).sData = SignedData.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(1), true)).getCertificates();
            return super.getCertificate();
        }
        JcaJceHelper jcaJceHelper = ((CertificateFactory)((Object)jcaJceHelper)).bcHelper;
        return new X509CertificateObject(jcaJceHelper, com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Certificate.getInstance(aSN1Sequence));
    }

    private Certificate getCertificate() {
        if (((CertificateFactory)((Object)jcaJceHelper)).sData != null) {
            while (((CertificateFactory)((Object)jcaJceHelper)).sDataObjectCount < ((CertificateFactory)((Object)jcaJceHelper)).sData.size()) {
                int n = ((CertificateFactory)((Object)jcaJceHelper)).sDataObjectCount;
                ((CertificateFactory)((Object)jcaJceHelper)).sDataObjectCount = n + 1;
                ASN1Encodable aSN1Encodable = ((CertificateFactory)((Object)jcaJceHelper)).sData.getObjectAt(n);
                if (!(aSN1Encodable instanceof ASN1Sequence)) continue;
                JcaJceHelper jcaJceHelper = ((CertificateFactory)((Object)jcaJceHelper)).bcHelper;
                return new X509CertificateObject(jcaJceHelper, com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Certificate.getInstance(aSN1Encodable));
            }
        }
        return null;
    }

    private CRL readPEMCRL(InputStream inputStream) {
        return this.getCRL(PEM_CRL_PARSER.readPEMObject(inputStream));
    }

    private CRL readDERCRL(ASN1InputStream aSN1InputStream) {
        return this.getCRL(ASN1Sequence.getInstance(aSN1InputStream.readObject()));
    }

    private CRL getCRL(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence == null) {
            return null;
        }
        if (aSN1Sequence.size() > 1 && aSN1Sequence.getObjectAt(0) instanceof ASN1ObjectIdentifier && aSN1Sequence.getObjectAt(0).equals(PKCSObjectIdentifiers.signedData)) {
            this.sCrlData = SignedData.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(1), true)).getCRLs();
            return this.getCRL();
        }
        return this.createCRL(CertificateList.getInstance(aSN1Sequence));
    }

    private CRL getCRL() {
        ASN1Set aSN1Set = this.sCrlData;
        if (aSN1Set != null && this.sCrlDataObjectCount < aSN1Set.size()) {
            CertificateFactory certificateFactory = this;
            int n = this.sCrlDataObjectCount;
            this.sCrlDataObjectCount = n + 1;
            return certificateFactory.createCRL(CertificateList.getInstance(certificateFactory.sCrlData.getObjectAt(n)));
        }
        return null;
    }

    public CRL createCRL(CertificateList certificateList) {
        return new X509CRLObject(this.bcHelper, certificateList);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Certificate engineGenerateCertificate(InputStream var1_1) {
        block13: {
            block12: {
                block11: {
                    var2_3 = this.currentStream;
                    if (var2_3 == null || var2_3 != var1_1) {
                        v0 = this;
                        v0.currentStream = var1_1;
                        v0.sData = null;
                        v0.sDataObjectCount = 0;
                    }
                    try {
                        var2_3 = this.sData;
                        if (var2_3 == null) break block11;
                    }
                    catch (Exception var1_2) {
                        throw new ExCertificateException(com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.a.a(var1_2, a.a("parsing issue: ")), var1_2);
                    }
                    if (this.sDataObjectCount == var2_3.size()) ** GOTO lbl16
                    return this.getCertificate();
lbl16:
                    // 1 sources

                    v1 = this;
                    v1.sData = null;
                    v1.sDataObjectCount = 0;
                    return null;
                }
                if (var1_1.markSupported()) break block12;
                var2_3 = v2;
                v2 = new ByteArrayInputStream(Streams.readAll((InputStream)var1_1));
                var1_1 = var2_3;
            }
            v3 = var1_1;
            v3.mark(1);
            var2_4 = v3.read();
            if (var2_4 != -1) break block13;
            return null;
        }
        var1_1.reset();
        if (var2_4 == 48) ** GOTO lbl40
        return this.readPEMCertificate((InputStream)var1_1);
lbl40:
        // 1 sources

        return this.readDERCertificate(new ASN1InputStream((InputStream)var1_1));
    }

    public Collection engineGenerateCertificates(InputStream object) {
        Certificate certificate;
        ArrayList arrayList;
        BufferedInputStream bufferedInputStream;
        BufferedInputStream bufferedInputStream2 = bufferedInputStream;
        bufferedInputStream = new BufferedInputStream((InputStream)object);
        object = arrayList;
        arrayList = new ArrayList();
        while ((certificate = this.engineGenerateCertificate(bufferedInputStream2)) != null) {
            ((ArrayList)object).add(certificate);
        }
        return object;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CRL engineGenerateCRL(InputStream var1_2) {
        block16: {
            block15: {
                block14: {
                    var2_3 = this.currentCrlStream;
                    if (var2_3 == null) {
                        while (true) {
                            v0 = this;
                            v0.currentCrlStream = var1_2;
                            v0.sCrlData = null;
                            v0.sCrlDataObjectCount = 0;
                            break;
                        }
                    } else if (var2_3 != var1_2) ** continue;
                    var2_3 = this.sCrlData;
                    if (var2_3 == null) break block14;
                    if (this.sCrlDataObjectCount == var2_3.size()) ** GOTO lbl17
                    return this.getCRL();
lbl17:
                    // 1 sources

                    v1 = this;
                    v1.sCrlData = null;
                    v1.sCrlDataObjectCount = 0;
                    return null;
                }
                if (var1_2.markSupported()) break block15;
                var2_3 = v2;
                v2 = new ByteArrayInputStream(Streams.readAll((InputStream)var1_2));
                var1_2 = var2_3;
            }
            v3 = var1_2;
            v3.mark(1);
            var2_4 = v3.read();
            if (var2_4 != -1) break block16;
            return null;
        }
        var1_2.reset();
        if (var2_4 == 48) ** GOTO lbl41
        try {
            return this.readPEMCRL((InputStream)var1_2);
lbl41:
            // 1 sources

            return this.readDERCRL(new ASN1InputStream((InputStream)var1_2, true));
        }
        catch (Exception var0_1) {
            throw new CRLException(var0_1.toString());
        }
        catch (CRLException v4) {
            throw v4;
        }
    }

    public Collection engineGenerateCRLs(InputStream object) {
        BufferedInputStream bufferedInputStream;
        ArrayList<Object> arrayList;
        ArrayList<Object> arrayList2 = arrayList;
        arrayList = new ArrayList<Object>();
        BufferedInputStream bufferedInputStream2 = bufferedInputStream;
        bufferedInputStream = new BufferedInputStream((InputStream)object);
        while ((object = this.engineGenerateCRL(bufferedInputStream2)) != null) {
            arrayList2.add(object);
        }
        return arrayList2;
    }

    public Iterator engineGetCertPathEncodings() {
        return PKIXCertPath.certPathEncodings.iterator();
    }

    @Override
    public CertPath engineGenerateCertPath(InputStream inputStream) {
        return this.engineGenerateCertPath(inputStream, "PkiPath");
    }

    @Override
    public CertPath engineGenerateCertPath(InputStream inputStream, String string) {
        return new PKIXCertPath(inputStream, string);
    }

    public CertPath engineGenerateCertPath(List list) {
        for (Object e2 : list) {
            if (e2 == null || e2 instanceof X509Certificate) continue;
            throw new CertificateException(a.a("list contains non X509Certificate object while creating CertPath\n").append(e2.toString()).toString());
        }
        return new PKIXCertPath(list);
    }

    public class ExCertificateException
    extends CertificateException {
        private Throwable cause;

        public ExCertificateException(Throwable throwable) {
            this.cause = throwable;
        }

        public ExCertificateException(String string, Throwable throwable) {
            super(string);
            this.cause = throwable;
        }

        @Override
        public Throwable getCause() {
            return this.cause;
        }
    }
}

