/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.x509;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Null;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERNull;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.util.MessageDigestUtils;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.PSSParameterSpec;
import java.util.HashMap;
import java.util.Map;

class X509SignatureUtil {
    private static final Map<ASN1ObjectIdentifier, String> algNames = new HashMap<ASN1ObjectIdentifier, String>();
    private static final ASN1Null derNull;

    public static boolean isCompositeAlgorithm(AlgorithmIdentifier algorithmIdentifier) {
        return MiscObjectIdentifiers.id_alg_composite.equals(algorithmIdentifier.getAlgorithm());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setSignatureParameters(Signature signature, ASN1Encodable aSN1Encodable) {
        if (aSN1Encodable == null || derNull.equals(aSN1Encodable)) return;
        Signature signature2 = signature;
        AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(signature2.getAlgorithm(), signature.getProvider());
        try {
            algorithmParameters.init(aSN1Encodable.toASN1Primitive().getEncoded());
            if (!signature2.getAlgorithm().endsWith("MGF1")) return;
        }
        catch (IOException iOException) {
            throw new SignatureException(b.a(iOException, a.a("IOException decoding parameters: ")));
        }
        try {
            signature.setParameter(algorithmParameters.getParameterSpec(PSSParameterSpec.class));
            return;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SignatureException(a.a("Exception extracting parameters: ").append(generalSecurityException.getMessage()).toString());
        }
    }

    public static String getSignatureName(AlgorithmIdentifier aSN1Object) {
        Object object = ((AlgorithmIdentifier)aSN1Object).getParameters();
        if (object != null && !derNull.equals((ASN1Encodable)object)) {
            if (((AlgorithmIdentifier)aSN1Object).getAlgorithm().equals(PKCSObjectIdentifiers.id_RSASSA_PSS)) {
                aSN1Object = RSASSAPSSparams.getInstance(object);
                return d.a.a(new StringBuilder(), X509SignatureUtil.getDigestAlgName(((RSASSAPSSparams)aSN1Object).getHashAlgorithm().getAlgorithm()), "withRSAandMGF1");
            }
            if (((AlgorithmIdentifier)aSN1Object).getAlgorithm().equals(X9ObjectIdentifiers.ecdsa_with_SHA2)) {
                aSN1Object = ASN1Sequence.getInstance(object);
                return d.a.a(new StringBuilder(), X509SignatureUtil.getDigestAlgName((ASN1ObjectIdentifier)((ASN1Sequence)aSN1Object).getObjectAt(0)), "withECDSA");
            }
        }
        if ((object = algNames.get(((AlgorithmIdentifier)aSN1Object).getAlgorithm())) != null) {
            return object;
        }
        return X509SignatureUtil.findAlgName(((AlgorithmIdentifier)aSN1Object).getAlgorithm());
    }

    private static String getDigestAlgName(ASN1ObjectIdentifier object) {
        int n = ((String)(object = MessageDigestUtils.getDigestName((ASN1ObjectIdentifier)object))).indexOf(45);
        if (n > 0 && !((String)object).startsWith("SHA3")) {
            return ((String)object).substring(0, n) + ((String)object).substring(n + 1);
        }
        return object;
    }

    private static String findAlgName(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        Object object;
        Provider provider = Security.getProvider("BC");
        if (provider != null && (object = X509SignatureUtil.lookupAlg(provider, aSN1ObjectIdentifier)) != null) {
            return object;
        }
        object = Security.getProviders();
        for (int k = 0; k != ((Provider[])object).length; ++k) {
            Object object2 = object[k];
            if (provider == object2 || (object2 = X509SignatureUtil.lookupAlg((Provider)object2, aSN1ObjectIdentifier)) == null) continue;
            return object2;
        }
        return aSN1ObjectIdentifier.getId();
    }

    private static String lookupAlg(Provider object, ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        String string = ((Provider)object).getProperty("Alg.Alias.Signature." + aSN1ObjectIdentifier);
        if (string != null) {
            return string;
        }
        if ((object = ((Provider)object).getProperty("Alg.Alias.Signature.OID." + aSN1ObjectIdentifier)) != null) {
            return object;
        }
        return null;
    }

    public static void prettyPrintSignature(byte[] byArray, StringBuffer stringBuffer, String string) {
        if (byArray.length > 20) {
            stringBuffer.append("            Signature: ").append(Hex.toHexString(byArray, 0, 20)).append(string);
            for (int k = 20; k < byArray.length; k += 20) {
                if (k < byArray.length - 20) {
                    stringBuffer.append("                       ").append(Hex.toHexString(byArray, k, 20)).append(string);
                    continue;
                }
                stringBuffer.append("                       ").append(Hex.toHexString(byArray, k, byArray.length - k)).append(string);
            }
        } else {
            stringBuffer.append("            Signature: ").append(Hex.toHexString(byArray)).append(string);
        }
    }

    static {
        algNames.put(EdECObjectIdentifiers.id_Ed25519, "Ed25519");
        algNames.put(EdECObjectIdentifiers.id_Ed448, "Ed448");
        algNames.put(OIWObjectIdentifiers.dsaWithSHA1, "SHA1withDSA");
        algNames.put(X9ObjectIdentifiers.id_dsa_with_sha1, "SHA1withDSA");
        derNull = DERNull.INSTANCE;
    }
}

