/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric.util;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cms.GCMParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.g;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.i;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BufferedBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.InvalidCipherTextException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.DSTU7624Engine;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.AEADBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.AEADCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.CBCBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.CCMBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.CFBBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.CTSBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.EAXBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.GCFBBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.GCMBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.GOFBBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.KCCMBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.KCTRBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.KGCMBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.OCBBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.OFBBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.OpenPGPCFBBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.PGPCFBBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.SICBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.paddings.BlockCipherPadding;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.paddings.ISO10126d2Padding;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.paddings.ISO7816d4Padding;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.paddings.TBCPadding;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.paddings.X923Padding;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.paddings.ZeroBytePadding;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AEADParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithSBox;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric.util.BaseWrapCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric.util.BlockCipherProvider;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric.util.ClassUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric.util.SpecUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.spec.GOST28147ParameterSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.RC5ParameterSpec;

public class BaseBlockCipher
extends BaseWrapCipher {
    private static final int BUF_SIZE = 512;
    private static final Class gcmSpecClass = ClassUtil.loadClass(BaseBlockCipher.class, "javax.crypto.spec.GCMParameterSpec");
    private Class[] availableSpecs;
    private BlockCipher baseEngine;
    private BlockCipherProvider engineProvider;
    private GenericBlockCipher cipher;
    private ParametersWithIV ivParam;
    private AEADParameters aeadParams;
    private int keySizeInBits;
    private int scheme;
    private int digest;
    private int ivLength;
    private boolean padded;
    private boolean fixedIv;
    private PBEParameterSpec pbeSpec;
    private String pbeAlgorithm;
    private String modeName;

    public BaseBlockCipher(BlockCipher blockCipher) {
        BufferedGenericBlockCipher bufferedGenericBlockCipher;
        Class[] classArray = object;
        Class[] classArray2 = new Class[6];
        Object object = classArray2;
        classArray2[0] = RC2ParameterSpec.class;
        classArray2[1] = RC5ParameterSpec.class;
        classArray2[2] = gcmSpecClass;
        classArray2[3] = GOST28147ParameterSpec.class;
        classArray2[4] = IvParameterSpec.class;
        classArray2[5] = PBEParameterSpec.class;
        classArray.availableSpecs = object;
        v2.scheme = -1;
        classArray.ivLength = 0;
        v2.fixedIv = true;
        classArray.pbeSpec = null;
        v2.pbeAlgorithm = null;
        classArray.modeName = null;
        v2.baseEngine = blockCipher;
        object = bufferedGenericBlockCipher;
        bufferedGenericBlockCipher = new BufferedGenericBlockCipher(blockCipher);
        classArray.cipher = object;
    }

    public BaseBlockCipher(BlockCipher blockCipher, int n, int n2, int n3, int n4) {
        BufferedGenericBlockCipher bufferedGenericBlockCipher;
        Class[] classArray = object;
        Class[] classArray2 = new Class[6];
        Object object = classArray2;
        classArray2[0] = RC2ParameterSpec.class;
        classArray2[1] = RC5ParameterSpec.class;
        classArray2[2] = gcmSpecClass;
        classArray2[3] = GOST28147ParameterSpec.class;
        classArray2[4] = IvParameterSpec.class;
        classArray2[5] = PBEParameterSpec.class;
        classArray.availableSpecs = object;
        v2.fixedIv = true;
        classArray.pbeSpec = null;
        v2.pbeAlgorithm = null;
        classArray.modeName = null;
        v2.baseEngine = blockCipher;
        classArray.scheme = n;
        v2.digest = n2;
        classArray.keySizeInBits = n3;
        v2.ivLength = n4;
        object = bufferedGenericBlockCipher;
        bufferedGenericBlockCipher = new BufferedGenericBlockCipher(blockCipher);
        classArray.cipher = object;
    }

    public BaseBlockCipher(BlockCipherProvider blockCipherProvider) {
        BaseBlockCipher baseBlockCipher = this;
        this.availableSpecs = new Class[]{RC2ParameterSpec.class, RC5ParameterSpec.class, gcmSpecClass, GOST28147ParameterSpec.class, IvParameterSpec.class, PBEParameterSpec.class};
        this.scheme = -1;
        this.ivLength = 0;
        this.fixedIv = true;
        this.pbeSpec = null;
        this.pbeAlgorithm = null;
        this.modeName = null;
        this.baseEngine = blockCipherProvider.get();
        baseBlockCipher.engineProvider = blockCipherProvider;
        baseBlockCipher.cipher = new BufferedGenericBlockCipher(blockCipherProvider.get());
    }

    public BaseBlockCipher(AEADBlockCipher aEADBlockCipher) {
        BaseBlockCipher baseBlockCipher = blockCipher;
        ((BaseBlockCipher)((Object)blockCipher)).availableSpecs = new Class[]{RC2ParameterSpec.class, RC5ParameterSpec.class, gcmSpecClass, GOST28147ParameterSpec.class, IvParameterSpec.class, PBEParameterSpec.class};
        ((BaseBlockCipher)((Object)blockCipher)).scheme = -1;
        ((BaseBlockCipher)((Object)blockCipher)).ivLength = 0;
        ((BaseBlockCipher)((Object)blockCipher)).fixedIv = true;
        ((BaseBlockCipher)((Object)blockCipher)).pbeSpec = null;
        ((BaseBlockCipher)((Object)blockCipher)).pbeAlgorithm = null;
        ((BaseBlockCipher)((Object)blockCipher)).modeName = null;
        BlockCipher blockCipher = aEADBlockCipher.getUnderlyingCipher();
        baseBlockCipher.baseEngine = blockCipher;
        baseBlockCipher.ivLength = blockCipher.getBlockSize();
        baseBlockCipher.cipher = new AEADGenericBlockCipher(aEADBlockCipher);
    }

    public BaseBlockCipher(AEADCipher aEADCipher, boolean bl, int n) {
        AEADGenericBlockCipher aEADGenericBlockCipher;
        Class[] classArray = object;
        Class[] classArray2 = new Class[6];
        Object object = classArray2;
        classArray2[0] = RC2ParameterSpec.class;
        classArray2[1] = RC5ParameterSpec.class;
        classArray2[2] = gcmSpecClass;
        classArray2[3] = GOST28147ParameterSpec.class;
        classArray2[4] = IvParameterSpec.class;
        classArray2[5] = PBEParameterSpec.class;
        classArray.availableSpecs = object;
        v2.scheme = -1;
        classArray.pbeSpec = null;
        v2.pbeAlgorithm = null;
        classArray.modeName = null;
        v2.baseEngine = null;
        classArray.fixedIv = bl;
        v2.ivLength = n;
        object = aEADGenericBlockCipher;
        aEADGenericBlockCipher = new AEADGenericBlockCipher(aEADCipher);
        classArray.cipher = object;
    }

    public BaseBlockCipher(AEADBlockCipher aEADBlockCipher, boolean bl, int n) {
        BaseBlockCipher baseBlockCipher = this;
        this.availableSpecs = new Class[]{RC2ParameterSpec.class, RC5ParameterSpec.class, gcmSpecClass, GOST28147ParameterSpec.class, IvParameterSpec.class, PBEParameterSpec.class};
        this.scheme = -1;
        this.ivLength = 0;
        this.fixedIv = true;
        this.pbeSpec = null;
        this.pbeAlgorithm = null;
        this.modeName = null;
        this.baseEngine = aEADBlockCipher.getUnderlyingCipher();
        this.fixedIv = bl;
        baseBlockCipher.ivLength = n;
        baseBlockCipher.cipher = new AEADGenericBlockCipher(aEADBlockCipher);
    }

    public BaseBlockCipher(BlockCipher blockCipher, int n) {
        this(blockCipher, true, n);
    }

    public BaseBlockCipher(BlockCipher blockCipher, boolean bl, int n) {
        BaseBlockCipher baseBlockCipher = this;
        this.availableSpecs = new Class[]{RC2ParameterSpec.class, RC5ParameterSpec.class, gcmSpecClass, GOST28147ParameterSpec.class, IvParameterSpec.class, PBEParameterSpec.class};
        this.scheme = -1;
        this.ivLength = 0;
        this.pbeSpec = null;
        this.pbeAlgorithm = null;
        this.modeName = null;
        this.baseEngine = blockCipher;
        baseBlockCipher.fixedIv = bl;
        baseBlockCipher.cipher = new BufferedGenericBlockCipher(blockCipher);
        this.ivLength = n / 8;
    }

    public BaseBlockCipher(BufferedBlockCipher bufferedBlockCipher, int n) {
        this(bufferedBlockCipher, true, n);
    }

    public BaseBlockCipher(BufferedBlockCipher bufferedBlockCipher, boolean bl, int n) {
        BaseBlockCipher baseBlockCipher = this;
        this.availableSpecs = new Class[]{RC2ParameterSpec.class, RC5ParameterSpec.class, gcmSpecClass, GOST28147ParameterSpec.class, IvParameterSpec.class, PBEParameterSpec.class};
        this.scheme = -1;
        this.ivLength = 0;
        this.fixedIv = true;
        this.pbeSpec = null;
        this.pbeAlgorithm = null;
        this.modeName = null;
        baseBlockCipher.baseEngine = bufferedBlockCipher.getUnderlyingCipher();
        baseBlockCipher.cipher = new BufferedGenericBlockCipher(bufferedBlockCipher);
        this.fixedIv = bl;
        this.ivLength = n / 8;
    }

    private CipherParameters adjustParameters(AlgorithmParameterSpec object, CipherParameters object2) {
        Object object3;
        if (object2 instanceof ParametersWithIV) {
            CipherParameters cipherParameters = ((ParametersWithIV)object2).getParameters();
            if (object instanceof IvParameterSpec) {
                ParametersWithIV parametersWithIV;
                Object object4 = object3;
                object3 = (IvParameterSpec)object;
                object2 = parametersWithIV;
                parametersWithIV = new ParametersWithIV(cipherParameters, ((IvParameterSpec)object3).getIV());
                ((BaseBlockCipher)object4).ivParam = object2;
            } else if (object instanceof GOST28147ParameterSpec) {
                ParametersWithSBox parametersWithSBox;
                object = (GOST28147ParameterSpec)object;
                ParametersWithSBox parametersWithSBox2 = parametersWithSBox;
                parametersWithSBox = new ParametersWithSBox((CipherParameters)object2, ((GOST28147ParameterSpec)object).getSbox());
                if (((GOST28147ParameterSpec)object).getIV() != null && ((BaseBlockCipher)object3).ivLength != 0) {
                    ParametersWithIV parametersWithIV;
                    Object object5 = object3;
                    object3 = parametersWithIV;
                    parametersWithIV = new ParametersWithIV(cipherParameters, ((GOST28147ParameterSpec)object).getIV());
                    ((BaseBlockCipher)object5).ivParam = object3;
                    object2 = object3;
                } else {
                    object2 = parametersWithSBox2;
                }
            }
        } else if (object instanceof IvParameterSpec) {
            ParametersWithIV parametersWithIV;
            BaseBlockCipher baseBlockCipher = object3;
            object3 = (IvParameterSpec)object;
            object = parametersWithIV;
            parametersWithIV = new ParametersWithIV((CipherParameters)object2, ((IvParameterSpec)object3).getIV());
            baseBlockCipher.ivParam = object;
            object2 = object;
        } else if (object instanceof GOST28147ParameterSpec) {
            ParametersWithSBox parametersWithSBox;
            object = (GOST28147ParameterSpec)object;
            ParametersWithSBox parametersWithSBox3 = parametersWithSBox;
            parametersWithSBox = new ParametersWithSBox((CipherParameters)object2, ((GOST28147ParameterSpec)object).getSbox());
            if (((GOST28147ParameterSpec)object).getIV() != null && ((BaseBlockCipher)object3).ivLength != 0) {
                ParametersWithIV parametersWithIV;
                object2 = parametersWithIV;
                parametersWithIV = new ParametersWithIV(parametersWithSBox3, ((GOST28147ParameterSpec)object).getIV());
            } else {
                object2 = parametersWithSBox3;
            }
        }
        return object2;
    }

    private boolean isAEADModeName(String string) {
        return "CCM".equals(string) || "EAX".equals(string) || "GCM".equals(string) || "OCB".equals(string);
    }

    @Override
    public int engineGetBlockSize() {
        BlockCipher blockCipher = ((BaseBlockCipher)((Object)blockCipher)).baseEngine;
        if (blockCipher == null) {
            return -1;
        }
        return blockCipher.getBlockSize();
    }

    @Override
    public byte[] engineGetIV() {
        AEADParameters aEADParameters = ((BaseBlockCipher)((Object)parametersWithIV)).aeadParams;
        if (aEADParameters != null) {
            return aEADParameters.getNonce();
        }
        ParametersWithIV parametersWithIV = ((BaseBlockCipher)((Object)parametersWithIV)).ivParam;
        return parametersWithIV != null ? parametersWithIV.getIV() : null;
    }

    @Override
    public int engineGetKeySize(Key key) {
        return key.getEncoded().length * 8;
    }

    @Override
    public int engineGetOutputSize(int n) {
        return this.cipher.getOutputSize(n);
    }

    @Override
    public AlgorithmParameters engineGetParameters() {
        if (this.engineParams == null) {
            if (this.pbeSpec != null) {
                AlgorithmParameters algorithmParameters;
                try {
                    BaseBlockCipher baseBlockCipher = this;
                    algorithmParameters = baseBlockCipher.createParametersInstance(baseBlockCipher.pbeAlgorithm);
                }
                catch (Exception exception) {
                    return null;
                }
                this.engineParams = algorithmParameters;
                algorithmParameters.init(this.pbeSpec);
            }
            if (this.aeadParams != null) {
                if (this.baseEngine == null) {
                    AlgorithmParameters algorithmParameters;
                    try {
                        algorithmParameters = this.createParametersInstance(PKCSObjectIdentifiers.id_alg_AEADChaCha20Poly1305.getId());
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(((Object)exception).toString());
                    }
                    this.engineParams = algorithmParameters;
                    algorithmParameters.init(new DEROctetString(this.aeadParams.getNonce()).getEncoded());
                } else {
                    AlgorithmParameters algorithmParameters;
                    try {
                        algorithmParameters = this.createParametersInstance("GCM");
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(((Object)exception).toString());
                    }
                    this.engineParams = algorithmParameters;
                    algorithmParameters.init(new GCMParameters(this.aeadParams.getNonce(), this.aeadParams.getMacSize() / 8).getEncoded());
                }
            } else if (this.ivParam != null) {
                AlgorithmParameters algorithmParameters;
                String string = this.cipher.getUnderlyingCipher().getAlgorithmName();
                if (string.indexOf(47) >= 0) {
                    String string2 = string;
                    string = string2.substring(0, string2.indexOf(47));
                }
                try {
                    algorithmParameters = this.createParametersInstance(string);
                }
                catch (Exception exception) {
                    throw new RuntimeException(((Object)exception).toString());
                }
                this.engineParams = algorithmParameters;
                algorithmParameters.init(new IvParameterSpec(this.ivParam.getIV()));
            }
        }
        return this.engineParams;
    }

    @Override
    public void engineSetMode(String object) {
        block14: {
            block32: {
                block16: {
                    block31: {
                        AEADGenericBlockCipher aEADGenericBlockCipher;
                        block29: {
                            block30: {
                                AEADGenericBlockCipher aEADGenericBlockCipher2;
                                block28: {
                                    block27: {
                                        BufferedGenericBlockCipher bufferedGenericBlockCipher;
                                        block26: {
                                            BufferedGenericBlockCipher bufferedGenericBlockCipher2;
                                            block25: {
                                                BufferedGenericBlockCipher bufferedGenericBlockCipher3;
                                                block24: {
                                                    block22: {
                                                        block23: {
                                                            BufferedGenericBlockCipher bufferedGenericBlockCipher4;
                                                            block21: {
                                                                BufferedGenericBlockCipher bufferedGenericBlockCipher5;
                                                                block20: {
                                                                    BufferedGenericBlockCipher bufferedGenericBlockCipher6;
                                                                    block19: {
                                                                        block18: {
                                                                            block17: {
                                                                                BufferedGenericBlockCipher bufferedGenericBlockCipher7;
                                                                                block15: {
                                                                                    BufferedGenericBlockCipher bufferedGenericBlockCipher8;
                                                                                    if (this.baseEngine == null) break block14;
                                                                                    this.modeName = Strings.toUpperCase((String)object);
                                                                                    if (!this.modeName.equals("ECB")) break block15;
                                                                                    this.ivLength = 0;
                                                                                    object = bufferedGenericBlockCipher8;
                                                                                    bufferedGenericBlockCipher8 = new BufferedGenericBlockCipher(this.baseEngine);
                                                                                    break block16;
                                                                                }
                                                                                if (!this.modeName.equals("CBC")) break block17;
                                                                                this.ivLength = this.baseEngine.getBlockSize();
                                                                                object = bufferedGenericBlockCipher7;
                                                                                bufferedGenericBlockCipher7 = new BufferedGenericBlockCipher(new CBCBlockCipher(this.baseEngine));
                                                                                break block16;
                                                                            }
                                                                            if (!this.modeName.startsWith("OFB")) break block18;
                                                                            BaseBlockCipher baseBlockCipher = this;
                                                                            baseBlockCipher.ivLength = baseBlockCipher.baseEngine.getBlockSize();
                                                                            if (baseBlockCipher.modeName.length() != 3) {
                                                                                BufferedGenericBlockCipher bufferedGenericBlockCipher9;
                                                                                int n = Integer.parseInt(this.modeName.substring(3));
                                                                                BufferedGenericBlockCipher bufferedGenericBlockCipher10 = bufferedGenericBlockCipher9;
                                                                                bufferedGenericBlockCipher9 = new BufferedGenericBlockCipher(new OFBBlockCipher(this.baseEngine, n));
                                                                                object = bufferedGenericBlockCipher10;
                                                                            } else {
                                                                                BufferedGenericBlockCipher bufferedGenericBlockCipher11;
                                                                                object = bufferedGenericBlockCipher11;
                                                                                BlockCipher blockCipher = this.baseEngine;
                                                                                bufferedGenericBlockCipher11 = new BufferedGenericBlockCipher(new OFBBlockCipher(blockCipher, blockCipher.getBlockSize() * 8));
                                                                            }
                                                                            break block16;
                                                                        }
                                                                        if (!this.modeName.startsWith("CFB")) break block19;
                                                                        BaseBlockCipher baseBlockCipher = this;
                                                                        baseBlockCipher.ivLength = baseBlockCipher.baseEngine.getBlockSize();
                                                                        if (baseBlockCipher.modeName.length() != 3) {
                                                                            BufferedGenericBlockCipher bufferedGenericBlockCipher12;
                                                                            int n = Integer.parseInt(this.modeName.substring(3));
                                                                            BufferedGenericBlockCipher bufferedGenericBlockCipher13 = bufferedGenericBlockCipher12;
                                                                            bufferedGenericBlockCipher12 = new BufferedGenericBlockCipher(new CFBBlockCipher(this.baseEngine, n));
                                                                            object = bufferedGenericBlockCipher13;
                                                                        } else {
                                                                            BufferedGenericBlockCipher bufferedGenericBlockCipher14;
                                                                            object = bufferedGenericBlockCipher14;
                                                                            BlockCipher blockCipher = this.baseEngine;
                                                                            bufferedGenericBlockCipher14 = new BufferedGenericBlockCipher(new CFBBlockCipher(blockCipher, blockCipher.getBlockSize() * 8));
                                                                        }
                                                                        break block16;
                                                                    }
                                                                    if (!this.modeName.startsWith("PGPCFB")) break block20;
                                                                    boolean bl = this.modeName.equals("PGPCFBWITHIV");
                                                                    if (!bl && this.modeName.length() != 6) {
                                                                        throw new NoSuchAlgorithmException(a.a("no mode support for ").append(this.modeName).toString());
                                                                    }
                                                                    this.ivLength = this.baseEngine.getBlockSize();
                                                                    BufferedGenericBlockCipher bufferedGenericBlockCipher15 = bufferedGenericBlockCipher6;
                                                                    bufferedGenericBlockCipher6 = new BufferedGenericBlockCipher(new PGPCFBBlockCipher(this.baseEngine, bl));
                                                                    object = bufferedGenericBlockCipher15;
                                                                    break block16;
                                                                }
                                                                if (!this.modeName.equals("OPENPGPCFB")) break block21;
                                                                this.ivLength = 0;
                                                                object = bufferedGenericBlockCipher5;
                                                                bufferedGenericBlockCipher5 = new BufferedGenericBlockCipher(new OpenPGPCFBBlockCipher(this.baseEngine));
                                                                break block16;
                                                            }
                                                            if (!this.modeName.equals("SIC")) break block22;
                                                            this.ivLength = this.baseEngine.getBlockSize();
                                                            if (this.ivLength < 16) break block23;
                                                            this.fixedIv = false;
                                                            object = bufferedGenericBlockCipher4;
                                                            bufferedGenericBlockCipher4 = new BufferedGenericBlockCipher(new BufferedBlockCipher(new SICBlockCipher(this.baseEngine)));
                                                            break block16;
                                                        }
                                                        throw new IllegalArgumentException("Warning: SIC-Mode can become a twotime-pad if the blocksize of the cipher is too small. Use a cipher with a block size of at least 128 bits (e.g. AES)");
                                                    }
                                                    if (!this.modeName.equals("CTR")) break block24;
                                                    BaseBlockCipher baseBlockCipher = this;
                                                    baseBlockCipher.ivLength = baseBlockCipher.baseEngine.getBlockSize();
                                                    baseBlockCipher.fixedIv = false;
                                                    object = baseBlockCipher.baseEngine;
                                                    if (object instanceof DSTU7624Engine) {
                                                        KCTRBlockCipher kCTRBlockCipher;
                                                        BufferedBlockCipher bufferedBlockCipher;
                                                        BufferedGenericBlockCipher bufferedGenericBlockCipher16;
                                                        BufferedGenericBlockCipher bufferedGenericBlockCipher17 = bufferedGenericBlockCipher16;
                                                        BufferedBlockCipher bufferedBlockCipher2 = bufferedBlockCipher;
                                                        KCTRBlockCipher kCTRBlockCipher2 = kCTRBlockCipher;
                                                        kCTRBlockCipher = new KCTRBlockCipher((BlockCipher)object);
                                                        bufferedBlockCipher = new BufferedBlockCipher(kCTRBlockCipher2);
                                                        bufferedGenericBlockCipher16 = new BufferedGenericBlockCipher(bufferedBlockCipher2);
                                                        object = bufferedGenericBlockCipher17;
                                                    } else {
                                                        SICBlockCipher sICBlockCipher;
                                                        BufferedBlockCipher bufferedBlockCipher;
                                                        BufferedGenericBlockCipher bufferedGenericBlockCipher18;
                                                        BufferedGenericBlockCipher bufferedGenericBlockCipher19 = bufferedGenericBlockCipher18;
                                                        BufferedBlockCipher bufferedBlockCipher3 = bufferedBlockCipher;
                                                        SICBlockCipher sICBlockCipher2 = sICBlockCipher;
                                                        sICBlockCipher = new SICBlockCipher((BlockCipher)object);
                                                        bufferedBlockCipher = new BufferedBlockCipher(sICBlockCipher2);
                                                        bufferedGenericBlockCipher18 = new BufferedGenericBlockCipher(bufferedBlockCipher3);
                                                        object = bufferedGenericBlockCipher19;
                                                    }
                                                    break block16;
                                                }
                                                if (!this.modeName.equals("GOFB")) break block25;
                                                this.ivLength = this.baseEngine.getBlockSize();
                                                object = bufferedGenericBlockCipher3;
                                                bufferedGenericBlockCipher3 = new BufferedGenericBlockCipher(new BufferedBlockCipher(new GOFBBlockCipher(this.baseEngine)));
                                                break block16;
                                            }
                                            if (!this.modeName.equals("GCFB")) break block26;
                                            this.ivLength = this.baseEngine.getBlockSize();
                                            object = bufferedGenericBlockCipher2;
                                            bufferedGenericBlockCipher2 = new BufferedGenericBlockCipher(new BufferedBlockCipher(new GCFBBlockCipher(this.baseEngine)));
                                            break block16;
                                        }
                                        if (!this.modeName.equals("CTS")) break block27;
                                        this.ivLength = this.baseEngine.getBlockSize();
                                        object = bufferedGenericBlockCipher;
                                        bufferedGenericBlockCipher = new BufferedGenericBlockCipher(new CTSBlockCipher(new CBCBlockCipher(this.baseEngine)));
                                        break block16;
                                    }
                                    if (!this.modeName.equals("CCM")) break block28;
                                    this.ivLength = 12;
                                    if (this.baseEngine instanceof DSTU7624Engine) {
                                        AEADGenericBlockCipher aEADGenericBlockCipher3;
                                        object = aEADGenericBlockCipher3;
                                        aEADGenericBlockCipher3 = new AEADGenericBlockCipher(new KCCMBlockCipher(this.baseEngine));
                                    } else {
                                        AEADGenericBlockCipher aEADGenericBlockCipher4;
                                        object = aEADGenericBlockCipher4;
                                        aEADGenericBlockCipher4 = new AEADGenericBlockCipher(new CCMBlockCipher(this.baseEngine));
                                    }
                                    break block16;
                                }
                                if (!this.modeName.equals("OCB")) break block29;
                                if (this.engineProvider == null) break block30;
                                this.ivLength = 15;
                                object = aEADGenericBlockCipher2;
                                aEADGenericBlockCipher2 = new AEADGenericBlockCipher(new OCBBlockCipher(this.baseEngine, this.engineProvider.get()));
                                break block16;
                            }
                            throw new NoSuchAlgorithmException(i.a("can't support mode ", (String)object));
                        }
                        if (!this.modeName.equals("EAX")) break block31;
                        this.ivLength = this.baseEngine.getBlockSize();
                        object = aEADGenericBlockCipher;
                        aEADGenericBlockCipher = new AEADGenericBlockCipher(new EAXBlockCipher(this.baseEngine));
                        break block16;
                    }
                    if (!this.modeName.equals("GCM")) break block32;
                    BaseBlockCipher baseBlockCipher = this;
                    baseBlockCipher.ivLength = baseBlockCipher.baseEngine.getBlockSize();
                    if (baseBlockCipher.baseEngine instanceof DSTU7624Engine) {
                        AEADGenericBlockCipher aEADGenericBlockCipher;
                        object = aEADGenericBlockCipher;
                        aEADGenericBlockCipher = new AEADGenericBlockCipher(new KGCMBlockCipher(this.baseEngine));
                    } else {
                        AEADGenericBlockCipher aEADGenericBlockCipher;
                        object = aEADGenericBlockCipher;
                        aEADGenericBlockCipher = new AEADGenericBlockCipher(new GCMBlockCipher(this.baseEngine));
                    }
                }
                this.cipher = object;
                return;
            }
            throw new NoSuchAlgorithmException(i.a("can't support mode ", (String)object));
        }
        throw new NoSuchAlgorithmException("no mode supported for this algorithm");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void engineSetPadding(String string) {
        if (this.baseEngine == null) throw new NoSuchPaddingException("no padding supported for this algorithm");
        String string2 = Strings.toUpperCase(string);
        if (string2.equals("NOPADDING")) {
            if (!this.cipher.wrapOnNoPadding()) return;
            this.cipher = new BufferedGenericBlockCipher(new BufferedBlockCipher(this.cipher.getUnderlyingCipher()));
            return;
        } else if (!(string2.equals("WITHCTS") || string2.equals("CTSPADDING") || string2.equals("CS3PADDING"))) {
            BaseBlockCipher baseBlockCipher = this;
            baseBlockCipher.padded = true;
            if (baseBlockCipher.isAEADModeName(baseBlockCipher.modeName)) throw new NoSuchPaddingException("Only NoPadding can be used with AEAD modes.");
            if (!string2.equals("PKCS5PADDING") && !string2.equals("PKCS7PADDING")) {
                if (string2.equals("ZEROBYTEPADDING")) {
                    this.cipher = new BufferedGenericBlockCipher(this.cipher.getUnderlyingCipher(), new ZeroBytePadding());
                    return;
                } else if (!string2.equals("ISO10126PADDING") && !string2.equals("ISO10126-2PADDING")) {
                    if (!string2.equals("X9.23PADDING") && !string2.equals("X923PADDING")) {
                        if (!string2.equals("ISO7816-4PADDING") && !string2.equals("ISO9797-1PADDING")) {
                            if (!string2.equals("TBCPADDING")) throw new NoSuchPaddingException(g.a("Padding ", string, " unknown."));
                            this.cipher = new BufferedGenericBlockCipher(this.cipher.getUnderlyingCipher(), new TBCPadding());
                            return;
                        } else {
                            this.cipher = new BufferedGenericBlockCipher(this.cipher.getUnderlyingCipher(), new ISO7816d4Padding());
                        }
                        return;
                    } else {
                        this.cipher = new BufferedGenericBlockCipher(this.cipher.getUnderlyingCipher(), new X923Padding());
                    }
                    return;
                } else {
                    this.cipher = new BufferedGenericBlockCipher(this.cipher.getUnderlyingCipher(), new ISO10126d2Padding());
                }
                return;
            } else {
                this.cipher = new BufferedGenericBlockCipher(this.cipher.getUnderlyingCipher());
            }
            return;
        } else {
            this.cipher = new BufferedGenericBlockCipher(new CTSBlockCipher(this.cipher.getUnderlyingCipher()));
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void engineInit(int var1_4, Key var2_7, AlgorithmParameterSpec var3_11, SecureRandom var4_12) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 7[TRYBLOCK] [14, 13 : 2098->2129)] java.lang.Exception
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) {
        AlgorithmParameterSpec algorithmParameterSpec = null;
        if (algorithmParameters != null && (algorithmParameterSpec = SpecUtil.extractSpec(algorithmParameters, this.availableSpecs)) == null) {
            throw new InvalidAlgorithmParameterException(a.a("can't handle parameter ").append(algorithmParameters.toString()).toString());
        }
        this.engineInit(n, key, algorithmParameterSpec, secureRandom);
        this.engineParams = algorithmParameters;
    }

    @Override
    public void engineInit(int n, Key key, SecureRandom secureRandom) {
        BaseBlockCipher baseBlockCipher = baseBlockCipher2;
        BaseBlockCipher baseBlockCipher2 = null;
        try {
            baseBlockCipher.engineInit(n, key, (AlgorithmParameterSpec)((Object)baseBlockCipher2), secureRandom);
            return;
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException(invalidAlgorithmParameterException.getMessage());
        }
    }

    @Override
    public void engineUpdateAAD(byte[] byArray, int n, int n2) {
        this.cipher.updateAAD(byArray, n, n2);
    }

    @Override
    public void engineUpdateAAD(ByteBuffer byteBuffer) {
        int n = byteBuffer.remaining();
        if (n >= 1) {
            if (byteBuffer.hasArray()) {
                ByteBuffer byteBuffer2 = byteBuffer;
                BaseBlockCipher baseBlockCipher = object;
                ByteBuffer byteBuffer3 = byteBuffer;
                Object object = byteBuffer3.array();
                int n2 = byteBuffer3.arrayOffset();
                baseBlockCipher.engineUpdateAAD((byte[])object, byteBuffer.position() + n2, n);
                byteBuffer2.position(byteBuffer2.limit());
            } else if (n <= 512) {
                byte[] byArray = new byte[n];
                byteBuffer.get(byArray);
                ((BaseBlockCipher)object).engineUpdateAAD(byArray, 0, n);
                Arrays.fill(byArray, (byte)0);
            } else {
                int n3;
                int n4 = 512;
                byte[] byArray = new byte[512];
                do {
                    n3 = n;
                    n = Math.min(n4, n);
                    byteBuffer.get(byArray, 0, n);
                    ((BaseBlockCipher)object).engineUpdateAAD(byArray, 0, n);
                } while ((n = n3 - n) > 0);
                Arrays.fill(byArray, (byte)0);
            }
        }
    }

    @Override
    public byte[] engineUpdate(byte[] byArray, int n, int n2) {
        int n3 = ((BaseBlockCipher)object).cipher.getUpdateOutputSize(n2);
        if (n3 > 0) {
            Object object = new byte[n3];
            int n4 = ((BaseBlockCipher)object).cipher.processBytes(byArray, n, n2, (byte[])object, 0);
            if (n4 == 0) {
                return null;
            }
            if (n4 != n3) {
                byte[] byArray2 = new byte[n4];
                System.arraycopy(object, 0, byArray2, 0, n4);
                return byArray2;
            }
            return object;
        }
        ((BaseBlockCipher)object).cipher.processBytes(byArray, n, n2, null, 0);
        return null;
    }

    @Override
    public int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (n3 + this.cipher.getUpdateOutputSize(n2) <= byArray2.length) {
            try {
                return this.cipher.processBytes(byArray, n, n2, byArray2, n3);
            }
            catch (DataLengthException dataLengthException) {
                throw new IllegalStateException(((Object)dataLengthException).toString());
            }
        }
        throw new ShortBufferException("output buffer too short for input.");
    }

    @Override
    public byte[] engineDoFinal(byte[] byArray, int n, int n2) {
        block4: {
            int n3;
            int n4 = 0;
            int n5 = this.engineGetOutputSize(n2);
            byte[] byArray2 = new byte[n5];
            if (n2 != 0) {
                n4 = this.cipher.processBytes(byArray, n, n2, byArray2, 0);
            }
            try {
                n3 = n4 + this.cipher.doFinal(byArray2, n4);
                if (n3 == n5) {
                    return byArray2;
                }
                if (n3 > n5) break block4;
            }
            catch (DataLengthException dataLengthException) {
                throw new IllegalBlockSizeException(dataLengthException.getMessage());
            }
            byArray = new byte[n3];
            System.arraycopy(byArray2, 0, byArray, 0, n3);
            return byArray;
        }
        throw new IllegalBlockSizeException("internal buffer overflow");
    }

    @Override
    public int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4 = 0;
        if (this.engineGetOutputSize(n2) + n3 <= byArray2.length) {
            if (n2 != 0) {
                n4 = this.cipher.processBytes(byArray, n, n2, byArray2, n3);
            }
            int n5 = n4;
            GenericBlockCipher genericBlockCipher = this.cipher;
            try {
                return n5 + genericBlockCipher.doFinal(byArray2, n3 + n4);
            }
            catch (DataLengthException dataLengthException) {
                throw new IllegalBlockSizeException(dataLengthException.getMessage());
            }
            catch (OutputLengthException outputLengthException) {
                throw new IllegalBlockSizeException(outputLengthException.getMessage());
            }
        }
        throw new ShortBufferException("output buffer too short for input.");
    }

    public static class AEADGenericBlockCipher
    implements GenericBlockCipher {
        private static final Constructor aeadBadTagConstructor;
        private AEADCipher cipher;

        private static Constructor findExceptionConstructor(Class clazz) {
            Class[] classArray;
            Class clazz2;
            try {
                clazz2 = clazz;
                classArray = new Class[1];
            }
            catch (Exception exception) {
                return null;
            }
            classArray[0] = String.class;
            return clazz2.getConstructor(classArray);
        }

        public AEADGenericBlockCipher(AEADCipher aEADCipher) {
            this.cipher = aEADCipher;
        }

        public static /* synthetic */ AEADCipher access$000(AEADGenericBlockCipher aEADGenericBlockCipher) {
            return aEADGenericBlockCipher.cipher;
        }

        static {
            Class clazz = ClassUtil.loadClass(BaseBlockCipher.class, "javax.crypto.AEADBadTagException");
            aeadBadTagConstructor = clazz != null ? AEADGenericBlockCipher.findExceptionConstructor(clazz) : null;
        }

        @Override
        public void init(boolean bl, CipherParameters cipherParameters) {
            this.cipher.init(bl, cipherParameters);
        }

        @Override
        public String getAlgorithmName() {
            AEADCipher aEADCipher = ((AEADGenericBlockCipher)((Object)aEADCipher)).cipher;
            if (aEADCipher instanceof AEADBlockCipher) {
                return ((AEADBlockCipher)aEADCipher).getUnderlyingCipher().getAlgorithmName();
            }
            return aEADCipher.getAlgorithmName();
        }

        @Override
        public boolean wrapOnNoPadding() {
            return false;
        }

        @Override
        public BlockCipher getUnderlyingCipher() {
            AEADCipher aEADCipher = ((AEADGenericBlockCipher)((Object)aEADCipher)).cipher;
            if (aEADCipher instanceof AEADBlockCipher) {
                return ((AEADBlockCipher)aEADCipher).getUnderlyingCipher();
            }
            return null;
        }

        @Override
        public int getOutputSize(int n) {
            return this.cipher.getOutputSize(n);
        }

        @Override
        public int getUpdateOutputSize(int n) {
            return this.cipher.getUpdateOutputSize(n);
        }

        @Override
        public void updateAAD(byte[] byArray, int n, int n2) {
            this.cipher.processAADBytes(byArray, n, n2);
        }

        @Override
        public int processByte(byte by, byte[] byArray, int n) {
            return this.cipher.processByte(by, byArray, n);
        }

        @Override
        public int processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
            return this.cipher.processBytes(byArray, n, n2, byArray2, n3);
        }

        @Override
        public int doFinal(byte[] object, int n) {
            try {
                return this.cipher.doFinal((byte[])object, n);
            }
            catch (InvalidCipherTextException invalidCipherTextException) {
                Constructor constructor = aeadBadTagConstructor;
                object = constructor;
                if (constructor != null) {
                    Object[] objectArray;
                    Object object2 = object;
                    object = null;
                    try {
                        objectArray = new Object[1];
                        n = 0;
                    }
                    catch (Exception exception) {}
                    objectArray[n] = invalidCipherTextException.getMessage();
                    object = (BadPaddingException)((Constructor)object2).newInstance(objectArray);
                    if (object != null) {
                        throw object;
                    }
                }
                throw new BadPaddingException(invalidCipherTextException.getMessage());
            }
        }
    }

    public static class BufferedGenericBlockCipher
    implements GenericBlockCipher {
        private BufferedBlockCipher cipher;

        public BufferedGenericBlockCipher(BufferedBlockCipher bufferedBlockCipher) {
            this.cipher = bufferedBlockCipher;
        }

        public BufferedGenericBlockCipher(BlockCipher blockCipher) {
            PaddedBufferedBlockCipher paddedBufferedBlockCipher;
            PaddedBufferedBlockCipher paddedBufferedBlockCipher2 = paddedBufferedBlockCipher;
            paddedBufferedBlockCipher = new PaddedBufferedBlockCipher(blockCipher);
            v1.cipher = paddedBufferedBlockCipher2;
        }

        public BufferedGenericBlockCipher(BlockCipher blockCipher, BlockCipherPadding blockCipherPadding) {
            PaddedBufferedBlockCipher paddedBufferedBlockCipher;
            PaddedBufferedBlockCipher paddedBufferedBlockCipher2 = paddedBufferedBlockCipher;
            paddedBufferedBlockCipher = new PaddedBufferedBlockCipher(blockCipher, blockCipherPadding);
            v1.cipher = paddedBufferedBlockCipher2;
        }

        @Override
        public void init(boolean bl, CipherParameters cipherParameters) {
            this.cipher.init(bl, cipherParameters);
        }

        @Override
        public boolean wrapOnNoPadding() {
            return this.cipher instanceof CTSBlockCipher ^ true;
        }

        @Override
        public String getAlgorithmName() {
            return this.cipher.getUnderlyingCipher().getAlgorithmName();
        }

        @Override
        public BlockCipher getUnderlyingCipher() {
            return this.cipher.getUnderlyingCipher();
        }

        @Override
        public int getOutputSize(int n) {
            return this.cipher.getOutputSize(n);
        }

        @Override
        public int getUpdateOutputSize(int n) {
            return this.cipher.getUpdateOutputSize(n);
        }

        @Override
        public void updateAAD(byte[] byArray, int n, int n2) {
            throw new UnsupportedOperationException("AAD is not supported in the current mode.");
        }

        @Override
        public int processByte(byte by, byte[] byArray, int n) {
            return this.cipher.processByte(by, byArray, n);
        }

        @Override
        public int processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
            return this.cipher.processBytes(byArray, n, n2, byArray2, n3);
        }

        @Override
        public int doFinal(byte[] byArray, int n) {
            try {
                return this.cipher.doFinal(byArray, n);
            }
            catch (InvalidCipherTextException invalidCipherTextException) {
                throw new BadPaddingException(invalidCipherTextException.getMessage());
            }
        }
    }

    public static interface GenericBlockCipher {
        public void init(boolean var1, CipherParameters var2);

        public boolean wrapOnNoPadding();

        public String getAlgorithmName();

        public BlockCipher getUnderlyingCipher();

        public int getOutputSize(int var1);

        public int getUpdateOutputSize(int var1);

        public void updateAAD(byte[] var1, int var2, int var3);

        public int processByte(byte var1, byte[] var2, int var3);

        public int processBytes(byte[] var1, int var2, int var3, byte[] var4, int var5);

        public int doFinal(byte[] var1, int var2);
    }
}

