/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jce.netscape;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1InputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERBitString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERIA5String;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;

public class NetscapeCertRequest
extends ASN1Object {
    public AlgorithmIdentifier sigAlg;
    public AlgorithmIdentifier keyAlg;
    public byte[] sigBits;
    public String challenge;
    public DERBitString content;
    public PublicKey pubkey;

    private static ASN1Sequence getReq(byte[] byArray) {
        return ASN1Sequence.getInstance(new ASN1InputStream(new ByteArrayInputStream(byArray)).readObject());
    }

    public NetscapeCertRequest(byte[] byArray) {
        this(NetscapeCertRequest.getReq(byArray));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NetscapeCertRequest(ASN1Sequence aSN1Object) {
        X509EncodedKeySpec x509EncodedKeySpec;
        try {
            if (((ASN1Sequence)aSN1Object).size() != 3) throw new IllegalArgumentException("invalid SPKAC (size):" + ((ASN1Sequence)aSN1Object).size());
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(((Object)exception).toString());
        }
        this.sigAlg = AlgorithmIdentifier.getInstance(((ASN1Sequence)aSN1Object).getObjectAt(1));
        this.sigBits = ((DERBitString)((ASN1Sequence)aSN1Object).getObjectAt(2)).getOctets();
        aSN1Object = (ASN1Sequence)((ASN1Sequence)aSN1Object).getObjectAt(0);
        if (((ASN1Sequence)aSN1Object).size() != 2) throw new IllegalArgumentException("invalid PKAC (len): " + ((ASN1Sequence)aSN1Object).size());
        NetscapeCertRequest netscapeCertRequest = this;
        NetscapeCertRequest netscapeCertRequest2 = netscapeCertRequest;
        NetscapeCertRequest netscapeCertRequest3 = netscapeCertRequest;
        NetscapeCertRequest netscapeCertRequest4 = this;
        netscapeCertRequest4.challenge = ((DERIA5String)((ASN1Sequence)aSN1Object).getObjectAt(1)).getString();
        netscapeCertRequest4.content = new DERBitString(aSN1Object);
        aSN1Object = SubjectPublicKeyInfo.getInstance(((ASN1Sequence)aSN1Object).getObjectAt(0));
        X509EncodedKeySpec x509EncodedKeySpec2 = x509EncodedKeySpec;
        x509EncodedKeySpec = new X509EncodedKeySpec(new DERBitString(aSN1Object).getBytes());
        aSN1Object = ((SubjectPublicKeyInfo)aSN1Object).getAlgorithm();
        netscapeCertRequest2.keyAlg = aSN1Object;
        netscapeCertRequest3.pubkey = KeyFactory.getInstance(((AlgorithmIdentifier)aSN1Object).getAlgorithm().getId(), "BC").generatePublic(x509EncodedKeySpec2);
    }

    public NetscapeCertRequest(String string, AlgorithmIdentifier object, PublicKey publicKey) {
        ASN1EncodableVector aSN1EncodableVector;
        NetscapeCertRequest netscapeCertRequest = this;
        this.challenge = string;
        this.sigAlg = object;
        netscapeCertRequest.pubkey = publicKey;
        object = aSN1EncodableVector;
        ((ASN1EncodableVector)object)();
        aSN1EncodableVector.add(this.getKeySpec());
        aSN1EncodableVector.add(new DERIA5String(string));
        try {
            netscapeCertRequest.content = new DERBitString(new DERSequence((ASN1EncodableVector)object));
            return;
        }
        catch (IOException iOException) {
            throw new InvalidKeySpecException(a.a("exception encoding key: ").append(((Object)iOException).toString()).toString());
        }
    }

    private ASN1Primitive getKeySpec() {
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream2();
        try {
            byteArrayOutputStream.write(this.pubkey.getEncoded());
            byteArrayOutputStream.close();
            return new ASN1InputStream(new ByteArrayInputStream(byteArrayOutputStream2.toByteArray())).readObject();
        }
        catch (IOException iOException) {
            throw new InvalidKeySpecException(iOException.getMessage());
        }
    }

    public String getChallenge() {
        return this.challenge;
    }

    public void setChallenge(String string) {
        this.challenge = string;
    }

    public AlgorithmIdentifier getSigningAlgorithm() {
        return this.sigAlg;
    }

    public void setSigningAlgorithm(AlgorithmIdentifier algorithmIdentifier) {
        this.sigAlg = algorithmIdentifier;
    }

    public AlgorithmIdentifier getKeyAlgorithm() {
        return this.keyAlg;
    }

    public void setKeyAlgorithm(AlgorithmIdentifier algorithmIdentifier) {
        this.keyAlg = algorithmIdentifier;
    }

    public PublicKey getPublicKey() {
        return this.pubkey;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.pubkey = publicKey;
    }

    public boolean verify(String object) {
        if (!((String)object).equals(this.challenge)) {
            return false;
        }
        object = Signature.getInstance(this.sigAlg.getAlgorithm().getId(), "BC");
        ((Signature)object).initVerify(this.pubkey);
        ((Signature)object).update(this.content.getBytes());
        return ((Signature)object).verify(this.sigBits);
    }

    public void sign(PrivateKey privateKey) {
        this.sign(privateKey, null);
    }

    public void sign(PrivateKey object, SecureRandom secureRandom) {
        ASN1EncodableVector aSN1EncodableVector;
        Signature signature = Signature.getInstance(this.sigAlg.getAlgorithm().getId(), "BC");
        if (secureRandom != null) {
            signature.initSign((PrivateKey)object, secureRandom);
        } else {
            signature.initSign((PrivateKey)object);
        }
        Signature signature2 = signature;
        object = aSN1EncodableVector;
        ((ASN1EncodableVector)object)();
        aSN1EncodableVector.add(this.getKeySpec());
        aSN1EncodableVector.add(new DERIA5String(this.challenge));
        try {
            signature2.update(new DERSequence((ASN1EncodableVector)object).getEncoded("DER"));
            this.sigBits = signature2.sign();
            return;
        }
        catch (IOException iOException) {
            throw new SignatureException(iOException.getMessage());
        }
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2;
        ASN1EncodableVector aSN1EncodableVector3 = aSN1EncodableVector2;
        aSN1EncodableVector2 = new ASN1EncodableVector();
        ASN1EncodableVector aSN1EncodableVector4 = aSN1EncodableVector;
        aSN1EncodableVector4();
        try {
            aSN1EncodableVector.add(this.getKeySpec());
        }
        catch (Exception exception) {}
        ASN1EncodableVector aSN1EncodableVector5 = aSN1EncodableVector3;
        aSN1EncodableVector4.add(new DERIA5String(this.challenge));
        aSN1EncodableVector3.add(new DERSequence(aSN1EncodableVector4));
        aSN1EncodableVector5.add(this.sigAlg);
        aSN1EncodableVector5.add(new DERBitString(this.sigBits));
        return new DERSequence(aSN1EncodableVector3);
    }
}

