/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1InputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.d;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.util.ASN1Dump;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.X500Name;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.CRLDistPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.CRLNumber;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.CertificateList;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Extension;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Extensions;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.GeneralNames;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.IssuingDistributionPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.TBSCertList;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.X509Principal;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.ExtCRLException;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.RFC3280CertPathUtilities;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.X509CRLEntryObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.X509SignatureUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import java.io.IOException;
import java.math.BigInteger;
import java.security.Principal;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

public class X509CRLObject
extends X509CRL {
    private CertificateList c;
    private String sigAlgName;
    private byte[] sigAlgParams;
    private boolean isIndirect;
    private boolean isHashCodeSet = false;
    private int hashCodeValue;

    public static boolean isIndirectCRL(X509CRL object) {
        boolean bl;
        block5: {
            block4: {
                byte[] byArray;
                try {
                    byArray = object.getExtensionValue(Extension.issuingDistributionPoint.getId());
                }
                catch (Exception exception) {
                    throw new ExtCRLException("Exception reading IssuingDistributionPoint", exception);
                }
                object = byArray;
                if (byArray != null) {
                    if (!IssuingDistributionPoint.getInstance(ASN1OctetString.getInstance(object).getOctets()).isIndirectCRL()) break block4;
                    bl = true;
                    break block5;
                }
            }
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public X509CRLObject(CertificateList certificateList) {
        this.c = certificateList;
        try {
            this.sigAlgName = X509SignatureUtil.getSignatureName(certificateList.getSignatureAlgorithm());
            this.sigAlgParams = (byte[])(certificateList.getSignatureAlgorithm().getParameters() != null ? certificateList.getSignatureAlgorithm().getParameters().toASN1Primitive().getEncoded("DER") : null);
            this.isIndirect = X509CRLObject.isIndirectCRL(this);
            return;
        }
        catch (Exception exception) {
            throw new CRLException(f.a.a("CRL contents invalid: ", exception));
        }
    }

    private Set getExtensionOIDs(boolean bl) {
        if (((X509CRLObject)this).getVersion() == 2 && (this = ((X509CRLObject)this).c.getTBSCertList().getExtensions()) != null) {
            HashSet<String> hashSet;
            HashSet<String> hashSet2 = hashSet;
            hashSet = new HashSet<String>();
            Enumeration enumeration = ((Extensions)this).oids();
            while (enumeration.hasMoreElements()) {
                ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)enumeration.nextElement();
                if (bl != ((Extensions)this).getExtension(aSN1ObjectIdentifier).isCritical()) continue;
                hashSet2.add(aSN1ObjectIdentifier.getId());
            }
            return hashSet2;
        }
        return null;
    }

    private void doVerify(PublicKey publicKey, Signature signature) {
        if (this.c.getSignatureAlgorithm().equals(this.c.getTBSCertList().getSignature())) {
            signature.initVerify(publicKey);
            signature.update(this.getTBSCertList());
            if (signature.verify(this.getSignature())) {
                return;
            }
            throw new SignatureException("CRL does not verify with supplied public key.");
        }
        throw new CRLException("Signature algorithm on CertificateList does not match TBSCertList.");
    }

    private Set loadCRLEntries() {
        HashSet<X509CRLEntryObject> hashSet;
        HashSet<X509CRLEntryObject> hashSet2 = hashSet;
        hashSet = new HashSet<X509CRLEntryObject>();
        Enumeration enumeration = this.c.getRevokedCertificateEnumeration();
        X500Name x500Name = null;
        while (enumeration.hasMoreElements()) {
            ASN1Object aSN1Object = (TBSCertList.CRLEntry)enumeration.nextElement();
            hashSet2.add(new X509CRLEntryObject((TBSCertList.CRLEntry)aSN1Object, this.isIndirect, x500Name));
            if (!this.isIndirect || !((TBSCertList.CRLEntry)aSN1Object).hasExtensions() || (aSN1Object = ((TBSCertList.CRLEntry)aSN1Object).getExtensions().getExtension(Extension.certificateIssuer)) == null) continue;
            x500Name = X500Name.getInstance(GeneralNames.getInstance(((Extension)aSN1Object).getParsedValue()).getNames()[0].getName());
        }
        return hashSet2;
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        if ((this = ((X509CRLObject)this).getCriticalExtensionOIDs()) == null) {
            return false;
        }
        Object object = this;
        object.remove(RFC3280CertPathUtilities.ISSUING_DISTRIBUTION_POINT);
        object.remove(RFC3280CertPathUtilities.DELTA_CRL_INDICATOR);
        return object.isEmpty() ^ true;
    }

    public Set getCriticalExtensionOIDs() {
        return this.getExtensionOIDs(true);
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.getExtensionOIDs(false);
    }

    @Override
    public byte[] getExtensionValue(String string) {
        Object object = ((X509CRLObject)object).c.getTBSCertList().getExtensions();
        if (object != null) {
            ASN1ObjectIdentifier aSN1ObjectIdentifier;
            Object object2 = object;
            object = aSN1ObjectIdentifier;
            aSN1ObjectIdentifier = new ASN1ObjectIdentifier(string);
            if ((object = ((Extensions)object2).getExtension((ASN1ObjectIdentifier)object)) != null) {
                try {
                    return ((Extension)object).getExtnValue().getEncoded();
                }
                catch (Exception exception) {
                    throw new IllegalStateException(d.a(exception, a.a("error parsing ")));
                }
            }
        }
        return null;
    }

    @Override
    public byte[] getEncoded() {
        try {
            return this.c.getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CRLException(((Object)iOException).toString());
        }
    }

    @Override
    public void verify(PublicKey publicKey) {
        Signature signature;
        try {
            signature = Signature.getInstance(this.getSigAlgName(), "BC");
        }
        catch (Exception exception) {
            signature = Signature.getInstance(this.getSigAlgName());
        }
        this.doVerify(publicKey, signature);
    }

    @Override
    public void verify(PublicKey publicKey, String object) {
        object = object != null ? Signature.getInstance(this.getSigAlgName(), (String)object) : Signature.getInstance(this.getSigAlgName());
        this.doVerify(publicKey, (Signature)object);
    }

    @Override
    public void verify(PublicKey publicKey, Provider object) {
        object = object != null ? Signature.getInstance(this.getSigAlgName(), (Provider)object) : Signature.getInstance(this.getSigAlgName());
        this.doVerify(publicKey, (Signature)object);
    }

    @Override
    public int getVersion() {
        return this.c.getVersionNumber();
    }

    @Override
    public Principal getIssuerDN() {
        return new X509Principal(X500Name.getInstance(this.c.getIssuer().toASN1Primitive()));
    }

    @Override
    public X500Principal getIssuerX500Principal() {
        try {
            return new X500Principal(this.c.getIssuer().getEncoded());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("can't encode issuer DN");
        }
    }

    @Override
    public Date getThisUpdate() {
        return this.c.getThisUpdate().getDate();
    }

    @Override
    public Date getNextUpdate() {
        if (this.c.getNextUpdate() != null) {
            return this.c.getNextUpdate().getDate();
        }
        return null;
    }

    @Override
    public X509CRLEntry getRevokedCertificate(BigInteger bigInteger) {
        Enumeration enumeration = this.c.getRevokedCertificateEnumeration();
        X500Name x500Name = null;
        while (enumeration.hasMoreElements()) {
            ASN1Object aSN1Object = (TBSCertList.CRLEntry)enumeration.nextElement();
            if (((TBSCertList.CRLEntry)aSN1Object).getUserCertificate().hasValue(bigInteger)) {
                return new X509CRLEntryObject((TBSCertList.CRLEntry)aSN1Object, this.isIndirect, x500Name);
            }
            if (!this.isIndirect || !((TBSCertList.CRLEntry)aSN1Object).hasExtensions() || (aSN1Object = ((TBSCertList.CRLEntry)aSN1Object).getExtensions().getExtension(Extension.certificateIssuer)) == null) continue;
            x500Name = X500Name.getInstance(GeneralNames.getInstance(((Extension)aSN1Object).getParsedValue()).getNames()[0].getName());
        }
        return null;
    }

    public Set getRevokedCertificates() {
        if (!(this = ((X509CRLObject)this).loadCRLEntries()).isEmpty()) {
            return Collections.unmodifiableSet(this);
        }
        return null;
    }

    @Override
    public byte[] getTBSCertList() {
        try {
            return this.c.getTBSCertList().getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CRLException(((Object)iOException).toString());
        }
    }

    @Override
    public byte[] getSignature() {
        return this.c.getSignature().getOctets();
    }

    @Override
    public String getSigAlgName() {
        return this.sigAlgName;
    }

    @Override
    public String getSigAlgOID() {
        return this.c.getSignatureAlgorithm().getAlgorithm().getId();
    }

    @Override
    public byte[] getSigAlgParams() {
        Object object = ((X509CRLObject)object).sigAlgParams;
        if (((X509CRLObject)object).sigAlgParams != null) {
            int n = ((Object)object).length;
            byte[] byArray = new byte[n];
            System.arraycopy(object, 0, byArray, 0, n);
            return byArray;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String toString() {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2;
        StringBuffer stringBuffer3 = stringBuffer2 = stringBuffer;
        stringBuffer3();
        String string = Strings.lineSeparator();
        stringBuffer3.append("              Version: ").append(((X509CRLObject)((Object)iterator)).getVersion()).append(string);
        stringBuffer3.append("             IssuerDN: ").append(((X509CRLObject)((Object)iterator)).getIssuerDN()).append(string);
        stringBuffer3.append("          This update: ").append(((X509CRLObject)((Object)iterator)).getThisUpdate()).append(string);
        stringBuffer3.append("          Next update: ").append(((X509CRLObject)((Object)iterator)).getNextUpdate()).append(string);
        stringBuffer3.append("  Signature Algorithm: ").append(((X509CRLObject)((Object)iterator)).getSigAlgName()).append(string);
        Object object = ((X509CRLObject)((Object)iterator)).getSignature();
        stringBuffer.append("            Signature: ").append(new String(Hex.encode((byte[])object, 0, 20))).append(string);
        for (int k = 20; k < ((byte[])object).length; k += 20) {
            if (k < ((byte[])object).length - 20) {
                stringBuffer2.append("                       ").append(new String(Hex.encode((byte[])object, k, 20))).append(string);
                continue;
            }
            stringBuffer2.append("                       ").append(new String(Hex.encode((byte[])object, k, ((Object)object).length - k))).append(string);
        }
        Extensions extensions = ((X509CRLObject)((Object)iterator)).c.getTBSCertList().getExtensions();
        object = extensions;
        if (extensions != null) {
            Enumeration enumeration = ((Extensions)object).oids();
            if (enumeration.hasMoreElements()) {
                stringBuffer2.append("           Extensions: ").append(string);
            }
            while (enumeration.hasMoreElements()) {
                ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)enumeration.nextElement();
                Extension extension = ((Extensions)object).getExtension(aSN1ObjectIdentifier);
                if (extension.getExtnValue() != null) {
                    ASN1InputStream aSN1InputStream;
                    byte[] byArray = extension.getExtnValue().getOctets();
                    ASN1InputStream aSN1InputStream2 = aSN1InputStream;
                    aSN1InputStream = new ASN1InputStream(byArray);
                    stringBuffer2.append("                       critical(").append(extension.isCritical()).append(") ");
                    try {
                        StringBuffer stringBuffer4;
                        if (aSN1ObjectIdentifier.equals(Extension.cRLNumber)) {
                            stringBuffer4 = stringBuffer2.append(new CRLNumber(ASN1Integer.getInstance(aSN1InputStream2.readObject()).getPositiveValue()));
                        } else if (aSN1ObjectIdentifier.equals(Extension.deltaCRLIndicator)) {
                            stringBuffer4 = stringBuffer2.append("Base CRL: " + new CRLNumber(ASN1Integer.getInstance(aSN1InputStream2.readObject()).getPositiveValue()));
                        } else if (aSN1ObjectIdentifier.equals(Extension.issuingDistributionPoint)) {
                            stringBuffer4 = stringBuffer2.append(IssuingDistributionPoint.getInstance(aSN1InputStream2.readObject()));
                        } else if (aSN1ObjectIdentifier.equals(Extension.cRLDistributionPoints)) {
                            stringBuffer4 = stringBuffer2.append(CRLDistPoint.getInstance(aSN1InputStream2.readObject()));
                        } else if (aSN1ObjectIdentifier.equals(Extension.freshestCRL)) {
                            stringBuffer4 = stringBuffer2.append(CRLDistPoint.getInstance(aSN1InputStream2.readObject()));
                        } else {
                            StringBuffer stringBuffer5 = stringBuffer2;
                            stringBuffer5.append(aSN1ObjectIdentifier.getId());
                            stringBuffer4 = stringBuffer5.append(" value = ").append(ASN1Dump.dumpAsString(aSN1InputStream2.readObject()));
                        }
                        stringBuffer4.append(string);
                    }
                    catch (Exception exception) {
                        StringBuffer stringBuffer6 = stringBuffer2;
                        stringBuffer6.append(aSN1ObjectIdentifier.getId());
                        stringBuffer6.append(" value = ").append("*****").append(string);
                    }
                    continue;
                }
                stringBuffer2.append(string);
            }
        }
        if ((iterator = ((X509CRLObject)((Object)iterator)).getRevokedCertificates()) != null) {
            Iterator iterator = iterator.iterator();
            while (iterator.hasNext()) {
                stringBuffer2.append(iterator.next());
                stringBuffer2.append(string);
            }
        }
        return stringBuffer2.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isRevoked(Certificate certificate) {
        Object object;
        if (!certificate.getType().equals("X.509")) {
            throw new RuntimeException("X.509 CRL used with non X.509 Cert");
        }
        Enumeration enumeration = ((X509CRLObject)object).c.getRevokedCertificateEnumeration();
        X500Name x500Name = ((X509CRLObject)object).c.getIssuer();
        if (enumeration == null) return false;
        X509Certificate x509Certificate = (X509Certificate)certificate;
        BigInteger bigInteger = x509Certificate.getSerialNumber();
        while (enumeration.hasMoreElements()) {
            Extension extension;
            TBSCertList.CRLEntry cRLEntry = TBSCertList.CRLEntry.getInstance(enumeration.nextElement());
            if (((X509CRLObject)object).isIndirect && cRLEntry.hasExtensions() && (extension = cRLEntry.getExtensions().getExtension(Extension.certificateIssuer)) != null) {
                x500Name = X500Name.getInstance(GeneralNames.getInstance(extension.getParsedValue()).getNames()[0].getName());
            }
            if (!cRLEntry.getUserCertificate().hasValue(bigInteger)) continue;
            if (certificate instanceof X509Certificate) {
                object = X500Name.getInstance(x509Certificate.getIssuerX500Principal().getEncoded());
                return x500Name.equals(object);
            }
            try {
                object = com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Certificate.getInstance(certificate.getEncoded()).getIssuer();
                return x500Name.equals(object);
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new RuntimeException("Cannot process certificate");
            }
        }
        return false;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof X509CRL)) {
            return false;
        }
        if (object instanceof X509CRLObject) {
            object = (X509CRLObject)object;
            if (this.isHashCodeSet && ((X509CRLObject)object).isHashCodeSet && ((X509CRLObject)object).hashCodeValue != this.hashCodeValue) {
                return false;
            }
            return this.c.equals(((X509CRLObject)object).c);
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        if (!this.isHashCodeSet) {
            this.isHashCodeSet = true;
            this.hashCodeValue = super.hashCode();
        }
        return this.hashCodeValue;
    }
}

