/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.AbstractECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECAlgorithms;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECConstants;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECMultiplier;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.GLVMultiplier;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.LongArray;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.PreCompCallback;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.PreCompInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.Tnaf;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.WNafL2RMultiplier;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.WTauNafMultiplier;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.endo.ECEndomorphism;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.endo.GLVEndomorphism;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.field.FiniteField;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.field.FiniteFields;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.BigIntegers;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Integers;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Hashtable;
import java.util.Random;

public abstract class ECCurve {
    public static final int COORD_AFFINE = 0;
    public static final int COORD_HOMOGENEOUS = 1;
    public static final int COORD_JACOBIAN = 2;
    public static final int COORD_JACOBIAN_CHUDNOVSKY = 3;
    public static final int COORD_JACOBIAN_MODIFIED = 4;
    public static final int COORD_LAMBDA_AFFINE = 5;
    public static final int COORD_LAMBDA_PROJECTIVE = 6;
    public static final int COORD_SKEWED = 7;
    public FiniteField field;
    public ECFieldElement a;
    public ECFieldElement b;
    public BigInteger order;
    public BigInteger cofactor;
    public int coord = 0;
    public ECEndomorphism endomorphism = null;
    public ECMultiplier multiplier = null;

    public static int[] getAllCoordinateSystems() {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    }

    public ECCurve(FiniteField finiteField) {
        this.field = finiteField;
    }

    public abstract int getFieldSize();

    public abstract ECFieldElement fromBigInteger(BigInteger var1);

    public abstract boolean isValidFieldElement(BigInteger var1);

    public abstract ECFieldElement randomFieldElement(SecureRandom var1);

    public abstract ECFieldElement randomFieldElementMult(SecureRandom var1);

    public synchronized Config configure() {
        ECCurve eCCurve = this;
        int n = eCCurve.coord;
        ECEndomorphism eCEndomorphism = eCCurve.endomorphism;
        ECMultiplier eCMultiplier = eCCurve.multiplier;
        return new Config(n, eCEndomorphism, eCMultiplier);
    }

    public ECPoint validatePoint(BigInteger bigInteger, BigInteger bigInteger2) {
        if (((ECPoint)(this = ((ECCurve)this).createPoint(bigInteger, bigInteger2))).isValid()) {
            return this;
        }
        throw new IllegalArgumentException("Invalid point coordinates");
    }

    public ECPoint createPoint(BigInteger bigInteger, BigInteger bigInteger2) {
        ECCurve eCCurve = eCFieldElement;
        ECFieldElement eCFieldElement = ((ECCurve)((Object)eCFieldElement)).fromBigInteger(bigInteger);
        return eCCurve.createRawPoint(eCFieldElement, eCCurve.fromBigInteger(bigInteger2));
    }

    public abstract ECCurve cloneCurve();

    public abstract ECPoint createRawPoint(ECFieldElement var1, ECFieldElement var2);

    public abstract ECPoint createRawPoint(ECFieldElement var1, ECFieldElement var2, ECFieldElement[] var3);

    public ECMultiplier createDefaultMultiplier() {
        ECEndomorphism eCEndomorphism = this.endomorphism;
        if (eCEndomorphism instanceof GLVEndomorphism) {
            return new GLVMultiplier(this, (GLVEndomorphism)eCEndomorphism);
        }
        return new WNafL2RMultiplier();
    }

    public boolean supportsCoordinateSystem(int n) {
        return n == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreCompInfo getPreCompInfo(ECPoint eCPoint, String string) {
        ECPoint eCPoint2 = eCPoint;
        ((ECCurve)((Object)hashtable)).checkPoint(eCPoint);
        synchronized (eCPoint2) {
            block7: {
                Hashtable hashtable = eCPoint2.preCompTable;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                if (hashtable != null) break block7;
                return null;
            }
            synchronized (hashtable) {
                return (PreCompInfo)hashtable.get(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public PreCompInfo precompute(ECPoint var1_1, String var2_2, PreCompCallback var3_3) {
        v0 = var1_1;
        this.checkPoint((ECPoint)var1_1);
        synchronized (v0) {
            this = v0.preCompTable;
            if (this != null) ** GOTO lbl13
            v1 = var1_1;
            this = v2;
            v2 = new Hashtable<K, V>(4);
            v1.preCompTable = this;
lbl13:
            // 2 sources

            v3 = var3_3;
            v4 = this;
            v5 = var2_2;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            ** synchronized (this)
lbl-1000:
            // 1 sources

            {
                block11: {
                    var1_1 = (PreCompInfo)v4.get(v5);
                    var3_3 = v3.precompute((PreCompInfo)var1_1);
                    if (var3_3 == var1_1) break block11;
                    this.put(var2_2, var3_3);
                }
                return var3_3;
            }
        }
    }

    public ECPoint importPoint(ECPoint eCPoint) {
        if (eCPoint2 == eCPoint.getCurve()) {
            return eCPoint;
        }
        if (eCPoint.isInfinity()) {
            return ((ECCurve)((Object)eCPoint2)).getInfinity();
        }
        ECCurve eCCurve = eCPoint2;
        ECPoint eCPoint2 = eCPoint.normalize();
        return eCCurve.createPoint(eCPoint2.getXCoord().toBigInteger(), eCPoint2.getYCoord().toBigInteger());
    }

    public void normalizeAll(ECPoint[] eCPointArray) {
        int n = eCPointArray.length;
        this.normalizeAll(eCPointArray, 0, n, null);
    }

    public void normalizeAll(ECPoint[] eCPointArray, int n, int n2, ECFieldElement eCFieldElement) {
        ECCurve eCCurve = this;
        eCCurve.checkPoints(eCPointArray, n, n2);
        int n3 = eCCurve.getCoordinateSystem();
        if (n3 != 0 && n3 != 5) {
            int n4 = n2;
            ECFieldElement[] eCFieldElementArray = new ECFieldElement[n4];
            int[] nArray = new int[n4];
            int n5 = 0;
            for (int k = 0; k < n2; ++k) {
                int n6 = n + k;
                ECPoint eCPoint = eCPointArray[n6];
                if (eCPoint == null || eCFieldElement == null && eCPoint.isNormalized()) continue;
                eCFieldElementArray[n5] = eCPoint.getZCoord(0);
                int n7 = n5 + 1;
                nArray[n5] = n6;
                n5 = n7;
            }
            if (n5 == 0) {
                return;
            }
            ECAlgorithms.montgomeryTrick(eCFieldElementArray, 0, n5, eCFieldElement);
            for (n = 0; n < n5; ++n) {
                n2 = nArray[n];
                eCPointArray[n2] = eCPointArray[n2].normalize(eCFieldElementArray[n]);
            }
            return;
        }
        if (eCFieldElement == null) {
            return;
        }
        throw new IllegalArgumentException("'iso' not valid for affine coordinates");
    }

    public abstract ECPoint getInfinity();

    public FiniteField getField() {
        return this.field;
    }

    public ECFieldElement getA() {
        return this.a;
    }

    public ECFieldElement getB() {
        return this.b;
    }

    public BigInteger getOrder() {
        return this.order;
    }

    public BigInteger getCofactor() {
        return this.cofactor;
    }

    public int getCoordinateSystem() {
        return this.coord;
    }

    public abstract ECPoint decompressPoint(int var1, BigInteger var2);

    public ECEndomorphism getEndomorphism() {
        return this.endomorphism;
    }

    public ECMultiplier getMultiplier() {
        if (this.multiplier == null) {
            this.multiplier = this.createDefaultMultiplier();
        }
        return this.multiplier;
    }

    public ECPoint decodePoint(byte[] object) {
        block11: {
            int n = (((ECCurve)object2).getFieldSize() + 7) / 8;
            byte by = object[0];
            switch (by) {
                default: {
                    throw new IllegalArgumentException(b.a.a("Invalid point encoding 0x").append(Integer.toString(by, 16)).toString());
                }
                case 6: 
                case 7: {
                    Object object2;
                    if (((byte[])object).length == n * 2 + 1) {
                        boolean bl;
                        byte[] byArray = object;
                        object = BigIntegers.fromUnsignedByteArray(object, 1, n);
                        BigInteger bigInteger = BigIntegers.fromUnsignedByteArray(byArray, n + 1, n);
                        boolean bl2 = bigInteger.testBit(0);
                        if (bl2 == (bl = by == 7)) {
                            object2 = ((ECCurve)object2).validatePoint((BigInteger)object, bigInteger);
                            break;
                        }
                        throw new IllegalArgumentException("Inconsistent Y coordinate in hybrid encoding");
                    }
                    throw new IllegalArgumentException("Incorrect length for hybrid encoding");
                }
                case 4: {
                    Object object2;
                    if (((byte[])object).length == n * 2 + 1) {
                        Object object3 = object2;
                        object2 = BigIntegers.fromUnsignedByteArray(object, 1, n);
                        object2 = ((ECCurve)object3).validatePoint((BigInteger)object2, BigIntegers.fromUnsignedByteArray(object, n + 1, n));
                        break;
                    }
                    throw new IllegalArgumentException("Incorrect length for uncompressed encoding");
                }
                case 2: 
                case 3: {
                    if (((byte[])object).length == n + 1) {
                        int n2 = by & 1;
                        if (((ECPoint)(object2 = ((ECCurve)object2).decompressPoint(n2, BigIntegers.fromUnsignedByteArray(object, 1, n)))).implIsValid(true, true)) break;
                        throw new IllegalArgumentException("Invalid point");
                    }
                    throw new IllegalArgumentException("Incorrect length for compressed encoding");
                }
                case 0: {
                    if (((byte[])object).length != 1) break block11;
                    Object object2 = ((ECCurve)object2).getInfinity();
                }
            }
            if (by != 0 && ((ECPoint)object2).isInfinity()) {
                throw new IllegalArgumentException("Invalid infinity encoding");
            }
            return object2;
        }
        throw new IllegalArgumentException("Incorrect length for infinity encoding");
    }

    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n, final int n2) {
        final int n3 = this.getFieldSize() + 7 >>> 3;
        final byte[] byArray = new byte[n2 * n3 * 2];
        int n4 = 0;
        for (int k = 0; k < n2; ++k) {
            Object object = eCPointArray[n + k];
            byte[] byArray2 = ((ECPoint)object).getRawXCoord().toBigInteger().toByteArray();
            object = ((ECPoint)object).getRawYCoord().toBigInteger().toByteArray();
            int n5 = byArray2.length > n3 ? 1 : 0;
            int n6 = byArray2.length - n5;
            int n7 = ((Object)object).length > n3 ? 1 : 0;
            int n8 = n4;
            n4 = ((Object)object).length - n7;
            int n9 = n8 + n3;
            System.arraycopy(byArray2, n5, byArray, n9 - n6, n6);
            System.arraycopy(object, n7, byArray, (n9 += n3) - n4, n4);
            n4 = n9;
        }
        return new AbstractECLookupTable(){

            private ECPoint createPoint(byte[] byArray3, byte[] byArray2) {
                ECCurve eCCurve = ECCurve.this;
                return eCCurve.createRawPoint(eCCurve.fromBigInteger(new BigInteger(1, byArray3)), ECCurve.this.fromBigInteger(new BigInteger(1, byArray2)));
            }

            @Override
            public int getSize() {
                return n2;
            }

            @Override
            public ECPoint lookup(int n) {
                int n22 = n3;
                byte[] byArray4 = new byte[n22];
                byte[] byArray2 = new byte[n22];
                int n32 = 0;
                for (int k = 0; k < n2; ++k) {
                    int n4;
                    int n5 = (k ^ n) - 1 >> 31;
                    for (int i2 = 0; i2 < (n4 = n3); ++i2) {
                        byte[] byArray3 = byArray;
                        byArray4[i2] = (byte)(byArray4[i2] ^ byArray[n32 + i2] & n5);
                        byArray2[i2] = (byte)(byArray2[i2] ^ byArray3[n32 + n4 + i2] & n5);
                    }
                    n32 = n4 * 2 + n32;
                }
                return this.createPoint(byArray4, byArray2);
            }

            @Override
            public ECPoint lookupVar(int n) {
                int n22;
                int n32 = n3;
                byte[] byArray4 = new byte[n32];
                byte[] byArray2 = new byte[n32];
                int n4 = n * n32 * 2;
                for (int k = 0; k < (n22 = n3); ++k) {
                    byte[] byArray3 = byArray;
                    byArray4[k] = byArray3[n4 + k];
                    byArray2[k] = byArray[n4 + n22 + k];
                }
                return this.createPoint(byArray4, byArray2);
            }
        };
    }

    public void checkPoint(ECPoint eCPoint) {
        if (eCPoint != null && this == eCPoint.getCurve()) {
            return;
        }
        throw new IllegalArgumentException("'point' must be non-null and on this curve");
    }

    public void checkPoints(ECPoint[] eCPointArray) {
        int n = eCPointArray.length;
        this.checkPoints(eCPointArray, 0, n);
    }

    public void checkPoints(ECPoint[] eCPointArray, int n, int n2) {
        if (eCPointArray != null) {
            if (n >= 0 && n2 >= 0 && n <= eCPointArray.length - n2) {
                for (int k = 0; k < n2; ++k) {
                    ECPoint eCPoint = eCPointArray[n + k];
                    if (eCPoint == null || this == eCPoint.getCurve()) continue;
                    throw new IllegalArgumentException("'points' entries must be null or on this curve");
                }
                return;
            }
            throw new IllegalArgumentException("invalid range specified for 'points'");
        }
        throw new IllegalArgumentException("'points' cannot be null");
    }

    public boolean equals(ECCurve eCCurve) {
        return this == eCCurve || eCCurve != null && this.getField().equals(eCCurve.getField()) && this.getA().toBigInteger().equals(eCCurve.getA().toBigInteger()) && this.getB().toBigInteger().equals(eCCurve.getB().toBigInteger());
    }

    public boolean equals(Object object) {
        return this == object || object instanceof ECCurve && this.equals((ECCurve)object);
    }

    public int hashCode() {
        return this.getField().hashCode() ^ Integers.rotateLeft(this.getA().toBigInteger().hashCode(), 8) ^ Integers.rotateLeft(this.getB().toBigInteger().hashCode(), 16);
    }

    public static class F2m
    extends AbstractF2m {
        private static final int F2M_DEFAULT_COORDS = 6;
        private int m;
        private int k1;
        private int k2;
        private int k3;
        private ECPoint.F2m infinity;

        public F2m(int n, int n2, BigInteger bigInteger, BigInteger bigInteger2) {
            this(n, n2, 0, 0, bigInteger, bigInteger2, null, null);
        }

        public F2m(int n, int n2, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
            this(n, n2, 0, 0, bigInteger, bigInteger2, bigInteger3, bigInteger4);
        }

        public F2m(int n, int n2, int n3, int n4, BigInteger bigInteger, BigInteger bigInteger2) {
            this(n, n2, n3, n4, bigInteger, bigInteger2, null, null);
        }

        public F2m(int n, int n2, int n3, int n4, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
            F2m f2m = this;
            super(n, n2, n3, n4);
            this.m = n;
            this.k1 = n2;
            this.k2 = n3;
            this.k3 = n4;
            this.order = bigInteger3;
            f2m.cofactor = bigInteger4;
            f2m.infinity = new ECPoint.F2m(this, null, null);
            this.a = this.fromBigInteger(bigInteger);
            this.b = this.fromBigInteger(bigInteger2);
            this.coord = 6;
        }

        public F2m(int n, int n2, int n3, int n4, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, BigInteger bigInteger, BigInteger bigInteger2) {
            super(n, n2, n3, n4);
            ECPoint.F2m f2m;
            this.m = n;
            this.k1 = n2;
            this.k2 = n3;
            this.k3 = n4;
            this.order = bigInteger;
            this.cofactor = bigInteger2;
            ECPoint.F2m f2m2 = f2m;
            f2m = new ECPoint.F2m(this, null, null);
            this.infinity = f2m2;
            this.a = eCFieldElement;
            this.b = eCFieldElement2;
            this.coord = 6;
        }

        @Override
        public ECCurve cloneCurve() {
            F2m f2m = this;
            int n = f2m.m;
            int n2 = f2m.k1;
            int n3 = f2m.k2;
            int n4 = f2m.k3;
            ECFieldElement eCFieldElement = f2m.a;
            ECFieldElement eCFieldElement2 = f2m.b;
            BigInteger bigInteger = f2m.order;
            BigInteger bigInteger2 = f2m.cofactor;
            return new F2m(n, n2, n3, n4, eCFieldElement, eCFieldElement2, bigInteger, bigInteger2);
        }

        @Override
        public boolean supportsCoordinateSystem(int n) {
            return n == 0 || n == 1 || n == 6;
        }

        @Override
        public ECMultiplier createDefaultMultiplier() {
            if (this.isKoblitz()) {
                return new WTauNafMultiplier();
            }
            return super.createDefaultMultiplier();
        }

        @Override
        public int getFieldSize() {
            return this.m;
        }

        @Override
        public ECFieldElement fromBigInteger(BigInteger bigInteger) {
            F2m f2m = this;
            int n = f2m.m;
            int n2 = f2m.k1;
            int n3 = f2m.k2;
            int n4 = f2m.k3;
            return new ECFieldElement.F2m(n, n2, n3, n4, bigInteger);
        }

        @Override
        public ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
            return new ECPoint.F2m(this, eCFieldElement, eCFieldElement2);
        }

        @Override
        public ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
            return new ECPoint.F2m(this, eCFieldElement, eCFieldElement2, eCFieldElementArray);
        }

        @Override
        public ECPoint getInfinity() {
            return this.infinity;
        }

        public int getM() {
            return this.m;
        }

        public boolean isTrinomial() {
            return this.k2 == 0 && this.k3 == 0;
        }

        public int getK1() {
            return this.k1;
        }

        public int getK2() {
            return this.k2;
        }

        public int getK3() {
            return this.k3;
        }

        @Override
        public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n, final int n2) {
            int[] nArray;
            F2m f2m = this;
            final int n3 = f2m.m + 63 >>> 6;
            if (f2m.isTrinomial()) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = this.k1;
            } else {
                int[] nArray3 = new int[3];
                nArray = nArray3;
                nArray[0] = this.k1;
                nArray[1] = this.k2;
                nArray3[2] = this.k3;
            }
            final long[] lArray = new long[n2 * n3 * 2];
            int n4 = 0;
            for (int k = 0; k < n2; ++k) {
                ECPoint eCPoint = eCPointArray[n + k];
                ((ECFieldElement.F2m)eCPoint.getRawXCoord()).x.copyTo(lArray, n4);
                ((ECFieldElement.F2m)eCPoint.getRawYCoord()).x.copyTo(lArray, n4 += n3);
                n4 += n3;
            }
            return new AbstractECLookupTable(){

                private ECPoint createPoint(long[] object, long[] lArray2) {
                    LongArray longArray;
                    ECFieldElement.F2m f2m;
                    LongArray longArray2;
                    ECFieldElement.F2m f2m2;
                    ECFieldElement.F2m f2m3 = f2m2;
                    1 v1 = this;
                    int n = m;
                    int[] nArray2 = v1.nArray;
                    Object object2 = longArray2;
                    longArray2 = new LongArray((long[])object);
                    f2m2 = new ECFieldElement.F2m(n, nArray2, (LongArray)object2);
                    object = f2m;
                    1 v4 = this;
                    int n22 = m;
                    object2 = v4.nArray;
                    LongArray longArray3 = longArray;
                    longArray = new LongArray(lArray2);
                    f2m = new ECFieldElement.F2m(n22, (int[])object2, longArray3);
                    return this.createRawPoint(f2m3, (ECFieldElement)object);
                }

                @Override
                public int getSize() {
                    return n2;
                }

                @Override
                public ECPoint lookup(int n) {
                    1 v0 = this;
                    long[] lArray4 = Nat.create64(v0.n3);
                    long[] lArray2 = Nat.create64(v0.n3);
                    int n22 = 0;
                    for (int k = 0; k < n2; ++k) {
                        int n32;
                        long l = (k ^ n) - 1 >> 31;
                        for (int i2 = 0; i2 < (n32 = n3); ++i2) {
                            long[] lArray3 = lArray;
                            lArray4[i2] = lArray4[i2] ^ lArray[n22 + i2] & l;
                            lArray2[i2] = lArray2[i2] ^ lArray3[n22 + n32 + i2] & l;
                        }
                        n22 = n32 * 2 + n22;
                    }
                    return this.createPoint(lArray4, lArray2);
                }

                @Override
                public ECPoint lookupVar(int n) {
                    int n22;
                    1 v0 = this;
                    long[] lArray4 = Nat.create64(v0.n3);
                    long[] lArray2 = Nat.create64(v0.n3);
                    int n32 = n * v0.n3 * 2;
                    for (int k = 0; k < (n22 = n3); ++k) {
                        long[] lArray3 = lArray;
                        lArray4[k] = lArray3[n32 + k];
                        lArray2[k] = lArray[n32 + n22 + k];
                    }
                    return this.createPoint(lArray4, lArray2);
                }
            };
        }
    }

    public static abstract class AbstractF2m
    extends ECCurve {
        private BigInteger[] si = null;

        public static BigInteger inverse(int n, int[] nArray, BigInteger bigInteger) {
            return new LongArray(bigInteger).modInverse(n, nArray).toBigInteger();
        }

        private static FiniteField buildField(int n, int n2, int n3, int n4) {
            if (n2 != 0) {
                if (n3 == 0) {
                    if (n4 == 0) {
                        return FiniteFields.getBinaryExtensionField(new int[]{0, n2, n});
                    }
                    throw new IllegalArgumentException("k3 must be 0 if k2 == 0");
                }
                if (n3 > n2) {
                    if (n4 > n3) {
                        return FiniteFields.getBinaryExtensionField(new int[]{0, n2, n3, n4, n});
                    }
                    throw new IllegalArgumentException("k3 must be > k2");
                }
                throw new IllegalArgumentException("k2 must be > k1");
            }
            throw new IllegalArgumentException("k1 must be > 0");
        }

        public AbstractF2m(int n, int n2, int n3, int n4) {
            super(AbstractF2m.buildField(n, n2, n3, n4));
        }

        private static BigInteger implRandomFieldElementMult(SecureRandom secureRandom, int n) {
            BigInteger bigInteger;
            while ((bigInteger = BigIntegers.createRandomBigInteger(n, secureRandom)).signum() <= 0) {
            }
            return bigInteger;
        }

        @Override
        public ECPoint createPoint(BigInteger object, BigInteger object2) {
            AbstractF2m abstractF2m = this;
            object = abstractF2m.fromBigInteger((BigInteger)object);
            object2 = abstractF2m.fromBigInteger((BigInteger)object2);
            int n = abstractF2m.getCoordinateSystem();
            if (n == 5 || n == 6) {
                if (((ECFieldElement)object).isZero()) {
                    if (!((ECFieldElement)object2).square().equals(this.getB())) {
                        throw new IllegalArgumentException();
                    }
                } else {
                    object2 = ((ECFieldElement)object2).divide((ECFieldElement)object).add((ECFieldElement)object);
                }
            }
            return this.createRawPoint((ECFieldElement)object, (ECFieldElement)object2);
        }

        @Override
        public boolean isValidFieldElement(BigInteger bigInteger) {
            return bigInteger != null && bigInteger.signum() >= 0 && bigInteger.bitLength() <= this.getFieldSize();
        }

        @Override
        public ECFieldElement randomFieldElement(SecureRandom secureRandom) {
            AbstractF2m abstractF2m = this;
            return abstractF2m.fromBigInteger(BigIntegers.createRandomBigInteger(abstractF2m.getFieldSize(), secureRandom));
        }

        @Override
        public ECFieldElement randomFieldElementMult(SecureRandom secureRandom) {
            int n = this.getFieldSize();
            return this.fromBigInteger(AbstractF2m.implRandomFieldElementMult(secureRandom, n)).multiply(this.fromBigInteger(AbstractF2m.implRandomFieldElementMult(secureRandom, n)));
        }

        @Override
        public ECPoint decompressPoint(int n, BigInteger object) {
            object = this.fromBigInteger((BigInteger)object);
            ECFieldElement eCFieldElement = null;
            if (((ECFieldElement)object).isZero()) {
                eCFieldElement = this.getB().sqrt();
            } else {
                ECFieldElement eCFieldElement2 = this.solveQuadraticEquation(((ECFieldElement)object).square().invert().multiply(this.getB()).add(this.getA()).add((ECFieldElement)object));
                if (eCFieldElement2 != null) {
                    int n2;
                    n = eCFieldElement2.testBitZero() ? 1 : 0;
                    if (n != (n2 = n == 1 ? 1 : 0)) {
                        eCFieldElement2 = eCFieldElement2.addOne();
                    }
                    eCFieldElement = (n = this.getCoordinateSystem()) != 5 && n != 6 ? eCFieldElement2.multiply((ECFieldElement)object) : eCFieldElement2.add((ECFieldElement)object);
                }
            }
            if (eCFieldElement != null) {
                return this.createRawPoint((ECFieldElement)object, eCFieldElement);
            }
            throw new IllegalArgumentException("Invalid point compression");
        }

        public ECFieldElement solveQuadraticEquation(ECFieldElement eCFieldElement) {
            ECFieldElement eCFieldElement2;
            Random random;
            ECFieldElement eCFieldElement3 = (ECFieldElement.AbstractF2m)eCFieldElement;
            boolean bl = ((ECFieldElement.AbstractF2m)eCFieldElement3).hasFastTrace();
            if (bl && ((ECFieldElement.AbstractF2m)eCFieldElement3).trace() != 0) {
                return null;
            }
            int n = ((ECCurve)((Object)eCFieldElement4)).getFieldSize();
            if ((n & 1) != 0) {
                ECFieldElement eCFieldElement4 = ((ECFieldElement.AbstractF2m)eCFieldElement3).halfTrace();
                if (!bl && !eCFieldElement4.square().add(eCFieldElement4).add(eCFieldElement).isZero()) {
                    return null;
                }
                return eCFieldElement4;
            }
            if (eCFieldElement.isZero()) {
                return eCFieldElement;
            }
            eCFieldElement3 = ((ECCurve)((Object)eCFieldElement4)).fromBigInteger(ECConstants.ZERO);
            Random random2 = random;
            random = new Random();
            do {
                BigInteger bigInteger;
                Object object = bigInteger;
                bigInteger = new BigInteger(n, random2);
                object = ((ECCurve)((Object)eCFieldElement4)).fromBigInteger((BigInteger)object);
                eCFieldElement2 = eCFieldElement3;
                ECFieldElement eCFieldElement5 = eCFieldElement;
                for (int k = 1; k < n; ++k) {
                    ECFieldElement eCFieldElement6 = eCFieldElement5.square();
                    eCFieldElement5 = eCFieldElement6;
                    eCFieldElement5 = eCFieldElement2.square().add(eCFieldElement5.multiply((ECFieldElement)object));
                    eCFieldElement2 = eCFieldElement6.add(eCFieldElement);
                    ECFieldElement eCFieldElement7 = eCFieldElement2;
                    eCFieldElement2 = eCFieldElement5;
                    eCFieldElement5 = eCFieldElement7;
                }
                if (eCFieldElement5.isZero()) continue;
                return null;
            } while (eCFieldElement2.square().add(eCFieldElement2).isZero());
            return eCFieldElement2;
        }

        public synchronized BigInteger[] getSi() {
            if (this.si == null) {
                this.si = Tnaf.getSi(this);
            }
            return this.si;
        }

        public boolean isKoblitz() {
            return this.order != null && this.cofactor != null && this.b.isOne() && (this.a.isZero() || this.a.isOne());
        }
    }

    public static class Fp
    extends AbstractFp {
        private static final int FP_DEFAULT_COORDS = 4;
        public BigInteger q;
        public BigInteger r;
        public ECPoint.Fp infinity;

        public Fp(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
            this(bigInteger, bigInteger2, bigInteger3, null, null);
        }

        public Fp(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5) {
            Fp fp = this;
            Fp fp2 = this;
            super(bigInteger);
            this.q = bigInteger;
            fp2.r = ECFieldElement.Fp.calculateResidue(bigInteger);
            fp2.infinity = new ECPoint.Fp(this, null, null);
            this.a = this.fromBigInteger(bigInteger2);
            this.b = this.fromBigInteger(bigInteger3);
            this.order = bigInteger4;
            fp.cofactor = bigInteger5;
            fp.coord = 4;
        }

        public Fp(BigInteger object, BigInteger bigInteger, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, BigInteger bigInteger2, BigInteger bigInteger3) {
            super((BigInteger)object);
            ECPoint.Fp fp;
            this.q = object;
            this.r = bigInteger;
            object = fp;
            fp = new ECPoint.Fp(this, null, null);
            this.infinity = object;
            this.a = eCFieldElement;
            this.b = eCFieldElement2;
            this.order = bigInteger2;
            this.cofactor = bigInteger3;
            this.coord = 4;
        }

        @Override
        public ECCurve cloneCurve() {
            Fp fp = bigInteger;
            BigInteger bigInteger = fp.q;
            BigInteger bigInteger2 = fp.r;
            ECFieldElement eCFieldElement = fp.a;
            ECFieldElement eCFieldElement2 = fp.b;
            BigInteger bigInteger3 = fp.order;
            BigInteger bigInteger4 = fp.cofactor;
            return new Fp(bigInteger, bigInteger2, eCFieldElement, eCFieldElement2, bigInteger3, bigInteger4);
        }

        @Override
        public boolean supportsCoordinateSystem(int n) {
            return n == 0 || n == 1 || n == 2 || n == 4;
        }

        public BigInteger getQ() {
            return this.q;
        }

        @Override
        public int getFieldSize() {
            return this.q.bitLength();
        }

        @Override
        public ECFieldElement fromBigInteger(BigInteger bigInteger) {
            Fp fp = bigInteger2;
            BigInteger bigInteger2 = fp.q;
            return new ECFieldElement.Fp(bigInteger2, fp.r, bigInteger);
        }

        @Override
        public ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
            return new ECPoint.Fp(this, eCFieldElement, eCFieldElement2);
        }

        @Override
        public ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
            return new ECPoint.Fp(this, eCFieldElement, eCFieldElement2, eCFieldElementArray);
        }

        @Override
        public ECPoint importPoint(ECPoint eCPoint) {
            int n;
            if (!(this == eCPoint.getCurve() || this.getCoordinateSystem() != 2 || eCPoint.isInfinity() || (n = eCPoint.getCurve().getCoordinateSystem()) != 2 && n != 3 && n != 4)) {
                Fp fp = this;
                ECFieldElement eCFieldElement = this.fromBigInteger(eCPoint.x.toBigInteger());
                ECFieldElement[] eCFieldElementArray = new ECFieldElement[1];
                ECFieldElement[] eCFieldElementArray2 = eCFieldElementArray;
                eCFieldElementArray[0] = this.fromBigInteger(eCPoint.zs[0].toBigInteger());
                return new ECPoint.Fp(fp, eCFieldElement, fp.fromBigInteger(eCPoint.y.toBigInteger()), eCFieldElementArray2);
            }
            return super.importPoint(eCPoint);
        }

        @Override
        public ECPoint getInfinity() {
            return this.infinity;
        }
    }

    public static abstract class AbstractFp
    extends ECCurve {
        public AbstractFp(BigInteger bigInteger) {
            super(FiniteFields.getPrimeField(bigInteger));
        }

        private static BigInteger implRandomFieldElement(SecureRandom secureRandom, BigInteger bigInteger) {
            BigInteger bigInteger2;
            while ((bigInteger2 = BigIntegers.createRandomBigInteger(bigInteger.bitLength(), secureRandom)).compareTo(bigInteger) >= 0) {
            }
            return bigInteger2;
        }

        private static BigInteger implRandomFieldElementMult(SecureRandom secureRandom, BigInteger bigInteger) {
            BigInteger bigInteger2;
            while ((bigInteger2 = BigIntegers.createRandomBigInteger(bigInteger.bitLength(), secureRandom)).signum() <= 0 || bigInteger2.compareTo(bigInteger) >= 0) {
            }
            return bigInteger2;
        }

        @Override
        public boolean isValidFieldElement(BigInteger bigInteger) {
            return bigInteger != null && bigInteger.signum() >= 0 && bigInteger.compareTo(this.getField().getCharacteristic()) < 0;
        }

        @Override
        public ECFieldElement randomFieldElement(SecureRandom secureRandom) {
            BigInteger bigInteger = this.getField().getCharacteristic();
            return this.fromBigInteger(AbstractFp.implRandomFieldElement(secureRandom, bigInteger)).multiply(this.fromBigInteger(AbstractFp.implRandomFieldElement(secureRandom, bigInteger)));
        }

        @Override
        public ECFieldElement randomFieldElementMult(SecureRandom secureRandom) {
            BigInteger bigInteger = this.getField().getCharacteristic();
            return this.fromBigInteger(AbstractFp.implRandomFieldElementMult(secureRandom, bigInteger)).multiply(this.fromBigInteger(AbstractFp.implRandomFieldElementMult(secureRandom, bigInteger)));
        }

        @Override
        public ECPoint decompressPoint(int n, BigInteger object) {
            ECFieldElement eCFieldElement = ((ECFieldElement)(object = this.fromBigInteger((BigInteger)object))).square().add(this.a).multiply((ECFieldElement)object).add(this.b).sqrt();
            if (eCFieldElement != null) {
                int n2;
                n = eCFieldElement.testBitZero() ? 1 : 0;
                if (n != (n2 = n == 1 ? 1 : 0)) {
                    eCFieldElement = eCFieldElement.negate();
                }
                return this.createRawPoint((ECFieldElement)object, eCFieldElement);
            }
            throw new IllegalArgumentException("Invalid point compression");
        }
    }

    public class Config {
        public int coord;
        public ECEndomorphism endomorphism;
        public ECMultiplier multiplier;

        public Config(int n, ECEndomorphism eCEndomorphism, ECMultiplier eCMultiplier) {
            this.coord = n;
            this.endomorphism = eCEndomorphism;
            this.multiplier = eCMultiplier;
        }

        public Config setCoordinateSystem(int n) {
            this.coord = n;
            return this;
        }

        public Config setEndomorphism(ECEndomorphism eCEndomorphism) {
            this.endomorphism = eCEndomorphism;
            return this;
        }

        public Config setMultiplier(ECMultiplier eCMultiplier) {
            this.multiplier = eCMultiplier;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ECCurve create() {
            if (ECCurve.this.supportsCoordinateSystem(this.coord)) {
                ECCurve eCCurve = ECCurve.this.cloneCurve();
                if (eCCurve != ECCurve.this) {
                    ECCurve eCCurve2 = eCCurve;
                    synchronized (eCCurve) {
                        eCCurve.coord = this.coord;
                        eCCurve.endomorphism = this.endomorphism;
                        eCCurve2.multiplier = this.multiplier;
                        // ** MonitorExit[v0] (shouldn't be in output)
                        return eCCurve2;
                    }
                }
                throw new IllegalStateException("implementation returned current curve");
            }
            throw new IllegalStateException("unsupported coordinate system");
        }
    }
}

