/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecP160R2Field;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat160;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SecP160R2FieldElement
extends ECFieldElement.AbstractFp {
    public static final BigInteger Q = new BigInteger(1, Hex.decodeStrict("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFAC73"));
    public int[] x;

    public SecP160R2FieldElement(BigInteger bigInteger) {
        if (bigInteger != null && bigInteger.signum() >= 0 && bigInteger.compareTo(Q) < 0) {
            this.x = SecP160R2Field.fromBigInteger(bigInteger);
            return;
        }
        throw new IllegalArgumentException("x value invalid for SecP160R2FieldElement");
    }

    public SecP160R2FieldElement() {
        this.x = Nat160.create();
    }

    public SecP160R2FieldElement(int[] nArray) {
        this.x = nArray;
    }

    @Override
    public boolean isZero() {
        return Nat160.isZero(this.x);
    }

    @Override
    public boolean isOne() {
        return Nat160.isOne(this.x);
    }

    @Override
    public boolean testBitZero() {
        return Nat160.getBit(this.x, 0) == 1;
    }

    @Override
    public BigInteger toBigInteger() {
        return Nat160.toBigInteger(this.x);
    }

    @Override
    public String getFieldName() {
        return "SecP160R2Field";
    }

    @Override
    public int getFieldSize() {
        return Q.bitLength();
    }

    @Override
    public ECFieldElement add(ECFieldElement eCFieldElement) {
        SecP160R2FieldElement secP160R2FieldElement = object;
        Object object = Nat160.create();
        SecP160R2Field.add(secP160R2FieldElement.x, ((SecP160R2FieldElement)eCFieldElement).x, (int[])object);
        return new SecP160R2FieldElement((int[])object);
    }

    @Override
    public ECFieldElement addOne() {
        SecP160R2FieldElement secP160R2FieldElement = object;
        Object object = Nat160.create();
        SecP160R2Field.addOne(secP160R2FieldElement.x, (int[])object);
        return new SecP160R2FieldElement((int[])object);
    }

    @Override
    public ECFieldElement subtract(ECFieldElement eCFieldElement) {
        SecP160R2FieldElement secP160R2FieldElement = object;
        Object object = Nat160.create();
        SecP160R2Field.subtract(secP160R2FieldElement.x, ((SecP160R2FieldElement)eCFieldElement).x, (int[])object);
        return new SecP160R2FieldElement((int[])object);
    }

    @Override
    public ECFieldElement multiply(ECFieldElement eCFieldElement) {
        SecP160R2FieldElement secP160R2FieldElement = object;
        Object object = Nat160.create();
        SecP160R2Field.multiply(secP160R2FieldElement.x, ((SecP160R2FieldElement)eCFieldElement).x, (int[])object);
        return new SecP160R2FieldElement((int[])object);
    }

    @Override
    public ECFieldElement divide(ECFieldElement eCFieldElement) {
        int[] nArray = Nat160.create();
        SecP160R2Field.inv(((SecP160R2FieldElement)eCFieldElement).x, nArray);
        SecP160R2Field.multiply(nArray, this.x, nArray);
        return new SecP160R2FieldElement(nArray);
    }

    @Override
    public ECFieldElement negate() {
        SecP160R2FieldElement secP160R2FieldElement = object;
        Object object = Nat160.create();
        SecP160R2Field.negate(secP160R2FieldElement.x, (int[])object);
        return new SecP160R2FieldElement((int[])object);
    }

    @Override
    public ECFieldElement square() {
        SecP160R2FieldElement secP160R2FieldElement = object;
        Object object = Nat160.create();
        SecP160R2Field.square(secP160R2FieldElement.x, (int[])object);
        return new SecP160R2FieldElement((int[])object);
    }

    @Override
    public ECFieldElement invert() {
        SecP160R2FieldElement secP160R2FieldElement = object;
        Object object = Nat160.create();
        SecP160R2Field.inv(secP160R2FieldElement.x, (int[])object);
        return new SecP160R2FieldElement((int[])object);
    }

    @Override
    public ECFieldElement sqrt() {
        int[] nArray = ((SecP160R2FieldElement)object).x;
        if (!Nat160.isZero(((SecP160R2FieldElement)object).x) && !Nat160.isOne(nArray)) {
            int[] nArray2 = nArray;
            int[] nArray3 = Nat160.create();
            Object object = nArray3;
            SecP160R2Field.square(nArray, (int[])object);
            SecP160R2Field.multiply(nArray3, nArray, (int[])object);
            int[] nArray4 = Nat160.create();
            SecP160R2Field.square((int[])object, nArray4);
            SecP160R2Field.multiply(nArray4, nArray, nArray4);
            int[] nArray5 = Nat160.create();
            Object object2 = object;
            int[] nArray6 = nArray;
            Object object3 = object;
            int[] nArray7 = nArray;
            int[] nArray8 = nArray5;
            int[] nArray9 = nArray5;
            SecP160R2Field.square(nArray4, nArray5);
            SecP160R2Field.multiply(nArray5, nArray, nArray5);
            int[] nArray10 = Nat160.create();
            Object object4 = object = (Object)nArray10;
            SecP160R2Field.squareN(nArray5, 3, (int[])object);
            SecP160R2Field.multiply((int[])object4, nArray4, (int[])object);
            SecP160R2Field.squareN((int[])object4, 7, nArray5);
            SecP160R2Field.multiply(nArray5, (int[])object4, nArray5);
            SecP160R2Field.squareN(nArray5, 3, (int[])object);
            SecP160R2Field.multiply(nArray10, nArray4, (int[])object);
            nArray = Nat160.create();
            int[] nArray11 = nArray5;
            int[] nArray12 = nArray;
            SecP160R2Field.squareN((int[])object, 14, nArray);
            SecP160R2Field.multiply(nArray12, nArray5, nArray);
            SecP160R2Field.squareN(nArray12, 31, nArray5);
            SecP160R2Field.multiply(nArray11, nArray, nArray5);
            SecP160R2Field.squareN(nArray11, 62, nArray);
            SecP160R2Field.multiply(nArray, nArray5, nArray);
            SecP160R2Field.squareN(nArray, 3, nArray5);
            SecP160R2Field.multiply(nArray8, nArray4, nArray5);
            SecP160R2Field.squareN(nArray9, 18, nArray5);
            SecP160R2Field.multiply(nArray8, (int[])object, nArray5);
            SecP160R2Field.squareN(nArray9, 2, nArray5);
            SecP160R2Field.multiply(nArray5, nArray7, nArray5);
            SecP160R2Field.squareN(nArray5, 3, nArray5);
            SecP160R2Field.multiply(nArray5, (int[])object3, nArray5);
            SecP160R2Field.squareN(nArray5, 6, nArray5);
            SecP160R2Field.multiply(nArray5, nArray4, nArray5);
            SecP160R2Field.squareN(nArray5, 2, nArray5);
            SecP160R2Field.multiply(nArray5, nArray6, nArray5);
            SecP160R2Field.square(nArray5, (int[])object2);
            if (Nat160.eq(nArray2, nArray3)) {
                SecP160R2FieldElement secP160R2FieldElement;
                object = secP160R2FieldElement;
                secP160R2FieldElement = new SecP160R2FieldElement(nArray5);
            } else {
                object = null;
            }
            return object;
        }
        return object;
    }

    public boolean equals(Object object) {
        if (object == secP160R2FieldElement2) {
            return true;
        }
        if (!(object instanceof SecP160R2FieldElement)) {
            return false;
        }
        SecP160R2FieldElement secP160R2FieldElement = secP160R2FieldElement2;
        SecP160R2FieldElement secP160R2FieldElement2 = (SecP160R2FieldElement)object;
        return Nat160.eq(secP160R2FieldElement.x, secP160R2FieldElement2.x);
    }

    public int hashCode() {
        return Q.hashCode() ^ Arrays.hashCode(this.x, 0, 5);
    }
}

