/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Mod;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat192;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SecP192R1Field {
    private static final long M = 0xFFFFFFFFL;
    public static final int[] P = new int[]{-1, -1, -2, -1, -1, -1};
    private static final int[] PExt = new int[]{1, 0, 2, 0, 1, 0, -2, -1, -3, -1, -1, -1};
    private static final int[] PExtInv = new int[]{-1, -1, -3, -1, -2, -1, 1, 0, 2};
    private static final int P5 = -1;
    private static final int PExt11 = -1;

    public static void add(int[] nArray, int[] nArray2, int[] nArray3) {
        if (Nat192.add(nArray, nArray2, nArray3) != 0 || nArray3[5] == -1 && Nat192.gte(nArray3, P)) {
            SecP192R1Field.addPInvTo(nArray3);
        }
    }

    public static void addExt(int[] nArray, int[] nArray2, int[] nArray3) {
        if ((Nat.add(12, nArray, nArray2, nArray3) != 0 || nArray3[11] == -1 && Nat.gte(12, nArray3, nArray = PExt)) && Nat.addTo(PExtInv.length, nArray = PExtInv, nArray3) != 0) {
            int n = nArray.length;
            Nat.incAt(12, nArray3, n);
        }
    }

    public static void addOne(int[] nArray, int[] nArray2) {
        if (Nat.inc(6, nArray, nArray2) != 0 || nArray2[5] == -1 && Nat192.gte(nArray2, P)) {
            SecP192R1Field.addPInvTo(nArray2);
        }
    }

    public static int[] fromBigInteger(BigInteger object) {
        int[] nArray = Nat192.fromBigInteger((BigInteger)object);
        object = nArray;
        if (nArray[5] == -1) {
            int[] nArray2 = P;
            if (Nat192.gte((int[])object, P)) {
                Nat192.subFrom(nArray2, (int[])object);
            }
        }
        return object;
    }

    public static void half(int[] nArray, int[] nArray2) {
        if ((nArray[0] & 1) == 0) {
            Nat.shiftDownBit(6, nArray, 0, nArray2);
        } else {
            int n = Nat192.add(nArray, P, nArray2);
            Nat.shiftDownBit(6, nArray2, n);
        }
    }

    public static void inv(int[] nArray, int[] nArray2) {
        Mod.checkedModOddInverse(P, nArray, nArray2);
    }

    public static int isZero(int[] nArray) {
        int n = 0;
        for (int k = 0; k < 6; ++k) {
            n |= nArray[k];
        }
        return (n >>> 1 | n & 1) - 1 >> 31;
    }

    public static void multiply(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = Nat192.createExt();
        Nat192.mul(nArray, nArray2, nArray4);
        SecP192R1Field.reduce(nArray4, nArray3);
    }

    public static void multiplyAddToExt(int[] nArray, int[] nArray2, int[] nArray3) {
        if ((Nat192.mulAddTo(nArray, nArray2, nArray3) != 0 || nArray3[11] == -1 && Nat.gte(12, nArray3, nArray = PExt)) && Nat.addTo(PExtInv.length, nArray = PExtInv, nArray3) != 0) {
            int n = nArray.length;
            Nat.incAt(12, nArray3, n);
        }
    }

    public static void negate(int[] nArray, int[] nArray2) {
        if (SecP192R1Field.isZero(nArray) != 0) {
            Nat192.sub(P, P, nArray2);
        } else {
            Nat192.sub(P, nArray, nArray2);
        }
    }

    public static void random(SecureRandom secureRandom, int[] nArray) {
        int[] nArray2;
        byte[] byArray = new byte[24];
        do {
            secureRandom.nextBytes(byArray);
            Pack.littleEndianToInt(byArray, 0, nArray, 0, 6);
        } while (Nat.lessThan(6, nArray, nArray2 = P) == 0);
    }

    public static void randomMult(SecureRandom secureRandom, int[] nArray) {
        do {
            SecP192R1Field.random(secureRandom, nArray);
        } while (SecP192R1Field.isZero(nArray) != 0);
    }

    public static void reduce(int[] nArray, int[] nArray2) {
        int n;
        long l = (long)nArray[6] & 0xFFFFFFFFL;
        long l2 = (long)nArray[7] & 0xFFFFFFFFL;
        long l3 = (long)nArray[8] & 0xFFFFFFFFL;
        long l4 = (long)nArray[9] & 0xFFFFFFFFL;
        long l5 = (long)nArray[10] & 0xFFFFFFFFL;
        long l6 = (long)nArray[11] & 0xFFFFFFFFL;
        l5 = l + l5;
        l6 = l2 + l6;
        long l7 = l4;
        long l8 = ((long)nArray[0] & 0xFFFFFFFFL) + l5 + 0L;
        int n2 = (int)l8;
        long l9 = l8 >> 32;
        l9 = ((long)nArray[1] & 0xFFFFFFFFL) + l6 + l9;
        nArray2[1] = n = (int)l9;
        l4 = l9 >> 32;
        l6 += l7;
        long l10 = l2;
        long l11 = l;
        long l12 = ((long)nArray[2] & 0xFFFFFFFFL) + (l5 += l3) + l4;
        l = l12 & 0xFFFFFFFFL;
        l2 = l12 >> 32;
        l2 = ((long)nArray[3] & 0xFFFFFFFFL) + l6 + l2;
        nArray2[3] = (int)l2;
        l2 >>= 32;
        l4 = l5 - l11;
        l5 = l6 - l10;
        l2 = ((long)nArray[4] & 0xFFFFFFFFL) + l4 + l2;
        nArray2[4] = (int)l2;
        l2 >>= 32;
        l2 = ((long)nArray[5] & 0xFFFFFFFFL) + l5 + l2;
        nArray2[5] = (int)l2;
        l += (l2 >>= 32);
        nArray2[0] = (int)(l2 += (long)n2 & 0xFFFFFFFFL);
        if ((l2 >>= 32) != 0L) {
            long l13 = l;
            l = l2 + ((long)n & 0xFFFFFFFFL);
            nArray2[1] = (int)l;
            l = l13 + (l >> 32);
        }
        nArray2[2] = (int)l;
        if (l >> 32 != 0L && Nat.incAt(6, nArray2, 3) != 0 || nArray2[5] == -1 && Nat192.gte(nArray2, P)) {
            SecP192R1Field.addPInvTo(nArray2);
        }
    }

    public static void reduce32(int n, int[] nArray) {
        long l = 0L;
        if (n != 0) {
            long l2 = (long)n & 0xFFFFFFFFL;
            l = ((long)nArray[0] & 0xFFFFFFFFL) + l2 + l;
            nArray[0] = (int)l;
            if ((l >>= 32) != 0L) {
                nArray[1] = (int)(l += (long)nArray[1] & 0xFFFFFFFFL);
                l >>= 32;
            }
            l = ((long)nArray[2] & 0xFFFFFFFFL) + l2 + l;
            nArray[2] = (int)l;
            l >>= 32;
        }
        if (l != 0L && Nat.incAt(6, nArray, 3) != 0 || nArray[5] == -1 && Nat192.gte(nArray, P)) {
            SecP192R1Field.addPInvTo(nArray);
        }
    }

    public static void square(int[] nArray, int[] nArray2) {
        int[] nArray3 = Nat192.createExt();
        Nat192.square(nArray, nArray3);
        SecP192R1Field.reduce(nArray3, nArray2);
    }

    public static void squareN(int[] nArray, int n, int[] nArray2) {
        int[] nArray3 = Nat192.createExt();
        Nat192.square(nArray, nArray3);
        SecP192R1Field.reduce(nArray3, nArray2);
        while ((n += -1) > 0) {
            Nat192.square(nArray2, nArray3);
            SecP192R1Field.reduce(nArray3, nArray2);
        }
    }

    public static void subtract(int[] nArray, int[] nArray2, int[] nArray3) {
        if (Nat192.sub(nArray, nArray2, nArray3) != 0) {
            SecP192R1Field.subPInvFrom(nArray3);
        }
    }

    public static void subtractExt(int[] nArray, int[] nArray2, int[] nArray3) {
        if (Nat.sub(12, nArray, nArray2, nArray3) != 0 && Nat.subFrom(PExtInv.length, nArray = PExtInv, nArray3) != 0) {
            int n = nArray.length;
            Nat.decAt(12, nArray3, n);
        }
    }

    public static void twice(int[] nArray, int[] nArray2) {
        if (Nat.shiftUpBit(6, nArray, 0, nArray2) != 0 || nArray2[5] == -1 && Nat192.gte(nArray2, P)) {
            SecP192R1Field.addPInvTo(nArray2);
        }
    }

    private static void addPInvTo(int[] nArray) {
        long l = ((long)nArray[0] & 0xFFFFFFFFL) + 1L;
        nArray[0] = (int)l;
        if ((l >>= 32) != 0L) {
            nArray[1] = (int)(l += (long)nArray[1] & 0xFFFFFFFFL);
            l >>= 32;
        }
        l = ((long)nArray[2] & 0xFFFFFFFFL) + 1L + l;
        nArray[2] = (int)l;
        if (l >> 32 != 0L) {
            Nat.incAt(6, nArray, 3);
        }
    }

    private static void subPInvFrom(int[] nArray) {
        long l = ((long)nArray[0] & 0xFFFFFFFFL) - 1L;
        nArray[0] = (int)l;
        if ((l >>= 32) != 0L) {
            nArray[1] = (int)(l += (long)nArray[1] & 0xFFFFFFFFL);
            l >>= 32;
        }
        l = ((long)nArray[2] & 0xFFFFFFFFL) - 1L + l;
        nArray[2] = (int)l;
        if (l >> 32 != 0L) {
            Nat.decAt(6, nArray, 3);
        }
    }
}

