/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecP521R1Field;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SecP521R1FieldElement
extends ECFieldElement.AbstractFp {
    public static final BigInteger Q = new BigInteger(1, Hex.decodeStrict("01FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF"));
    public int[] x;

    public SecP521R1FieldElement(BigInteger bigInteger) {
        if (bigInteger != null && bigInteger.signum() >= 0 && bigInteger.compareTo(Q) < 0) {
            this.x = SecP521R1Field.fromBigInteger(bigInteger);
            return;
        }
        throw new IllegalArgumentException("x value invalid for SecP521R1FieldElement");
    }

    public SecP521R1FieldElement() {
        this.x = Nat.create(17);
    }

    public SecP521R1FieldElement(int[] nArray) {
        this.x = nArray;
    }

    @Override
    public boolean isZero() {
        return Nat.isZero(17, this.x);
    }

    @Override
    public boolean isOne() {
        return Nat.isOne(17, this.x);
    }

    @Override
    public boolean testBitZero() {
        return Nat.getBit(this.x, 0) == 1;
    }

    @Override
    public BigInteger toBigInteger() {
        return Nat.toBigInteger(17, this.x);
    }

    @Override
    public String getFieldName() {
        return "SecP521R1Field";
    }

    @Override
    public int getFieldSize() {
        return Q.bitLength();
    }

    @Override
    public ECFieldElement add(ECFieldElement eCFieldElement) {
        SecP521R1FieldElement secP521R1FieldElement = object;
        Object object = Nat.create(17);
        SecP521R1Field.add(secP521R1FieldElement.x, ((SecP521R1FieldElement)eCFieldElement).x, (int[])object);
        return new SecP521R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement addOne() {
        SecP521R1FieldElement secP521R1FieldElement = object;
        Object object = Nat.create(17);
        SecP521R1Field.addOne(secP521R1FieldElement.x, (int[])object);
        return new SecP521R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement subtract(ECFieldElement eCFieldElement) {
        SecP521R1FieldElement secP521R1FieldElement = object;
        Object object = Nat.create(17);
        SecP521R1Field.subtract(secP521R1FieldElement.x, ((SecP521R1FieldElement)eCFieldElement).x, (int[])object);
        return new SecP521R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement multiply(ECFieldElement eCFieldElement) {
        SecP521R1FieldElement secP521R1FieldElement = object;
        Object object = Nat.create(17);
        SecP521R1Field.multiply(secP521R1FieldElement.x, ((SecP521R1FieldElement)eCFieldElement).x, (int[])object);
        return new SecP521R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement divide(ECFieldElement eCFieldElement) {
        int[] nArray = Nat.create(17);
        SecP521R1Field.inv(((SecP521R1FieldElement)eCFieldElement).x, nArray);
        SecP521R1Field.multiply(nArray, this.x, nArray);
        return new SecP521R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement negate() {
        SecP521R1FieldElement secP521R1FieldElement = object;
        Object object = Nat.create(17);
        SecP521R1Field.negate(secP521R1FieldElement.x, (int[])object);
        return new SecP521R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement square() {
        SecP521R1FieldElement secP521R1FieldElement = object;
        Object object = Nat.create(17);
        SecP521R1Field.square(secP521R1FieldElement.x, (int[])object);
        return new SecP521R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement invert() {
        SecP521R1FieldElement secP521R1FieldElement = object;
        Object object = Nat.create(17);
        SecP521R1Field.inv(secP521R1FieldElement.x, (int[])object);
        return new SecP521R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement sqrt() {
        Object object = ((SecP521R1FieldElement)object2).x;
        if (!Nat.isZero(17, object) && !Nat.isOne(17, object)) {
            int[] nArray = Nat.create(17);
            Object object2 = nArray;
            int[] nArray2 = Nat.create(17);
            SecP521R1Field.squareN(object, 519, (int[])object2);
            SecP521R1Field.square(nArray, nArray2);
            if (Nat.eq(17, object, nArray2)) {
                SecP521R1FieldElement secP521R1FieldElement;
                object = secP521R1FieldElement;
                secP521R1FieldElement = new SecP521R1FieldElement((int[])object2);
            } else {
                object = null;
            }
            return object;
        }
        return object2;
    }

    public boolean equals(Object object) {
        if (object == object2) {
            return true;
        }
        if (!(object instanceof SecP521R1FieldElement)) {
            return false;
        }
        Object object2 = ((SecP521R1FieldElement)object2).x;
        object = ((SecP521R1FieldElement)object).x;
        return Nat.eq(17, (int[])object2, (int[])object);
    }

    public int hashCode() {
        return Q.hashCode() ^ Arrays.hashCode(this.x, 0, 17);
    }
}

