/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecT239Field;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat256;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.math.BigInteger;

public class SecT239FieldElement
extends ECFieldElement.AbstractF2m {
    public long[] x;

    public SecT239FieldElement(BigInteger bigInteger) {
        if (bigInteger != null && bigInteger.signum() >= 0 && bigInteger.bitLength() <= 239) {
            this.x = SecT239Field.fromBigInteger(bigInteger);
            return;
        }
        throw new IllegalArgumentException("x value invalid for SecT239FieldElement");
    }

    public SecT239FieldElement() {
        this.x = Nat256.create64();
    }

    public SecT239FieldElement(long[] lArray) {
        this.x = lArray;
    }

    @Override
    public boolean isOne() {
        return Nat256.isOne64(this.x);
    }

    @Override
    public boolean isZero() {
        return Nat256.isZero64(this.x);
    }

    @Override
    public boolean testBitZero() {
        return (this.x[0] & 1L) != 0L;
    }

    @Override
    public BigInteger toBigInteger() {
        return Nat256.toBigInteger64(this.x);
    }

    @Override
    public String getFieldName() {
        return "SecT239Field";
    }

    @Override
    public int getFieldSize() {
        return 239;
    }

    @Override
    public ECFieldElement add(ECFieldElement eCFieldElement) {
        SecT239FieldElement secT239FieldElement = object;
        Object object = Nat256.create64();
        SecT239Field.add(secT239FieldElement.x, ((SecT239FieldElement)eCFieldElement).x, (long[])object);
        return new SecT239FieldElement((long[])object);
    }

    @Override
    public ECFieldElement addOne() {
        SecT239FieldElement secT239FieldElement = object;
        Object object = Nat256.create64();
        SecT239Field.addOne(secT239FieldElement.x, (long[])object);
        return new SecT239FieldElement((long[])object);
    }

    @Override
    public ECFieldElement subtract(ECFieldElement eCFieldElement) {
        return this.add(eCFieldElement);
    }

    @Override
    public ECFieldElement multiply(ECFieldElement eCFieldElement) {
        SecT239FieldElement secT239FieldElement = object;
        Object object = Nat256.create64();
        SecT239Field.multiply(secT239FieldElement.x, ((SecT239FieldElement)eCFieldElement).x, (long[])object);
        return new SecT239FieldElement((long[])object);
    }

    @Override
    public ECFieldElement multiplyMinusProduct(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement eCFieldElement3) {
        return this.multiplyPlusProduct(eCFieldElement, eCFieldElement2, eCFieldElement3);
    }

    @Override
    public ECFieldElement multiplyPlusProduct(ECFieldElement object, ECFieldElement object2, ECFieldElement object3) {
        Object object4 = ((SecT239FieldElement)object4).x;
        object = ((SecT239FieldElement)object).x;
        object2 = ((SecT239FieldElement)object2).x;
        object3 = ((SecT239FieldElement)object3).x;
        long[] lArray = Nat256.createExt64();
        SecT239Field.multiplyAddToExt((long[])object4, (long[])object, lArray);
        SecT239Field.multiplyAddToExt((long[])object2, (long[])object3, lArray);
        long[] lArray2 = Nat256.create64();
        object4 = lArray2;
        SecT239Field.reduce(lArray, lArray2);
        return new SecT239FieldElement((long[])object4);
    }

    @Override
    public ECFieldElement divide(ECFieldElement eCFieldElement) {
        return this.multiply(eCFieldElement.invert());
    }

    @Override
    public ECFieldElement negate() {
        return this;
    }

    @Override
    public ECFieldElement square() {
        SecT239FieldElement secT239FieldElement = object;
        Object object = Nat256.create64();
        SecT239Field.square(secT239FieldElement.x, (long[])object);
        return new SecT239FieldElement((long[])object);
    }

    @Override
    public ECFieldElement squareMinusProduct(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return this.squarePlusProduct(eCFieldElement, eCFieldElement2);
    }

    @Override
    public ECFieldElement squarePlusProduct(ECFieldElement object, ECFieldElement object2) {
        Object object3 = ((SecT239FieldElement)object3).x;
        object = ((SecT239FieldElement)object).x;
        object2 = ((SecT239FieldElement)object2).x;
        long[] lArray = Nat256.createExt64();
        SecT239Field.squareAddToExt((long[])object3, lArray);
        SecT239Field.multiplyAddToExt((long[])object, (long[])object2, lArray);
        long[] lArray2 = Nat256.create64();
        object3 = lArray2;
        SecT239Field.reduce(lArray, lArray2);
        return new SecT239FieldElement((long[])object3);
    }

    @Override
    public ECFieldElement squarePow(int n) {
        if (n < 1) {
            return object;
        }
        SecT239FieldElement secT239FieldElement = object;
        Object object = Nat256.create64();
        SecT239Field.squareN(secT239FieldElement.x, n, (long[])object);
        return new SecT239FieldElement((long[])object);
    }

    @Override
    public ECFieldElement halfTrace() {
        SecT239FieldElement secT239FieldElement = object;
        Object object = Nat256.create64();
        SecT239Field.halfTrace(secT239FieldElement.x, (long[])object);
        return new SecT239FieldElement((long[])object);
    }

    @Override
    public boolean hasFastTrace() {
        return true;
    }

    @Override
    public int trace() {
        return SecT239Field.trace(this.x);
    }

    @Override
    public ECFieldElement invert() {
        SecT239FieldElement secT239FieldElement = object;
        Object object = Nat256.create64();
        SecT239Field.invert(secT239FieldElement.x, (long[])object);
        return new SecT239FieldElement((long[])object);
    }

    @Override
    public ECFieldElement sqrt() {
        SecT239FieldElement secT239FieldElement = object;
        Object object = Nat256.create64();
        SecT239Field.sqrt(secT239FieldElement.x, (long[])object);
        return new SecT239FieldElement((long[])object);
    }

    public int getRepresentation() {
        return 2;
    }

    public int getM() {
        return 239;
    }

    public int getK1() {
        return 158;
    }

    public int getK2() {
        return 0;
    }

    public int getK3() {
        return 0;
    }

    public boolean equals(Object object) {
        if (object == secT239FieldElement2) {
            return true;
        }
        if (!(object instanceof SecT239FieldElement)) {
            return false;
        }
        SecT239FieldElement secT239FieldElement = secT239FieldElement2;
        SecT239FieldElement secT239FieldElement2 = (SecT239FieldElement)object;
        return Nat256.eq64(secT239FieldElement.x, secT239FieldElement2.x);
    }

    public int hashCode() {
        return Arrays.hashCode(this.x, 0, 4) ^ 0x16CAFFE;
    }
}

