/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.util.GMSSRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;

public class GMSSRootSig {
    private Digest messDigestOTS;
    private int mdsize;
    private int keysize;
    private byte[] privateKeyOTS;
    private byte[] hash;
    private byte[] sign;
    private int w;
    private GMSSRandom gmssRandom;
    private int messagesize;
    private int k;
    private int r;
    private int test;
    private int counter;
    private int ii;
    private long test8;
    private long big8;
    private int steps;
    private int checksum;
    private int height;
    private byte[] seed;

    public GMSSRootSig(Digest digest, byte[][] byArray, int[] nArray) {
        int n;
        GMSSRootSig gMSSRootSig = this;
        gMSSRootSig.messDigestOTS = digest;
        gMSSRootSig.gmssRandom = new GMSSRandom(digest);
        this.counter = nArray[0];
        this.test = nArray[1];
        this.ii = nArray[2];
        this.r = nArray[3];
        this.steps = nArray[4];
        this.keysize = nArray[5];
        this.height = nArray[6];
        this.w = nArray[7];
        this.checksum = nArray[8];
        int n2 = this.messDigestOTS.getDigestSize();
        this.mdsize = n = n2;
        n = this.w;
        this.k = (1 << n) - 1;
        this.messagesize = (int)Math.ceil((double)(n2 << 3) / (double)n);
        this.privateKeyOTS = byArray[0];
        this.seed = byArray[1];
        this.hash = byArray[2];
        this.sign = byArray[3];
        byte[] byArray2 = byArray[4];
        this.test8 = (long)(byArray2[0] & 0xFF) | (long)(byArray2[1] & 0xFF) << 8 | (long)(byArray2[2] & 0xFF) << 16 | (long)(byArray2[3] & 0xFF) << 24 | (long)(byArray2[4] & 0xFF) << 32 | (long)(byArray2[5] & 0xFF) << 40 | (long)(byArray2[6] & 0xFF) << 48 | (long)(byArray2[7] & 0xFF) << 56;
        this.big8 = (long)(byArray2[8] & 0xFF) | (long)(byArray2[9] & 0xFF) << 8 | (long)(byArray2[10] & 0xFF) << 16 | (long)(byArray2[11] & 0xFF) << 24 | (long)(byArray2[12] & 0xFF) << 32 | (long)(byArray2[13] & 0xFF) << 40 | (long)(byArray2[14] & 0xFF) << 48 | (long)(byArray2[15] & 0xFF) << 56;
    }

    public GMSSRootSig(Digest digest, int n, int n2) {
        this.messDigestOTS = digest;
        this.gmssRandom = new GMSSRandom(digest);
        int n3 = this.messDigestOTS.getDigestSize();
        GMSSRootSig gMSSRootSig = this;
        this.mdsize = n3;
        this.w = n;
        gMSSRootSig.height = n2;
        gMSSRootSig.k = (1 << n) - 1;
        this.messagesize = (int)Math.ceil((double)(n3 << 3) / (double)n);
    }

    private void oneStep() {
        int n = this.w;
        if (8 % n == 0) {
            n = this.test;
            if (n == 0) {
                GMSSRootSig gMSSRootSig = this;
                gMSSRootSig.privateKeyOTS = gMSSRootSig.gmssRandom.nextSeed(this.seed);
                n = gMSSRootSig.ii;
                if (n < this.mdsize) {
                    n = this.hash[n];
                    this.test = n & this.k;
                    this.hash[n] = (byte)(n >>> this.w);
                } else {
                    n = this.checksum;
                    this.test = n & this.k;
                    this.checksum = n >>> this.w;
                }
            } else if (n > 0) {
                GMSSRootSig gMSSRootSig = this;
                gMSSRootSig.messDigestOTS.update(this.privateKeyOTS, 0, this.privateKeyOTS.length);
                byte[] byArray = new byte[gMSSRootSig.messDigestOTS.getDigestSize()];
                gMSSRootSig.privateKeyOTS = byArray;
                gMSSRootSig.messDigestOTS.doFinal(byArray, 0);
                --gMSSRootSig.test;
            }
            if (this.test == 0) {
                int n2;
                GMSSRootSig gMSSRootSig = this;
                GMSSRootSig gMSSRootSig2 = this;
                byte[] byArray = gMSSRootSig2.sign;
                int n3 = this.mdsize;
                int n4 = gMSSRootSig2.counter * n3;
                System.arraycopy(gMSSRootSig.privateKeyOTS, 0, byArray, n4, n3);
                this.counter = n2 = gMSSRootSig.counter + 1;
                if (n2 % (8 / this.w) == 0) {
                    ++this.ii;
                }
            }
        } else if (n < 8) {
            int n5;
            int n6 = this.test;
            if (n6 == 0) {
                n6 = this.counter;
                if (n6 % 8 == 0 && this.ii < (n5 = this.mdsize)) {
                    this.big8 = 0L;
                    if (n6 < n5 / n << 3) {
                        for (n = 0; n < this.w; ++n) {
                            GMSSRootSig gMSSRootSig = this;
                            long l = gMSSRootSig.big8;
                            byte[] byArray = gMSSRootSig.hash;
                            int n7 = gMSSRootSig.ii;
                            this.big8 = l ^ (long)((byArray[n7] & 0xFF) << (n << 3));
                            gMSSRootSig.ii = n7 + 1;
                        }
                    } else {
                        for (n = 0; n < this.mdsize % this.w; ++n) {
                            GMSSRootSig gMSSRootSig = this;
                            long l = gMSSRootSig.big8;
                            byte[] byArray = gMSSRootSig.hash;
                            int n8 = gMSSRootSig.ii;
                            this.big8 = l ^ (long)((byArray[n8] & 0xFF) << (n << 3));
                            gMSSRootSig.ii = n8 + 1;
                        }
                    }
                }
                if (this.counter == this.messagesize) {
                    this.big8 = this.checksum;
                }
                GMSSRootSig gMSSRootSig = this;
                gMSSRootSig.test = (int)(gMSSRootSig.big8 & (long)this.k);
                gMSSRootSig.privateKeyOTS = gMSSRootSig.gmssRandom.nextSeed(this.seed);
            } else if (n6 > 0) {
                GMSSRootSig gMSSRootSig = this;
                gMSSRootSig.messDigestOTS.update(this.privateKeyOTS, 0, this.privateKeyOTS.length);
                byte[] byArray = new byte[gMSSRootSig.messDigestOTS.getDigestSize()];
                gMSSRootSig.privateKeyOTS = byArray;
                gMSSRootSig.messDigestOTS.doFinal(byArray, 0);
                --gMSSRootSig.test;
            }
            if (this.test == 0) {
                GMSSRootSig gMSSRootSig = this;
                GMSSRootSig gMSSRootSig3 = this;
                byte[] byArray = gMSSRootSig3.sign;
                int n9 = this.mdsize;
                n5 = gMSSRootSig3.counter * n9;
                System.arraycopy(gMSSRootSig.privateKeyOTS, 0, byArray, n5, n9);
                gMSSRootSig.big8 >>>= this.w;
                ++gMSSRootSig.counter;
            }
        } else if (n < 57) {
            long l = this.test8;
            if (l == 0L) {
                this.big8 = 0L;
                this.ii = 0;
                int n10 = this.r;
                int n11 = n10 % 8;
                int n12 = n10 >>> 3;
                int n13 = this.mdsize;
                if (n12 < n13) {
                    long l2;
                    if (n10 <= (n13 << 3) - n) {
                        this.r = n10 + n;
                        n13 = this.r + 7 >>> 3;
                    } else {
                        this.r = n10 + n;
                    }
                    while (n12 < n13) {
                        GMSSRootSig gMSSRootSig = this;
                        long l3 = gMSSRootSig.big8;
                        int n14 = gMSSRootSig.hash[n12] & 0xFF;
                        int n15 = gMSSRootSig.ii;
                        this.big8 = l3 ^ (long)(n14 << (n15 << 3));
                        gMSSRootSig.ii = n15 + 1;
                        ++n12;
                    }
                    this.big8 = l2 = this.big8 >>> n11;
                    this.test8 = l2 & (long)this.k;
                } else {
                    n10 = this.checksum;
                    this.test8 = n10 & this.k;
                    this.checksum = n10 >>> n;
                }
                this.privateKeyOTS = this.gmssRandom.nextSeed(this.seed);
            } else if (l > 0L) {
                GMSSRootSig gMSSRootSig = this;
                gMSSRootSig.messDigestOTS.update(this.privateKeyOTS, 0, this.privateKeyOTS.length);
                byte[] byArray = new byte[gMSSRootSig.messDigestOTS.getDigestSize()];
                gMSSRootSig.privateKeyOTS = byArray;
                gMSSRootSig.messDigestOTS.doFinal(byArray, 0);
                --gMSSRootSig.test8;
            }
            if (this.test8 == 0L) {
                GMSSRootSig gMSSRootSig = this;
                GMSSRootSig gMSSRootSig4 = this;
                byte[] byArray = gMSSRootSig4.sign;
                int n16 = this.mdsize;
                int n17 = gMSSRootSig4.counter * n16;
                System.arraycopy(gMSSRootSig.privateKeyOTS, 0, byArray, n17, n16);
                ++gMSSRootSig.counter;
            }
        }
    }

    public void initSign(byte[] byArray, byte[] byArray2) {
        int n;
        GMSSRootSig gMSSRootSig = object;
        gMSSRootSig.hash = new byte[gMSSRootSig.mdsize];
        gMSSRootSig.messDigestOTS.update(byArray2, 0, byArray2.length);
        byArray2 = new byte[gMSSRootSig.messDigestOTS.getDigestSize()];
        gMSSRootSig.hash = byArray2;
        gMSSRootSig.messDigestOTS.doFinal(byArray2, 0);
        int n2 = gMSSRootSig.mdsize;
        byte[] byArray3 = new byte[n2];
        System.arraycopy(gMSSRootSig.hash, 0, byArray3, 0, n2);
        n2 = 0;
        int n3 = gMSSRootSig.getLog((gMSSRootSig.messagesize << ((GMSSRootSig)object).w) + 1);
        int n4 = gMSSRootSig.w;
        if (8 % n4 == 0) {
            int n5;
            n4 = 8 / n4;
            for (int k = 0; k < ((GMSSRootSig)object).mdsize; ++k) {
                for (int i2 = 0; i2 < n4; ++i2) {
                    byte by = byArray3[k];
                    n2 += by & ((GMSSRootSig)object).k;
                    byArray3[k] = (byte)(by >>> ((GMSSRootSig)object).w);
                }
            }
            ((GMSSRootSig)object).checksum = n5 = (((GMSSRootSig)object).messagesize << ((GMSSRootSig)object).w) - n2;
            n4 = 0;
            while (n4 < n3) {
                int n6 = n4;
                int n7 = n5;
                n2 += n5 & ((GMSSRootSig)object).k;
                n5 = ((GMSSRootSig)object).w;
                n4 = n7 >>> n5;
                int n8 = n5 = n6 + n5;
                n5 = n4;
                n4 = n8;
            }
        } else if (n4 < 8) {
            int n9 = 0;
            n4 = ((GMSSRootSig)object).mdsize / n4;
            for (int k = 0; k < n4; ++k) {
                int n10;
                long l = 0L;
                for (n10 = 0; n10 < ((GMSSRootSig)object).w; ++n10) {
                    l ^= (long)((byArray3[n9] & 0xFF) << (n10 << 3));
                    ++n9;
                }
                for (n10 = 0; n10 < 8; ++n10) {
                    n2 += (int)(l & (long)((GMSSRootSig)object).k);
                    l >>>= ((GMSSRootSig)object).w;
                }
            }
            n4 = ((GMSSRootSig)object).mdsize % ((GMSSRootSig)object).w;
            long l = 0L;
            for (int k = 0; k < n4; ++k) {
                l ^= (long)((byArray3[n9] & 0xFF) << (k << 3));
                ++n9;
            }
            int n11 = n4 << 3;
            n4 = 0;
            while (n4 < n11) {
                int n12 = n4;
                n2 += (int)(l & (long)((GMSSRootSig)object).k);
                n4 = ((GMSSRootSig)object).w;
                l >>>= n4;
                n4 = n12 + n4;
            }
            ((GMSSRootSig)object).checksum = n11 = (((GMSSRootSig)object).messagesize << ((GMSSRootSig)object).w) - n2;
            n4 = 0;
            while (n4 < n3) {
                int n13 = n4;
                int n14 = n11;
                n2 += n11 & ((GMSSRootSig)object).k;
                n11 = ((GMSSRootSig)object).w;
                n4 = n14 >>> n11;
                int n15 = n11 = n13 + n11;
                n11 = n4;
                n4 = n15;
            }
        } else if (n4 < 57) {
            int n16;
            int n17;
            int n18;
            n4 = 0;
            while (n4 <= ((n18 = ((GMSSRootSig)object).mdsize) << 3) - (n17 = ((GMSSRootSig)object).w)) {
                int n19 = n4;
                int n20 = n4;
                n18 = n20 % 8;
                n17 = n19 + n17;
                int n21 = n17 + 7 >>> 3;
                long l = 0L;
                int n22 = 0;
                for (n4 = (v780397) >>> 3; n4 < n21; ++n4) {
                    l ^= (long)((byArray3[n4] & 0xFF) << (n22 << 3));
                    ++n22;
                }
                long l2 = l >>> n18;
                n2 = (int)((long)n2 + (l2 & (long)((GMSSRootSig)object).k));
                n4 = n17;
            }
            n17 = n4 >>> 3;
            if (n17 < n18) {
                n4 %= 8;
                long l = 0L;
                n18 = 0;
                while (n17 < ((GMSSRootSig)object).mdsize) {
                    l ^= (long)((byArray3[n17] & 0xFF) << (n18 << 3));
                    ++n18;
                    ++n17;
                }
                long l3 = l >>> n4;
                n2 = (int)((long)n2 + (l3 & (long)((GMSSRootSig)object).k));
            }
            ((GMSSRootSig)object).checksum = n16 = (((GMSSRootSig)object).messagesize << ((GMSSRootSig)object).w) - n2;
            int n23 = 0;
            while (n23 < n3) {
                int n24 = n23;
                int n25 = n16;
                n2 += n16 & ((GMSSRootSig)object).k;
                n16 = ((GMSSRootSig)object).w;
                n23 = n25 >>> n16;
                int n26 = n16 = n24 + n16;
                n16 = n23;
                n23 = n26;
            }
        }
        GMSSRootSig gMSSRootSig2 = object;
        ((GMSSRootSig)object).keysize = n = gMSSRootSig2.messagesize + (int)Math.ceil((double)n3 / (double)((GMSSRootSig)object).w);
        gMSSRootSig2.steps = (int)Math.ceil((double)(n + n2) / (double)(1 << ((GMSSRootSig)object).height));
        n = gMSSRootSig2.keysize;
        n2 = gMSSRootSig2.mdsize;
        GMSSRootSig gMSSRootSig3 = object;
        gMSSRootSig3.sign = new byte[n * n2];
        gMSSRootSig3.counter = 0;
        gMSSRootSig3.test = 0;
        gMSSRootSig3.ii = 0;
        gMSSRootSig3.test8 = 0L;
        gMSSRootSig3.r = 0;
        ((GMSSRootSig)object).privateKeyOTS = new byte[n2];
        byte[] byArray4 = new byte[n2];
        Object object = byArray4;
        gMSSRootSig2.seed = byArray4;
        System.arraycopy(byArray, 0, object, 0, n2);
    }

    public boolean updateSign() {
        for (int k = 0; k < this.steps; ++k) {
            if (this.counter < this.keysize) {
                this.oneStep();
            }
            if (this.counter != this.keysize) continue;
            return true;
        }
        return false;
    }

    public byte[] getSig() {
        return this.sign;
    }

    public int getLog(int n) {
        int n2 = 1;
        int n3 = 2;
        while (n3 < n) {
            n3 <<= 1;
            ++n2;
        }
        return n2;
    }

    public byte[][] getStatByte() {
        byte[][] byArray = new byte[5][this.mdsize];
        byte[][] byArray2 = byArray;
        byArray2[0] = this.privateKeyOTS;
        byArray2[1] = this.seed;
        byArray2[2] = this.hash;
        byArray2[3] = this.sign;
        byArray[4] = this.getStatLong();
        return byArray;
    }

    public int[] getStatInt() {
        int[] nArray = new int[9];
        int[] nArray2 = nArray;
        nArray2[0] = this.counter;
        nArray2[1] = this.test;
        nArray2[2] = this.ii;
        nArray2[3] = this.r;
        nArray2[4] = this.steps;
        nArray2[5] = this.keysize;
        nArray2[6] = this.height;
        nArray2[7] = this.w;
        nArray[8] = this.checksum;
        return nArray;
    }

    public byte[] getStatLong() {
        byte[] byArray = new byte[16];
        byte[] byArray2 = byArray;
        long l = this.test8;
        byArray2[0] = (byte)(l & 0xFFL);
        byArray2[1] = (byte)(l >> 8 & 0xFFL);
        byArray2[2] = (byte)(l >> 16 & 0xFFL);
        byArray2[3] = (byte)(l >> 24 & 0xFFL);
        byArray2[4] = (byte)(l >> 32 & 0xFFL);
        byArray2[5] = (byte)(l >> 40 & 0xFFL);
        byArray2[6] = (byte)(l >> 48 & 0xFFL);
        byArray2[7] = (byte)(l >> 56 & 0xFFL);
        l = this.big8;
        byArray2[8] = (byte)(l & 0xFFL);
        byArray2[9] = (byte)(l >> 8 & 0xFFL);
        byArray2[10] = (byte)(l >> 16 & 0xFFL);
        byArray2[11] = (byte)(l >> 24 & 0xFFL);
        byArray2[12] = (byte)(l >> 32 & 0xFFL);
        byArray2[13] = (byte)(l >> 40 & 0xFFL);
        byArray2[14] = (byte)(l >> 48 & 0xFFL);
        byArray[15] = (byte)(l >> 56 & 0xFFL);
        return byArray;
    }

    public String toString() {
        GMSSRootSig gMSSRootSig = object;
        Object object = a.a("").append(((GMSSRootSig)object).big8).append("  ").toString();
        int[] nArray = gMSSRootSig.getStatInt();
        byte[][] byArray = new byte[5][gMSSRootSig.mdsize].getStatByte();
        for (int k = 0; k < 9; ++k) {
            object = b.a(a.a((String)object), nArray[k], " ");
        }
        for (int k = 0; k < 5; ++k) {
            object = d.a.a(a.a((String)object), new String(Hex.encode(byArray[k])), " ");
        }
        return object;
    }
}

