/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.e;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.i;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.util.GMSSRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Integers;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import java.util.Vector;

public class Treehash {
    private int maxHeight;
    private Vector tailStack;
    private Vector heightOfNodes;
    private byte[] firstNode;
    private byte[] seedActive;
    private byte[] seedNext;
    private int tailLength;
    private int firstNodeHeight;
    private boolean isInitialized;
    private boolean isFinished;
    private boolean seedInitialized;
    private Digest messDigestTree;

    public Treehash(Digest object, byte[][] byArray, int[] nArray) {
        int n;
        Vector vector;
        this.messDigestTree = object;
        this.maxHeight = nArray[0];
        this.tailLength = nArray[1];
        this.firstNodeHeight = nArray[2];
        this.isFinished = nArray[3] == 1;
        this.isInitialized = nArray[4] == 1;
        this.seedInitialized = nArray[5] == 1;
        object = vector;
        vector = new Vector();
        this.heightOfNodes = object;
        for (n = 0; n < this.tailLength; ++n) {
            this.heightOfNodes.addElement(Integers.valueOf(nArray[n + 6]));
        }
        Treehash treehash = this;
        this.firstNode = byArray[0];
        this.seedActive = byArray[1];
        treehash.seedNext = byArray[2];
        treehash.tailStack = new Vector();
        for (n = 0; n < this.tailLength; ++n) {
            this.tailStack.addElement(byArray[n + 3]);
        }
    }

    public Treehash(Vector vector, int n, Digest digest) {
        Treehash treehash = this;
        this.tailStack = vector;
        treehash.maxHeight = n;
        treehash.firstNode = null;
        treehash.isInitialized = false;
        treehash.isFinished = false;
        treehash.seedInitialized = false;
        this.messDigestTree = digest;
        this.seedNext = new byte[digest.getDigestSize()];
        this.seedActive = new byte[this.messDigestTree.getDigestSize()];
    }

    public void initializeSeed(byte[] byArray) {
        Treehash treehash = object;
        Treehash treehash2 = object;
        Object object = treehash2.seedNext;
        int n = treehash2.messDigestTree.getDigestSize();
        System.arraycopy(byArray, 0, object, 0, n);
        treehash.seedInitialized = true;
    }

    public void initialize() {
        if (((Treehash)object).seedInitialized) {
            Treehash treehash;
            ((Treehash)object).heightOfNodes = new Vector();
            ((Treehash)object).tailLength = 0;
            ((Treehash)object).firstNode = null;
            ((Treehash)object).firstNodeHeight = -1;
            ((Treehash)object).isInitialized = true;
            Treehash treehash2 = object;
            Object object = treehash2.seedActive;
            int n = treehash2.messDigestTree.getDigestSize();
            System.arraycopy(treehash.seedNext, 0, object, 0, n);
            return;
        }
        throw new IllegalStateException(b.a(a.a("Seed "), ((Treehash)object).maxHeight, " not initialized"));
    }

    public void update(GMSSRandom gMSSRandom, byte[] byArray) {
        if (this.isFinished) {
            System.err.println("No more update possible for treehash instance!");
            return;
        }
        if (!this.isInitialized) {
            System.err.println("Treehash instance not initialized before update");
            return;
        }
        Treehash treehash = this;
        byte[] cfr_ignored_0 = new byte[treehash.messDigestTree.getDigestSize()];
        gMSSRandom.nextSeed(treehash.seedActive);
        if (this.firstNode == null) {
            Treehash treehash2 = this;
            treehash2.firstNode = byArray;
            treehash2.firstNodeHeight = 0;
        } else {
            int n;
            int n2 = 0;
            while (this.tailLength > 0 && n2 == (Integer)this.heightOfNodes.lastElement()) {
                Treehash treehash3 = this;
                Treehash treehash4 = this;
                int n3 = treehash4.messDigestTree.getDigestSize() << 1;
                byte[] byArray2 = new byte[n3];
                n = this.messDigestTree.getDigestSize();
                System.arraycopy(treehash4.tailStack.lastElement(), 0, byArray2, 0, n);
                Vector vector = treehash4.tailStack;
                vector.removeElementAt(vector.size() - 1);
                Vector vector2 = treehash4.heightOfNodes;
                vector2.removeElementAt(vector2.size() - 1);
                n = treehash4.messDigestTree.getDigestSize();
                int n4 = treehash4.messDigestTree.getDigestSize();
                System.arraycopy(byArray, 0, byArray2, n, n4);
                treehash3.messDigestTree.update(byArray2, 0, n3);
                byArray = new byte[treehash3.messDigestTree.getDigestSize()];
                treehash3.messDigestTree.doFinal(byArray, 0);
                ++n2;
                --treehash3.tailLength;
            }
            Treehash treehash5 = this;
            treehash5.tailStack.addElement(byArray);
            treehash5.heightOfNodes.addElement(Integers.valueOf(n2));
            ++treehash5.tailLength;
            if ((Integer)treehash5.heightOfNodes.lastElement() == this.firstNodeHeight) {
                Treehash treehash6 = this;
                n2 = treehash6.messDigestTree.getDigestSize() << 1;
                byArray = new byte[n2];
                int n5 = this.messDigestTree.getDigestSize();
                System.arraycopy(treehash6.firstNode, 0, byArray, 0, n5);
                Treehash treehash7 = this;
                n5 = treehash7.messDigestTree.getDigestSize();
                n = treehash7.messDigestTree.getDigestSize();
                System.arraycopy(treehash6.tailStack.lastElement(), 0, byArray, n5, n);
                Vector vector = treehash6.tailStack;
                vector.removeElementAt(vector.size() - 1);
                Vector vector3 = treehash6.heightOfNodes;
                vector3.removeElementAt(vector3.size() - 1);
                treehash6.messDigestTree.update(byArray, 0, n2);
                byte[] byArray3 = new byte[treehash6.messDigestTree.getDigestSize()];
                treehash6.firstNode = byArray3;
                treehash6.messDigestTree.doFinal(byArray3, 0);
                ++treehash6.firstNodeHeight;
                treehash6.tailLength = 0;
            }
        }
        if (this.firstNodeHeight == this.maxHeight) {
            this.isFinished = true;
        }
    }

    public void destroy() {
        Treehash treehash = this;
        treehash.isInitialized = false;
        treehash.isFinished = false;
        treehash.firstNode = null;
        treehash.tailLength = 0;
        treehash.firstNodeHeight = -1;
    }

    public int getLowestNodeHeight() {
        if (this.firstNode == null) {
            return this.maxHeight;
        }
        if (this.tailLength == 0) {
            return this.firstNodeHeight;
        }
        return Math.min(this.firstNodeHeight, (Integer)this.heightOfNodes.lastElement());
    }

    public int getFirstNodeHeight() {
        if (this.firstNode == null) {
            return this.maxHeight;
        }
        return this.firstNodeHeight;
    }

    public boolean wasInitialized() {
        return this.isInitialized;
    }

    public boolean wasFinished() {
        return this.isFinished;
    }

    public byte[] getFirstNode() {
        return this.firstNode;
    }

    public byte[] getSeedActive() {
        return this.seedActive;
    }

    public void setFirstNode(byte[] byArray) {
        if (!this.isInitialized) {
            this.initialize();
        }
        this.firstNode = byArray;
        this.firstNodeHeight = this.maxHeight;
        this.isFinished = true;
    }

    public void updateNextSeed(GMSSRandom gMSSRandom) {
        gMSSRandom.nextSeed(this.seedNext);
    }

    public Vector getTailStack() {
        return this.tailStack;
    }

    public byte[][] getStatByte() {
        byte[][] byArray = new byte[this.tailLength + 3][this.messDigestTree.getDigestSize()];
        byte[][] byArray2 = byArray;
        byArray2[0] = this.firstNode;
        byArray2[1] = this.seedActive;
        byArray[2] = this.seedNext;
        for (int k = 0; k < this.tailLength; ++k) {
            byArray2[k + 3] = (byte[])this.tailStack.elementAt(k);
        }
        return byArray2;
    }

    public int[] getStatInt() {
        Treehash treehash = this;
        int n = treehash.tailLength;
        int[] nArray = new int[n + 6];
        int[] nArray2 = nArray;
        nArray2[0] = this.maxHeight;
        nArray2[1] = n;
        nArray[2] = this.firstNodeHeight;
        nArray2[3] = treehash.isFinished ? 1 : 0;
        nArray2[4] = this.isInitialized ? 1 : 0;
        nArray2[5] = this.seedInitialized ? 1 : 0;
        for (n = 0; n < this.tailLength; ++n) {
            nArray2[n + 6] = (Integer)this.heightOfNodes.elementAt(n);
        }
        return nArray2;
    }

    public String toString() {
        int n;
        String string = "Treehash    : ";
        for (n = 0; n < this.tailLength + 6; ++n) {
            string = b.a(a.a(string), this.getStatInt()[n], " ");
        }
        for (n = 0; n < this.tailLength + 3; ++n) {
            string = this.getStatByte()[n] != null ? d.a.a(a.a(string), new String(Hex.encode(this.getStatByte()[n])), " ") : i.a(string, "null ");
        }
        return e.a(string, "  ").append(this.messDigestTree.getDigestSize()).toString();
    }
}

