/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.Composer;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.HSSSignature;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMS;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSContext;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSContextBasedVerifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSSignature;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSSignedPubKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.io.Streams;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class HSSPublicKeyParameters
extends LMSKeyParameters
implements LMSContextBasedVerifier {
    private final int l;
    private final LMSPublicKeyParameters lmsPublicKey;

    public HSSPublicKeyParameters(int n, LMSPublicKeyParameters lMSPublicKeyParameters) {
        super(false);
        this.l = n;
        this.lmsPublicKey = lMSPublicKeyParameters;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HSSPublicKeyParameters getInstance(Object object) {
        if (object instanceof HSSPublicKeyParameters) {
            return (HSSPublicKeyParameters)object;
        }
        if (object instanceof DataInputStream) {
            Object object2 = object;
            int n = ((DataInputStream)object2).readInt();
            LMSPublicKeyParameters lMSPublicKeyParameters = LMSPublicKeyParameters.getInstance(object2);
            return new HSSPublicKeyParameters(n, lMSPublicKeyParameters);
        }
        if (object instanceof byte[]) {
            void var0_4;
            InputStream inputStream;
            block10: {
                HSSPublicKeyParameters hSSPublicKeyParameters;
                DataInputStream dataInputStream;
                inputStream = null;
                DataInputStream dataInputStream2 = dataInputStream;
                try {
                    dataInputStream = new DataInputStream(new ByteArrayInputStream((byte[])object));
                }
                catch (Throwable throwable) {
                    // empty catch block
                    break block10;
                }
                try {
                    hSSPublicKeyParameters = HSSPublicKeyParameters.getInstance(dataInputStream);
                }
                catch (Throwable throwable) {
                    inputStream = dataInputStream2;
                    break block10;
                }
                ((InputStream)dataInputStream2).close();
                return hSSPublicKeyParameters;
            }
            if (inputStream != null) {
                inputStream.close();
            }
            throw var0_4;
        }
        if (object instanceof InputStream) {
            return HSSPublicKeyParameters.getInstance(Streams.readAll((InputStream)object));
        }
        throw new IllegalArgumentException("cannot parse " + object);
    }

    public int getL() {
        return this.l;
    }

    public LMSPublicKeyParameters getLMSPublicKey() {
        return this.lmsPublicKey;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            object = (HSSPublicKeyParameters)object;
            if (this.l != ((HSSPublicKeyParameters)object).l) {
                return false;
            }
            return this.lmsPublicKey.equals(((HSSPublicKeyParameters)object).lmsPublicKey);
        }
        return false;
    }

    public int hashCode() {
        HSSPublicKeyParameters hSSPublicKeyParameters = this;
        int n = hSSPublicKeyParameters.l * 31;
        return hSSPublicKeyParameters.lmsPublicKey.hashCode() + n;
    }

    @Override
    public byte[] getEncoded() {
        return Composer.compose().u32str(this.l).bytes(this.lmsPublicKey.getEncoded()).build();
    }

    @Override
    public LMSContext generateLMSContext(byte[] objectArray) {
        LMSSignedPubKey[] lMSSignedPubKeyArray;
        try {
            Encodable encodable = HSSSignature.getInstance(objectArray, ((HSSPublicKeyParameters)encodable).getL());
            lMSSignedPubKeyArray = ((HSSSignature)encodable).getSignedPubKey();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(b.a(iOException, a.a("cannot parse signature: ")));
        }
        objectArray = lMSSignedPubKeyArray;
        return lMSSignedPubKeyArray[lMSSignedPubKeyArray.length - 1].getPublicKey().generateOtsContext(((HSSSignature)encodable).getSignature()).withSignedPublicKeys((LMSSignedPubKey[])objectArray);
    }

    @Override
    public boolean verify(LMSContext lMSContext) {
        boolean bl = false;
        LMSSignedPubKey[] lMSSignedPubKeyArray = lMSContext.getSignedPubKeys();
        if (lMSSignedPubKeyArray.length != encodable.getL() - 1) {
            return false;
        }
        Encodable encodable = encodable.getLMSPublicKey();
        for (int k = 0; k < lMSSignedPubKeyArray.length; ++k) {
            if (!LMS.verifySignature((LMSPublicKeyParameters)encodable, (LMSSignature)(encodable = lMSSignedPubKeyArray[k].getSignature()), lMSSignedPubKeyArray[k].getPublicKey().toByteArray())) {
                boolean bl2;
                bl = bl2 = true;
            }
            encodable = lMSSignedPubKeyArray[k].getPublicKey();
        }
        return (bl ^ true) & ((LMSPublicKeyParameters)encodable).verify(lMSContext);
    }
}

