/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.Composer;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMOtsParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMOtsPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMS;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSContext;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSContextBasedVerifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSSignature;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSigParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.io.Streams;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LMSPublicKeyParameters
extends LMSKeyParameters
implements LMSContextBasedVerifier {
    private final LMSigParameters parameterSet;
    private final LMOtsParameters lmOtsType;
    private final byte[] I;
    private final byte[] T1;

    public LMSPublicKeyParameters(LMSigParameters lMSigParameters, LMOtsParameters lMOtsParameters, byte[] byArray, byte[] byArray2) {
        super(false);
        this.parameterSet = lMSigParameters;
        this.lmOtsType = lMOtsParameters;
        this.I = Arrays.clone(byArray2);
        this.T1 = Arrays.clone(byArray);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LMSPublicKeyParameters getInstance(Object object) {
        if (object instanceof LMSPublicKeyParameters) {
            return (LMSPublicKeyParameters)object;
        }
        if (object instanceof DataInputStream) {
            DataInputStream dataInputStream = (DataInputStream)object;
            object = LMSigParameters.getParametersForType(dataInputStream.readInt());
            LMOtsParameters lMOtsParameters = LMOtsParameters.getParametersForType(dataInputStream.readInt());
            byte[] byArray = new byte[16];
            dataInputStream.readFully(byArray);
            byte[] byArray2 = new byte[((LMSigParameters)object).getM()];
            dataInputStream.readFully(byArray2);
            return new LMSPublicKeyParameters((LMSigParameters)object, lMOtsParameters, byArray2, byArray);
        }
        if (object instanceof byte[]) {
            void var0_3;
            InputStream inputStream;
            block10: {
                LMSPublicKeyParameters lMSPublicKeyParameters;
                DataInputStream dataInputStream;
                inputStream = null;
                DataInputStream dataInputStream2 = dataInputStream;
                try {
                    dataInputStream = new DataInputStream(new ByteArrayInputStream((byte[])object));
                }
                catch (Throwable throwable) {
                    // empty catch block
                    break block10;
                }
                try {
                    lMSPublicKeyParameters = LMSPublicKeyParameters.getInstance(dataInputStream);
                }
                catch (Throwable throwable) {
                    inputStream = dataInputStream2;
                    break block10;
                }
                ((InputStream)dataInputStream2).close();
                return lMSPublicKeyParameters;
            }
            if (inputStream != null) {
                inputStream.close();
            }
            throw var0_3;
        }
        if (object instanceof InputStream) {
            return LMSPublicKeyParameters.getInstance(Streams.readAll((InputStream)object));
        }
        throw new IllegalArgumentException("cannot parse " + object);
    }

    @Override
    public byte[] getEncoded() {
        return this.toByteArray();
    }

    public LMSigParameters getSigParameters() {
        return this.parameterSet;
    }

    public LMOtsParameters getOtsParameters() {
        return this.lmOtsType;
    }

    public LMSParameters getLMSParameters() {
        LMSPublicKeyParameters lMSPublicKeyParameters = lMSigParameters;
        LMSigParameters lMSigParameters = lMSPublicKeyParameters.getSigParameters();
        return new LMSParameters(lMSigParameters, lMSPublicKeyParameters.getOtsParameters());
    }

    public byte[] getT1() {
        return Arrays.clone(this.T1);
    }

    public boolean matchesT1(byte[] byArray) {
        return Arrays.constantTimeAreEqual(this.T1, byArray);
    }

    public byte[] getI() {
        return Arrays.clone(this.I);
    }

    public byte[] refI() {
        return this.I;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            object = (LMSPublicKeyParameters)object;
            if (!this.parameterSet.equals(((LMSPublicKeyParameters)object).parameterSet)) {
                return false;
            }
            if (!this.lmOtsType.equals(((LMSPublicKeyParameters)object).lmOtsType)) {
                return false;
            }
            if (!Arrays.areEqual(this.I, ((LMSPublicKeyParameters)object).I)) {
                return false;
            }
            return Arrays.areEqual(this.T1, ((LMSPublicKeyParameters)object).T1);
        }
        return false;
    }

    public int hashCode() {
        LMSPublicKeyParameters lMSPublicKeyParameters = this;
        int n = lMSPublicKeyParameters.parameterSet.hashCode() * 31;
        n = (lMSPublicKeyParameters.lmOtsType.hashCode() + n) * 31;
        n = (Arrays.hashCode(lMSPublicKeyParameters.I) + n) * 31;
        return Arrays.hashCode(lMSPublicKeyParameters.T1) + n;
    }

    public byte[] toByteArray() {
        return Composer.compose().u32str(this.parameterSet.getType()).u32str(this.lmOtsType.getType()).bytes(this.I).bytes(this.T1).build();
    }

    @Override
    public LMSContext generateLMSContext(byte[] byArray) {
        try {
            return this.generateOtsContext(LMSSignature.getInstance(byArray));
        }
        catch (IOException iOException) {
            throw new IllegalStateException(b.a(iOException, a.a("cannot parse signature: ")));
        }
    }

    public LMSContext generateOtsContext(LMSSignature object) {
        int n = ((LMSPublicKeyParameters)((Object)lMOtsParameters)).getOtsParameters().getType();
        if (((LMSSignature)object).getOtsSignature().getType().getType() == n) {
            LMSSignature lMSSignature = object;
            LMSPublicKeyParameters lMSPublicKeyParameters = lMOtsParameters;
            LMOtsParameters lMOtsParameters = LMOtsParameters.getParametersForType(n);
            object = lMSPublicKeyParameters.I;
            n = lMSSignature.getQ();
            return new LMOtsPublicKey(lMOtsParameters, (byte[])object, n, null).createOtsContext((LMSSignature)object);
        }
        throw new IllegalArgumentException("ots type from lsm signature does not match ots signature type from embedded ots signature");
    }

    @Override
    public boolean verify(LMSContext lMSContext) {
        return LMS.verifySignature(this, lMSContext);
    }
}

