/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.ntru;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import java.nio.ByteBuffer;

public class NTRUSignerPrng {
    private int counter = 0;
    private byte[] seed;
    private Digest hashAlg;

    public NTRUSignerPrng(byte[] byArray, Digest digest) {
        this.seed = byArray;
        this.hashAlg = digest;
    }

    public byte[] nextBytes(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        while (byteBuffer.hasRemaining()) {
            NTRUSignerPrng nTRUSignerPrng = this;
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(nTRUSignerPrng.seed.length + 4);
            byteBuffer2.put(this.seed);
            byteBuffer2.putInt(this.counter);
            byte[] byArray = byteBuffer2.array();
            int n2 = nTRUSignerPrng.hashAlg.getDigestSize();
            byte[] byArray2 = new byte[n2];
            nTRUSignerPrng.hashAlg.update(byArray, 0, byArray.length);
            nTRUSignerPrng.hashAlg.doFinal(byArray2, 0);
            if (byteBuffer.remaining() < n2) {
                ByteBuffer byteBuffer3 = byteBuffer;
                int n3 = byteBuffer3.remaining();
                byteBuffer3.put(byArray2, 0, n3);
            } else {
                byteBuffer.put(byArray2);
            }
            ++this.counter;
        }
        return byteBuffer.array();
    }
}

