/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.ntru;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.KeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.EncodableDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHA256Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHA512Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.ntru.NTRUSigningParameters;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;

public class NTRUSigningKeyGenerationParameters
extends KeyGenerationParameters
implements Cloneable {
    public static final int BASIS_TYPE_STANDARD = 0;
    public static final int BASIS_TYPE_TRANSPOSE = 1;
    public static final int KEY_GEN_ALG_RESULTANT = 0;
    public static final int KEY_GEN_ALG_FLOAT = 1;
    public static final NTRUSigningKeyGenerationParameters APR2011_439;
    public static final NTRUSigningKeyGenerationParameters APR2011_439_PROD;
    public static final NTRUSigningKeyGenerationParameters APR2011_743;
    public static final NTRUSigningKeyGenerationParameters APR2011_743_PROD;
    public static final NTRUSigningKeyGenerationParameters TEST157;
    public static final NTRUSigningKeyGenerationParameters TEST157_PROD;
    public int N;
    public int q;
    public int d;
    public int d1;
    public int d2;
    public int d3;
    public int B;
    public double beta;
    public double betaSq;
    public double normBound;
    public double normBoundSq;
    public int signFailTolerance = 100;
    public double keyNormBound;
    public double keyNormBoundSq;
    public boolean primeCheck;
    public int basisType;
    public int bitsF = 6;
    public boolean sparse;
    public int keyGenAlg;
    public Digest hashAlg;
    public int polyType;

    public NTRUSigningKeyGenerationParameters(int n, int n2, int n3, int n4, int n5, double d2, double d3, double d4, boolean bl, boolean bl2, int n6, Digest digest) {
        super(CryptoServicesRegistrar.getSecureRandom(), n);
        this.N = n;
        this.q = n2;
        this.d = n3;
        this.B = n4;
        this.basisType = n5;
        this.beta = d2;
        this.normBound = d3;
        this.keyNormBound = d4;
        this.primeCheck = bl;
        this.sparse = bl2;
        this.keyGenAlg = n6;
        this.hashAlg = digest;
        this.polyType = 0;
        this.init();
    }

    public NTRUSigningKeyGenerationParameters(int n, int n2, int n3, int n4, int n5, int n6, int n7, double d2, double d3, double d4, boolean bl, boolean bl2, int n8, Digest digest) {
        super(CryptoServicesRegistrar.getSecureRandom(), n);
        this.N = n;
        this.q = n2;
        this.d1 = n3;
        this.d2 = n4;
        this.d3 = n5;
        this.B = n6;
        this.basisType = n7;
        this.beta = d2;
        this.normBound = d3;
        this.keyNormBound = d4;
        this.primeCheck = bl;
        this.sparse = bl2;
        this.keyGenAlg = n8;
        this.hashAlg = digest;
        this.polyType = 1;
        this.init();
    }

    private void init() {
        NTRUSigningKeyGenerationParameters nTRUSigningKeyGenerationParameters = this;
        double d2 = nTRUSigningKeyGenerationParameters.beta;
        nTRUSigningKeyGenerationParameters.betaSq = d2 * d2;
        double d3 = nTRUSigningKeyGenerationParameters.normBound;
        nTRUSigningKeyGenerationParameters.normBoundSq = d3 * d3;
        double d4 = nTRUSigningKeyGenerationParameters.keyNormBound;
        nTRUSigningKeyGenerationParameters.keyNormBoundSq = d4 * d4;
    }

    public NTRUSigningKeyGenerationParameters(InputStream object) {
        super(CryptoServicesRegistrar.getSecureRandom(), 0);
        DataInputStream dataInputStream;
        DataInputStream dataInputStream2;
        DataInputStream dataInputStream3 = dataInputStream2 = dataInputStream;
        dataInputStream3((InputStream)object);
        this.N = dataInputStream3.readInt();
        this.q = dataInputStream2.readInt();
        this.d = dataInputStream2.readInt();
        this.d1 = dataInputStream2.readInt();
        this.d2 = dataInputStream2.readInt();
        this.d3 = dataInputStream2.readInt();
        this.B = dataInputStream2.readInt();
        this.basisType = dataInputStream2.readInt();
        this.beta = dataInputStream2.readDouble();
        this.normBound = dataInputStream2.readDouble();
        this.keyNormBound = dataInputStream2.readDouble();
        this.signFailTolerance = dataInputStream2.readInt();
        this.primeCheck = dataInputStream2.readBoolean();
        this.sparse = dataInputStream2.readBoolean();
        this.bitsF = dataInputStream2.readInt();
        this.keyGenAlg = ((InputStream)dataInputStream2).read();
        object = dataInputStream.readUTF();
        if ("SHA-512".equals(object)) {
            SHA512Digest sHA512Digest;
            object = sHA512Digest;
            sHA512Digest = new SHA512Digest();
            this.hashAlg = object;
        } else if ("SHA-256".equals(object)) {
            SHA256Digest sHA256Digest;
            object = sHA256Digest;
            sHA256Digest = new SHA256Digest();
            this.hashAlg = object;
        }
        this.polyType = ((InputStream)dataInputStream2).read();
        this.init();
    }

    static {
        SHA256Digest sHA256Digest;
        SHA256Digest sHA256Digest2;
        SHA512Digest sHA512Digest;
        SHA512Digest sHA512Digest2;
        SHA256Digest sHA256Digest3;
        SHA256Digest sHA256Digest4;
        EncodableDigest encodableDigest = sHA256Digest4;
        sHA256Digest4 = new SHA256Digest();
        APR2011_439 = new NTRUSigningKeyGenerationParameters(439, 2048, 146, 1, 1, 0.165, 490.0, 280.0, false, true, 0, (Digest)((Object)encodableDigest));
        encodableDigest = sHA256Digest3;
        sHA256Digest3 = new SHA256Digest();
        APR2011_439_PROD = new NTRUSigningKeyGenerationParameters(439, 2048, 9, 8, 5, 1, 1, 0.165, 490.0, 280.0, false, true, 0, (Digest)((Object)encodableDigest));
        encodableDigest = sHA512Digest2;
        sHA512Digest2 = new SHA512Digest();
        APR2011_743 = new NTRUSigningKeyGenerationParameters(743, 2048, 248, 1, 1, 0.127, 560.0, 360.0, true, false, 0, (Digest)((Object)encodableDigest));
        encodableDigest = sHA512Digest;
        sHA512Digest = new SHA512Digest();
        APR2011_743_PROD = new NTRUSigningKeyGenerationParameters(743, 2048, 11, 11, 15, 1, 1, 0.127, 560.0, 360.0, true, false, 0, (Digest)((Object)encodableDigest));
        encodableDigest = sHA256Digest2;
        sHA256Digest2 = new SHA256Digest();
        TEST157 = new NTRUSigningKeyGenerationParameters(157, 256, 29, 1, 1, 0.38, 200.0, 80.0, false, false, 0, (Digest)((Object)encodableDigest));
        encodableDigest = sHA256Digest;
        sHA256Digest = new SHA256Digest();
        TEST157_PROD = new NTRUSigningKeyGenerationParameters(157, 256, 5, 5, 8, 1, 1, 0.38, 200.0, 80.0, false, false, 0, (Digest)((Object)encodableDigest));
    }

    public void writeTo(OutputStream outputStream) {
        DataOutputStream dataOutputStream;
        DataOutputStream dataOutputStream2 = dataOutputStream;
        dataOutputStream2(outputStream);
        dataOutputStream2.writeInt(this.N);
        dataOutputStream2.writeInt(this.q);
        dataOutputStream2.writeInt(this.d);
        dataOutputStream2.writeInt(this.d1);
        dataOutputStream2.writeInt(this.d2);
        dataOutputStream2.writeInt(this.d3);
        dataOutputStream2.writeInt(this.B);
        dataOutputStream2.writeInt(this.basisType);
        dataOutputStream2.writeDouble(this.beta);
        dataOutputStream2.writeDouble(this.normBound);
        dataOutputStream2.writeDouble(this.keyNormBound);
        dataOutputStream2.writeInt(this.signFailTolerance);
        dataOutputStream2.writeBoolean(this.primeCheck);
        dataOutputStream2.writeBoolean(this.sparse);
        dataOutputStream2.writeInt(this.bitsF);
        dataOutputStream2.write(this.keyGenAlg);
        dataOutputStream2.writeUTF(this.hashAlg.getAlgorithmName());
        dataOutputStream.write(this.polyType);
    }

    public NTRUSigningParameters getSigningParameters() {
        NTRUSigningKeyGenerationParameters nTRUSigningKeyGenerationParameters = this;
        int n = nTRUSigningKeyGenerationParameters.N;
        int n2 = nTRUSigningKeyGenerationParameters.q;
        int n3 = nTRUSigningKeyGenerationParameters.d;
        int n4 = nTRUSigningKeyGenerationParameters.B;
        double d2 = nTRUSigningKeyGenerationParameters.beta;
        double d3 = nTRUSigningKeyGenerationParameters.normBound;
        Digest digest = nTRUSigningKeyGenerationParameters.hashAlg;
        return new NTRUSigningParameters(n, n2, n3, n4, d2, d3, digest);
    }

    public NTRUSigningKeyGenerationParameters clone() {
        if (this.polyType == 0) {
            NTRUSigningKeyGenerationParameters nTRUSigningKeyGenerationParameters = this;
            int n = nTRUSigningKeyGenerationParameters.N;
            int n2 = nTRUSigningKeyGenerationParameters.q;
            int n3 = nTRUSigningKeyGenerationParameters.d;
            int n4 = nTRUSigningKeyGenerationParameters.B;
            int n5 = nTRUSigningKeyGenerationParameters.basisType;
            double d2 = nTRUSigningKeyGenerationParameters.beta;
            double d3 = nTRUSigningKeyGenerationParameters.normBound;
            double d4 = nTRUSigningKeyGenerationParameters.keyNormBound;
            boolean bl = nTRUSigningKeyGenerationParameters.primeCheck;
            boolean bl2 = nTRUSigningKeyGenerationParameters.sparse;
            int n6 = nTRUSigningKeyGenerationParameters.keyGenAlg;
            Digest digest = nTRUSigningKeyGenerationParameters.hashAlg;
            return new NTRUSigningKeyGenerationParameters(n, n2, n3, n4, n5, d2, d3, d4, bl, bl2, n6, digest);
        }
        NTRUSigningKeyGenerationParameters nTRUSigningKeyGenerationParameters = this;
        int n = nTRUSigningKeyGenerationParameters.N;
        int n7 = nTRUSigningKeyGenerationParameters.q;
        int n8 = nTRUSigningKeyGenerationParameters.d1;
        int n9 = nTRUSigningKeyGenerationParameters.d2;
        int n10 = nTRUSigningKeyGenerationParameters.d3;
        int n11 = nTRUSigningKeyGenerationParameters.B;
        int n12 = nTRUSigningKeyGenerationParameters.basisType;
        double d5 = nTRUSigningKeyGenerationParameters.beta;
        double d6 = nTRUSigningKeyGenerationParameters.normBound;
        double d7 = nTRUSigningKeyGenerationParameters.keyNormBound;
        boolean bl = nTRUSigningKeyGenerationParameters.primeCheck;
        boolean bl3 = nTRUSigningKeyGenerationParameters.sparse;
        int n13 = nTRUSigningKeyGenerationParameters.keyGenAlg;
        Digest digest = nTRUSigningKeyGenerationParameters.hashAlg;
        return new NTRUSigningKeyGenerationParameters(n, n7, n8, n9, n10, n11, n12, d5, d6, d7, bl, bl3, n13, digest);
    }

    public int hashCode() {
        long l;
        long l2;
        NTRUSigningKeyGenerationParameters nTRUSigningKeyGenerationParameters = this;
        long l3 = l2 = Double.doubleToLongBits(this.beta);
        long l4 = l2 = Double.doubleToLongBits(this.betaSq);
        int n = ((((((((((31 + nTRUSigningKeyGenerationParameters.B) * 31 + this.N) * 31 + this.basisType) * 31 + (int)(l3 ^ l3 >>> 32)) * 31 + (int)(l4 ^ l4 >>> 32)) * 31 + this.bitsF) * 31 + this.d) * 31 + this.d1) * 31 + this.d2) * 31 + this.d3) * 31;
        Digest digest = nTRUSigningKeyGenerationParameters.hashAlg;
        int n2 = digest == null ? 0 : digest.getAlgorithmName().hashCode();
        long l5 = l = Double.doubleToLongBits(this.keyNormBound);
        long l6 = l = Double.doubleToLongBits(this.keyNormBoundSq);
        long l7 = l = Double.doubleToLongBits(this.normBound);
        long l8 = l = Double.doubleToLongBits(this.normBoundSq);
        int n3 = (((((((n + n2) * 31 + this.keyGenAlg) * 31 + (int)(l5 ^ l5 >>> 32)) * 31 + (int)(l6 ^ l6 >>> 32)) * 31 + (int)(l7 ^ l7 >>> 32)) * 31 + (int)(l8 ^ l8 >>> 32)) * 31 + this.polyType) * 31;
        n2 = this.primeCheck ? 1231 : 1237;
        int n4 = (((n3 + n2) * 31 + this.q) * 31 + this.signFailTolerance) * 31;
        n3 = this.sparse ? 1231 : 1237;
        return n4 + n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof NTRUSigningKeyGenerationParameters)) {
            return false;
        }
        object = (NTRUSigningKeyGenerationParameters)object;
        if (this.B != ((NTRUSigningKeyGenerationParameters)object).B) {
            return false;
        }
        if (this.N != ((NTRUSigningKeyGenerationParameters)object).N) {
            return false;
        }
        if (this.basisType != ((NTRUSigningKeyGenerationParameters)object).basisType) {
            return false;
        }
        if (Double.doubleToLongBits(this.beta) != Double.doubleToLongBits(((NTRUSigningKeyGenerationParameters)object).beta)) {
            return false;
        }
        if (Double.doubleToLongBits(this.betaSq) != Double.doubleToLongBits(((NTRUSigningKeyGenerationParameters)object).betaSq)) {
            return false;
        }
        if (this.bitsF != ((NTRUSigningKeyGenerationParameters)object).bitsF) {
            return false;
        }
        if (this.d != ((NTRUSigningKeyGenerationParameters)object).d) {
            return false;
        }
        if (this.d1 != ((NTRUSigningKeyGenerationParameters)object).d1) {
            return false;
        }
        if (this.d2 != ((NTRUSigningKeyGenerationParameters)object).d2) {
            return false;
        }
        if (this.d3 != ((NTRUSigningKeyGenerationParameters)object).d3) {
            return false;
        }
        Digest digest = this.hashAlg;
        if (digest == null ? ((NTRUSigningKeyGenerationParameters)object).hashAlg != null : !digest.getAlgorithmName().equals(((NTRUSigningKeyGenerationParameters)object).hashAlg.getAlgorithmName())) {
            return false;
        }
        if (this.keyGenAlg != ((NTRUSigningKeyGenerationParameters)object).keyGenAlg) {
            return false;
        }
        if (Double.doubleToLongBits(this.keyNormBound) != Double.doubleToLongBits(((NTRUSigningKeyGenerationParameters)object).keyNormBound)) {
            return false;
        }
        if (Double.doubleToLongBits(this.keyNormBoundSq) != Double.doubleToLongBits(((NTRUSigningKeyGenerationParameters)object).keyNormBoundSq)) {
            return false;
        }
        if (Double.doubleToLongBits(this.normBound) != Double.doubleToLongBits(((NTRUSigningKeyGenerationParameters)object).normBound)) {
            return false;
        }
        if (Double.doubleToLongBits(this.normBoundSq) != Double.doubleToLongBits(((NTRUSigningKeyGenerationParameters)object).normBoundSq)) {
            return false;
        }
        if (this.polyType != ((NTRUSigningKeyGenerationParameters)object).polyType) {
            return false;
        }
        if (this.primeCheck != ((NTRUSigningKeyGenerationParameters)object).primeCheck) {
            return false;
        }
        if (this.q != ((NTRUSigningKeyGenerationParameters)object).q) {
            return false;
        }
        if (this.signFailTolerance != ((NTRUSigningKeyGenerationParameters)object).signFailTolerance) {
            return false;
        }
        return this.sparse == ((NTRUSigningKeyGenerationParameters)object).sparse;
    }

    public String toString() {
        StringBuilder stringBuilder;
        DecimalFormat decimalFormat;
        DecimalFormat decimalFormat2 = decimalFormat;
        decimalFormat = new DecimalFormat("0.00");
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(a.a("SignatureParameters(N=").append(this.N).append(" q=").append(this.q).toString());
        if (this.polyType == 0) {
            stringBuilder2.append(a.a(" polyType=SIMPLE d=").append(this.d).toString());
        } else {
            stringBuilder2.append(a.a(" polyType=PRODUCT d1=").append(this.d1).append(" d2=").append(this.d2).append(" d3=").append(this.d3).toString());
        }
        StringBuilder stringBuilder3 = stringBuilder2;
        stringBuilder3.append(a.a(" B=").append(this.B).append(" basisType=").append(this.basisType).append(" beta=").append(decimalFormat2.format(this.beta)).append(" normBound=").append(decimalFormat2.format(this.normBound)).append(" keyNormBound=").append(decimalFormat2.format(this.keyNormBound)).append(" prime=").append(this.primeCheck).append(" sparse=").append(this.sparse).append(" keyGenAlg=").append(this.keyGenAlg).append(" hashAlg=").append(this.hashAlg).append(")").toString());
        return stringBuilder3.toString();
    }
}

