/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.ntru;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHA256Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHA512Digest;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;

public class NTRUSigningParameters
implements Cloneable {
    public int N;
    public int q;
    public int d;
    public int d1;
    public int d2;
    public int d3;
    public int B;
    public double beta;
    public double betaSq;
    public double normBound;
    public double normBoundSq;
    public int signFailTolerance;
    public int bitsF;
    public Digest hashAlg;

    public NTRUSigningParameters(int n, int n2, int n3, int n4, double d2, double d3, Digest digest) {
        NTRUSigningParameters nTRUSigningParameters = this;
        nTRUSigningParameters.signFailTolerance = 100;
        nTRUSigningParameters.bitsF = 6;
        nTRUSigningParameters.N = n;
        nTRUSigningParameters.q = n2;
        nTRUSigningParameters.d = n3;
        nTRUSigningParameters.B = n4;
        nTRUSigningParameters.beta = d2;
        nTRUSigningParameters.normBound = d3;
        nTRUSigningParameters.hashAlg = digest;
        nTRUSigningParameters.init();
    }

    public NTRUSigningParameters(int n, int n2, int n3, int n4, int n5, int n6, double d2, double d3, double d4, Digest digest) {
        NTRUSigningParameters nTRUSigningParameters = this;
        nTRUSigningParameters.signFailTolerance = 100;
        nTRUSigningParameters.bitsF = 6;
        nTRUSigningParameters.N = n;
        nTRUSigningParameters.q = n2;
        nTRUSigningParameters.d1 = n3;
        nTRUSigningParameters.d2 = n4;
        nTRUSigningParameters.d3 = n5;
        nTRUSigningParameters.B = n6;
        nTRUSigningParameters.beta = d2;
        nTRUSigningParameters.normBound = d3;
        nTRUSigningParameters.hashAlg = digest;
        nTRUSigningParameters.init();
    }

    private void init() {
        NTRUSigningParameters nTRUSigningParameters = this;
        double d2 = nTRUSigningParameters.beta;
        nTRUSigningParameters.betaSq = d2 * d2;
        double d3 = nTRUSigningParameters.normBound;
        nTRUSigningParameters.normBoundSq = d3 * d3;
    }

    public NTRUSigningParameters(InputStream object) {
        DataInputStream dataInputStream;
        DataInputStream dataInputStream2;
        this.signFailTolerance = 100;
        this.bitsF = 6;
        DataInputStream dataInputStream3 = dataInputStream2 = dataInputStream;
        dataInputStream3((InputStream)object);
        this.N = dataInputStream3.readInt();
        this.q = dataInputStream2.readInt();
        this.d = dataInputStream2.readInt();
        this.d1 = dataInputStream2.readInt();
        this.d2 = dataInputStream2.readInt();
        this.d3 = dataInputStream2.readInt();
        this.B = dataInputStream2.readInt();
        this.beta = dataInputStream2.readDouble();
        this.normBound = dataInputStream2.readDouble();
        this.signFailTolerance = dataInputStream2.readInt();
        this.bitsF = dataInputStream2.readInt();
        object = dataInputStream.readUTF();
        if ("SHA-512".equals(object)) {
            SHA512Digest sHA512Digest;
            object = sHA512Digest;
            sHA512Digest = new SHA512Digest();
            this.hashAlg = object;
        } else if ("SHA-256".equals(object)) {
            SHA256Digest sHA256Digest;
            object = sHA256Digest;
            sHA256Digest = new SHA256Digest();
            this.hashAlg = object;
        }
        this.init();
    }

    public void writeTo(OutputStream outputStream) {
        DataOutputStream dataOutputStream;
        DataOutputStream dataOutputStream2 = dataOutputStream;
        dataOutputStream2(outputStream);
        dataOutputStream2.writeInt(this.N);
        dataOutputStream2.writeInt(this.q);
        dataOutputStream2.writeInt(this.d);
        dataOutputStream2.writeInt(this.d1);
        dataOutputStream2.writeInt(this.d2);
        dataOutputStream2.writeInt(this.d3);
        dataOutputStream2.writeInt(this.B);
        dataOutputStream2.writeDouble(this.beta);
        dataOutputStream2.writeDouble(this.normBound);
        dataOutputStream2.writeInt(this.signFailTolerance);
        dataOutputStream2.writeInt(this.bitsF);
        dataOutputStream.writeUTF(this.hashAlg.getAlgorithmName());
    }

    public NTRUSigningParameters clone() {
        NTRUSigningParameters nTRUSigningParameters = this;
        int n = nTRUSigningParameters.N;
        int n2 = nTRUSigningParameters.q;
        int n3 = nTRUSigningParameters.d;
        int n4 = nTRUSigningParameters.B;
        double d2 = nTRUSigningParameters.beta;
        double d3 = nTRUSigningParameters.normBound;
        Digest digest = nTRUSigningParameters.hashAlg;
        return new NTRUSigningParameters(n, n2, n3, n4, d2, d3, digest);
    }

    public int hashCode() {
        long l;
        long l2;
        NTRUSigningParameters nTRUSigningParameters = this;
        long l3 = l2 = Double.doubleToLongBits(this.beta);
        long l4 = l2 = Double.doubleToLongBits(this.betaSq);
        int n = (((((((((31 + nTRUSigningParameters.B) * 31 + this.N) * 31 + (int)(l3 ^ l3 >>> 32)) * 31 + (int)(l4 ^ l4 >>> 32)) * 31 + this.bitsF) * 31 + this.d) * 31 + this.d1) * 31 + this.d2) * 31 + this.d3) * 31;
        Digest digest = nTRUSigningParameters.hashAlg;
        int n2 = digest == null ? 0 : digest.getAlgorithmName().hashCode();
        long l5 = l = Double.doubleToLongBits(this.normBound);
        long l6 = l = Double.doubleToLongBits(this.normBoundSq);
        return ((((n + n2) * 31 + (int)(l5 ^ l5 >>> 32)) * 31 + (int)(l6 ^ l6 >>> 32)) * 31 + this.q) * 31 + this.signFailTolerance;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof NTRUSigningParameters)) {
            return false;
        }
        object = (NTRUSigningParameters)object;
        if (this.B != ((NTRUSigningParameters)object).B) {
            return false;
        }
        if (this.N != ((NTRUSigningParameters)object).N) {
            return false;
        }
        if (Double.doubleToLongBits(this.beta) != Double.doubleToLongBits(((NTRUSigningParameters)object).beta)) {
            return false;
        }
        if (Double.doubleToLongBits(this.betaSq) != Double.doubleToLongBits(((NTRUSigningParameters)object).betaSq)) {
            return false;
        }
        if (this.bitsF != ((NTRUSigningParameters)object).bitsF) {
            return false;
        }
        if (this.d != ((NTRUSigningParameters)object).d) {
            return false;
        }
        if (this.d1 != ((NTRUSigningParameters)object).d1) {
            return false;
        }
        if (this.d2 != ((NTRUSigningParameters)object).d2) {
            return false;
        }
        if (this.d3 != ((NTRUSigningParameters)object).d3) {
            return false;
        }
        Digest digest = this.hashAlg;
        if (digest == null ? ((NTRUSigningParameters)object).hashAlg != null : !digest.getAlgorithmName().equals(((NTRUSigningParameters)object).hashAlg.getAlgorithmName())) {
            return false;
        }
        if (Double.doubleToLongBits(this.normBound) != Double.doubleToLongBits(((NTRUSigningParameters)object).normBound)) {
            return false;
        }
        if (Double.doubleToLongBits(this.normBoundSq) != Double.doubleToLongBits(((NTRUSigningParameters)object).normBoundSq)) {
            return false;
        }
        if (this.q != ((NTRUSigningParameters)object).q) {
            return false;
        }
        return this.signFailTolerance == ((NTRUSigningParameters)object).signFailTolerance;
    }

    public String toString() {
        DecimalFormat decimalFormat;
        DecimalFormat decimalFormat2 = decimalFormat;
        decimalFormat = new DecimalFormat("0.00");
        StringBuilder stringBuilder = new StringBuilder(a.a("SignatureParameters(N=").append(this.N).append(" q=").append(this.q).toString());
        stringBuilder.append(a.a(" B=").append(this.B).append(" beta=").append(decimalFormat2.format(this.beta)).append(" normBound=").append(decimalFormat2.format(this.normBound)).append(" hashAlg=").append(this.hashAlg).append(")").toString());
        return stringBuilder.toString();
    }
}

