/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.util;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Set;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.SPHINCS256KeyParams;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.XMSSKeyParams;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.XMSSMTKeyParams;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.XMSSMTPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.XMSSPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.Composer;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.HSSPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.newhope.NHPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.qtesla.QTESLAPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincs.SPHINCSKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincs.SPHINCSPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.util.Utils;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.BDS;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.BDSStateMap;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSMTKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSMTPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;
import java.io.IOException;

public class PrivateKeyInfoFactory {
    private PrivateKeyInfoFactory() {
    }

    public static PrivateKeyInfo createPrivateKeyInfo(AsymmetricKeyParameter asymmetricKeyParameter) {
        return PrivateKeyInfoFactory.createPrivateKeyInfo(asymmetricKeyParameter, null);
    }

    public static PrivateKeyInfo createPrivateKeyInfo(AsymmetricKeyParameter object, ASN1Set object2) {
        if (object instanceof QTESLAPrivateKeyParameters) {
            DEROctetString dEROctetString;
            ASN1Object aSN1Object;
            object = (QTESLAPrivateKeyParameters)object;
            AlgorithmIdentifier algorithmIdentifier = aSN1Object = Utils.qTeslaLookupAlgID(((QTESLAPrivateKeyParameters)object).getSecurityCategory());
            aSN1Object = dEROctetString;
            dEROctetString = new DEROctetString(((QTESLAPrivateKeyParameters)object).getSecret());
            return new PrivateKeyInfo(algorithmIdentifier, aSN1Object, (ASN1Set)object2);
        }
        if (object instanceof SPHINCSPrivateKeyParameters) {
            AlgorithmIdentifier algorithmIdentifier;
            object = (SPHINCSPrivateKeyParameters)object;
            object2 = algorithmIdentifier;
            algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.sphincs256, new SPHINCS256KeyParams(Utils.sphincs256LookupTreeAlgID(((SPHINCSKeyParameters)object).getTreeDigest())));
            return new PrivateKeyInfo((AlgorithmIdentifier)object2, new DEROctetString(((SPHINCSPrivateKeyParameters)object).getKeyData()));
        }
        if (object instanceof NHPrivateKeyParameters) {
            DEROctetString dEROctetString;
            AlgorithmIdentifier algorithmIdentifier;
            NHPrivateKeyParameters nHPrivateKeyParameters = (NHPrivateKeyParameters)object;
            object = algorithmIdentifier;
            algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.newHope);
            short[] sArray = nHPrivateKeyParameters.getSecData();
            object2 = sArray;
            byte[] byArray = new byte[sArray.length * 2];
            for (int k = 0; k != ((Object)object2).length; ++k) {
                Pack.shortToLittleEndian((short)object2[k], byArray, k * 2);
            }
            object2 = dEROctetString;
            dEROctetString = new DEROctetString(byArray);
            return new PrivateKeyInfo((AlgorithmIdentifier)object, (ASN1Encodable)object2);
        }
        if (object instanceof LMSPrivateKeyParameters) {
            DEROctetString dEROctetString;
            AlgorithmIdentifier algorithmIdentifier;
            object = (LMSPrivateKeyParameters)object;
            byte[] byArray = Composer.compose().u32str(1).bytes((Encodable)object).build();
            object = Composer.compose().u32str(1).bytes(((LMSPrivateKeyParameters)object).getPublicKey()).build();
            ASN1Object aSN1Object = algorithmIdentifier;
            algorithmIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_alg_hss_lms_hashsig);
            AlgorithmIdentifier algorithmIdentifier2 = aSN1Object;
            aSN1Object = dEROctetString;
            dEROctetString = new DEROctetString(byArray);
            return new PrivateKeyInfo(algorithmIdentifier2, aSN1Object, (ASN1Set)object2, (byte[])object);
        }
        if (object instanceof HSSPrivateKeyParameters) {
            DEROctetString dEROctetString;
            AlgorithmIdentifier algorithmIdentifier;
            object = (HSSPrivateKeyParameters)object;
            byte[] byArray = Composer.compose().u32str(((HSSPrivateKeyParameters)object).getL()).bytes((Encodable)object).build();
            object = Composer.compose().u32str(((HSSPrivateKeyParameters)object).getL()).bytes(((HSSPrivateKeyParameters)object).getPublicKey().getLMSPublicKey()).build();
            ASN1Object aSN1Object = algorithmIdentifier;
            algorithmIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_alg_hss_lms_hashsig);
            AlgorithmIdentifier algorithmIdentifier3 = aSN1Object;
            aSN1Object = dEROctetString;
            dEROctetString = new DEROctetString(byArray);
            return new PrivateKeyInfo(algorithmIdentifier3, aSN1Object, (ASN1Set)object2, (byte[])object);
        }
        if (object instanceof XMSSPrivateKeyParameters) {
            AlgorithmIdentifier algorithmIdentifier;
            object = (XMSSPrivateKeyParameters)object;
            AlgorithmIdentifier algorithmIdentifier4 = algorithmIdentifier;
            algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.xmss, new XMSSKeyParams(((XMSSPrivateKeyParameters)object).getParameters().getHeight(), Utils.xmssLookupTreeAlgID(((XMSSKeyParameters)object).getTreeDigest())));
            return new PrivateKeyInfo(algorithmIdentifier4, PrivateKeyInfoFactory.xmssCreateKeyStructure((XMSSPrivateKeyParameters)object), (ASN1Set)object2);
        }
        if (object instanceof XMSSMTPrivateKeyParameters) {
            AlgorithmIdentifier algorithmIdentifier;
            object = (XMSSMTPrivateKeyParameters)object;
            AlgorithmIdentifier algorithmIdentifier5 = algorithmIdentifier;
            Object object3 = object;
            int n = ((XMSSMTPrivateKeyParameters)object3).getParameters().getLayers();
            algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.xmss_mt, new XMSSMTKeyParams(((XMSSMTPrivateKeyParameters)object).getParameters().getHeight(), n, Utils.xmssLookupTreeAlgID(((XMSSMTKeyParameters)object3).getTreeDigest())));
            return new PrivateKeyInfo(algorithmIdentifier5, PrivateKeyInfoFactory.xmssmtCreateKeyStructure((XMSSMTPrivateKeyParameters)object), (ASN1Set)object2);
        }
        throw new IOException("key parameters not recognized");
    }

    private static XMSSPrivateKey xmssCreateKeyStructure(XMSSPrivateKeyParameters object) {
        int n;
        XMSSPrivateKeyParameters xMSSPrivateKeyParameters = object;
        object = xMSSPrivateKeyParameters.getEncoded();
        int n2 = xMSSPrivateKeyParameters.getParameters().getTreeDigestSize();
        int n3 = xMSSPrivateKeyParameters.getParameters().getHeight();
        if (XMSSUtil.isIndexValid(n3, n = (int)XMSSUtil.bytesToXBigEndian((byte[])object, 0, 4))) {
            Object object2 = object;
            byte[] byArray = XMSSUtil.extractBytesAtOffset((byte[])object2, 4, n2);
            int n4 = n2 + 4;
            byte[] byArray2 = XMSSUtil.extractBytesAtOffset((byte[])object, n4, n2);
            int n5 = n4 + n2;
            byte[] byArray3 = XMSSUtil.extractBytesAtOffset((byte[])object, n5, n2);
            int n6 = n5 + n2;
            byte[] byArray4 = XMSSUtil.extractBytesAtOffset((byte[])object, n6, n2);
            int n7 = n6 + n2;
            byte[] byArray5 = XMSSUtil.extractBytesAtOffset((byte[])object2, n7, ((Object)object).length - n7);
            object = byArray5;
            try {
                BDS bDS = (BDS)XMSSUtil.deserialize(byArray5, BDS.class);
                if (bDS.getMaxIndex() != (1 << n3) - 1) {
                    n3 = bDS.getMaxIndex();
                    return new XMSSPrivateKey(n, byArray, byArray2, byArray3, byArray4, (byte[])object, n3);
                }
                return new XMSSPrivateKey(n, byArray, byArray2, byArray3, byArray4, (byte[])object);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException(a.a("cannot parse BDS: ").append(classNotFoundException.getMessage()).toString());
            }
        }
        throw new IllegalArgumentException("index out of bounds");
    }

    private static XMSSMTPrivateKey xmssmtCreateKeyStructure(XMSSMTPrivateKeyParameters object) {
        XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters = object;
        object = xMSSMTPrivateKeyParameters.getEncoded();
        int n = xMSSMTPrivateKeyParameters.getParameters().getTreeDigestSize();
        int n2 = xMSSMTPrivateKeyParameters.getParameters().getHeight();
        int n3 = (n2 + 7) / 8;
        int n4 = 0;
        long l = (int)XMSSUtil.bytesToXBigEndian((byte[])object, 0, n3);
        if (XMSSUtil.isIndexValid(n2, l)) {
            byte[] byArray = XMSSUtil.extractBytesAtOffset((byte[])object, n3 += n4, n);
            n4 = n3 + n;
            byte[] byArray2 = XMSSUtil.extractBytesAtOffset((byte[])object, n4, n);
            int n5 = n4 + n;
            byte[] byArray3 = XMSSUtil.extractBytesAtOffset((byte[])object, n5, n);
            int n6 = n5 + n;
            byte[] byArray4 = XMSSUtil.extractBytesAtOffset((byte[])object, n6, n);
            int n7 = n6 + n;
            byte[] byArray5 = XMSSUtil.extractBytesAtOffset((byte[])object, n7, ((Object)object).length - n7);
            object = byArray5;
            try {
                BDSStateMap bDSStateMap = (BDSStateMap)XMSSUtil.deserialize(byArray5, BDSStateMap.class);
                if (bDSStateMap.getMaxIndex() != (1L << n2) - 1L) {
                    long l2 = bDSStateMap.getMaxIndex();
                    return new XMSSMTPrivateKey(l, byArray, byArray2, byArray3, byArray4, (byte[])object, l2);
                }
                return new XMSSMTPrivateKey(l, byArray, byArray2, byArray3, byArray4, (byte[])object);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException(a.a("cannot parse BDSStateMap: ").append(classNotFoundException.getMessage()).toString());
            }
        }
        throw new IllegalArgumentException("index out of bounds");
    }
}

