/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.DigestUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.WOTSPlusOid;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSOid;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSUtil;

final class WOTSPlusParameters {
    private final XMSSOid oid;
    private final int digestSize;
    private final int winternitzParameter;
    private final int len;
    private final int len1;
    private final int len2;
    private final ASN1ObjectIdentifier treeDigest;

    public WOTSPlusParameters(ASN1ObjectIdentifier object) {
        if (object != null) {
            this.treeDigest = object;
            object = DigestUtil.getDigest((ASN1ObjectIdentifier)object);
            int n = XMSSUtil.getDigestSize((Digest)object);
            WOTSPlusParameters wOTSPlusParameters = this;
            wOTSPlusParameters.digestSize = n;
            wOTSPlusParameters.winternitzParameter = 16;
            int n2 = (int)Math.ceil((double)(n * 8) / (double)XMSSUtil.log2(16));
            int n3 = n2;
            WOTSPlusParameters wOTSPlusParameters2 = this;
            wOTSPlusParameters2.len1 = n3;
            wOTSPlusParameters2.len2 = n3 = (int)Math.floor(XMSSUtil.log2((16 - 1) * n3) / XMSSUtil.log2(16)) + 1;
            this.len = n3 = n2 + n3;
            this.oid = WOTSPlusOid.lookup(object.getAlgorithmName(), n, 16, n3);
            if (this.oid != null) {
                return;
            }
            throw new IllegalArgumentException(a.a("cannot find OID for digest algorithm: ").append(object.getAlgorithmName()).toString());
        }
        throw new NullPointerException("treeDigest == null");
    }

    public XMSSOid getOid() {
        return this.oid;
    }

    public int getTreeDigestSize() {
        return this.digestSize;
    }

    public int getWinternitzParameter() {
        return this.winternitzParameter;
    }

    public int getLen() {
        return this.len;
    }

    public int getLen1() {
        return this.len1;
    }

    public int getLen2() {
        return this.len2;
    }

    public ASN1ObjectIdentifier getTreeDigest() {
        return this.treeDigest;
    }
}

