/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.DefaultXMSSMTOid;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.DigestUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.WOTSPlus;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSOid;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Integers;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class XMSSMTParameters {
    private static final Map<Integer, XMSSMTParameters> paramsLookupTable;
    private final XMSSOid oid;
    private final XMSSParameters xmssParams;
    private final int height;
    private final int layers;

    public XMSSMTParameters(int n, int n2, Digest digest) {
        this(n, n2, DigestUtil.getDigestOID(digest.getAlgorithmName()));
    }

    public XMSSMTParameters(int n, int n2, ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        this.height = n;
        this.layers = n2;
        this.xmssParams = new XMSSParameters(XMSSMTParameters.xmssTreeHeight(n, n2), aSN1ObjectIdentifier);
        XMSSMTParameters xMSSMTParameters = this;
        int n3 = xMSSMTParameters.getTreeDigestSize();
        n = xMSSMTParameters.getWinternitzParameter();
        int n4 = xMSSMTParameters.getLen();
        int n5 = xMSSMTParameters.getHeight();
        this.oid = DefaultXMSSMTOid.lookup(this.getTreeDigest(), n3, n, n4, n5, n2);
    }

    private static int xmssTreeHeight(int n, int n2) {
        if (n >= 2) {
            if (n % n2 == 0) {
                if ((n /= n2) != 1) {
                    return n;
                }
                throw new IllegalArgumentException("height / layers must be greater than 1");
            }
            throw new IllegalArgumentException("layers must divide totalHeight without remainder");
        }
        throw new IllegalArgumentException("totalHeight must be > 1");
    }

    public static XMSSMTParameters lookupByOID(int n) {
        return paramsLookupTable.get(Integers.valueOf(n));
    }

    static {
        HashMap<Integer, XMSSMTParameters> hashMap;
        HashMap<Integer, XMSSMTParameters> hashMap2 = hashMap;
        ASN1ObjectIdentifier aSN1ObjectIdentifier = NISTObjectIdentifiers.id_sha256;
        new HashMap<Integer, XMSSMTParameters>().put(Integers.valueOf(1), new XMSSMTParameters(20, 2, aSN1ObjectIdentifier));
        Integer n = Integers.valueOf(2);
        a.a(20, 4, aSN1ObjectIdentifier, hashMap2, n);
        n = Integers.valueOf(3);
        a.a(40, 2, aSN1ObjectIdentifier, hashMap2, n);
        n = Integers.valueOf(4);
        a.a(40, 4, aSN1ObjectIdentifier, hashMap2, n);
        n = Integers.valueOf(5);
        a.a(40, 8, aSN1ObjectIdentifier, hashMap2, n);
        n = Integers.valueOf(6);
        a.a(60, 3, aSN1ObjectIdentifier, hashMap2, n);
        n = Integers.valueOf(7);
        a.a(60, 6, aSN1ObjectIdentifier, hashMap2, n);
        n = Integers.valueOf(8);
        a.a(60, 12, aSN1ObjectIdentifier, hashMap2, n);
        aSN1ObjectIdentifier = NISTObjectIdentifiers.id_sha512;
        hashMap2.put(Integers.valueOf(9), new XMSSMTParameters(20, 2, aSN1ObjectIdentifier));
        n = Integers.valueOf(10);
        a.a(20, 4, aSN1ObjectIdentifier, hashMap2, n);
        n = Integers.valueOf(11);
        a.a(40, 2, aSN1ObjectIdentifier, hashMap2, n);
        n = Integers.valueOf(12);
        a.a(40, 4, aSN1ObjectIdentifier, hashMap2, n);
        n = Integers.valueOf(13);
        a.a(40, 8, aSN1ObjectIdentifier, hashMap2, n);
        n = Integers.valueOf(14);
        a.a(60, 3, aSN1ObjectIdentifier, hashMap2, n);
        n = Integers.valueOf(15);
        a.a(60, 6, aSN1ObjectIdentifier, hashMap2, n);
        n = Integers.valueOf(16);
        a.a(60, 12, aSN1ObjectIdentifier, hashMap2, n);
        aSN1ObjectIdentifier = NISTObjectIdentifiers.id_shake128;
        hashMap2.put(Integers.valueOf(17), new XMSSMTParameters(20, 2, aSN1ObjectIdentifier));
        n = Integers.valueOf(18);
        a.a(20, 4, aSN1ObjectIdentifier, hashMap2, n);
        n = Integers.valueOf(19);
        a.a(40, 2, aSN1ObjectIdentifier, hashMap2, n);
        n = Integers.valueOf(20);
        a.a(40, 4, aSN1ObjectIdentifier, hashMap2, n);
        n = Integers.valueOf(21);
        a.a(40, 8, aSN1ObjectIdentifier, hashMap2, n);
        n = Integers.valueOf(22);
        a.a(60, 3, aSN1ObjectIdentifier, hashMap2, n);
        n = Integers.valueOf(23);
        a.a(60, 6, aSN1ObjectIdentifier, hashMap2, n);
        n = Integers.valueOf(24);
        a.a(60, 12, aSN1ObjectIdentifier, hashMap2, n);
        aSN1ObjectIdentifier = NISTObjectIdentifiers.id_shake256;
        hashMap2.put(Integers.valueOf(25), new XMSSMTParameters(20, 2, aSN1ObjectIdentifier));
        n = Integers.valueOf(26);
        a.a(20, 4, aSN1ObjectIdentifier, hashMap2, n);
        n = Integers.valueOf(27);
        a.a(40, 2, aSN1ObjectIdentifier, hashMap2, n);
        n = Integers.valueOf(28);
        a.a(40, 4, aSN1ObjectIdentifier, hashMap2, n);
        n = Integers.valueOf(29);
        a.a(40, 8, aSN1ObjectIdentifier, hashMap2, n);
        n = Integers.valueOf(30);
        a.a(60, 3, aSN1ObjectIdentifier, hashMap2, n);
        n = Integers.valueOf(31);
        a.a(60, 6, aSN1ObjectIdentifier, hashMap2, n);
        n = Integers.valueOf(32);
        a.a(60, 12, aSN1ObjectIdentifier, hashMap2, n);
        paramsLookupTable = Collections.unmodifiableMap(hashMap2);
    }

    public int getHeight() {
        return this.height;
    }

    public int getLayers() {
        return this.layers;
    }

    public XMSSParameters getXMSSParameters() {
        return this.xmssParams;
    }

    public WOTSPlus getWOTSPlus() {
        return this.xmssParams.getWOTSPlus();
    }

    public String getTreeDigest() {
        return this.xmssParams.getTreeDigest();
    }

    public int getTreeDigestSize() {
        return this.xmssParams.getTreeDigestSize();
    }

    public ASN1ObjectIdentifier getTreeDigestOID() {
        return this.xmssParams.getTreeDigestOID();
    }

    public int getWinternitzParameter() {
        return this.xmssParams.getWinternitzParameter();
    }

    public int getLen() {
        return this.xmssParams.getLen();
    }

    public XMSSOid getOid() {
        return this.oid;
    }
}

