/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.e;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.g;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.util.AlgorithmProvider;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.util.AsymmetricKeyInfoConverter;
import java.security.AccessController;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.PublicKey;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class BouncyCastlePQCProvider
extends Provider
implements ConfigurableProvider {
    private static String info = "BouncyCastle Post-Quantum Security Provider v1.67";
    public static String PROVIDER_NAME = "BCPQC";
    public static final ProviderConfiguration CONFIGURATION;
    private static final Map keyInfoConverters;
    private static final String ALGORITHM_PACKAGE = "com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.";
    private static final String[] ALGORITHMS;

    public BouncyCastlePQCProvider() {
        String string = PROVIDER_NAME;
        String string2 = info;
        super(string, 1.67, string2);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                BouncyCastlePQCProvider.this.setup();
                return null;
            }
        });
    }

    private void setup() {
        this.loadAlgorithms(ALGORITHM_PACKAGE, ALGORITHMS);
    }

    private void loadAlgorithms(String string, String[] stringArray) {
        for (int k = 0; k != stringArray.length; ++k) {
            Class clazz = BouncyCastlePQCProvider.loadClass(BouncyCastlePQCProvider.class, a.a(string).append(stringArray[k]).append("$Mappings").toString());
            if (clazz == null) continue;
            try {
                ((AlgorithmProvider)clazz.newInstance()).configure(this);
                continue;
            }
            catch (Exception exception) {
                throw new InternalError(e.a("cannot create instance of ", string).append(stringArray[k]).append("$Mappings : ").append(exception).toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AsymmetricKeyInfoConverter getAsymmetricKeyInfoConverter(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        Map map = keyInfoConverters;
        synchronized (map) {
            return (AsymmetricKeyInfoConverter)map.get(aSN1ObjectIdentifier);
        }
    }

    public static PublicKey getPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        AsymmetricKeyInfoConverter asymmetricKeyInfoConverter = BouncyCastlePQCProvider.getAsymmetricKeyInfoConverter(subjectPublicKeyInfo.getAlgorithm().getAlgorithm());
        if (asymmetricKeyInfoConverter == null) {
            return null;
        }
        return asymmetricKeyInfoConverter.generatePublic(subjectPublicKeyInfo);
    }

    public static PrivateKey getPrivateKey(PrivateKeyInfo privateKeyInfo) {
        AsymmetricKeyInfoConverter asymmetricKeyInfoConverter = BouncyCastlePQCProvider.getAsymmetricKeyInfoConverter(privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm());
        if (asymmetricKeyInfoConverter == null) {
            return null;
        }
        return asymmetricKeyInfoConverter.generatePrivate(privateKeyInfo);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Class loadClass(Class object, final String string) {
        try {
            object = ((Class)object).getClassLoader();
            if (object == null) return (Class)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return Class.forName(string);
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
            });
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        return ((ClassLoader)object).loadClass(string);
    }

    static {
        keyInfoConverters = new HashMap();
        ALGORITHMS = new String[]{"Rainbow", "McEliece", "SPHINCS", "LMS", "NH", "XMSS", "QTESLA"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setParameter(String string, Object object) {
        ProviderConfiguration providerConfiguration = CONFIGURATION;
        synchronized (providerConfiguration) {
            return;
        }
    }

    @Override
    public boolean hasAlgorithm(String string, String string2) {
        return ((Hashtable)this).containsKey(string + "." + string2) || ((Hashtable)this).containsKey("Alg.Alias." + string + "." + string2);
    }

    @Override
    public void addAlgorithm(String string, String string2) {
        if (!((Hashtable)this).containsKey(string)) {
            ((Dictionary)this).put(string, string2);
            return;
        }
        throw new IllegalStateException(g.a("duplicate provider key (", string, ") found"));
    }

    @Override
    public void addAlgorithm(String string, ASN1ObjectIdentifier aSN1ObjectIdentifier, String string2) {
        if (((Hashtable)this).containsKey(string + "." + string2)) {
            BouncyCastlePQCProvider bouncyCastlePQCProvider = this;
            bouncyCastlePQCProvider.addAlgorithm(string + "." + aSN1ObjectIdentifier, string2);
            bouncyCastlePQCProvider.addAlgorithm(string + ".OID." + aSN1ObjectIdentifier, string2);
            return;
        }
        throw new IllegalStateException("primary key (" + string + "." + string2 + ") not found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addKeyInfoConverter(ASN1ObjectIdentifier aSN1ObjectIdentifier, AsymmetricKeyInfoConverter asymmetricKeyInfoConverter) {
        Map<Object, Object> map = keyInfoConverters;
        synchronized (map) {
            map.put(aSN1ObjectIdentifier, asymmetricKeyInfoConverter);
            return;
        }
    }

    @Override
    public AsymmetricKeyInfoConverter getKeyInfoConverter(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return (AsymmetricKeyInfoConverter)keyInfoConverters.get(aSN1ObjectIdentifier);
    }

    @Override
    public void addAttributes(String string, Map<String, String> map) {
        for (String string2 : map.keySet()) {
            String string3 = g.a(string, " ", string2);
            if (!((Hashtable)this).containsKey(string3)) {
                ((Dictionary)this).put(string3, map.get(string2));
                continue;
            }
            throw new IllegalStateException(g.a("duplicate provider attribute key (", string3, ") found"));
        }
    }
}

