/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.newhope;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.util.AsymmetricKeyInfoConverter;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.newhope.BCNHPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.newhope.BCNHPublicKey;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class NHKeyFactorySpi
extends KeyFactorySpi
implements AsymmetricKeyInfoConverter {
    @Override
    public PrivateKey engineGeneratePrivate(KeySpec keySpec) {
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            try {
                return this.generatePrivate(PrivateKeyInfo.getInstance(ASN1Primitive.fromByteArray(((PKCS8EncodedKeySpec)keySpec).getEncoded())));
            }
            catch (Exception exception) {
                throw new InvalidKeySpecException(((Object)exception).toString());
            }
        }
        throw new InvalidKeySpecException(a.a("Unsupported key specification: ").append(keySpec.getClass()).append(".").toString());
    }

    @Override
    public PublicKey engineGeneratePublic(KeySpec keySpec) {
        if (keySpec instanceof X509EncodedKeySpec) {
            try {
                return this.generatePublic(SubjectPublicKeyInfo.getInstance(((X509EncodedKeySpec)keySpec).getEncoded()));
            }
            catch (Exception exception) {
                throw new InvalidKeySpecException(((Object)exception).toString());
            }
        }
        throw new InvalidKeySpecException("Unknown key specification: " + keySpec + ".");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final KeySpec engineGetKeySpec(Key key, Class clazz) {
        if (key instanceof BCNHPrivateKey) {
            if (!PKCS8EncodedKeySpec.class.isAssignableFrom(clazz)) throw new InvalidKeySpecException("Unknown key specification: " + clazz + ".");
            return new PKCS8EncodedKeySpec(key.getEncoded());
        }
        if (!(key instanceof BCNHPublicKey)) throw new InvalidKeySpecException(a.a("Unsupported key type: ").append(key.getClass()).append(".").toString());
        if (!X509EncodedKeySpec.class.isAssignableFrom(clazz)) throw new InvalidKeySpecException("Unknown key specification: " + clazz + ".");
        return new X509EncodedKeySpec(key.getEncoded());
    }

    @Override
    public final Key engineTranslateKey(Key key) {
        if (!(key instanceof BCNHPrivateKey) && !(key instanceof BCNHPublicKey)) {
            throw new InvalidKeyException("Unsupported key type");
        }
        return key;
    }

    @Override
    public PrivateKey generatePrivate(PrivateKeyInfo privateKeyInfo) {
        return new BCNHPrivateKey(privateKeyInfo);
    }

    @Override
    public PublicKey generatePublic(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        return new BCNHPublicKey(subjectPublicKeyInfo);
    }
}

