/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.xmss;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.KeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHA256Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHA512Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHAKEDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSMTKeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSMTKeyPairGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSMTParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSMTPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSMTPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.xmss.BCXMSSMTPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.xmss.BCXMSSMTPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.spec.XMSSMTParameterSpec;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class XMSSMTKeyPairGeneratorSpi
extends KeyPairGenerator {
    private XMSSMTKeyGenerationParameters param;
    private XMSSMTKeyPairGenerator engine = new XMSSMTKeyPairGenerator();
    private ASN1ObjectIdentifier treeDigest;
    private SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
    private boolean initialised = false;

    public XMSSMTKeyPairGeneratorSpi() {
        super("XMSSMT");
    }

    @Override
    public void initialize(int n, SecureRandom secureRandom) {
        throw new IllegalArgumentException("use AlgorithmParameterSpec");
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) {
        if (algorithmParameterSpec instanceof XMSSMTParameterSpec) {
            if (((XMSSMTParameterSpec)(algorithmParameterSpec = (XMSSMTParameterSpec)algorithmParameterSpec)).getTreeDigest().equals("SHA256")) {
                SHA256Digest sHA256Digest;
                XMSSMTKeyPairGeneratorSpi xMSSMTKeyPairGeneratorSpi = this;
                xMSSMTKeyPairGeneratorSpi.treeDigest = NISTObjectIdentifiers.id_sha256;
                AlgorithmParameterSpec algorithmParameterSpec2 = algorithmParameterSpec;
                int n = ((XMSSMTParameterSpec)algorithmParameterSpec2).getHeight();
                int n2 = ((XMSSMTParameterSpec)algorithmParameterSpec2).getLayers();
                SHA256Digest sHA256Digest2 = sHA256Digest;
                sHA256Digest = new SHA256Digest();
                xMSSMTKeyPairGeneratorSpi.param = new XMSSMTKeyGenerationParameters(new XMSSMTParameters(n, n2, sHA256Digest2), secureRandom);
            } else if (((XMSSMTParameterSpec)algorithmParameterSpec).getTreeDigest().equals("SHA512")) {
                SHA512Digest sHA512Digest;
                XMSSMTKeyPairGeneratorSpi xMSSMTKeyPairGeneratorSpi = this;
                xMSSMTKeyPairGeneratorSpi.treeDigest = NISTObjectIdentifiers.id_sha512;
                AlgorithmParameterSpec algorithmParameterSpec3 = algorithmParameterSpec;
                int n = ((XMSSMTParameterSpec)algorithmParameterSpec3).getHeight();
                int n3 = ((XMSSMTParameterSpec)algorithmParameterSpec3).getLayers();
                SHA512Digest sHA512Digest2 = sHA512Digest;
                sHA512Digest = new SHA512Digest();
                xMSSMTKeyPairGeneratorSpi.param = new XMSSMTKeyGenerationParameters(new XMSSMTParameters(n, n3, sHA512Digest2), secureRandom);
            } else if (((XMSSMTParameterSpec)algorithmParameterSpec).getTreeDigest().equals("SHAKE128")) {
                SHAKEDigest sHAKEDigest;
                XMSSMTKeyPairGeneratorSpi xMSSMTKeyPairGeneratorSpi = this;
                xMSSMTKeyPairGeneratorSpi.treeDigest = NISTObjectIdentifiers.id_shake128;
                AlgorithmParameterSpec algorithmParameterSpec4 = algorithmParameterSpec;
                int n = ((XMSSMTParameterSpec)algorithmParameterSpec4).getHeight();
                int n4 = ((XMSSMTParameterSpec)algorithmParameterSpec4).getLayers();
                SHAKEDigest sHAKEDigest2 = sHAKEDigest;
                sHAKEDigest = new SHAKEDigest(128);
                xMSSMTKeyPairGeneratorSpi.param = new XMSSMTKeyGenerationParameters(new XMSSMTParameters(n, n4, sHAKEDigest2), secureRandom);
            } else if (((XMSSMTParameterSpec)algorithmParameterSpec).getTreeDigest().equals("SHAKE256")) {
                SHAKEDigest sHAKEDigest;
                XMSSMTKeyPairGeneratorSpi xMSSMTKeyPairGeneratorSpi = this;
                xMSSMTKeyPairGeneratorSpi.treeDigest = NISTObjectIdentifiers.id_shake256;
                AlgorithmParameterSpec algorithmParameterSpec5 = algorithmParameterSpec;
                int n = ((XMSSMTParameterSpec)algorithmParameterSpec5).getHeight();
                int n5 = ((XMSSMTParameterSpec)algorithmParameterSpec5).getLayers();
                SHAKEDigest sHAKEDigest3 = sHAKEDigest;
                sHAKEDigest = new SHAKEDigest(256);
                xMSSMTKeyPairGeneratorSpi.param = new XMSSMTKeyGenerationParameters(new XMSSMTParameters(n, n5, sHAKEDigest3), secureRandom);
            }
            this.engine.init(this.param);
            this.initialised = true;
            return;
        }
        throw new InvalidAlgorithmParameterException("parameter object not a XMSSMTParameterSpec");
    }

    @Override
    public KeyPair generateKeyPair() {
        BCXMSSMTPrivateKey bCXMSSMTPrivateKey;
        Object object;
        Object object2;
        if (!this.initialised) {
            SHA512Digest sHA512Digest;
            XMSSMTParameters xMSSMTParameters;
            XMSSMTKeyGenerationParameters xMSSMTKeyGenerationParameters;
            object2 = xMSSMTKeyGenerationParameters;
            object = xMSSMTParameters;
            SHA512Digest sHA512Digest2 = sHA512Digest;
            sHA512Digest = new SHA512Digest();
            xMSSMTParameters = new XMSSMTParameters(10, 20, sHA512Digest2);
            this.param = new XMSSMTKeyGenerationParameters((XMSSMTParameters)object, this.random);
            this.engine.init((KeyGenerationParameters)object2);
            this.initialised = true;
        }
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.engine.generateKeyPair();
        object2 = (XMSSMTPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        object = (XMSSMTPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        BCXMSSMTPublicKey bCXMSSMTPublicKey = new BCXMSSMTPublicKey(this.treeDigest, (XMSSMTPublicKeyParameters)object2);
        object2 = bCXMSSMTPrivateKey;
        bCXMSSMTPrivateKey = new BCXMSSMTPrivateKey(this.treeDigest, (XMSSMTPrivateKeyParameters)object);
        return new KeyPair(bCXMSSMTPublicKey, (PrivateKey)object2);
    }
}

