/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.i;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.LittleEndianConversions;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.PolynomialRingGF2;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.RandUtils;
import java.security.SecureRandom;

public class GF2mField {
    private int degree = 0;
    private int polynomial;

    public GF2mField(int n) {
        if (n < 32) {
            if (n >= 1) {
                this.degree = n;
                this.polynomial = PolynomialRingGF2.getIrreduciblePolynomial(n);
                return;
            }
            throw new IllegalArgumentException(" Error: the degree of field is non-positive ");
        }
        throw new IllegalArgumentException(" Error: the degree of field is too large ");
    }

    public GF2mField(int n, int n2) {
        if (n == PolynomialRingGF2.degree(n2)) {
            if (PolynomialRingGF2.isIrreducible(n2)) {
                GF2mField gF2mField = this;
                gF2mField.degree = n;
                gF2mField.polynomial = n2;
                return;
            }
            throw new IllegalArgumentException(" Error: given polynomial is reducible");
        }
        throw new IllegalArgumentException(" Error: the degree is not correct");
    }

    public GF2mField(byte[] byArray) {
        if (byArray.length == 4) {
            int n;
            this.polynomial = n = LittleEndianConversions.OS2IP(byArray);
            if (PolynomialRingGF2.isIrreducible(n)) {
                this.degree = PolynomialRingGF2.degree(this.polynomial);
                return;
            }
            throw new IllegalArgumentException("byte array is not an encoded finite field");
        }
        throw new IllegalArgumentException("byte array is not an encoded finite field");
    }

    public GF2mField(GF2mField gF2mField) {
        this.degree = gF2mField.degree;
        this.polynomial = gF2mField.polynomial;
    }

    private static String polyToString(int n) {
        String string;
        String string2 = "";
        if (n == 0) {
            string = "0";
        } else {
            if ((byte)(n & 1) == 1) {
                string2 = "1";
            }
            n >>>= 1;
            int n2 = 1;
            while (n != 0) {
                if ((byte)(n & 1) == 1) {
                    string2 = string2 + "+x^" + n2;
                }
                n >>>= 1;
                ++n2;
            }
            string = string2;
        }
        return string;
    }

    public int getDegree() {
        return this.degree;
    }

    public int getPolynomial() {
        return this.polynomial;
    }

    public byte[] getEncoded() {
        return LittleEndianConversions.I2OSP(this.polynomial);
    }

    public int add(int n, int n2) {
        return n ^ n2;
    }

    public int mult(int n, int n2) {
        return PolynomialRingGF2.modMultiply(n, n2, this.polynomial);
    }

    public int exp(int n, int n2) {
        if (n2 == 0) {
            return 1;
        }
        if (n == 0) {
            return 0;
        }
        if (n == 1) {
            return 1;
        }
        int n3 = 1;
        if (n2 < 0) {
            n = this.inverse(n);
            n2 = -n2;
        }
        while (n2 != 0) {
            if ((n2 & 1) == 1) {
                n3 = this.mult(n3, n);
            }
            int n4 = n;
            n = this.mult(n4, n4);
            n2 >>>= 1;
        }
        return n3;
    }

    public int inverse(int n) {
        return this.exp(n, (1 << this.degree) - 2);
    }

    public int sqRoot(int n) {
        for (int k = 1; k < this.degree; ++k) {
            int n2 = n;
            n = this.mult(n2, n2);
        }
        return n;
    }

    public int getRandomElement(SecureRandom secureRandom) {
        return RandUtils.nextInt(secureRandom, 1 << this.degree);
    }

    public int getRandomNonZeroElement() {
        return this.getRandomNonZeroElement(CryptoServicesRegistrar.getSecureRandom());
    }

    public int getRandomNonZeroElement(SecureRandom secureRandom) {
        int n;
        int n2 = 0x100000;
        int n3 = RandUtils.nextInt(secureRandom, 1 << this.degree);
        for (n = 0; n3 == 0 && n < n2; ++n) {
            n3 = RandUtils.nextInt(secureRandom, 1 << this.degree);
        }
        if (n == n2) {
            n3 = 1;
        }
        return n3;
    }

    public boolean isElementOfThisField(int n) {
        int n2 = this.degree;
        if (n2 == 31) {
            return n >= 0;
        }
        return n >= 0 && n < 1 << n2;
    }

    public String elementToStr(int n) {
        String string = "";
        for (int k = 0; k < this.degree; ++k) {
            string = ((byte)n & 1) == 0 ? i.a("0", string) : i.a("1", string);
            n >>>= 1;
        }
        return string;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof GF2mField) {
            object = (GF2mField)object;
            return this.degree == ((GF2mField)object).degree && this.polynomial == ((GF2mField)object).polynomial;
        }
        return false;
    }

    public int hashCode() {
        return this.polynomial;
    }

    public String toString() {
        return d.a.a(a.a("Finite Field GF(2^").append(this.degree).append(") = GF(2)[X]/<"), GF2mField.polyToString(this.polynomial), "> ");
    }
}

