/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra;

import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2Polynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2nElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2nField;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2nONBElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2nONBField;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2nPolynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2nPolynomialElement;
import java.security.SecureRandom;
import java.util.Vector;

public class GF2nPolynomialField
extends GF2nField {
    public GF2Polynomial[] squaringMatrix;
    private boolean isTrinomial = false;
    private boolean isPentanomial = false;
    private int tc;
    private int[] pc = new int[3];

    public GF2nPolynomialField(int n, SecureRandom secureRandom) {
        super(secureRandom);
        if (n >= 3) {
            Vector vector;
            Vector vector2;
            GF2nPolynomialField gF2nPolynomialField = object;
            gF2nPolynomialField.mDegree = n;
            gF2nPolynomialField.computeFieldPolynomial();
            gF2nPolynomialField.computeSquaringMatrix();
            Object object = vector2;
            vector2 = new Vector();
            gF2nPolynomialField.fields = object;
            object = vector;
            vector = new Vector();
            gF2nPolynomialField.matrices = object;
            return;
        }
        throw new IllegalArgumentException("k must be at least 3");
    }

    public GF2nPolynomialField(int n, SecureRandom secureRandom, boolean bl) {
        super(secureRandom);
        if (n >= 3) {
            Vector vector;
            Vector vector2;
            ((GF2nField)object).mDegree = n;
            if (bl) {
                ((GF2nPolynomialField)object).computeFieldPolynomial();
            } else {
                ((GF2nPolynomialField)object).computeFieldPolynomial2();
            }
            ((GF2nPolynomialField)object).computeSquaringMatrix();
            Object object = vector2;
            vector2 = new Vector();
            v1.fields = object;
            object = vector;
            vector = new Vector();
            v1.matrices = object;
            return;
        }
        throw new IllegalArgumentException("k must be at least 3");
    }

    public GF2nPolynomialField(int n, SecureRandom secureRandom, GF2Polynomial gF2Polynomial) {
        super(secureRandom);
        if (n >= 3) {
            if (gF2Polynomial.getLength() == n + 1) {
                if (gF2Polynomial.isIrreducible()) {
                    Vector vector;
                    Vector vector2;
                    ((GF2nField)object).mDegree = n;
                    ((GF2nField)object).fieldPolynomial = gF2Polynomial;
                    ((GF2nPolynomialField)object).computeSquaringMatrix();
                    n = 2;
                    for (int k = 1; k < ((GF2nField)object).fieldPolynomial.getLength() - 1; ++k) {
                        if (!((GF2nField)object).fieldPolynomial.testBit(k)) continue;
                        if (++n == 3) {
                            ((GF2nPolynomialField)object).tc = k;
                        }
                        if (n > 5) continue;
                        ((GF2nPolynomialField)object).pc[n - 3] = k;
                    }
                    if (n == 3) {
                        ((GF2nPolynomialField)object).isTrinomial = true;
                    }
                    if (n == 5) {
                        ((GF2nPolynomialField)object).isPentanomial = true;
                    }
                    GF2nPolynomialField gF2nPolynomialField = object;
                    Object object = vector2;
                    vector2 = new Vector();
                    gF2nPolynomialField.fields = object;
                    object = vector;
                    vector = new Vector();
                    gF2nPolynomialField.matrices = object;
                    return;
                }
                throw new RuntimeException();
            }
            throw new RuntimeException();
        }
        throw new IllegalArgumentException("degree must be at least 3");
    }

    private void computeSquaringMatrix() {
        int n = this.mDegree;
        GF2Polynomial[] gF2PolynomialArray = new GF2Polynomial[n - 1];
        this.squaringMatrix = new GF2Polynomial[n];
        int n2 = 0;
        while (true) {
            GF2Polynomial gF2Polynomial;
            Object object = this.squaringMatrix;
            if (n2 >= this.squaringMatrix.length) break;
            GF2Polynomial[] gF2PolynomialArray2 = object;
            object = gF2Polynomial;
            gF2Polynomial = new GF2Polynomial(this.mDegree, "ZERO");
            gF2PolynomialArray2[n2] = object;
            ++n2;
        }
        for (n2 = 0; n2 < this.mDegree - 1; ++n2) {
            gF2PolynomialArray[n2] = new GF2Polynomial(1, "ONE").shiftLeft(this.mDegree + n2).remainder(this.fieldPolynomial);
        }
        for (n2 = 1; n2 <= Math.abs(this.mDegree >> 1); ++n2) {
            int n3;
            for (int k = 1; k <= (n3 = this.mDegree); ++k) {
                if (!gF2PolynomialArray[n3 - (n2 << 1)].testBit(n3 - k)) continue;
                this.squaringMatrix[k - 1].setBit(this.mDegree - n2);
            }
        }
        for (int k = Math.abs(this.mDegree >> 1) + 1; k <= (n2 = this.mDegree); ++k) {
            this.squaringMatrix[(k << 1) - n2 - 1].setBit(n2 - k);
        }
    }

    private boolean testTrinomials() {
        boolean bl = false;
        this.fieldPolynomial = new GF2Polynomial(this.mDegree + 1);
        this.fieldPolynomial.setBit(0);
        this.fieldPolynomial.setBit(this.mDegree);
        for (int k = 1; k < this.mDegree && !bl; ++k) {
            GF2nPolynomialField gF2nPolynomialField = this;
            gF2nPolynomialField.fieldPolynomial.setBit(k);
            bl = gF2nPolynomialField.fieldPolynomial.isIrreducible();
            if (bl) {
                GF2nPolynomialField gF2nPolynomialField2 = this;
                gF2nPolynomialField2.isTrinomial = true;
                gF2nPolynomialField2.tc = k;
                return bl;
            }
            GF2nPolynomialField gF2nPolynomialField3 = this;
            gF2nPolynomialField3.fieldPolynomial.resetBit(k);
            bl = gF2nPolynomialField3.fieldPolynomial.isIrreducible();
        }
        return bl;
    }

    private boolean testPentanomials() {
        boolean bl = false;
        this.fieldPolynomial = new GF2Polynomial(this.mDegree + 1);
        this.fieldPolynomial.setBit(0);
        this.fieldPolynomial.setBit(this.mDegree);
        int n = 1;
        while (n <= this.mDegree - 3 && !bl) {
            int n2;
            this.fieldPolynomial.setBit(n);
            int n3 = n2 = n + 1;
            while (n3 <= this.mDegree - 2 && !bl) {
                int n4;
                this.fieldPolynomial.setBit(n3);
                for (int k = n4 = n3 + 1; k <= this.mDegree - 1 && !bl; ++k) {
                    GF2nPolynomialField gF2nPolynomialField = this;
                    gF2nPolynomialField.fieldPolynomial.setBit(k);
                    boolean bl2 = (gF2nPolynomialField.mDegree & 1) != 0;
                    boolean bl3 = (n & 1) != 0;
                    bl2 |= bl3;
                    bl3 = (n3 & 1) != 0;
                    bl2 |= bl3;
                    bl3 = (k & 1) != 0;
                    if (bl2 | bl3 && (bl = this.fieldPolynomial.isIrreducible())) {
                        GF2nPolynomialField gF2nPolynomialField2 = this;
                        gF2nPolynomialField2.isPentanomial = true;
                        int[] nArray = gF2nPolynomialField2.pc;
                        nArray[0] = n;
                        nArray[1] = n3;
                        gF2nPolynomialField2.pc[2] = k;
                        return bl;
                    }
                    this.fieldPolynomial.resetBit(k);
                }
                this.fieldPolynomial.resetBit(n3);
                n3 = n4;
            }
            this.fieldPolynomial.resetBit(n);
            n = n2;
        }
        return bl;
    }

    private boolean testRandom() {
        GF2nPolynomialField gF2nPolynomialField;
        this.fieldPolynomial = new GF2Polynomial(this.mDegree + 1);
        do {
            gF2nPolynomialField = this;
            gF2nPolynomialField.fieldPolynomial.randomize();
            gF2nPolynomialField.fieldPolynomial.setBit(this.mDegree);
            gF2nPolynomialField.fieldPolynomial.setBit(0);
        } while (!gF2nPolynomialField.fieldPolynomial.isIrreducible());
        return true;
    }

    public boolean isTrinomial() {
        return this.isTrinomial;
    }

    public boolean isPentanomial() {
        return this.isPentanomial;
    }

    public int getTc() {
        if (this.isTrinomial) {
            return this.tc;
        }
        throw new RuntimeException();
    }

    public int[] getPc() {
        if (this.isPentanomial) {
            int[] nArray = new int[3];
            System.arraycopy(this.pc, 0, nArray, 0, 3);
            return nArray;
        }
        throw new RuntimeException();
    }

    public GF2Polynomial getSquaringVector(int n) {
        return new GF2Polynomial(this.squaringMatrix[n]);
    }

    @Override
    public GF2nElement getRandomRoot(GF2Polynomial object) {
        GF2nPolynomial gF2nPolynomial;
        Object object2 = gF2nPolynomial;
        int n = new GF2nPolynomial((GF2Polynomial)object, this).getDegree();
        while (n > 1) {
            int n2;
            int n3;
            do {
                GF2nPolynomial gF2nPolynomial2;
                GF2nPolynomial gF2nPolynomial3;
                GF2nPolynomialElement gF2nPolynomialElement;
                object = gF2nPolynomialElement;
                gF2nPolynomialElement = new GF2nPolynomialElement(this, this.random);
                GF2nPolynomial gF2nPolynomial4 = gF2nPolynomial3;
                new GF2nPolynomial(2, GF2nPolynomialElement.ZERO(this)).set(1, (GF2nElement)object);
                object = gF2nPolynomial2;
                gF2nPolynomial2 = new GF2nPolynomial(gF2nPolynomial4);
                for (n2 = 1; n2 <= this.mDegree - 1; ++n2) {
                    Object object3 = object;
                    object = ((GF2nPolynomial)object3).multiplyAndReduce((GF2nPolynomial)object3, (GF2nPolynomial)object2).add(gF2nPolynomial4);
                }
                object = ((GF2nPolynomial)object).gcd((GF2nPolynomial)object2);
                n3 = ((GF2nPolynomial)object).getDegree();
                n2 = ((GF2nPolynomial)object2).getDegree();
            } while (n3 == 0 || n3 == n2);
            if (n3 << 1 > n2) {
                object2 = object = ((GF2nPolynomial)object2).quotient((GF2nPolynomial)object);
            } else {
                GF2nPolynomial gF2nPolynomial5;
                object2 = gF2nPolynomial5;
                gF2nPolynomial5 = new GF2nPolynomial((GF2nPolynomial)object);
            }
            n = ((GF2nPolynomial)object2).getDegree();
        }
        return ((GF2nPolynomial)object2).at(0);
    }

    @Override
    public void computeCOBMatrix(GF2nField gF2nField) {
        int n = this.mDegree;
        if (n == gF2nField.mDegree) {
            GF2nElement[] gF2nElementArray;
            int n2;
            GF2nElement gF2nElement;
            int n3 = gF2nField instanceof GF2nONBField;
            if (n3 != 0) {
                gF2nField.computeCOBMatrix(this);
                return;
            }
            GF2Polynomial[] gF2PolynomialArray = new GF2Polynomial[n];
            for (int k = 0; k < this.mDegree; ++k) {
                GF2Polynomial gF2Polynomial;
                GF2Polynomial gF2Polynomial2 = gF2Polynomial;
                gF2Polynomial = new GF2Polynomial(this.mDegree);
                gF2PolynomialArray[k] = gF2Polynomial2;
            }
            while ((gF2nElement = gF2nField.getRandomRoot(this.fieldPolynomial)).isZero()) {
            }
            if (gF2nElement instanceof GF2nONBElement) {
                n2 = this.mDegree;
                GF2nONBElement[] gF2nONBElementArray = new GF2nONBElement[n2];
                gF2nElementArray = gF2nONBElementArray;
                gF2nONBElementArray[n2 - 1] = GF2nONBElement.ONE((GF2nONBField)gF2nField);
            } else {
                n2 = this.mDegree;
                GF2nPolynomialElement[] gF2nPolynomialElementArray = new GF2nPolynomialElement[n2];
                gF2nElementArray = gF2nPolynomialElementArray;
                gF2nPolynomialElementArray[n2 - 1] = GF2nPolynomialElement.ONE((GF2nPolynomialField)gF2nField);
            }
            gF2nElementArray[this.mDegree - 2] = gF2nElement;
            for (n2 = (v932875) - 3; n2 >= 0; --n2) {
                gF2nElementArray[n2] = (GF2nElement)gF2nElementArray[n2 + 1].multiply(gF2nElement);
            }
            if (n3 != 0) {
                for (n3 = 0; n3 < this.mDegree; ++n3) {
                    for (int k = 0; k < (n2 = this.mDegree); ++k) {
                        if (!gF2nElementArray[n3].testBit(n2 - k - 1)) continue;
                        n2 = this.mDegree;
                        gF2PolynomialArray[n2 - k - 1].setBit(n2 - n3 - 1);
                    }
                }
            } else {
                for (n3 = 0; n3 < this.mDegree; ++n3) {
                    for (int k = 0; k < this.mDegree; ++k) {
                        if (!gF2nElementArray[n3].testBit(k)) continue;
                        n2 = this.mDegree;
                        gF2PolynomialArray[n2 - k - 1].setBit(n2 - n3 - 1);
                    }
                }
            }
            GF2nField gF2nField2 = gF2nField;
            GF2nPolynomialField gF2nPolynomialField = this;
            gF2nPolynomialField.fields.addElement(gF2nField);
            gF2nPolynomialField.matrices.addElement(gF2PolynomialArray);
            gF2nField2.fields.addElement(this);
            gF2nField2.matrices.addElement(this.invertMatrix(gF2PolynomialArray));
            return;
        }
        throw new IllegalArgumentException("GF2nPolynomialField.computeCOBMatrix: B1 has a different degree and thus cannot be coverted to!");
    }

    @Override
    public void computeFieldPolynomial() {
        if (this.testTrinomials()) {
            return;
        }
        if (this.testPentanomials()) {
            return;
        }
        this.testRandom();
    }

    public void computeFieldPolynomial2() {
        if (this.testTrinomials()) {
            return;
        }
        if (this.testPentanomials()) {
            return;
        }
        this.testRandom();
    }
}

