/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra;

public final class LittleEndianConversions {
    private LittleEndianConversions() {
    }

    public static int OS2IP(byte[] byArray) {
        return byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16 | (byArray[3] & 0xFF) << 24;
    }

    public static int OS2IP(byte[] byArray, int n) {
        return byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n] & 0xFF) << 24;
    }

    public static int OS2IP(byte[] byArray, int n, int n2) {
        int n3 = n2;
        n2 = 0;
        for (int k = (v936909) - 1; k >= 0; --k) {
            n2 |= (byArray[n + k] & 0xFF) << k * 8;
        }
        return n2;
    }

    public static long OS2LIP(byte[] byArray, int n) {
        return (long)(byArray[n++] & 0xFF) | (long)((byArray[n++] & 0xFF) << 8) | (long)((byArray[n++] & 0xFF) << 16) | ((long)byArray[n++] & 0xFFL) << 24 | ((long)byArray[n++] & 0xFFL) << 32 | ((long)byArray[n++] & 0xFFL) << 40 | ((long)byArray[n++] & 0xFFL) << 48 | ((long)byArray[n] & 0xFFL) << 56;
    }

    public static byte[] I2OSP(int n) {
        byte[] byArray = new byte[4];
        byte[] byArray2 = byArray;
        byArray2[0] = (byte)n;
        byArray2[1] = (byte)(n >>> 8);
        byArray2[2] = (byte)(n >>> 16);
        byArray[3] = (byte)(n >>> 24);
        return byArray;
    }

    public static void I2OSP(int n, byte[] byArray, int n2) {
        int n3 = n;
        int n4 = n;
        int n5 = n;
        int n6 = n;
        n = n2 + 1;
        byArray[n2] = (byte)n6;
        int n7 = n + 1;
        byArray[n] = (byte)(n5 >>> 8);
        n = n7 + 1;
        byArray[n7] = (byte)(n4 >>> 16);
        byArray[n] = (byte)(n3 >>> 24);
    }

    public static void I2OSP(int n, byte[] byArray, int n2, int n3) {
        --n3;
        while (n3 >= 0) {
            int n4 = n2 + n3;
            byArray[n4] = (byte)(n >>> n3 * 8);
            --n3;
        }
    }

    public static byte[] I2OSP(long l) {
        byte[] byArray = new byte[8];
        byte[] byArray2 = byArray;
        byArray2[0] = (byte)l;
        byArray2[1] = (byte)(l >>> 8);
        byArray2[2] = (byte)(l >>> 16);
        byArray2[3] = (byte)(l >>> 24);
        byArray2[4] = (byte)(l >>> 32);
        byArray2[5] = (byte)(l >>> 40);
        byArray2[6] = (byte)(l >>> 48);
        byArray[7] = (byte)(l >>> 56);
        return byArray;
    }

    public static void I2OSP(long l, byte[] byArray, int n) {
        int n2 = n + 1;
        byArray[n] = (byte)l;
        int n3 = n2 + 1;
        byArray[n2] = (byte)(l >>> 8);
        n2 = n3 + 1;
        byArray[n3] = (byte)(l >>> 16);
        n3 = n2 + 1;
        byArray[n2] = (byte)(l >>> 24);
        n2 = n3 + 1;
        byArray[n3] = (byte)(l >>> 32);
        n3 = n2 + 1;
        byArray[n2] = (byte)(l >>> 40);
        n2 = n3 + 1;
        byArray[n3] = (byte)(l >>> 48);
        byArray[n2] = (byte)(l >>> 56);
    }

    public static byte[] toByteArray(int[] nArray, int n) {
        int n2 = nArray.length;
        byte[] byArray = new byte[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 <= n2 - 2) {
            LittleEndianConversions.I2OSP(nArray[n4], byArray, n3);
            ++n4;
            n3 += 4;
        }
        LittleEndianConversions.I2OSP(nArray[n2 - 1], byArray, n3, n - n3);
        return byArray;
    }

    public static int[] toIntArray(byte[] byArray) {
        int n = (byArray.length + 3) / 4;
        int n2 = byArray.length & 3;
        int[] nArray = new int[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 <= n - 2) {
            nArray[n4] = LittleEndianConversions.OS2IP(byArray, n3);
            ++n4;
            n3 += 4;
        }
        if (n2 != 0) {
            int n5 = n - 1;
            nArray[n5] = LittleEndianConversions.OS2IP(byArray, n3, n2);
        } else {
            int n6 = n - 1;
            nArray[n6] = LittleEndianConversions.OS2IP(byArray, n3);
        }
        return nArray;
    }
}

