/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.e;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.i;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.IntUtils;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.IntegerFunctions;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.LittleEndianConversions;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.RandUtils;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class Permutation {
    private int[] perm;

    public Permutation(int n) {
        if (n > 0) {
            this.perm = new int[n];
            --n;
            while (n >= 0) {
                int n2 = n--;
                this.perm[n2] = n2;
            }
            return;
        }
        throw new IllegalArgumentException("invalid length");
    }

    public Permutation(int[] nArray) {
        if (this.isPermutation(nArray)) {
            this.perm = IntUtils.clone(nArray);
            return;
        }
        throw new IllegalArgumentException("array is not a permutation vector");
    }

    public Permutation(byte[] byArray) {
        if (byArray.length > 4) {
            int n;
            int n2 = LittleEndianConversions.OS2IP(byArray, 0);
            if (byArray.length == n2 * (n = IntegerFunctions.ceilLog256(n2 - 1)) + 4) {
                this.perm = new int[n2];
                for (int k = 0; k < n2; ++k) {
                    this.perm[k] = LittleEndianConversions.OS2IP(byArray, k * n + 4, n);
                }
                Permutation permutation = this;
                if (permutation.isPermutation(permutation.perm)) {
                    return;
                }
                throw new IllegalArgumentException("invalid encoding");
            }
            throw new IllegalArgumentException("invalid encoding");
        }
        throw new IllegalArgumentException("invalid encoding");
    }

    public Permutation(int n, SecureRandom secureRandom) {
        if (n > 0) {
            this.perm = new int[n];
            int[] nArray = new int[n];
            int n2 = 0;
            while (n2 < n) {
                int n3 = n2++;
                nArray[n3] = n3;
            }
            int n4 = n;
            for (n2 = 0; n2 < n; ++n2) {
                int n5 = RandUtils.nextInt(secureRandom, n4);
                this.perm[n2] = nArray[n5];
                nArray[n5] = nArray[n4 += -1];
            }
            return;
        }
        throw new IllegalArgumentException("invalid length");
    }

    private boolean isPermutation(int[] nArray) {
        int n = nArray.length;
        boolean[] blArray = new boolean[n];
        for (int k = 0; k < n; ++k) {
            int n2 = nArray[k];
            if (n2 >= 0 && n2 < n && !blArray[n2]) {
                blArray[n2] = true;
                continue;
            }
            return false;
        }
        return true;
    }

    public byte[] getEncoded() {
        int n = this.perm.length;
        int n2 = IntegerFunctions.ceilLog256(n - 1);
        byte[] byArray = new byte[n * n2 + 4];
        LittleEndianConversions.I2OSP(n, byArray, 0);
        for (int k = 0; k < n; ++k) {
            LittleEndianConversions.I2OSP(this.perm[k], byArray, k * n2 + 4, n2);
        }
        return byArray;
    }

    public int[] getVector() {
        return IntUtils.clone(this.perm);
    }

    public Permutation computeInverse() {
        Permutation permutation;
        Permutation permutation2 = permutation;
        permutation = new Permutation(this.perm.length);
        for (int k = this.perm.length - 1; k >= 0; --k) {
            permutation2.perm[this.perm[k]] = k;
        }
        return permutation2;
    }

    public Permutation rightMultiply(Permutation permutation) {
        int[] nArray = this.perm;
        if (permutation.perm.length == this.perm.length) {
            Permutation permutation2;
            Permutation permutation3 = permutation2;
            permutation2 = new Permutation(nArray.length);
            for (int k = this.perm.length - 1; k >= 0; --k) {
                permutation3.perm[k] = this.perm[permutation.perm[k]];
            }
            return permutation3;
        }
        throw new IllegalArgumentException("length mismatch");
    }

    public boolean equals(Object object) {
        if (!(object instanceof Permutation)) {
            return false;
        }
        Permutation permutation = permutation2;
        Permutation permutation2 = (Permutation)object;
        return IntUtils.equals(permutation.perm, permutation2.perm);
    }

    public String toString() {
        String string = a.a("[").append(this.perm[0]).toString();
        for (int k = 1; k < this.perm.length; ++k) {
            string = e.a(string, ", ").append(this.perm[k]).toString();
        }
        return i.a(string, "]");
    }

    public int hashCode() {
        return Arrays.hashCode(this.perm);
    }
}

