/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.f;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.BigIntPolynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.IntegerPolynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.TernaryPolynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.util.ArrayEncoder;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.util.Util;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SparseTernaryPolynomial
implements TernaryPolynomial {
    private static final int BITS_PER_INDEX = 11;
    private int N;
    private int[] ones;
    private int[] negOnes;

    public SparseTernaryPolynomial(int n, int[] nArray, int[] nArray2) {
        this.N = n;
        this.ones = nArray;
        this.negOnes = nArray2;
    }

    public SparseTernaryPolynomial(IntegerPolynomial integerPolynomial) {
        this(integerPolynomial.coeffs);
    }

    public SparseTernaryPolynomial(int[] nArray) {
        int n;
        SparseTernaryPolynomial sparseTernaryPolynomial = this;
        sparseTernaryPolynomial.N = n = nArray.length;
        sparseTernaryPolynomial.ones = new int[n];
        sparseTernaryPolynomial.negOnes = new int[n];
        n = 0;
        int n2 = 0;
        for (int k = 0; k < this.N; ++k) {
            int n3 = nArray[k];
            if (n3 != -1) {
                if (n3 == 0) continue;
                if (n3 == 1) {
                    this.ones[n++] = k;
                    continue;
                }
                throw new IllegalArgumentException(f.a("Illegal value: ", n3, ", must be one of {-1, 0, 1}"));
            }
            this.negOnes[n2++] = k;
        }
        SparseTernaryPolynomial sparseTernaryPolynomial2 = this;
        sparseTernaryPolynomial2.ones = Arrays.copyOf(sparseTernaryPolynomial2.ones, n);
        sparseTernaryPolynomial2.negOnes = Arrays.copyOf(sparseTernaryPolynomial2.negOnes, n2);
    }

    public static SparseTernaryPolynomial fromBinary(InputStream inputStream, int n, int n2, int n3) {
        int n4 = 32 - Integer.numberOfLeadingZeros(2047);
        int[] nArray = ArrayEncoder.decodeModQ(Util.readFullLength(inputStream, (n2 * n4 + 7) / 8), n2, 2048);
        int[] nArray2 = ArrayEncoder.decodeModQ(Util.readFullLength(inputStream, (n3 * n4 + 7) / 8), n3, 2048);
        return new SparseTernaryPolynomial(n, nArray, nArray2);
    }

    public static SparseTernaryPolynomial generateRandom(int n, int n2, int n3, SecureRandom secureRandom) {
        int[] nArray = Util.generateRandomTernary(n, n2, n3, secureRandom);
        return new SparseTernaryPolynomial(nArray);
    }

    @Override
    public IntegerPolynomial mult(IntegerPolynomial object) {
        object = ((IntegerPolynomial)object).coeffs;
        int n = this.N;
        if (((IntegerPolynomial)object).coeffs.length == n) {
            int n2;
            int[] nArray;
            int[] nArray2 = new int[n];
            int n3 = 0;
            while (true) {
                nArray = this.ones;
                if (n3 == this.ones.length) break;
                int n4 = nArray[n3];
                n4 = this.N - 1 - n4;
                for (n2 = (v947585) - 1; n2 >= 0; --n2) {
                    nArray2[n2] = nArray2[n2] + object[n4];
                    if ((n4 += -1) >= 0) continue;
                    n4 = this.N - 1;
                }
                ++n3;
            }
            n3 = 0;
            while (true) {
                nArray = this.negOnes;
                if (n3 == this.negOnes.length) break;
                int n5 = nArray[n3];
                n5 = this.N - 1 - n5;
                for (n2 = (v947626) - 1; n2 >= 0; --n2) {
                    nArray2[n2] = nArray2[n2] - object[n5];
                    if ((n5 += -1) >= 0) continue;
                    n5 = this.N - 1;
                }
                ++n3;
            }
            return new IntegerPolynomial(nArray2);
        }
        throw new IllegalArgumentException("Number of coefficients must be the same");
    }

    @Override
    public IntegerPolynomial mult(IntegerPolynomial integerPolynomial, int n) {
        IntegerPolynomial integerPolynomial2 = this.mult(integerPolynomial);
        integerPolynomial2.mod(n);
        return integerPolynomial2;
    }

    @Override
    public BigIntPolynomial mult(BigIntPolynomial bigIntegerArray) {
        bigIntegerArray = bigIntegerArray.coeffs;
        int n = this.N;
        if (bigIntegerArray.coeffs.length == n) {
            int n2;
            int[] nArray;
            int n3;
            BigInteger[] bigIntegerArray2 = new BigInteger[n];
            for (n3 = 0; n3 < this.N; ++n3) {
                bigIntegerArray2[n3] = BigInteger.ZERO;
            }
            n3 = 0;
            while (true) {
                nArray = this.ones;
                if (n3 == this.ones.length) break;
                int n4 = nArray[n3];
                n4 = this.N - 1 - n4;
                for (n2 = (v947703) - 1; n2 >= 0; --n2) {
                    bigIntegerArray2[n2] = bigIntegerArray2[n2].add(bigIntegerArray[n4]);
                    if ((n4 += -1) >= 0) continue;
                    n4 = this.N - 1;
                }
                ++n3;
            }
            n3 = 0;
            while (true) {
                nArray = this.negOnes;
                if (n3 == this.negOnes.length) break;
                int n5 = nArray[n3];
                n5 = this.N - 1 - n5;
                for (n2 = (v947744) - 1; n2 >= 0; --n2) {
                    bigIntegerArray2[n2] = bigIntegerArray2[n2].subtract(bigIntegerArray[n5]);
                    if ((n5 += -1) >= 0) continue;
                    n5 = this.N - 1;
                }
                ++n3;
            }
            return new BigIntPolynomial(bigIntegerArray2);
        }
        throw new IllegalArgumentException("Number of coefficients must be the same");
    }

    @Override
    public int[] getOnes() {
        return this.ones;
    }

    @Override
    public int[] getNegOnes() {
        return this.negOnes;
    }

    public byte[] toBinary() {
        byte[] byArray = ArrayEncoder.encodeModQ(((SparseTernaryPolynomial)object).ones, 2048);
        Object object = ArrayEncoder.encodeModQ(((SparseTernaryPolynomial)object).negOnes, 2048);
        byte[] byArray2 = Arrays.copyOf(byArray, byArray.length + ((Object)object).length);
        Object object2 = object;
        int n = byArray.length;
        int n2 = ((Object)object2).length;
        System.arraycopy(object2, 0, byArray2, n, n2);
        return byArray2;
    }

    @Override
    public IntegerPolynomial toIntegerPolynomial() {
        int[] nArray;
        int[] nArray2 = new int[this.N];
        int n = 0;
        while (true) {
            nArray = this.ones;
            if (n == this.ones.length) break;
            nArray2[nArray[n]] = 1;
            ++n;
        }
        n = 0;
        while (true) {
            nArray = this.negOnes;
            if (n == this.negOnes.length) break;
            nArray2[nArray[n]] = -1;
            ++n;
        }
        return new IntegerPolynomial(nArray2);
    }

    @Override
    public int size() {
        return this.N;
    }

    @Override
    public void clear() {
        int[] nArray;
        int n = 0;
        while (true) {
            nArray = this.ones;
            if (n >= this.ones.length) break;
            nArray[n] = 0;
            ++n;
        }
        n = 0;
        while (true) {
            nArray = this.negOnes;
            if (n >= this.negOnes.length) break;
            nArray[n] = 0;
            ++n;
        }
    }

    public int hashCode() {
        SparseTernaryPolynomial sparseTernaryPolynomial = this;
        int n = (31 + sparseTernaryPolynomial.N) * 31;
        n = (Arrays.hashCode(sparseTernaryPolynomial.negOnes) + n) * 31;
        return Arrays.hashCode(sparseTernaryPolynomial.ones) + n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (SparseTernaryPolynomial)object;
        if (this.N != ((SparseTernaryPolynomial)object).N) {
            return false;
        }
        if (!Arrays.areEqual(this.negOnes, ((SparseTernaryPolynomial)object).negOnes)) {
            return false;
        }
        return Arrays.areEqual(this.ones, ((SparseTernaryPolynomial)object).ones);
    }
}

