/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.util;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Objects;
import java.math.BigInteger;
import java.util.NoSuchElementException;

public final class Arrays {
    private Arrays() {
    }

    public static boolean areAllZeroes(byte[] byArray, int n, int n2) {
        int n3 = 0;
        for (int k = 0; k < n2; ++k) {
            n3 |= byArray[n + k];
        }
        return n3 == 0;
    }

    public static boolean areEqual(boolean[] blArray, boolean[] blArray2) {
        return java.util.Arrays.equals(blArray, blArray2);
    }

    public static boolean areEqual(byte[] byArray, byte[] byArray2) {
        return java.util.Arrays.equals(byArray, byArray2);
    }

    public static boolean areEqual(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        if ((n2 -= n) != n4 - n3) {
            return false;
        }
        for (n4 = 0; n4 < n2; ++n4) {
            if (byArray[n + n4] == byArray2[n3 + n4]) continue;
            return false;
        }
        return true;
    }

    public static boolean areEqual(char[] cArray, char[] cArray2) {
        return java.util.Arrays.equals(cArray, cArray2);
    }

    public static boolean areEqual(int[] nArray, int[] nArray2) {
        return java.util.Arrays.equals(nArray, nArray2);
    }

    public static boolean areEqual(long[] lArray, long[] lArray2) {
        return java.util.Arrays.equals(lArray, lArray2);
    }

    public static boolean areEqual(Object[] objectArray, Object[] objectArray2) {
        return java.util.Arrays.equals(objectArray, objectArray2);
    }

    public static boolean areEqual(short[] sArray, short[] sArray2) {
        return java.util.Arrays.equals(sArray, sArray2);
    }

    public static boolean constantTimeAreEqual(byte[] byArray, byte[] byArray2) {
        if (byArray != null && byArray2 != null) {
            if (byArray == byArray2) {
                return true;
            }
            int n = byArray.length < byArray2.length ? byArray.length : byArray2.length;
            int n2 = byArray.length ^ byArray2.length;
            for (int k = 0; k != n; ++k) {
                n2 |= byArray[k] ^ byArray2[k];
            }
            while (n < byArray2.length) {
                byte by = byArray2[n];
                n2 |= by ^ ~by;
                ++n;
            }
            return n2 == 0;
        }
        return false;
    }

    public static boolean constantTimeAreEqual(int n, byte[] byArray, int n2, byte[] byArray2, int n3) {
        if (byArray != null) {
            if (byArray2 != null) {
                if (n >= 0) {
                    if (n2 <= byArray.length - n) {
                        if (n3 <= byArray2.length - n) {
                            int n4 = 0;
                            for (int k = 0; k < n; ++k) {
                                n4 |= byArray[n2 + k] ^ byArray2[n3 + k];
                            }
                            return n4 == 0;
                        }
                        throw new IndexOutOfBoundsException("'bOff' value invalid for specified length");
                    }
                    throw new IndexOutOfBoundsException("'aOff' value invalid for specified length");
                }
                throw new IllegalArgumentException("'len' cannot be negative");
            }
            throw new NullPointerException("'b' cannot be null");
        }
        throw new NullPointerException("'a' cannot be null");
    }

    public static int compareUnsigned(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return 0;
        }
        if (byArray == null) {
            return -1;
        }
        if (byArray2 == null) {
            return 1;
        }
        int n = Math.min(byArray.length, byArray2.length);
        for (int k = 0; k < n; ++k) {
            int n2 = byArray[k] & 0xFF;
            int n3 = byArray2[k] & 0xFF;
            if (n2 < n3) {
                return -1;
            }
            if (n2 <= n3) continue;
            return 1;
        }
        if (byArray.length < byArray2.length) {
            return -1;
        }
        if (byArray.length > byArray2.length) {
            return 1;
        }
        return 0;
    }

    public static boolean contains(boolean[] blArray, boolean bl) {
        for (int k = 0; k < blArray.length; ++k) {
            if (blArray[k] != bl) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(byte[] byArray, byte by) {
        for (int k = 0; k < byArray.length; ++k) {
            if (byArray[k] != by) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(char[] cArray, char c2) {
        for (int k = 0; k < cArray.length; ++k) {
            if (cArray[k] != c2) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(int[] nArray, int n) {
        for (int k = 0; k < nArray.length; ++k) {
            if (nArray[k] != n) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(long[] lArray, long l) {
        for (int k = 0; k < lArray.length; ++k) {
            if (lArray[k] != l) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(short[] sArray, short s) {
        for (int k = 0; k < sArray.length; ++k) {
            if (sArray[k] != s) continue;
            return true;
        }
        return false;
    }

    public static void fill(boolean[] blArray, boolean bl) {
        java.util.Arrays.fill(blArray, bl);
    }

    public static void fill(boolean[] blArray, int n, int n2, boolean bl) {
        java.util.Arrays.fill(blArray, n, n2, bl);
    }

    public static void fill(byte[] byArray, byte by) {
        java.util.Arrays.fill(byArray, by);
    }

    public static void fill(byte[] byArray, int n, byte by) {
        Arrays.fill(byArray, n, byArray.length, by);
    }

    public static void fill(byte[] byArray, int n, int n2, byte by) {
        java.util.Arrays.fill(byArray, n, n2, by);
    }

    public static void fill(char[] cArray, char c2) {
        java.util.Arrays.fill(cArray, c2);
    }

    public static void fill(char[] cArray, int n, int n2, char c2) {
        java.util.Arrays.fill(cArray, n, n2, c2);
    }

    public static void fill(int[] nArray, int n) {
        java.util.Arrays.fill(nArray, n);
    }

    public static void fill(int[] nArray, int n, int n2) {
        java.util.Arrays.fill(nArray, n, nArray.length, n2);
    }

    public static void fill(int[] nArray, int n, int n2, int n3) {
        java.util.Arrays.fill(nArray, n, n2, n3);
    }

    public static void fill(long[] lArray, long l) {
        java.util.Arrays.fill(lArray, l);
    }

    public static void fill(long[] lArray, int n, long l) {
        java.util.Arrays.fill(lArray, n, lArray.length, l);
    }

    public static void fill(long[] lArray, int n, int n2, long l) {
        java.util.Arrays.fill(lArray, n, n2, l);
    }

    public static void fill(Object[] objectArray, Object object) {
        java.util.Arrays.fill(objectArray, object);
    }

    public static void fill(Object[] objectArray, int n, int n2, Object object) {
        java.util.Arrays.fill(objectArray, n, n2, object);
    }

    public static void fill(short[] sArray, short s) {
        java.util.Arrays.fill(sArray, s);
    }

    public static void fill(short[] sArray, int n, short s) {
        java.util.Arrays.fill(sArray, n, sArray.length, s);
    }

    public static void fill(short[] sArray, int n, int n2, short s) {
        java.util.Arrays.fill(sArray, n, n2, s);
    }

    public static int hashCode(byte[] byArray) {
        if (byArray == null) {
            return 0;
        }
        int n = byArray.length;
        int n2 = n + 1;
        while ((n += -1) >= 0) {
            n2 = n2 * 257 ^ byArray[n];
        }
        return n2;
    }

    public static int hashCode(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            return 0;
        }
        int n3 = n2 + 1;
        while ((n2 += -1) >= 0) {
            n3 = n3 * 257 ^ byArray[n + n2];
        }
        return n3;
    }

    public static int hashCode(char[] cArray) {
        if (cArray == null) {
            return 0;
        }
        int n = cArray.length;
        int n2 = n + 1;
        while ((n += -1) >= 0) {
            n2 = n2 * 257 ^ cArray[n];
        }
        return n2;
    }

    public static int hashCode(int[][] nArray) {
        int n = 0;
        for (int k = 0; k != nArray.length; ++k) {
            n *= 257;
            n = Arrays.hashCode(nArray[k]) + n;
        }
        return n;
    }

    public static int hashCode(int[] nArray) {
        if (nArray == null) {
            return 0;
        }
        int n = nArray.length;
        int n2 = n + 1;
        while ((n += -1) >= 0) {
            n2 = n2 * 257 ^ nArray[n];
        }
        return n2;
    }

    public static int hashCode(int[] nArray, int n, int n2) {
        if (nArray == null) {
            return 0;
        }
        int n3 = n2 + 1;
        while ((n2 += -1) >= 0) {
            n3 = n3 * 257 ^ nArray[n + n2];
        }
        return n3;
    }

    public static int hashCode(long[] lArray) {
        if (lArray == null) {
            return 0;
        }
        int n = lArray.length;
        int n2 = n + 1;
        while ((n += -1) >= 0) {
            long l = lArray[n];
            n2 = (n2 * 257 ^ (int)l) * 257 ^ (int)(l >>> 32);
        }
        return n2;
    }

    public static int hashCode(long[] lArray, int n, int n2) {
        if (lArray == null) {
            return 0;
        }
        int n3 = n2 + 1;
        while ((n2 += -1) >= 0) {
            long l = lArray[n + n2];
            n3 = (n3 * 257 ^ (int)l) * 257 ^ (int)(l >>> 32);
        }
        return n3;
    }

    public static int hashCode(short[][][] sArray) {
        int n = 0;
        for (int k = 0; k != sArray.length; ++k) {
            n *= 257;
            n = Arrays.hashCode(sArray[k]) + n;
        }
        return n;
    }

    public static int hashCode(short[][] sArray) {
        int n = 0;
        for (int k = 0; k != sArray.length; ++k) {
            n *= 257;
            n = Arrays.hashCode(sArray[k]) + n;
        }
        return n;
    }

    public static int hashCode(short[] sArray) {
        if (sArray == null) {
            return 0;
        }
        int n = sArray.length;
        int n2 = n + 1;
        while ((n += -1) >= 0) {
            n2 = n2 * 257 ^ sArray[n] & 0xFF;
        }
        return n2;
    }

    public static int hashCode(Object[] objectArray) {
        if (objectArray == null) {
            return 0;
        }
        int n = objectArray.length;
        int n2 = n + 1;
        while ((n += -1) >= 0) {
            n2 = n2 * 257 ^ Objects.hashCode(objectArray[n]);
        }
        return n2;
    }

    public static boolean[] clone(boolean[] blArray) {
        return blArray == null ? null : (boolean[])blArray.clone();
    }

    public static byte[] clone(byte[] byArray) {
        return byArray == null ? null : (byte[])byArray.clone();
    }

    public static char[] clone(char[] cArray) {
        return cArray == null ? null : (char[])cArray.clone();
    }

    public static int[] clone(int[] nArray) {
        return nArray == null ? null : (int[])nArray.clone();
    }

    public static long[] clone(long[] lArray) {
        return lArray == null ? null : (long[])lArray.clone();
    }

    public static short[] clone(short[] sArray) {
        return sArray == null ? null : (short[])sArray.clone();
    }

    public static BigInteger[] clone(BigInteger[] bigIntegerArray) {
        return bigIntegerArray == null ? null : (BigInteger[])bigIntegerArray.clone();
    }

    public static byte[] clone(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            return null;
        }
        if (byArray2 != null && byArray2.length == byArray.length) {
            int n = byArray2.length;
            System.arraycopy(byArray, 0, byArray2, 0, n);
            return byArray2;
        }
        return Arrays.clone(byArray);
    }

    public static long[] clone(long[] lArray, long[] lArray2) {
        if (lArray == null) {
            return null;
        }
        if (lArray2 != null && lArray2.length == lArray.length) {
            int n = lArray2.length;
            System.arraycopy(lArray, 0, lArray2, 0, n);
            return lArray2;
        }
        return Arrays.clone(lArray);
    }

    public static byte[][] clone(byte[][] byArray) {
        if (byArray == null) {
            return null;
        }
        int n = byArray.length;
        byte[][] byArrayArray = new byte[n][];
        for (int k = 0; k != n; ++k) {
            byArrayArray[k] = Arrays.clone(byArray[k]);
        }
        return byArrayArray;
    }

    public static byte[][][] clone(byte[][][] byArray) {
        if (byArray == null) {
            return null;
        }
        int n = byArray.length;
        byte[][][] byArrayArray = new byte[n][][];
        for (int k = 0; k != n; ++k) {
            byArrayArray[k] = Arrays.clone(byArray[k]);
        }
        return byArrayArray;
    }

    public static boolean[] copyOf(boolean[] blArray, int n) {
        boolean[] blArray2 = new boolean[n];
        int n2 = Math.min(blArray.length, n);
        System.arraycopy(blArray, 0, blArray2, 0, n2);
        return blArray2;
    }

    public static byte[] copyOf(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        int n2 = Math.min(byArray.length, n);
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    public static char[] copyOf(char[] cArray, int n) {
        char[] cArray2 = new char[n];
        int n2 = Math.min(cArray.length, n);
        System.arraycopy(cArray, 0, cArray2, 0, n2);
        return cArray2;
    }

    public static int[] copyOf(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        int n2 = Math.min(nArray.length, n);
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        return nArray2;
    }

    public static long[] copyOf(long[] lArray, int n) {
        long[] lArray2 = new long[n];
        int n2 = Math.min(lArray.length, n);
        System.arraycopy(lArray, 0, lArray2, 0, n2);
        return lArray2;
    }

    public static short[] copyOf(short[] sArray, int n) {
        short[] sArray2 = new short[n];
        int n2 = Math.min(sArray.length, n);
        System.arraycopy(sArray, 0, sArray2, 0, n2);
        return sArray2;
    }

    public static BigInteger[] copyOf(BigInteger[] bigIntegerArray, int n) {
        BigInteger[] bigIntegerArray2 = new BigInteger[n];
        int n2 = Math.min(bigIntegerArray.length, n);
        System.arraycopy(bigIntegerArray, 0, bigIntegerArray2, 0, n2);
        return bigIntegerArray2;
    }

    public static boolean[] copyOfRange(boolean[] blArray, int n, int n2) {
        n2 = Arrays.getLength(n, n2);
        boolean[] blArray2 = new boolean[n2];
        int n3 = Math.min(blArray.length - n, n2);
        System.arraycopy(blArray, n, blArray2, 0, n3);
        return blArray2;
    }

    public static byte[] copyOfRange(byte[] byArray, int n, int n2) {
        n2 = Arrays.getLength(n, n2);
        byte[] byArray2 = new byte[n2];
        int n3 = Math.min(byArray.length - n, n2);
        System.arraycopy(byArray, n, byArray2, 0, n3);
        return byArray2;
    }

    public static char[] copyOfRange(char[] cArray, int n, int n2) {
        n2 = Arrays.getLength(n, n2);
        char[] cArray2 = new char[n2];
        int n3 = Math.min(cArray.length - n, n2);
        System.arraycopy(cArray, n, cArray2, 0, n3);
        return cArray2;
    }

    public static int[] copyOfRange(int[] nArray, int n, int n2) {
        n2 = Arrays.getLength(n, n2);
        int[] nArray2 = new int[n2];
        int n3 = Math.min(nArray.length - n, n2);
        System.arraycopy(nArray, n, nArray2, 0, n3);
        return nArray2;
    }

    public static long[] copyOfRange(long[] lArray, int n, int n2) {
        n2 = Arrays.getLength(n, n2);
        long[] lArray2 = new long[n2];
        int n3 = Math.min(lArray.length - n, n2);
        System.arraycopy(lArray, n, lArray2, 0, n3);
        return lArray2;
    }

    public static short[] copyOfRange(short[] sArray, int n, int n2) {
        n2 = Arrays.getLength(n, n2);
        short[] sArray2 = new short[n2];
        int n3 = Math.min(sArray.length - n, n2);
        System.arraycopy(sArray, n, sArray2, 0, n3);
        return sArray2;
    }

    public static BigInteger[] copyOfRange(BigInteger[] bigIntegerArray, int n, int n2) {
        n2 = Arrays.getLength(n, n2);
        BigInteger[] bigIntegerArray2 = new BigInteger[n2];
        int n3 = Math.min(bigIntegerArray.length - n, n2);
        System.arraycopy(bigIntegerArray, n, bigIntegerArray2, 0, n3);
        return bigIntegerArray2;
    }

    private static int getLength(int n, int n2) {
        StringBuffer stringBuffer;
        int n3 = n2 - n;
        if (n3 >= 0) {
            return n3;
        }
        StringBuffer stringBuffer2 = stringBuffer;
        new StringBuffer(n).append(" > ").append(n2);
        throw new IllegalArgumentException(stringBuffer2.toString());
    }

    public static byte[] append(byte[] byArray, byte by) {
        if (byArray == null) {
            return new byte[]{by};
        }
        int n = byArray.length;
        byte[] byArray2 = new byte[n + 1];
        byte[] byArray3 = byArray2;
        System.arraycopy(byArray, 0, byArray3, 0, n);
        byArray2[n] = by;
        return byArray2;
    }

    public static short[] append(short[] sArray, short s) {
        if (sArray == null) {
            return new short[]{s};
        }
        int n = sArray.length;
        short[] sArray2 = new short[n + 1];
        short[] sArray3 = sArray2;
        System.arraycopy(sArray, 0, sArray3, 0, n);
        sArray2[n] = s;
        return sArray2;
    }

    public static int[] append(int[] nArray, int n) {
        if (nArray == null) {
            return new int[]{n};
        }
        int n2 = nArray.length;
        int[] nArray2 = new int[n2 + 1];
        int[] nArray3 = nArray2;
        System.arraycopy(nArray, 0, nArray3, 0, n2);
        nArray2[n2] = n;
        return nArray2;
    }

    public static String[] append(String[] stringArray, String string) {
        if (stringArray == null) {
            return new String[]{string};
        }
        int n = stringArray.length;
        String[] stringArray2 = new String[n + 1];
        String[] stringArray3 = stringArray2;
        System.arraycopy(stringArray, 0, stringArray3, 0, n);
        stringArray2[n] = string;
        return stringArray2;
    }

    public static byte[] concatenate(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            return Arrays.clone(byArray2);
        }
        if (byArray2 == null) {
            return Arrays.clone(byArray);
        }
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        int n = byArray.length;
        System.arraycopy(byArray, 0, byArray3, 0, n);
        n = byArray.length;
        int n2 = byArray2.length;
        System.arraycopy(byArray2, 0, byArray3, n, n2);
        return byArray3;
    }

    public static byte[] concatenate(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        if (byArray == null) {
            return Arrays.concatenate(byArray2, byArray3);
        }
        if (byArray2 == null) {
            return Arrays.concatenate(byArray, byArray3);
        }
        if (byArray3 == null) {
            return Arrays.concatenate(byArray, byArray2);
        }
        byte[] byArray4 = new byte[byArray.length + byArray2.length + byArray3.length];
        int n = byArray.length;
        System.arraycopy(byArray, 0, byArray4, 0, n);
        n = byArray.length + 0;
        int n2 = byArray2.length;
        System.arraycopy(byArray2, 0, byArray4, n, n2);
        n2 = byArray3.length;
        System.arraycopy(byArray3, 0, byArray4, n += byArray2.length, n2);
        return byArray4;
    }

    public static byte[] concatenate(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        if (byArray == null) {
            return Arrays.concatenate(byArray2, byArray3, byArray4);
        }
        if (byArray2 == null) {
            return Arrays.concatenate(byArray, byArray3, byArray4);
        }
        if (byArray3 == null) {
            return Arrays.concatenate(byArray, byArray2, byArray4);
        }
        if (byArray4 == null) {
            return Arrays.concatenate(byArray, byArray2, byArray3);
        }
        byte[] byArray5 = new byte[byArray.length + byArray2.length + byArray3.length + byArray4.length];
        int n = byArray.length;
        System.arraycopy(byArray, 0, byArray5, 0, n);
        n = byArray.length + 0;
        int n2 = byArray2.length;
        System.arraycopy(byArray2, 0, byArray5, n, n2);
        n2 = byArray3.length;
        System.arraycopy(byArray3, 0, byArray5, n += byArray2.length, n2);
        n2 = byArray4.length;
        System.arraycopy(byArray4, 0, byArray5, n += byArray3.length, n2);
        return byArray5;
    }

    public static byte[] concatenate(byte[][] byArray) {
        int n;
        int n2 = 0;
        for (n = 0; n != byArray.length; ++n) {
            n2 += byArray[n].length;
        }
        byte[] byArray2 = new byte[n2];
        n = 0;
        for (int k = 0; k != byArray.length; ++k) {
            byte[] byArray3 = byArray[k];
            int n3 = byArray3.length;
            System.arraycopy(byArray3, 0, byArray2, n, n3);
            n += byArray[k].length;
        }
        return byArray2;
    }

    public static int[] concatenate(int[] nArray, int[] nArray2) {
        if (nArray == null) {
            return Arrays.clone(nArray2);
        }
        if (nArray2 == null) {
            return Arrays.clone(nArray);
        }
        int[] nArray3 = new int[nArray.length + nArray2.length];
        int n = nArray.length;
        System.arraycopy(nArray, 0, nArray3, 0, n);
        n = nArray.length;
        int n2 = nArray2.length;
        System.arraycopy(nArray2, 0, nArray3, n, n2);
        return nArray3;
    }

    public static byte[] prepend(byte[] byArray, byte by) {
        if (byArray == null) {
            return new byte[]{by};
        }
        int n = byArray.length;
        byte[] byArray2 = new byte[n + 1];
        byte[] byArray3 = byArray2;
        System.arraycopy(byArray, 0, byArray3, 1, n);
        byArray2[0] = by;
        return byArray2;
    }

    public static short[] prepend(short[] sArray, short s) {
        if (sArray == null) {
            return new short[]{s};
        }
        int n = sArray.length;
        short[] sArray2 = new short[n + 1];
        short[] sArray3 = sArray2;
        System.arraycopy(sArray, 0, sArray3, 1, n);
        sArray2[0] = s;
        return sArray2;
    }

    public static int[] prepend(int[] nArray, int n) {
        if (nArray == null) {
            return new int[]{n};
        }
        int n2 = nArray.length;
        int[] nArray2 = new int[n2 + 1];
        int[] nArray3 = nArray2;
        System.arraycopy(nArray, 0, nArray3, 1, n2);
        nArray2[0] = n;
        return nArray2;
    }

    public static byte[] reverse(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        int n = 0;
        int n2 = byArray.length;
        byte[] byArray2 = new byte[n2];
        while ((n2 += -1) >= 0) {
            int n3 = n + 1;
            byArray2[n2] = byArray[n];
            n = n3;
        }
        return byArray2;
    }

    public static int[] reverse(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        int n = 0;
        int n2 = nArray.length;
        int[] nArray2 = new int[n2];
        while ((n2 += -1) >= 0) {
            int n3 = n + 1;
            nArray2[n2] = nArray[n];
            n = n3;
        }
        return nArray2;
    }

    public static void clear(byte[] byArray) {
        if (byArray != null) {
            java.util.Arrays.fill(byArray, (byte)0);
        }
    }

    public static void clear(int[] nArray) {
        if (nArray != null) {
            java.util.Arrays.fill(nArray, 0);
        }
    }

    public static boolean isNullOrContainsNull(Object[] objectArray) {
        if (objectArray == null) {
            return true;
        }
        int n = objectArray.length;
        for (int k = 0; k < n; ++k) {
            if (objectArray[k] != null) continue;
            return true;
        }
        return false;
    }

    public static boolean isNullOrEmpty(byte[] byArray) {
        return byArray == null || byArray.length < 1;
    }

    public static boolean isNullOrEmpty(int[] nArray) {
        return nArray == null || nArray.length < 1;
    }

    public static boolean isNullOrEmpty(Object[] objectArray) {
        return objectArray == null || objectArray.length < 1;
    }

    public static class Iterator<T>
    implements java.util.Iterator<T> {
        private final T[] dataArray;
        private int position = 0;

        public Iterator(T[] TArray) {
            this.dataArray = TArray;
        }

        @Override
        public boolean hasNext() {
            return this.position < this.dataArray.length;
        }

        @Override
        public T next() {
            int n = this.position;
            T[] TArray = this.dataArray;
            if (n != this.dataArray.length) {
                this.position = n + 1;
                return TArray[n];
            }
            throw new NoSuchElementException(a.a("Out of elements: ").append(this.position).toString());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove element from an Array.");
        }
    }
}

