/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.x509;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Extension;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Selector;
import com.fis.ekyc.nfc.build_in.bouncycastle.x509.X509AttributeCertificate;
import com.fis.ekyc.nfc.build_in.bouncycastle.x509.extension.X509ExtensionUtil;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CRL;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLSelector;

public class X509CRLStoreSelector
extends X509CRLSelector
implements Selector {
    private boolean deltaCRLIndicator = false;
    private boolean completeCRLEnabled = false;
    private BigInteger maxBaseCRLNumber = null;
    private byte[] issuingDistributionPoint = null;
    private boolean issuingDistributionPointEnabled = false;
    private X509AttributeCertificate attrCertChecking;

    public static X509CRLStoreSelector getInstance(X509CRLSelector x509CRLSelector) {
        if (x509CRLSelector != null) {
            X509CRLStoreSelector x509CRLStoreSelector;
            X509CRLStoreSelector x509CRLStoreSelector2 = x509CRLStoreSelector;
            x509CRLStoreSelector2();
            x509CRLStoreSelector2.setCertificateChecking(x509CRLSelector.getCertificateChecking());
            x509CRLStoreSelector2.setDateAndTime(x509CRLSelector.getDateAndTime());
            try {
                x509CRLStoreSelector2.setIssuerNames(x509CRLSelector.getIssuerNames());
                x509CRLStoreSelector2.setIssuers(x509CRLSelector.getIssuers());
                x509CRLStoreSelector2.setMaxCRLNumber(x509CRLSelector.getMaxCRL());
                x509CRLStoreSelector.setMinCRLNumber(x509CRLSelector.getMinCRL());
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(iOException.getMessage());
            }
            return x509CRLStoreSelector;
        }
        throw new IllegalArgumentException("cannot create from null selector");
    }

    public boolean isIssuingDistributionPointEnabled() {
        return this.issuingDistributionPointEnabled;
    }

    public void setIssuingDistributionPointEnabled(boolean bl) {
        this.issuingDistributionPointEnabled = bl;
    }

    public void setAttrCertificateChecking(X509AttributeCertificate x509AttributeCertificate) {
        this.attrCertChecking = x509AttributeCertificate;
    }

    public X509AttributeCertificate getAttrCertificateChecking() {
        return this.attrCertChecking;
    }

    public boolean match(Object object) {
        byte[] byArray;
        Object object2;
        block9: {
            if (!(object instanceof X509CRL)) {
                return false;
            }
            object = (X509CRL)object;
            object2 = null;
            try {
                byArray = object.getExtensionValue(Extension.deltaCRLIndicator.getId());
                if (byArray == null) break block9;
            }
            catch (Exception exception) {
                return false;
            }
            object2 = ASN1Integer.getInstance(X509ExtensionUtil.fromExtensionValue(byArray));
        }
        if (this.isDeltaCRLIndicatorEnabled() && object2 == null) {
            return false;
        }
        if (this.isCompleteCRLEnabled() && object2 != null) {
            return false;
        }
        if (object2 != null && this.maxBaseCRLNumber != null && ((ASN1Integer)object2).getPositiveValue().compareTo(this.maxBaseCRLNumber) == 1) {
            return false;
        }
        if (this.issuingDistributionPointEnabled) {
            object2 = object.getExtensionValue(Extension.issuingDistributionPoint.getId());
            byArray = this.issuingDistributionPoint;
            if (this.issuingDistributionPoint == null ? object2 != null : !Arrays.areEqual((byte[])object2, byArray)) {
                return false;
            }
        }
        return super.match((CRL)object);
    }

    @Override
    public boolean match(CRL cRL) {
        return this.match((Object)cRL);
    }

    public boolean isDeltaCRLIndicatorEnabled() {
        return this.deltaCRLIndicator;
    }

    public void setDeltaCRLIndicatorEnabled(boolean bl) {
        this.deltaCRLIndicator = bl;
    }

    @Override
    public Object clone() {
        X509CRLStoreSelector x509CRLStoreSelector = X509CRLStoreSelector.getInstance(this);
        x509CRLStoreSelector.deltaCRLIndicator = this.deltaCRLIndicator;
        x509CRLStoreSelector.completeCRLEnabled = this.completeCRLEnabled;
        x509CRLStoreSelector.maxBaseCRLNumber = this.maxBaseCRLNumber;
        x509CRLStoreSelector.attrCertChecking = this.attrCertChecking;
        x509CRLStoreSelector.issuingDistributionPointEnabled = this.issuingDistributionPointEnabled;
        x509CRLStoreSelector.issuingDistributionPoint = Arrays.clone(this.issuingDistributionPoint);
        return x509CRLStoreSelector;
    }

    public boolean isCompleteCRLEnabled() {
        return this.completeCRLEnabled;
    }

    public void setCompleteCRLEnabled(boolean bl) {
        this.completeCRLEnabled = bl;
    }

    public BigInteger getMaxBaseCRLNumber() {
        return this.maxBaseCRLNumber;
    }

    public void setMaxBaseCRLNumber(BigInteger bigInteger) {
        this.maxBaseCRLNumber = bigInteger;
    }

    public byte[] getIssuingDistributionPoint() {
        return Arrays.clone(this.issuingDistributionPoint);
    }

    public void setIssuingDistributionPoint(byte[] byArray) {
        this.issuingDistributionPoint = Arrays.clone(byArray);
    }
}

