/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.x509;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERBitString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.d;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.j;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.TBSCertificate;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Time;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.V1TBSCertificateGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.X509Name;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.x509.CertificateFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.util.BCJcaJceHelper;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.util.JcaJceHelper;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.X509Principal;
import com.fis.ekyc.nfc.build_in.bouncycastle.x509.ExtCertificateEncodingException;
import com.fis.ekyc.nfc.build_in.bouncycastle.x509.X509Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Iterator;
import javax.security.auth.x500.X500Principal;

public class X509V1CertificateGenerator {
    private final JcaJceHelper bcHelper;
    private final CertificateFactory certificateFactory;
    private V1TBSCertificateGenerator tbsGen;
    private ASN1ObjectIdentifier sigOID;
    private AlgorithmIdentifier sigAlgId;
    private String signatureAlgorithm;

    public X509V1CertificateGenerator() {
        V1TBSCertificateGenerator v1TBSCertificateGenerator;
        CertificateFactory certificateFactory;
        BCJcaJceHelper bCJcaJceHelper;
        Object object = bCJcaJceHelper;
        bCJcaJceHelper = new BCJcaJceHelper();
        v1.bcHelper = object;
        object = certificateFactory;
        certificateFactory = new CertificateFactory();
        v1.certificateFactory = object;
        object = v1TBSCertificateGenerator;
        v1TBSCertificateGenerator = new V1TBSCertificateGenerator();
        v1.tbsGen = object;
    }

    private X509Certificate generateJcaObject(TBSCertificate tBSCertificate, byte[] byArray) {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2();
        aSN1EncodableVector2.add(tBSCertificate);
        aSN1EncodableVector.add(this.sigAlgId);
        aSN1EncodableVector.add(new DERBitString(byArray));
        try {
            return (X509Certificate)this.certificateFactory.engineGenerateCertificate(new ByteArrayInputStream(new DERSequence(aSN1EncodableVector2).getEncoded("DER")));
        }
        catch (Exception exception) {
            throw new ExtCertificateEncodingException("exception producing certificate object", exception);
        }
    }

    public void reset() {
        V1TBSCertificateGenerator v1TBSCertificateGenerator;
        X509V1CertificateGenerator x509V1CertificateGenerator = v1TBSCertificateGenerator2;
        V1TBSCertificateGenerator v1TBSCertificateGenerator2 = v1TBSCertificateGenerator;
        v1TBSCertificateGenerator = new V1TBSCertificateGenerator();
        x509V1CertificateGenerator.tbsGen = v1TBSCertificateGenerator2;
    }

    public void setSerialNumber(BigInteger bigInteger) {
        if (bigInteger.compareTo(BigInteger.ZERO) > 0) {
            this.tbsGen.setSerialNumber(new ASN1Integer(bigInteger));
            return;
        }
        throw new IllegalArgumentException("serial number must be a positive integer");
    }

    public void setIssuerDN(X500Principal x500Principal) {
        try {
            this.tbsGen.setIssuer(new X509Principal(x500Principal.getEncoded()));
            return;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(j.a("can't process principal: ", iOException));
        }
    }

    public void setIssuerDN(X509Name x509Name) {
        this.tbsGen.setIssuer(x509Name);
    }

    public void setNotBefore(Date date) {
        this.tbsGen.setStartDate(new Time(date));
    }

    public void setNotAfter(Date date) {
        this.tbsGen.setEndDate(new Time(date));
    }

    public void setSubjectDN(X500Principal x500Principal) {
        try {
            this.tbsGen.setSubject(new X509Principal(x500Principal.getEncoded()));
            return;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(j.a("can't process principal: ", iOException));
        }
    }

    public void setSubjectDN(X509Name x509Name) {
        this.tbsGen.setSubject(x509Name);
    }

    public void setPublicKey(PublicKey publicKey) {
        try {
            this.tbsGen.setSubjectPublicKeyInfo(SubjectPublicKeyInfo.getInstance(publicKey.getEncoded()));
            return;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(d.a(exception, a.a("unable to process key - ")));
        }
    }

    public void setSignatureAlgorithm(String string) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier;
        X509V1CertificateGenerator x509V1CertificateGenerator = algorithmIdentifier;
        ((X509V1CertificateGenerator)((Object)algorithmIdentifier)).signatureAlgorithm = string;
        try {
            aSN1ObjectIdentifier = X509Util.getAlgorithmOID(string);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Unknown signature type requested");
        }
        ((X509V1CertificateGenerator)((Object)algorithmIdentifier)).sigOID = aSN1ObjectIdentifier;
        AlgorithmIdentifier algorithmIdentifier = X509Util.getSigAlgID(aSN1ObjectIdentifier, string);
        x509V1CertificateGenerator.sigAlgId = algorithmIdentifier;
        x509V1CertificateGenerator.tbsGen.setSignature(algorithmIdentifier);
    }

    public X509Certificate generateX509Certificate(PrivateKey privateKey) {
        try {
            return this.generateX509Certificate(privateKey, "BC", null);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new SecurityException("BC provider not installed!");
        }
    }

    public X509Certificate generateX509Certificate(PrivateKey privateKey, SecureRandom secureRandom) {
        try {
            return this.generateX509Certificate(privateKey, "BC", secureRandom);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new SecurityException("BC provider not installed!");
        }
    }

    public X509Certificate generateX509Certificate(PrivateKey privateKey, String string) {
        return this.generateX509Certificate(privateKey, string, null);
    }

    public X509Certificate generateX509Certificate(PrivateKey privateKey, String string, SecureRandom secureRandom) {
        try {
            return this.generate(privateKey, string, secureRandom);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SecurityException("exception: " + generalSecurityException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw invalidKeyException;
        }
        catch (SignatureException signatureException) {
            throw signatureException;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw noSuchProviderException;
        }
    }

    public X509Certificate generate(PrivateKey privateKey) {
        return this.generate(privateKey, (SecureRandom)null);
    }

    public X509Certificate generate(PrivateKey privateKey, SecureRandom secureRandom) {
        X509V1CertificateGenerator x509V1CertificateGenerator = this;
        TBSCertificate tBSCertificate = x509V1CertificateGenerator.tbsGen.generateTBSCertificate();
        try {
            return x509V1CertificateGenerator.generateJcaObject(tBSCertificate, X509Util.calculateSignature(this.sigOID, this.signatureAlgorithm, privateKey, secureRandom, tBSCertificate));
        }
        catch (IOException iOException) {
            throw new ExtCertificateEncodingException("exception encoding TBS cert", iOException);
        }
    }

    public X509Certificate generate(PrivateKey privateKey, String string) {
        return this.generate(privateKey, string, null);
    }

    public X509Certificate generate(PrivateKey privateKey, String string, SecureRandom secureRandom) {
        X509V1CertificateGenerator x509V1CertificateGenerator = this;
        TBSCertificate tBSCertificate = x509V1CertificateGenerator.tbsGen.generateTBSCertificate();
        try {
            return x509V1CertificateGenerator.generateJcaObject(tBSCertificate, X509Util.calculateSignature(this.sigOID, this.signatureAlgorithm, string, privateKey, secureRandom, tBSCertificate));
        }
        catch (IOException iOException) {
            throw new ExtCertificateEncodingException("exception encoding TBS cert", iOException);
        }
    }

    public Iterator getSignatureAlgNames() {
        return X509Util.getAlgNames();
    }
}

