/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.cvc;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.i;
import com.fis.ekyc.nfc.build_in.cvc.CVCObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.cvc.OIDField;
import java.util.HashMap;

public class AlgorithmUtil {
    private static HashMap<String, OIDField> algorithmMap = new HashMap();
    private static HashMap<String, String> conversionMap = new HashMap();

    public static OIDField getOIDField(String string) {
        OIDField oIDField = algorithmMap.get(AlgorithmUtil.convertAlgorithmNameToCVC(string));
        if (oIDField != null) {
            return oIDField;
        }
        throw new IllegalArgumentException(i.a("Unsupported algorithmName: ", string));
    }

    public static String convertAlgorithmNameToCVC(String string) {
        String string2 = conversionMap.get(string.toUpperCase());
        if (string2 != null) {
            return string2;
        }
        return string.toUpperCase();
    }

    public static String getAlgorithmName(OIDField oIDField) {
        for (String string : algorithmMap.keySet()) {
            if (!algorithmMap.get(string).getValue().equals(oIDField.getValue())) continue;
            return string;
        }
        throw new IllegalArgumentException(a.a("Unknown OIDField: ").append(oIDField.getValue()).toString());
    }

    static {
        algorithmMap.put("SHA1WITHRSA", CVCObjectIdentifiers.id_TA_RSA_v1_5_SHA_1);
        algorithmMap.put("SHA256WITHRSA", CVCObjectIdentifiers.id_TA_RSA_v1_5_SHA_256);
        algorithmMap.put("SHA512WITHRSA", CVCObjectIdentifiers.id_TA_RSA_v1_5_SHA_512);
        algorithmMap.put("SHA1WITHRSAANDMGF1", CVCObjectIdentifiers.id_TA_RSA_PSS_SHA_1);
        algorithmMap.put("SHA256WITHRSAANDMGF1", CVCObjectIdentifiers.id_TA_RSA_PSS_SHA_256);
        algorithmMap.put("SHA512WITHRSAANDMGF1", CVCObjectIdentifiers.id_TA_RSA_PSS_SHA_512);
        algorithmMap.put("SHA1WITHECDSA", CVCObjectIdentifiers.id_TA_ECDSA_SHA_1);
        algorithmMap.put("SHA224WITHECDSA", CVCObjectIdentifiers.id_TA_ECDSA_SHA_224);
        algorithmMap.put("SHA256WITHECDSA", CVCObjectIdentifiers.id_TA_ECDSA_SHA_256);
        algorithmMap.put("SHA384WITHECDSA", CVCObjectIdentifiers.id_TA_ECDSA_SHA_384);
        algorithmMap.put("SHA512WITHECDSA", CVCObjectIdentifiers.id_TA_ECDSA_SHA_512);
        conversionMap.put("SHA1WITHECDSA", "SHA1WITHECDSA");
        conversionMap.put("SHA224WITHECDSA", "SHA224WITHECDSA");
        conversionMap.put("SHA256WITHECDSA", "SHA256WITHECDSA");
        conversionMap.put("SHA384WITHECDSA", "SHA384WITHECDSA");
        conversionMap.put("SHA512WITHECDSA", "SHA512WITHECDSA");
    }
}

