/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.h;
import com.fis.ekyc.nfc.build_in.eidparser.APDULevelReadBinaryCapable;
import com.fis.ekyc.nfc.build_in.eidparser.io.FragmentBuffer;
import com.fis.ekyc.nfc.build_in.eidparser.lds.LDSFileUtil;
import com.fis.ekyc.nfc.build_in.eidparser.protocol.SecureMessagingWrapper;
import com.fis.ekyc.nfc.build_in.scuba.smartcards.APDUWrapper;
import com.fis.ekyc.nfc.build_in.scuba.smartcards.CardServiceException;
import com.fis.ekyc.nfc.build_in.scuba.smartcards.FileInfo;
import com.fis.ekyc.nfc.build_in.scuba.smartcards.FileSystemStructured;
import com.fis.ekyc.nfc.build_in.scuba.tlv.TLVInputStream;
import com.fis.ekyc.nfc.build_in.scuba.util.Hex;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultFileSystem
implements FileSystemStructured {
    public static final int NO_SFI = -1;
    private static final Logger LOGGER = Logger.getLogger("com.fis.ekyc.sdk.nfc.build_in..jmrtd");
    private static final int READ_AHEAD_LENGTH = 8;
    private short selectedFID;
    private boolean isSFIEnabled;
    private int maxReadBinaryLength;
    private boolean isSelected;
    private APDULevelReadBinaryCapable service;
    private Map<Short, DefaultFileInfo> fileInfos;
    private Map<Short, Byte> fidToSFI;
    private APDUWrapper wrapper;
    private APDUWrapper oldWrapper;

    public DefaultFileSystem(APDULevelReadBinaryCapable aPDULevelReadBinaryCapable, boolean bl) {
        DefaultFileSystem defaultFileSystem = map;
        Map<Short, Byte> map = LDSFileUtil.FID_TO_SFI;
        defaultFileSystem(aPDULevelReadBinaryCapable, bl, map);
    }

    public DefaultFileSystem(APDULevelReadBinaryCapable aPDULevelReadBinaryCapable, boolean bl, Map<Short, Byte> map) {
        HashMap hashMap;
        ((DefaultFileSystem)((Object)hashMap2)).service = aPDULevelReadBinaryCapable;
        HashMap hashMap2 = hashMap;
        hashMap = new HashMap();
        v1.fileInfos = hashMap2;
        v1.selectedFID = 0;
        v1.isSelected = false;
        v1.isSFIEnabled = bl;
        v1.fidToSFI = map;
        v1.maxReadBinaryLength = 65536;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized DefaultFileInfo getFileInfo() {
        Object object;
        block13: {
            DefaultFileInfo defaultFileInfo;
            int n;
            block14: {
                short s = ((DefaultFileSystem)((Object)stringBuilder)).selectedFID;
                if (s <= 0) {
                    throw new CardServiceException("No file selected");
                }
                object = ((DefaultFileSystem)((Object)stringBuilder)).fileInfos.get(s);
                if (object != null) {
                    return object;
                }
                try {
                    block12: {
                        if (((DefaultFileSystem)((Object)stringBuilder)).isSFIEnabled) {
                            object = ((DefaultFileSystem)((Object)stringBuilder)).fidToSFI.get(((DefaultFileSystem)((Object)stringBuilder)).selectedFID);
                            if (object != null) {
                                int n2 = 128;
                                object = ((DefaultFileSystem)((Object)stringBuilder)).sendReadBinary((Byte)object & 0xFF | n2, 0, 8, false);
                                ((DefaultFileSystem)((Object)stringBuilder)).isSelected = true;
                                break block12;
                            } else {
                                throw new NumberFormatException("Unknown FID " + Integer.toHexString(((DefaultFileSystem)((Object)stringBuilder)).selectedFID));
                            }
                        }
                        if (!((DefaultFileSystem)((Object)stringBuilder)).isSelected) {
                            DefaultFileSystem defaultFileSystem = stringBuilder;
                            defaultFileSystem.sendSelectFile(defaultFileSystem.selectedFID);
                            defaultFileSystem.isSelected = true;
                        }
                        object = ((DefaultFileSystem)((Object)stringBuilder)).sendReadBinary(0, 8, false);
                    }
                    if (object == null || ((Object)object).length == 0) break block13;
                    n = DefaultFileSystem.getFileLength(((DefaultFileSystem)((Object)stringBuilder)).selectedFID, 8, (byte[])object);
                    if (n >= ((Object)object).length) break block14;
                    object = Arrays.copyOf((byte[])object, n);
                }
                catch (IOException iOException) {
                    DefaultFileSystem defaultFileSystem = stringBuilder;
                    StringBuilder stringBuilder = a.a("Error getting file info for ");
                    throw new CardServiceException(h.a(defaultFileSystem.selectedFID, stringBuilder), iOException);
                }
            }
            DefaultFileInfo defaultFileInfo2 = defaultFileInfo;
            DefaultFileInfo defaultFileInfo3 = defaultFileInfo2;
            defaultFileInfo3(((DefaultFileSystem)((Object)stringBuilder)).selectedFID, n);
            defaultFileInfo3.addFragment(0, (byte[])object);
            ((DefaultFileSystem)((Object)stringBuilder)).fileInfos.put(((DefaultFileSystem)((Object)stringBuilder)).selectedFID, defaultFileInfo2);
            return defaultFileInfo;
        }
        LOGGER.warning("Something is wrong with prefix, prefix = " + Hex.bytesToHexString((byte[])object));
        return null;
    }

    private static int getFileLength(short s, int n, byte[] byArray) {
        TLVInputStream tLVInputStream;
        ByteArrayInputStream byteArrayInputStream;
        block11: {
            int n2;
            TLVInputStream tLVInputStream2;
            ByteArrayInputStream byteArrayInputStream2;
            if (byArray.length < n) {
                return byArray.length;
            }
            byteArrayInputStream = byteArrayInputStream2;
            byteArrayInputStream2 = new ByteArrayInputStream(byArray);
            tLVInputStream = tLVInputStream2;
            try {
                if (new TLVInputStream(byteArrayInputStream).readTag() != 66) break block11;
                n2 = 36;
            }
            catch (Throwable throwable) {
                try {
                    tLVInputStream.close();
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.FINE, "Error closing stream", iOException);
                }
                throw throwable;
            }
            try {
                tLVInputStream.close();
            }
            catch (IOException iOException) {
                LOGGER.log(Level.FINE, "Error closing stream", iOException);
            }
            return n2;
        }
        TLVInputStream tLVInputStream3 = tLVInputStream;
        byte[] byArray2 = byArray;
        int n3 = tLVInputStream.readLength();
        int n4 = byArray2.length - byteArrayInputStream.available() + n3;
        try {
            tLVInputStream3.close();
        }
        catch (IOException iOException) {
            LOGGER.log(Level.FINE, "Error closing stream", iOException);
        }
        return n4;
    }

    public void setWrapper(APDUWrapper aPDUWrapper) {
        this.oldWrapper = this.wrapper;
        this.wrapper = aPDUWrapper;
    }

    public APDUWrapper getWrapper() {
        return this.wrapper;
    }

    public int getMaxReadBinaryLength() {
        return this.maxReadBinaryLength;
    }

    @Override
    public synchronized FileInfo[] getSelectedPath() {
        if ((this = ((DefaultFileSystem)this).getFileInfo()) == null) {
            return null;
        }
        return new DefaultFileInfo[]{this};
    }

    @Override
    public synchronized void selectFile(short s) {
        if (this.selectedFID == s) {
            return;
        }
        DefaultFileSystem defaultFileSystem = this;
        defaultFileSystem.selectedFID = s;
        defaultFileSystem.isSelected = false;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public synchronized byte[] readBinary(int var1_1, int var2_4) {
        block27: {
            block26: {
                var3_7 = null;
                if (this.selectedFID <= 0) ** GOTO lbl69
                var3_7 = this.getFileInfo();
                if (var3_7 == null) ** GOTO lbl68
                v0 = var3_7;
                v1 = var1_1;
                var2_4 = Math.min(var2_4, this.maxReadBinaryLength);
                var4_8 = v0.getSmallestUnbufferedFragment(v1, var2_4);
                if (var4_8.getLength() <= 0) ** GOTO lbl61
                if (!this.isSFIEnabled || var1_1 >= 256) ** GOTO lbl34
                var5_9 = this.fidToSFI.get(this.selectedFID);
                if (var5_9 == null) ** GOTO lbl33
                v2 = var4_8;
                var5_10 = 128;
                var5_10 = var5_9 & 255 | var5_10;
                var6_13 = v2.getOffset();
                var7_15 = v2.getLength();
                var5_11 = this.sendReadBinary(var5_10, var6_13, var7_15, false);
                this.isSelected = true;
                break block26;
lbl33:
                // 1 sources

                throw new NumberFormatException("Unknown FID " + Integer.toHexString(this.selectedFID));
lbl34:
                // 1 sources

                if (this.isSelected) ** GOTO lbl39
                v3 = this;
                v3.sendSelectFile(v3.selectedFID);
                v3.isSelected = true;
lbl39:
                // 2 sources

                v4 = var1_1;
                v5 = var4_8;
                v6 = v5;
                var5_12 = v5.getOffset();
                var6_14 = v6.getLength();
                var7_16 = v4 > 32767;
                var5_11 = this.sendReadBinary(var5_12, var6_14, var7_16);
            }
            if (var5_11 == null) break block27;
            if (var5_11.length <= 0) ** GOTO lbl54
            var3_7.addFragment(var4_8.getOffset(), var5_11);
lbl54:
            // 2 sources

            if (var5_11.length >= var4_8.getLength()) ** GOTO lbl61
            var2_4 = var5_11.length;
            ** GOTO lbl61
        }
        throw new IllegalStateException("Could not read bytes");
lbl61:
        // 3 sources

        v7 = var2_4;
        var4_8 = var3_7.getBuffer();
        var5_11 = new byte[v7];
        try {
            System.arraycopy(var4_8, var1_1, var5_11, 0, var2_4);
            return var5_11;
lbl68:
            // 1 sources

            throw new IllegalStateException("Could not get file info");
lbl69:
            // 1 sources

            throw new CardServiceException("No file selected");
        }
        catch (Exception var1_2) {
            var4_8 = a.a("Read binary failed on file ");
            if (var3_7 == null) {
                var3_7 = Integer.toHexString(this.selectedFID);
            }
            v8 = var2_5;
            v8(var4_8.append(var3_7).toString(), var1_2);
            throw v8;
        }
        catch (CardServiceException var1_3) {
            if (((short)var1_3.getSW() & 26368) == 26368 && this.maxReadBinaryLength > 223) {
                this.wrapper = this.oldWrapper;
                this.maxReadBinaryLength = 223;
                return new byte[0];
            }
            var4_8 = a.a("Read binary failed on file ");
            if (var3_7 == null) {
                var3_7 = Integer.toHexString(this.selectedFID);
            }
            v9 = var2_6;
            v9(var4_8.append(var3_7).toString(), var1_3);
            throw v9;
        }
    }

    public synchronized void sendSelectFile(short s) {
        this.service.sendSelectFile(this.wrapper, s);
    }

    public synchronized byte[] sendReadBinary(int n, int n2, boolean bl) {
        APDUWrapper aPDUWrapper = this.wrapper;
        if (aPDUWrapper instanceof SecureMessagingWrapper) {
            aPDUWrapper = SecureMessagingWrapper.getInstance((SecureMessagingWrapper)aPDUWrapper);
        }
        this.oldWrapper = aPDUWrapper;
        return this.service.sendReadBinary(this.wrapper, -1, n, n2, false, bl);
    }

    public synchronized byte[] sendReadBinary(int n, int n2, int n3, boolean bl) {
        return this.service.sendReadBinary(this.wrapper, n, n2, n3, true, bl);
    }

    public static class DefaultFileInfo
    extends FileInfo
    implements Serializable {
        private static final long serialVersionUID = 6727369753765119839L;
        private short fid;
        private FragmentBuffer buffer;

        public DefaultFileInfo(short s, int n) {
            FragmentBuffer fragmentBuffer;
            serializable.fid = s;
            Serializable serializable = fragmentBuffer;
            fragmentBuffer = new FragmentBuffer(n);
            v1.buffer = serializable;
        }

        public byte[] getBuffer() {
            return this.buffer.getBuffer();
        }

        @Override
        public short getFID() {
            return this.fid;
        }

        @Override
        public int getFileLength() {
            return this.buffer.getLength();
        }

        public String toString() {
            return Integer.toHexString(this.fid);
        }

        public FragmentBuffer.Fragment getSmallestUnbufferedFragment(int n, int n2) {
            return this.buffer.getSmallestUnbufferedFragment(n, n2);
        }

        public void addFragment(int n, byte[] byArray) {
            this.buffer.addFragment(n, byArray);
        }
    }
}

