/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser.cbeff;

import com.fis.ekyc.nfc.build_in.eidparser.cbeff.BiometricDataBlock;
import com.fis.ekyc.nfc.build_in.eidparser.cbeff.BiometricDataBlockEncoder;
import com.fis.ekyc.nfc.build_in.eidparser.cbeff.CBEFFInfo;
import com.fis.ekyc.nfc.build_in.eidparser.cbeff.ComplexCBEFFInfo;
import com.fis.ekyc.nfc.build_in.eidparser.cbeff.ISO781611;
import com.fis.ekyc.nfc.build_in.eidparser.cbeff.SimpleCBEFFInfo;
import com.fis.ekyc.nfc.build_in.scuba.tlv.TLVOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ISO781611Encoder<B extends BiometricDataBlock>
implements ISO781611 {
    private BiometricDataBlockEncoder<B> bdbEncoder;

    public ISO781611Encoder(BiometricDataBlockEncoder<B> biometricDataBlockEncoder) {
        this.bdbEncoder = biometricDataBlockEncoder;
    }

    private void writeBITGroup(List<CBEFFInfo> list, OutputStream outputStream) {
        if (outputStream instanceof TLVOutputStream) {
            outputStream = (TLVOutputStream)outputStream;
        } else {
            TLVOutputStream tLVOutputStream;
            TLVOutputStream tLVOutputStream2 = tLVOutputStream;
            tLVOutputStream = new TLVOutputStream(outputStream);
            outputStream = tLVOutputStream2;
        }
        OutputStream outputStream2 = outputStream;
        ((TLVOutputStream)outputStream2).writeTag(32609);
        ((TLVOutputStream)outputStream2).writeTag(2);
        int n = list.size();
        byte[] byArray = new byte[1];
        byte[] byArray2 = byArray;
        byArray[0] = (byte)n;
        ((TLVOutputStream)outputStream).writeValue(byArray2);
        for (int k = 0; k < n; ++k) {
            this.writeBIT((TLVOutputStream)outputStream, k, (SimpleCBEFFInfo)list.get(k));
        }
        ((TLVOutputStream)outputStream).writeValueEnd();
    }

    private void writeBIT(TLVOutputStream tLVOutputStream, int n, SimpleCBEFFInfo<B> simpleCBEFFInfo) {
        tLVOutputStream.writeTag(32608);
        this.writeBHT(tLVOutputStream, n, simpleCBEFFInfo);
        this.writeBiometricDataBlock(tLVOutputStream, simpleCBEFFInfo.getBiometricDataBlock());
        tLVOutputStream.writeValueEnd();
    }

    private void writeBHT(TLVOutputStream tLVOutputStream, int n, SimpleCBEFFInfo<B> simpleCBEFFInfo) {
        tLVOutputStream.writeTag(161);
        Iterator<Map.Entry<Integer, byte[]>> iterator = simpleCBEFFInfo.getBiometricDataBlock().getStandardBiometricHeader().getElements().entrySet().iterator();
        while (iterator.hasNext()) {
            TLVOutputStream tLVOutputStream2 = tLVOutputStream;
            Map.Entry entry = (Map.Entry)iterator.next();
            tLVOutputStream2.writeTag((Integer)entry.getKey());
            tLVOutputStream2.writeValue((byte[])entry.getValue());
        }
        tLVOutputStream.writeValueEnd();
    }

    private void writeBiometricDataBlock(TLVOutputStream tLVOutputStream, B b2) {
        tLVOutputStream.writeTag(24366);
        this.bdbEncoder.encode(b2, tLVOutputStream);
        tLVOutputStream.writeValueEnd();
    }

    public void encode(CBEFFInfo cBEFFInfo, OutputStream outputStream) {
        if (cBEFFInfo instanceof SimpleCBEFFInfo) {
            this.writeBITGroup(Arrays.asList(cBEFFInfo), outputStream);
        } else if (cBEFFInfo instanceof ComplexCBEFFInfo) {
            this.writeBITGroup(((ComplexCBEFFInfo)cBEFFInfo).getSubRecords(), outputStream);
        }
    }
}

