/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser.lds;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DLSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.i;
import com.fis.ekyc.nfc.build_in.eidparser.lds.SecurityInfo;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Logger;

public class ActiveAuthenticationInfo
extends SecurityInfo {
    private static final long serialVersionUID = 6830847342039845308L;
    private static final Logger LOGGER = Logger.getLogger("com.fis.ekyc.sdk.nfc.build_in..jmrtd.lds");
    public static final int VERSION_1 = 1;
    public static final String ECDSA_PLAIN_SIGNATURES = "0.4.0.127.0.7.1.1.4.1";
    public static final String ECDSA_PLAIN_SHA1_OID = "0.4.0.127.0.7.1.1.4.1.1";
    public static final String ECDSA_PLAIN_SHA224_OID = "0.4.0.127.0.7.1.1.4.1.2";
    public static final String ECDSA_PLAIN_SHA256_OID = "0.4.0.127.0.7.1.1.4.1.3";
    public static final String ECDSA_PLAIN_SHA384_OID = "0.4.0.127.0.7.1.1.4.1.4";
    public static final String ECDSA_PLAIN_SHA512_OID = "0.4.0.127.0.7.1.1.4.1.5";
    public static final String ECDSA_PLAIN_RIPEMD160_OID = "0.4.0.127.0.7.1.1.4.1.6";
    private String oid;
    private int version;
    private String signatureAlgorithmOID;

    public ActiveAuthenticationInfo(String string2, int n, String string3) {
        ActiveAuthenticationInfo activeAuthenticationInfo = this;
        activeAuthenticationInfo.oid = string2;
        activeAuthenticationInfo.version = n;
        activeAuthenticationInfo.signatureAlgorithmOID = string3;
        activeAuthenticationInfo.checkFields();
    }

    public ActiveAuthenticationInfo(String string2) {
        this("2.23.136.1.1.5", 1, string2);
    }

    public static String lookupMnemonicByOID(String string2) {
        if (ECDSA_PLAIN_SHA1_OID.equals(string2)) {
            return "SHA1withECDSA";
        }
        if (ECDSA_PLAIN_SHA224_OID.equals(string2)) {
            return "SHA224withECDSA";
        }
        if (ECDSA_PLAIN_SHA256_OID.equals(string2)) {
            return "SHA256withECDSA";
        }
        if (ECDSA_PLAIN_SHA384_OID.equals(string2)) {
            return "SHA384withECDSA";
        }
        if (ECDSA_PLAIN_SHA512_OID.equals(string2)) {
            return "SHA512withECDSA";
        }
        if (ECDSA_PLAIN_RIPEMD160_OID.equals(string2)) {
            return "RIPEMD160withECDSA";
        }
        throw new NoSuchAlgorithmException(i.a("Unknown OID ", string2));
    }

    public static boolean checkRequiredIdentifier(String string2) {
        return "2.23.136.1.1.5".equals(string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkFields() {
        try {
            if (!ActiveAuthenticationInfo.checkRequiredIdentifier(this.oid)) throw new IllegalArgumentException("Wrong identifier: " + this.oid);
            if (this.version != 1) {
                LOGGER.warning("Wrong version: " + this.version);
            }
            if (ECDSA_PLAIN_SHA1_OID.equals(this.signatureAlgorithmOID)) return;
            if (ECDSA_PLAIN_SHA224_OID.equals(this.signatureAlgorithmOID)) return;
            if (ECDSA_PLAIN_SHA256_OID.equals(this.signatureAlgorithmOID)) return;
            if (ECDSA_PLAIN_SHA384_OID.equals(this.signatureAlgorithmOID)) return;
            if (ECDSA_PLAIN_SHA512_OID.equals(this.signatureAlgorithmOID)) return;
            if (!ECDSA_PLAIN_RIPEMD160_OID.equals(this.signatureAlgorithmOID)) throw new IllegalArgumentException("Wrong signature algorithm OID: " + this.signatureAlgorithmOID);
            return;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Malformed ActiveAuthenticationInfo", exception);
        }
    }

    private String toProtocolOIDString(String string2) {
        if ("2.23.136.1.1.5".equals(string2)) {
            return "id-AA";
        }
        return string2;
    }

    public static String toSignatureAlgorithmOIDString(String string2) {
        if (ECDSA_PLAIN_SHA1_OID.equals(string2)) {
            return "ecdsa-plain-SHA1";
        }
        if (ECDSA_PLAIN_SHA224_OID.equals(string2)) {
            return "ecdsa-plain-SHA224";
        }
        if (ECDSA_PLAIN_SHA256_OID.equals(string2)) {
            return "ecdsa-plain-SHA256";
        }
        if (ECDSA_PLAIN_SHA384_OID.equals(string2)) {
            return "ecdsa-plain-SHA384";
        }
        if (ECDSA_PLAIN_SHA512_OID.equals(string2)) {
            return "ecdsa-plain-SHA512";
        }
        if (ECDSA_PLAIN_RIPEMD160_OID.equals(string2)) {
            return "ecdsa-plain-RIPEMD160";
        }
        return string2;
    }

    @Override
    @Deprecated
    public ASN1Primitive getDERObject() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        new ASN1EncodableVector().add(new ASN1ObjectIdentifier(this.oid));
        aSN1EncodableVector2.add(new ASN1Integer(this.version));
        if (this.signatureAlgorithmOID != null) {
            aSN1EncodableVector2.add(new ASN1ObjectIdentifier(this.signatureAlgorithmOID));
        }
        return new DLSequence(aSN1EncodableVector2);
    }

    @Override
    public String getObjectIdentifier() {
        return this.oid;
    }

    public int getVersion() {
        return this.version;
    }

    @Override
    public String getProtocolOIDString() {
        ActiveAuthenticationInfo activeAuthenticationInfo = this;
        return activeAuthenticationInfo.toProtocolOIDString(activeAuthenticationInfo.oid);
    }

    public String getSignatureAlgorithmOID() {
        return this.signatureAlgorithmOID;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ActiveAuthenticationInfo");
        stringBuilder.append(" [");
        ActiveAuthenticationInfo activeAuthenticationInfo = this;
        stringBuilder.append(a.a("protocol: ").append(activeAuthenticationInfo.toProtocolOIDString(activeAuthenticationInfo.oid)).toString());
        stringBuilder.append(", ");
        stringBuilder.append("version: " + this.version);
        stringBuilder.append(", ");
        stringBuilder.append("signatureAlgorithmOID: " + ActiveAuthenticationInfo.toSignatureAlgorithmOIDString(this.getSignatureAlgorithmOID()));
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == activeAuthenticationInfo2) {
            return true;
        }
        if (!ActiveAuthenticationInfo.class.equals(object.getClass())) {
            return false;
        }
        ActiveAuthenticationInfo activeAuthenticationInfo = activeAuthenticationInfo2;
        ActiveAuthenticationInfo activeAuthenticationInfo2 = (ActiveAuthenticationInfo)object;
        return activeAuthenticationInfo.getDERObject().equals(activeAuthenticationInfo2.getDERObject());
    }

    public int hashCode() {
        int n = 12345;
        int n2 = 3;
        String string2 = this.oid;
        n2 = (string2 == null ? 0 : string2.hashCode()) * n2;
        ActiveAuthenticationInfo activeAuthenticationInfo = this;
        int n3 = n2 + n;
        n3 = activeAuthenticationInfo.version * 5 + n3;
        n = 11;
        String string3 = activeAuthenticationInfo.signatureAlgorithmOID;
        return (string3 == null ? 1 : string3.hashCode()) * n + n3;
    }
}

